/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.jssrc.dsl;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableList;
import com.google.errorprone.annotations.ForOverride;
import com.google.template.soy.base.internal.BaseUtils;
import com.google.template.soy.base.internal.UniqueNameGenerator;
import com.google.template.soy.exprtree.IntegerNode;
import com.google.template.soy.exprtree.Operator;
import com.google.template.soy.jssrc.dsl.ArrayLiteral;
import com.google.template.soy.jssrc.dsl.Assignment;
import com.google.template.soy.jssrc.dsl.BinaryOperation;
import com.google.template.soy.jssrc.dsl.Bracket;
import com.google.template.soy.jssrc.dsl.Call;
import com.google.template.soy.jssrc.dsl.Composite;
import com.google.template.soy.jssrc.dsl.Conditional;
import com.google.template.soy.jssrc.dsl.ConditionalBuilder;
import com.google.template.soy.jssrc.dsl.Declaration;
import com.google.template.soy.jssrc.dsl.Dot;
import com.google.template.soy.jssrc.dsl.FormattingContext;
import com.google.template.soy.jssrc.dsl.Group;
import com.google.template.soy.jssrc.dsl.IfThenPair;
import com.google.template.soy.jssrc.dsl.Leaf;
import com.google.template.soy.jssrc.dsl.LeafStatement;
import com.google.template.soy.jssrc.dsl.MapLiteral;
import com.google.template.soy.jssrc.dsl.New;
import com.google.template.soy.jssrc.dsl.OutputContext;
import com.google.template.soy.jssrc.dsl.PrefixUnaryOperation;
import com.google.template.soy.jssrc.dsl.Return;
import com.google.template.soy.jssrc.dsl.Statement;
import com.google.template.soy.jssrc.dsl.Ternary;
import com.google.template.soy.jssrc.restricted.JsExpr;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Pattern;
import javax.annotation.Nullable;

public abstract class CodeChunk {
    private static final Pattern ID = Pattern.compile("[A-Za-z_$][\\w$]*");

    public static WithValue fromExpr(JsExpr expr) {
        return Leaf.create(expr);
    }

    public static WithValue id(String id) {
        Preconditions.checkState((boolean)ID.matcher(id).matches(), (String)"not a valid id: %s", (Object)id);
        return Leaf.create(id);
    }

    public static WithValue dottedId(String dotSeparatedIdentifiers) {
        List ids = Splitter.on((char)'.').splitToList((CharSequence)dotSeparatedIdentifiers);
        Preconditions.checkState((!ids.isEmpty() ? 1 : 0) != 0, (String)"not a dot-separated sequence of JavaScript identifiers: %s", (Object)dotSeparatedIdentifiers);
        WithValue tip = CodeChunk.id((String)ids.get(0));
        for (int i = 1; i < ids.size(); ++i) {
            tip = tip.dotAccess((String)ids.get(i));
        }
        return tip;
    }

    public static WithValue stringLiteral(String contents) {
        String escaped = BaseUtils.escapeToSoyString(contents, true);
        escaped = escaped.replace("</script", "<\\/script");
        return Leaf.create(escaped);
    }

    public static WithValue number(long value) {
        Preconditions.checkArgument((boolean)IntegerNode.isInRange(value), (String)"Number is outside JS safe integer range: %s", (long)value);
        return Leaf.create(Long.toString(value));
    }

    public static WithValue number(double value) {
        return Leaf.create(Double.toString(value));
    }

    public static WithValue declare(String varName, WithValue rhs) {
        return CodeChunk.declare(null, varName, rhs);
    }

    public static WithValue declare(@Nullable String closureCompilerTypeExpression, String varName, WithValue rhs) {
        return Declaration.create(closureCompilerTypeExpression, varName, rhs);
    }

    public static WithValue not(WithValue arg) {
        return PrefixUnaryOperation.create(Operator.NOT, arg);
    }

    public static WithValue new_(WithValue ctor) {
        return New.create(ctor);
    }

    public static WithValue operation(Operator op, List<WithValue> operands, Generator codeGenerator) {
        Preconditions.checkState((operands.size() == op.getNumOperands() ? 1 : 0) != 0);
        switch (op.getNumOperands()) {
            case 1: {
                return PrefixUnaryOperation.create(op, operands.get(0));
            }
            case 2: {
                if (op == Operator.AND) {
                    return operands.get(0).and(operands.get(1), codeGenerator);
                }
                if (op == Operator.OR) {
                    return operands.get(0).or(operands.get(1), codeGenerator);
                }
                return BinaryOperation.create(op, operands.get(0), operands.get(1));
            }
            case 3: {
                Preconditions.checkArgument((op == Operator.CONDITIONAL ? 1 : 0) != 0);
                return Ternary.create(operands.get(0), operands.get(1), operands.get(2));
            }
        }
        throw new AssertionError();
    }

    public static WithValue arrayLiteral(Iterable<? extends WithValue> elements) {
        return ArrayLiteral.create((ImmutableList<? extends WithValue>)ImmutableList.copyOf(elements));
    }

    public static WithValue mapLiteral(Iterable<? extends WithValue> keys, Iterable<? extends WithValue> values) {
        return MapLiteral.create((ImmutableList<? extends WithValue>)ImmutableList.copyOf(keys), (ImmutableList<? extends WithValue>)ImmutableList.copyOf(values));
    }

    public static CodeChunk return_(WithValue returnValue) {
        return Return.create(returnValue);
    }

    public static WithValue dontTrustPrecedenceOf(JsExpr couldHaveWrongPrecedence) {
        return Group.create(CodeChunk.fromExpr(couldHaveWrongPrecedence));
    }

    public static CodeChunk treatRawStringAsStatementLegacyOnly(String rawString, Iterable<String> requires) {
        return LeafStatement.create(rawString.trim(), requires);
    }

    public abstract void collectRequires(RequiresCollector var1);

    public final String getCode() {
        return this.getCode(0, OutputContext.STATEMENT, false);
    }

    public final String getStatementsForInsertingIntoForeignCodeAtIndent(int startingIndent) {
        String code = this.getCode(startingIndent, OutputContext.STATEMENT, true);
        return code.endsWith("\n") ? code : code + "\n";
    }

    @VisibleForTesting
    public final String getExpressionTestOnly() {
        return this.getCode(0, OutputContext.TRAILING_EXPRESSION, false);
    }

    public final JsExpr assertExpr() {
        WithValue withValue = (WithValue)this;
        Preconditions.checkState((boolean)withValue.isRepresentableAsSingleExpression(), (String)"Not an expr:\n%s", (Object)this.getCode());
        return withValue.singleExprOrName();
    }

    @ForOverride
    String getCode(int startingIndent, OutputContext outputContext, boolean moreToCome) {
        FormattingContext outputExprs = new FormattingContext(startingIndent);
        if (this instanceof WithValue) {
            ((WithValue)this).formatOutputExpr(outputExprs, outputContext);
        }
        FormattingContext initialStatements = new FormattingContext(startingIndent);
        this.formatInitialStatements(initialStatements, !outputExprs.isEmpty());
        return initialStatements.concat(outputExprs).toString();
    }

    final void formatInitialStatements(FormattingContext ctx, boolean moreToCome) {
        if (ctx.shouldFormat(this)) {
            this.doFormatInitialStatements(ctx, moreToCome);
        }
    }

    @ForOverride
    abstract void doFormatInitialStatements(FormattingContext var1, boolean var2);

    void formatAllStatements(FormattingContext ctx, boolean moreToCome) {
        this.formatInitialStatements(ctx, moreToCome);
    }

    CodeChunk() {
    }

    public static final class Builder {
        private final Generator owner;
        private final ImmutableList.Builder<CodeChunk> children;
        @Nullable
        private String varName;

        private Builder(Generator owner) {
            this.owner = owner;
            this.children = ImmutableList.builder();
        }

        public Builder statement(CodeChunk chunk) {
            this.children.add((Object)Statement.create(chunk));
            return this;
        }

        public Builder statements(Iterable<? extends CodeChunk> statements) {
            for (CodeChunk codeChunk : statements) {
                this.statement(codeChunk);
            }
            return this;
        }

        public ConditionalBuilder if_(WithValue predicate, CodeChunk consequent) {
            return new ConditionalBuilder(predicate, consequent, this);
        }

        public Builder assign(WithValue rhs) {
            if (this.varName != null) {
                this.children.add((Object)Assignment.create(this.varName(), rhs));
            } else if (rhs instanceof Declaration) {
                this.children.add((Object)rhs);
                this.varName = ((Declaration)rhs).varName();
            } else {
                this.children.add((Object)Declaration.create(null, this.varName(), rhs));
            }
            return this;
        }

        private String varName() {
            if (this.varName == null) {
                this.varName = this.owner.newVarName();
            }
            return this.varName;
        }

        public CodeChunk build() {
            ImmutableList chunks = this.children.build();
            Preconditions.checkState((!chunks.isEmpty() ? 1 : 0) != 0, (Object)"CodeChunk.Builder with no chunks makes no sense");
            return chunks.size() > 1 ? Composite.create((ImmutableList<CodeChunk>)chunks, this.varName()) : (CodeChunk)chunks.get(0);
        }

        public WithValue buildAsValue() {
            CodeChunk chunk = this.build();
            return chunk instanceof Conditional ? this.createConditionalExpression((Conditional)chunk) : (WithValue)chunk;
        }

        void addChild(CodeChunk child) {
            this.children.add((Object)child);
        }

        private WithValue createConditionalExpression(Conditional conditional) {
            Preconditions.checkState((boolean)conditional.everyBranchHasAValue());
            WithValue var = this.owner.declare(WithValue.LITERAL_NULL);
            ConditionalBuilder builder = null;
            for (IfThenPair oldCondition : conditional.conditions()) {
                WithValue newConsequent = var.assign((WithValue)oldCondition.consequent);
                if (builder == null) {
                    builder = this.owner.newChunk().assign(var).if_(oldCondition.predicate, newConsequent);
                    continue;
                }
                builder.elseif_(oldCondition.predicate, newConsequent);
            }
            return (WithValue)builder.else_(var.assign((WithValue)conditional.trailingElse())).endif().build();
        }
    }

    public static final class Generator {
        private final UniqueNameGenerator nameGenerator;

        private Generator(UniqueNameGenerator nameGenerator) {
            this.nameGenerator = nameGenerator;
        }

        public static Generator create(UniqueNameGenerator nameGenerator) {
            return new Generator(nameGenerator);
        }

        private String newVarName() {
            return this.nameGenerator.generateName("$tmp");
        }

        public WithValue declare(WithValue rhs) {
            return CodeChunk.declare(this.newVarName(), rhs);
        }

        public Builder newChunk() {
            return new Builder(this);
        }

        public Builder newChunk(WithValue initialValue) {
            return new Builder(this).assign(initialValue);
        }
    }

    public static interface RequiresCollector {
        public void add(String var1);
    }

    public static abstract class WithValue
    extends CodeChunk {
        public static final WithValue LITERAL_TRUE = WithValue.id("true");
        public static final WithValue LITERAL_FALSE = WithValue.id("false");
        public static final WithValue LITERAL_NULL = WithValue.id("null");
        public static final WithValue LITERAL_EMPTY_STRING = Leaf.create("''");

        WithValue() {
        }

        public WithValue plus(WithValue rhs) {
            return BinaryOperation.create(Operator.PLUS, this, rhs);
        }

        public WithValue minus(WithValue rhs) {
            return BinaryOperation.create(Operator.MINUS, this, rhs);
        }

        public WithValue plusEquals(WithValue rhs) {
            return BinaryOperation.create("+=", 0, Operator.Associativity.RIGHT, this, rhs);
        }

        public WithValue doubleEquals(WithValue rhs) {
            return BinaryOperation.create(Operator.EQUAL, this, rhs);
        }

        public WithValue doubleNotEquals(WithValue rhs) {
            return BinaryOperation.create(Operator.NOT_EQUAL, this, rhs);
        }

        public WithValue tripleEquals(WithValue rhs) {
            return BinaryOperation.create("===", Operator.EQUAL.getPrecedence(), Operator.EQUAL.getAssociativity(), this, rhs);
        }

        public WithValue doubleEqualsNull() {
            return this.doubleEquals(LITERAL_NULL);
        }

        public WithValue times(WithValue rhs) {
            return BinaryOperation.create(Operator.TIMES, this, rhs);
        }

        public WithValue divideBy(WithValue rhs) {
            return BinaryOperation.create(Operator.DIVIDE_BY, this, rhs);
        }

        public WithValue and(WithValue rhs, Generator codeGenerator) {
            return BinaryOperation.and(this, rhs, codeGenerator);
        }

        public WithValue or(WithValue rhs, Generator codeGenerator) {
            return BinaryOperation.or(this, rhs, codeGenerator);
        }

        WithValue mod(WithValue rhs) {
            return BinaryOperation.create(Operator.MOD, this, rhs);
        }

        public WithValue dotAccess(String identifier) {
            return Dot.create(this, WithValue.id(identifier));
        }

        public WithValue bracketAccess(WithValue arg) {
            return Bracket.create(this, arg);
        }

        public WithValue call(WithValue ... args) {
            return this.call(Arrays.asList(args));
        }

        public WithValue call(Iterable<? extends WithValue> args) {
            return Call.create(this, (ImmutableList<WithValue>)ImmutableList.copyOf(args));
        }

        public WithValue instanceof_(String typeString) {
            return BinaryOperation.create("instanceof", Operator.LESS_THAN.getPrecedence(), Operator.Associativity.LEFT, this, WithValue.dottedId(typeString));
        }

        public WithValue assign(WithValue rhs) {
            return BinaryOperation.create("=", 0, Operator.Associativity.RIGHT, this, rhs);
        }

        public abstract boolean isRepresentableAsSingleExpression();

        public abstract JsExpr singleExprOrName();

        @ForOverride
        abstract void doFormatOutputExpr(FormattingContext var1, OutputContext var2);

        final void formatOutputExpr(FormattingContext ctx, OutputContext outputContext) {
            this.doFormatOutputExpr(ctx, outputContext);
            if (outputContext == OutputContext.STATEMENT && !(this instanceof Composite)) {
                ctx.append(';').endLine();
            }
        }

        @Override
        final void formatAllStatements(FormattingContext ctx, boolean moreToCome) {
            super.formatAllStatements(ctx, true);
            this.formatOutputExpr(ctx, OutputContext.STATEMENT);
        }
    }
}

