/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.jbcsrc;

import com.google.common.base.Preconditions;
import com.google.template.soy.data.SoyValueConverter;
import com.google.template.soy.data.restricted.BooleanData;
import com.google.template.soy.jbcsrc.AutoValue_FieldRef;
import com.google.template.soy.jbcsrc.BytecodeUtils;
import com.google.template.soy.jbcsrc.CodeBuilder;
import com.google.template.soy.jbcsrc.Expression;
import com.google.template.soy.jbcsrc.Statement;
import com.google.template.soy.jbcsrc.TypeInfo;
import com.google.template.soy.jbcsrc.runtime.Runtime;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.Type;

abstract class FieldRef {
    static final FieldRef BOOLEAN_DATA_FALSE = FieldRef.staticFieldReference(BooleanData.class, "FALSE");
    static final FieldRef BOOLEAN_DATA_TRUE = FieldRef.staticFieldReference(BooleanData.class, "TRUE");
    static final FieldRef NULL_PROVIDER = FieldRef.staticFieldReference(Runtime.class, "NULL_PROVIDER");
    static final FieldRef EMPTY_DICT = FieldRef.staticFieldReference(SoyValueConverter.class, "EMPTY_DICT");

    FieldRef() {
    }

    static FieldRef createFinalField(TypeInfo owner, String name, Class<?> type) {
        return FieldRef.createFinalField(owner, name, Type.getType(type));
    }

    static FieldRef createFinalField(TypeInfo owner, String name, Type type) {
        return new AutoValue_FieldRef(owner, name, type, 18, !BytecodeUtils.isPrimitive(type));
    }

    static FieldRef instanceFieldReference(Class<?> owner, String name) {
        Class<?> fieldType;
        int modifiers = 0;
        try {
            Field declaredField = owner.getDeclaredField(name);
            modifiers = declaredField.getModifiers();
            if (Modifier.isStatic(modifiers)) {
                throw new IllegalStateException("Field: " + declaredField + " is static");
            }
            fieldType = declaredField.getType();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return new AutoValue_FieldRef(TypeInfo.create(owner), name, Type.getType(fieldType), modifiers, !fieldType.isPrimitive());
    }

    static FieldRef staticFieldReference(Class<?> owner, String name) {
        Field declaredField;
        try {
            declaredField = owner.getDeclaredField(name);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return FieldRef.staticFieldReference(declaredField);
    }

    static FieldRef staticFieldReference(Field field) {
        if (!Modifier.isStatic(field.getModifiers())) {
            throw new IllegalStateException("Field: " + field + " is not static");
        }
        return new AutoValue_FieldRef(TypeInfo.create(field.getDeclaringClass()), field.getName(), Type.getType(field.getType()), 8, false);
    }

    static <T extends Enum<T>> FieldRef enumReference(T enumInstance) {
        return FieldRef.staticFieldReference(enumInstance.getDeclaringClass(), enumInstance.name());
    }

    static FieldRef createPublicStaticField(TypeInfo owner, String name, Type type) {
        return new AutoValue_FieldRef(owner, name, type, 25, !BytecodeUtils.isPrimitive(type));
    }

    static FieldRef createField(TypeInfo owner, String name, Class<?> type) {
        return FieldRef.createField(owner, name, Type.getType(type));
    }

    static FieldRef createField(TypeInfo owner, String name, Type type) {
        return new AutoValue_FieldRef(owner, name, type, 2, !BytecodeUtils.isPrimitive(type));
    }

    abstract TypeInfo owner();

    abstract String name();

    abstract Type type();

    abstract int accessFlags();

    abstract boolean isNullable();

    final boolean isStatic() {
        return (this.accessFlags() & 8) != 0;
    }

    void defineField(ClassVisitor cv) {
        cv.visitField(this.accessFlags(), this.name(), this.type().getDescriptor(), null, null);
    }

    FieldRef asNonNull() {
        if (!this.isNullable() || BytecodeUtils.isPrimitive(this.type())) {
            return this;
        }
        return new AutoValue_FieldRef(this.owner(), this.name(), this.type(), this.accessFlags(), false);
    }

    Expression accessor(final Expression owner) {
        Preconditions.checkState((!this.isStatic() ? 1 : 0) != 0);
        Preconditions.checkArgument((boolean)owner.resultType().equals((Object)this.owner().type()));
        Expression.Features features = Expression.Features.of();
        if (owner.isCheap()) {
            features = features.plus(Expression.Feature.CHEAP);
        }
        if (!this.isNullable()) {
            features = features.plus(Expression.Feature.NON_NULLABLE);
        }
        return new Expression(this.type(), features){

            @Override
            void doGen(CodeBuilder mv) {
                owner.gen(mv);
                mv.getField(FieldRef.this.owner().type(), FieldRef.this.name(), this.resultType());
            }
        };
    }

    Expression accessor() {
        Preconditions.checkState((boolean)this.isStatic());
        Expression.Features features = Expression.Features.of(Expression.Feature.CHEAP, new Expression.Feature[0]);
        if (!this.isNullable()) {
            features = features.plus(Expression.Feature.NON_NULLABLE);
        }
        return new Expression(this.type(), features){

            @Override
            void doGen(CodeBuilder mv) {
                mv.getStatic(FieldRef.this.owner().type(), FieldRef.this.name(), this.resultType());
            }
        };
    }

    Statement putInstanceField(final Expression instance, final Expression value) {
        Preconditions.checkState((!this.isStatic() ? 1 : 0) != 0, (Object)"This field is static!");
        instance.checkAssignableTo(this.owner().type());
        value.checkAssignableTo(this.type());
        return new Statement(){

            @Override
            void doGen(CodeBuilder adapter) {
                instance.gen(adapter);
                value.gen(adapter);
                FieldRef.this.putUnchecked(adapter);
            }
        };
    }

    Statement putStaticField(final Expression value) {
        Preconditions.checkState((boolean)this.isStatic(), (Object)"This field is not static!");
        value.checkAssignableTo(this.type());
        return new Statement(){

            @Override
            void doGen(CodeBuilder adapter) {
                value.gen(adapter);
                adapter.putStatic(FieldRef.this.owner().type(), FieldRef.this.name(), FieldRef.this.type());
            }
        };
    }

    void putUnchecked(CodeBuilder adapter) {
        Preconditions.checkState((!this.isStatic() ? 1 : 0) != 0, (Object)"This field is static!");
        adapter.putField(this.owner().type(), this.name(), this.type());
    }

    static FieldRef create(TypeInfo owner, String name, Type type, int accessFlags, boolean isNullable) {
        return new AutoValue_FieldRef(owner, name, type, accessFlags, isNullable);
    }
}

