/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.exprtree;

import com.google.common.base.Preconditions;
import com.google.template.soy.base.SourceLocation;
import com.google.template.soy.basetree.CopyState;
import com.google.template.soy.exprtree.AbstractExprNode;
import com.google.template.soy.exprtree.ExprNode;
import com.google.template.soy.types.SoyType;
import com.google.template.soy.types.primitive.UnknownType;

public final class GlobalNode
extends AbstractExprNode {
    public static final GlobalNode ERROR = new GlobalNode("error", SourceLocation.UNKNOWN);
    private String name;
    private boolean suppressUnknownGlobalErrors;
    private ExprNode.PrimitiveNode value = null;
    private SoyType soyType = UnknownType.getInstance();

    public GlobalNode(String name, SourceLocation sourceLocation) {
        super(sourceLocation);
        this.name = name;
    }

    private GlobalNode(GlobalNode orig, CopyState copyState) {
        super(orig, copyState);
        this.name = orig.name;
        this.soyType = orig.soyType;
        this.value = orig.value;
    }

    @Override
    public ExprNode.Kind getKind() {
        return ExprNode.Kind.GLOBAL_NODE;
    }

    @Override
    public SoyType getType() {
        return this.soyType;
    }

    public void resolve(SoyType soyType, ExprNode.PrimitiveNode value) {
        this.soyType = (SoyType)Preconditions.checkNotNull((Object)soyType);
        this.value = (ExprNode.PrimitiveNode)Preconditions.checkNotNull((Object)value);
    }

    public boolean isResolved() {
        return this.value != null;
    }

    public ExprNode.PrimitiveNode getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void suppressUnknownGlobalErrors() {
        this.suppressUnknownGlobalErrors = true;
    }

    public boolean shouldSuppressUnknownGlobalErrors() {
        return this.suppressUnknownGlobalErrors;
    }

    @Override
    public String toSourceString() {
        return this.name;
    }

    @Override
    public GlobalNode copy(CopyState copyState) {
        return new GlobalNode(this, copyState);
    }
}

