/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.error;

import com.google.common.collect.ComparisonChain;
import com.google.template.soy.base.SourceLocation;
import com.google.template.soy.error.AutoValue_SoyError;
import com.google.template.soy.error.SoyErrorKind;

public abstract class SoyError
implements Comparable<SoyError> {
    public static final Factory DEFAULT_FACTORY = new Factory(){

        @Override
        public SoyError create(SourceLocation location, SoyErrorKind kind, Object ... args) {
            String message = kind.format(args);
            return SoyError.createError(location, kind, message, location + ": error: " + message);
        }
    };

    static SoyError createError(SourceLocation location, SoyErrorKind kind, String message, String formattedError) {
        return new AutoValue_SoyError(location, kind, message, formattedError);
    }

    SoyError() {
    }

    public abstract SourceLocation location();

    public abstract SoyErrorKind errorKind();

    public abstract String message();

    abstract String formattedMessage();

    public String toString() {
        return this.formattedMessage();
    }

    @Override
    public int compareTo(SoyError o) {
        return ComparisonChain.start().compare((Comparable)this.location(), (Comparable)o.location()).compare((Comparable)((Object)this.message()), (Comparable)((Object)o.message())).result();
    }

    public static interface Factory {
        public SoyError create(SourceLocation var1, SoyErrorKind var2, Object ... var3);
    }
}

