/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.data.restricted;

import com.google.common.primitives.Booleans;
import com.google.template.soy.data.restricted.PrimitiveData;
import javax.annotation.concurrent.Immutable;

@Immutable
public final class BooleanData
extends PrimitiveData {
    public static final BooleanData TRUE = new BooleanData(true);
    public static final BooleanData FALSE = new BooleanData(false);
    private final boolean value;

    private BooleanData(boolean value) {
        this.value = value;
    }

    public static BooleanData forValue(boolean value) {
        return value ? TRUE : FALSE;
    }

    public boolean getValue() {
        return this.value;
    }

    @Override
    public boolean booleanValue() {
        return this.value;
    }

    public String toString() {
        return Boolean.toString(this.value);
    }

    @Override
    public boolean coerceToBoolean() {
        return this.value;
    }

    @Override
    public String coerceToString() {
        return this.toString();
    }

    @Override
    public boolean equals(Object other) {
        return this == other;
    }

    public int hashCode() {
        return Booleans.hashCode((boolean)this.value);
    }
}

