/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.data;

import com.google.template.soy.data.SoyAbstractCachingValueProvider;
import com.google.template.soy.data.SoyFutureException;
import com.google.template.soy.data.SoyValue;
import com.google.template.soy.data.SoyValueConverter;
import com.google.template.soy.jbcsrc.api.RenderResult;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import javax.annotation.Nonnull;

public final class SoyFutureValueProvider
extends SoyAbstractCachingValueProvider {
    private static final FutureBlockCallback NOOP = new FutureBlockCallback(){

        @Override
        public void beforeBlock() {
        }
    };
    public static final ThreadLocal<FutureBlockCallback> futureBlockCallback = new ThreadLocal<FutureBlockCallback>(){

        @Override
        protected FutureBlockCallback initialValue() {
            return NOOP;
        }
    };
    private final SoyValueConverter valueConverter;
    private final Future<?> future;

    public SoyFutureValueProvider(SoyValueConverter valueConverter, Future<?> future) {
        this.valueConverter = valueConverter;
        this.future = future;
    }

    @Override
    public RenderResult status() {
        return this.future.isDone() ? RenderResult.done() : RenderResult.continueAfter(this.future);
    }

    @Override
    @Nonnull
    protected final SoyValue compute() {
        try {
            if (!this.future.isDone()) {
                futureBlockCallback.get().beforeBlock();
            }
            return this.valueConverter.convert(this.future.get()).resolve();
        }
        catch (ExecutionException e) {
            throw new SoyFutureException(e.getCause());
        }
        catch (Throwable e) {
            throw new SoyFutureException(e);
        }
    }

    public static interface FutureBlockCallback {
        public void beforeBlock();
    }
}

