/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSortedSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.io.ByteSink;
import com.google.common.io.CharSource;
import com.google.inject.Guice;
import com.google.inject.Inject;
import com.google.inject.Module;
import com.google.inject.Provider;
import com.google.inject.util.Providers;
import com.google.protobuf.Descriptors;
import com.google.template.soy.ErrorReporterImpl;
import com.google.template.soy.GuiceInitializer;
import com.google.template.soy.SoyFileSetParser;
import com.google.template.soy.SoyModule;
import com.google.template.soy.base.internal.SoyFileKind;
import com.google.template.soy.base.internal.SoyFileSupplier;
import com.google.template.soy.base.internal.VolatileSoyFileSupplier;
import com.google.template.soy.basetree.SyntaxVersion;
import com.google.template.soy.conformance.CheckConformance;
import com.google.template.soy.conformance.ConformanceInput;
import com.google.template.soy.error.PrettyErrorFactory;
import com.google.template.soy.error.SnippetFormatter;
import com.google.template.soy.error.SoyCompilationException;
import com.google.template.soy.error.SoyError;
import com.google.template.soy.incrementaldomsrc.IncrementalDomSrcMain;
import com.google.template.soy.jbcsrc.BytecodeCompiler;
import com.google.template.soy.jbcsrc.api.SoySauce;
import com.google.template.soy.jbcsrc.api.SoySauceImpl;
import com.google.template.soy.jbcsrc.shared.CompiledTemplates;
import com.google.template.soy.jssrc.SoyJsSrcOptions;
import com.google.template.soy.jssrc.internal.JsSrcMain;
import com.google.template.soy.msgs.SoyMsgBundle;
import com.google.template.soy.msgs.SoyMsgBundleHandler;
import com.google.template.soy.msgs.internal.ExtractMsgsVisitor;
import com.google.template.soy.msgs.restricted.SoyMsg;
import com.google.template.soy.msgs.restricted.SoyMsgBundleImpl;
import com.google.template.soy.parseinfo.passes.GenerateParseInfoVisitor;
import com.google.template.soy.parsepasses.contextautoesc.ContentSecurityPolicyPass;
import com.google.template.soy.parsepasses.contextautoesc.ContextualAutoescaper;
import com.google.template.soy.parsepasses.contextautoesc.DerivedTemplateUtils;
import com.google.template.soy.passes.ChangeCallsToPassAllDataVisitor;
import com.google.template.soy.passes.ClearSoyDocStringsVisitor;
import com.google.template.soy.passes.FindIjParamsVisitor;
import com.google.template.soy.passes.FindTransitiveDepTemplatesVisitor;
import com.google.template.soy.passes.PassManager;
import com.google.template.soy.pysrc.SoyPySrcOptions;
import com.google.template.soy.pysrc.internal.PySrcMain;
import com.google.template.soy.shared.SoyAstCache;
import com.google.template.soy.shared.SoyGeneralOptions;
import com.google.template.soy.shared.internal.MainEntryPointUtils;
import com.google.template.soy.shared.restricted.SoyFunction;
import com.google.template.soy.shared.restricted.SoyPrintDirective;
import com.google.template.soy.sharedpasses.opti.SimplifyVisitor;
import com.google.template.soy.soytree.SoyFileNode;
import com.google.template.soy.soytree.SoyFileSetNode;
import com.google.template.soy.soytree.SoyNode;
import com.google.template.soy.soytree.SoyTreeUtils;
import com.google.template.soy.soytree.TemplateDelegateNode;
import com.google.template.soy.soytree.TemplateNode;
import com.google.template.soy.soytree.TemplateRegistry;
import com.google.template.soy.soytree.Visibility;
import com.google.template.soy.tofu.SoyTofu;
import com.google.template.soy.tofu.internal.BaseTofu;
import com.google.template.soy.types.SoyTypeProvider;
import com.google.template.soy.types.SoyTypeRegistry;
import com.google.template.soy.types.proto.SoyProtoTypeProvider;
import com.google.template.soy.xliffmsgplugin.XliffMsgPlugin;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public final class SoyFileSet {
    private static final Provider<SoyMsgBundleHandler> DEFAULT_SOY_MSG_BUNDLE_HANDLER_PROVIDER = Providers.of((Object)new SoyMsgBundleHandler(new XliffMsgPlugin()));
    private final Provider<SoyMsgBundleHandler> msgBundleHandlerProvider;
    private final BaseTofu.BaseTofuFactory baseTofuFactory;
    private final SoySauceImpl.Factory soyTemplatesFactory;
    private final Provider<JsSrcMain> jsSrcMainProvider;
    private final Provider<IncrementalDomSrcMain> incrementalDomSrcMainProvider;
    private final Provider<PySrcMain> pySrcMainProvider;
    private final ContextualAutoescaper contextualAutoescaper;
    private final SimplifyVisitor simplifyVisitor;
    private final SoyTypeRegistry typeRegistry;
    private final ImmutableMap<String, SoyFileSupplier> soyFileSuppliers;
    private final SoyAstCache cache;
    private final SoyGeneralOptions generalOptions;
    private final CheckConformance checkConformance;
    private ImmutableSet<Long> memoizedExtractedMsgIdsForPruning;
    private final ImmutableMap<String, ? extends SoyFunction> soyFunctionMap;
    private final ImmutableMap<String, ? extends SoyPrintDirective> printDirectives;
    private ErrorReporterImpl errorReporter;

    public static Builder builder() {
        return (Builder)Guice.createInjector((Module[])new Module[]{new SoyModule()}).getInstance(Builder.class);
    }

    SoyFileSet(BaseTofu.BaseTofuFactory baseTofuFactory, SoySauceImpl.Factory soyTemplatesFactory, Provider<JsSrcMain> jsSrcMainProvider, Provider<IncrementalDomSrcMain> incrementalDomSrcMainProvider, Provider<PySrcMain> pySrcMainProvider, ContextualAutoescaper contextualAutoescaper, SimplifyVisitor simplifyVisitor, SoyTypeRegistry typeRegistry, ImmutableMap<String, ? extends SoyFunction> soyFunctionMap, ImmutableMap<String, ? extends SoyPrintDirective> printDirectives, ImmutableMap<String, SoyFileSupplier> soyFileSuppliers, SoyGeneralOptions generalOptions, @Nullable SoyAstCache cache, Provider<SoyMsgBundleHandler> msgBundleHandlerProvider, CheckConformance checkConformance) {
        this.soyTemplatesFactory = soyTemplatesFactory;
        this.baseTofuFactory = baseTofuFactory;
        this.jsSrcMainProvider = jsSrcMainProvider;
        this.incrementalDomSrcMainProvider = incrementalDomSrcMainProvider;
        this.pySrcMainProvider = pySrcMainProvider;
        this.contextualAutoescaper = contextualAutoescaper;
        this.simplifyVisitor = simplifyVisitor;
        Preconditions.checkArgument((!soyFileSuppliers.isEmpty() ? 1 : 0) != 0, (Object)"Must have non-zero number of input Soy files.");
        this.typeRegistry = typeRegistry;
        this.soyFileSuppliers = soyFileSuppliers;
        this.cache = cache;
        this.generalOptions = generalOptions.clone();
        this.soyFunctionMap = soyFunctionMap;
        this.printDirectives = printDirectives;
        this.msgBundleHandlerProvider = msgBundleHandlerProvider;
        this.checkConformance = checkConformance;
    }

    @VisibleForTesting
    ImmutableMap<String, SoyFileSupplier> getSoyFileSuppliersForTesting() {
        return this.soyFileSuppliers;
    }

    @VisibleForTesting
    SoyGeneralOptions getOptionsForTesting() {
        return this.generalOptions;
    }

    public ImmutableMap<String, String> generateParseInfo(String javaPackage, String javaClassNameSource) {
        this.resetErrorReporter();
        SoyFileSetParser.ParseResult result = this.parse(SyntaxVersion.V2_0, true, true, this.typeRegistry, this.soyFunctionMap);
        this.throwIfErrorsPresent();
        SoyFileSetNode soyTree = result.fileSet();
        TemplateRegistry registry = result.registry();
        registry = this.autoescape(registry, soyTree);
        ImmutableMap<String, String> parseInfo = new GenerateParseInfoVisitor(javaPackage, javaClassNameSource, registry).exec(soyTree);
        this.throwIfErrorsPresent();
        return parseInfo;
    }

    public SoyMsgBundle extractMsgs() {
        this.resetErrorReporter();
        SoyFileSetNode soyTree = this.parse(SyntaxVersion.V1_0, true, true, SoyTypeRegistry.DEFAULT_UNKNOWN, this.soyFunctionMap).fileSet();
        SoyMsgBundle bundle = new ExtractMsgsVisitor().exec(soyTree);
        return bundle;
    }

    public SoyMsgBundle pruneTranslatedMsgs(SoyMsgBundle origTransMsgBundle) {
        this.resetErrorReporter();
        if (this.memoizedExtractedMsgIdsForPruning == null) {
            SoyFileSetParser.ParseResult result = this.parse(SyntaxVersion.V1_0, true, true, SoyTypeRegistry.DEFAULT_UNKNOWN, this.soyFunctionMap);
            SoyFileSetNode soyTree = result.fileSet();
            TemplateRegistry registry = result.registry();
            ArrayList allPublicTemplates = Lists.newArrayList();
            for (SoyFileNode soyFile : soyTree.getChildren()) {
                for (TemplateNode template : soyFile.getChildren()) {
                    if (template.getVisibility() != Visibility.PUBLIC) continue;
                    allPublicTemplates.add(template);
                }
            }
            ImmutableMap<TemplateNode, FindTransitiveDepTemplatesVisitor.TransitiveDepTemplatesInfo> depsInfoMap = new FindTransitiveDepTemplatesVisitor(registry).execOnMultipleTemplates(allPublicTemplates);
            FindTransitiveDepTemplatesVisitor.TransitiveDepTemplatesInfo mergedDepsInfo = FindTransitiveDepTemplatesVisitor.TransitiveDepTemplatesInfo.merge(depsInfoMap.values());
            SoyMsgBundle extractedMsgBundle = new ExtractMsgsVisitor().execOnMultipleNodes((Iterable<? extends SoyNode>)mergedDepsInfo.depTemplateSet);
            ImmutableSet.Builder extractedMsgIdsBuilder = ImmutableSet.builder();
            for (SoyMsg extractedMsg : extractedMsgBundle) {
                extractedMsgIdsBuilder.add((Object)extractedMsg.getId());
            }
            this.memoizedExtractedMsgIdsForPruning = extractedMsgIdsBuilder.build();
        }
        ImmutableList.Builder prunedTransMsgsBuilder = ImmutableList.builder();
        for (SoyMsg transMsg : origTransMsgBundle) {
            if (!this.memoizedExtractedMsgIdsForPruning.contains((Object)transMsg.getId())) continue;
            prunedTransMsgsBuilder.add((Object)transMsg);
        }
        return new SoyMsgBundleImpl(origTransMsgBundle.getLocaleString(), (List<SoyMsg>)prunedTransMsgsBuilder.build());
    }

    public SoyTofu compileToTofu() {
        this.resetErrorReporter();
        ServerCompilationPrimitives primitives = this.compileForServerRendering();
        this.throwIfErrorsPresent();
        return this.doCompileToTofu(primitives);
    }

    private SoyTofu doCompileToTofu(ServerCompilationPrimitives primitives) {
        return this.baseTofuFactory.create(primitives.registry, this.getTransitiveIjs(primitives.soyTree, primitives.registry), this.printDirectives);
    }

    public SoySauce compileTemplates() {
        this.resetErrorReporter();
        this.disallowExternalCalls();
        ServerCompilationPrimitives primitives = this.compileForServerRendering();
        this.throwIfErrorsPresent();
        return this.doCompileSoySauce(primitives);
    }

    void compileToJar(ByteSink jarTarget, Optional<ByteSink> srcJarTarget) throws IOException {
        this.resetErrorReporter();
        this.disallowExternalCalls();
        ServerCompilationPrimitives primitives = this.compileForServerRendering();
        BytecodeCompiler.compileToJar(primitives.registry, this.errorReporter, jarTarget);
        if (srcJarTarget.isPresent()) {
            BytecodeCompiler.writeSrcJar(primitives.registry, this.soyFileSuppliers, (ByteSink)srcJarTarget.get());
        }
        this.throwIfErrorsPresent();
    }

    private SoySauce doCompileSoySauce(ServerCompilationPrimitives primitives) {
        Optional<CompiledTemplates> templates = BytecodeCompiler.compile(primitives.registry, this.cache != null, this.errorReporter);
        this.throwIfErrorsPresent();
        return this.soyTemplatesFactory.create((CompiledTemplates)templates.get(), this.soyFunctionMap, this.printDirectives);
    }

    private ServerCompilationPrimitives compileForServerRendering() {
        SoyFileSetParser.ParseResult result = this.parse(SyntaxVersion.V2_0);
        this.throwIfErrorsPresent();
        SoyFileSetNode soyTree = result.fileSet();
        TemplateRegistry registry = result.registry();
        registry = this.autoescape(registry, soyTree);
        this.optimize(registry, soyTree);
        if (this.cache == null) {
            new ClearSoyDocStringsVisitor().exec(soyTree);
        }
        this.throwIfErrorsPresent();
        return new ServerCompilationPrimitives(registry, soyTree);
    }

    private ImmutableMap<String, ImmutableSortedSet<String>> getTransitiveIjs(SoyFileSetNode soyTree, TemplateRegistry registry) {
        ImmutableMap<TemplateNode, FindIjParamsVisitor.IjParamsInfo> templateToIjParamsInfoMap = new FindIjParamsVisitor(registry).execOnAllTemplates(soyTree);
        ImmutableMap.Builder templateToTransitiveIjParams = ImmutableMap.builder();
        for (Map.Entry entry : templateToIjParamsInfoMap.entrySet()) {
            templateToTransitiveIjParams.put((Object)((TemplateNode)entry.getKey()).getTemplateName(), ((FindIjParamsVisitor.IjParamsInfo)entry.getValue()).ijParamSet);
        }
        return templateToTransitiveIjParams.build();
    }

    private void disallowExternalCalls() {
        Boolean allowExternalCalls = this.generalOptions.allowExternalCalls();
        if (allowExternalCalls == null) {
            this.generalOptions.setAllowExternalCalls(false);
        } else if (allowExternalCalls.booleanValue()) {
            throw new IllegalStateException("SoyGeneralOptions.setAllowExternalCalls(true) is not supported with this method");
        }
    }

    public List<String> compileToJsSrc(SoyJsSrcOptions jsSrcOptions, @Nullable SoyMsgBundle msgBundle) {
        this.resetErrorReporter();
        if (jsSrcOptions.shouldAllowDeprecatedSyntax()) {
            this.generalOptions.setDeclaredSyntaxVersionName("1.0");
        }
        SoyFileSetParser.ParseResult parseResult = this.parse(SyntaxVersion.V2_0, true, false, this.typeRegistry, this.soyFunctionMap);
        this.throwIfErrorsPresent();
        TemplateRegistry registry = parseResult.registry();
        SoyFileSetNode fileSet = parseResult.fileSet();
        registry = this.autoescape(registry, fileSet);
        this.optimize(registry, fileSet);
        this.throwIfErrorsPresent();
        List<String> generatedSrcs = ((JsSrcMain)this.jsSrcMainProvider.get()).genJsSrc(fileSet, registry, jsSrcOptions, msgBundle, this.errorReporter);
        this.throwIfErrorsPresent();
        return generatedSrcs;
    }

    void compileToJsSrcFiles(String outputPathFormat, String inputFilePathPrefix, SoyJsSrcOptions jsSrcOptions, List<String> locales, @Nullable String messageFilePathFormat) throws IOException {
        this.resetErrorReporter();
        if (jsSrcOptions.shouldAllowDeprecatedSyntax()) {
            this.generalOptions.setDeclaredSyntaxVersionName("1.0");
        }
        SoyFileSetParser.ParseResult result = this.parse(SyntaxVersion.V2_0, true, false, this.typeRegistry, this.soyFunctionMap);
        this.throwIfErrorsPresent();
        SoyFileSetNode soyTree = result.fileSet();
        TemplateRegistry registry = result.registry();
        registry = this.autoescape(registry, soyTree);
        this.optimize(registry, soyTree);
        this.throwIfErrorsPresent();
        if (locales.isEmpty()) {
            ((JsSrcMain)this.jsSrcMainProvider.get()).genJsFiles(soyTree, registry, jsSrcOptions, null, null, outputPathFormat, inputFilePathPrefix, this.errorReporter);
        } else {
            for (String locale : locales) {
                SoyFileSetNode soyTreeClone = SoyTreeUtils.cloneNode(soyTree);
                String msgFilePath = MainEntryPointUtils.buildFilePath(messageFilePathFormat, locale, null, inputFilePathPrefix);
                SoyMsgBundle msgBundle = ((SoyMsgBundleHandler)this.msgBundleHandlerProvider.get()).createFromFile(new File(msgFilePath));
                if (msgBundle.getLocaleString() == null && !locale.startsWith("en")) {
                    throw new IOException("Error opening or reading message file " + msgFilePath);
                }
                ((JsSrcMain)this.jsSrcMainProvider.get()).genJsFiles(soyTreeClone, registry, jsSrcOptions, locale, msgBundle, outputPathFormat, inputFilePathPrefix, this.errorReporter);
            }
        }
        this.throwIfErrorsPresent();
    }

    public List<String> compileToIncrementalDomSrc(SoyJsSrcOptions jsSrcOptions) throws IOException {
        this.resetErrorReporter();
        SoyFileSetParser.ParseResult result = this.preprocessIncrementalDOMResults();
        List<String> generatedSrcs = ((IncrementalDomSrcMain)this.incrementalDomSrcMainProvider.get()).genJsSrc(result.fileSet(), result.registry(), jsSrcOptions, this.errorReporter);
        this.throwIfErrorsPresent();
        return generatedSrcs;
    }

    void compileToIncrementalDomSrcFiles(String outputPathFormat, SoyJsSrcOptions jsSrcOptions) throws IOException {
        this.resetErrorReporter();
        SoyFileSetParser.ParseResult result = this.preprocessIncrementalDOMResults();
        ((IncrementalDomSrcMain)this.incrementalDomSrcMainProvider.get()).genJsFiles(result.fileSet(), result.registry(), jsSrcOptions, outputPathFormat, this.errorReporter);
        this.throwIfErrorsPresent();
    }

    private SoyFileSetParser.ParseResult preprocessIncrementalDOMResults() {
        SyntaxVersion declaredSyntaxVersion = this.generalOptions.getDeclaredSyntaxVersion(SyntaxVersion.V2_0);
        Preconditions.checkState((declaredSyntaxVersion.num >= SyntaxVersion.V2_0.num ? 1 : 0) != 0, (Object)"Incremental DOM code generation only supports syntax version of V2 or higher.");
        SoyFileSetParser.ParseResult result = this.parse(SyntaxVersion.V2_0);
        this.throwIfErrorsPresent();
        SoyFileSetNode soyTree = result.fileSet();
        new ChangeCallsToPassAllDataVisitor().exec(soyTree);
        this.simplifyVisitor.simplify(soyTree, result.registry());
        this.throwIfErrorsPresent();
        return result;
    }

    public void compileToPySrcFiles(String outputPathFormat, String inputFilePathPrefix, SoyPySrcOptions pySrcOptions) throws IOException {
        this.resetErrorReporter();
        SoyFileSetParser.ParseResult result = this.parse(SyntaxVersion.V2_0);
        this.throwIfErrorsPresent();
        SoyFileSetNode soyTree = result.fileSet();
        TemplateRegistry registry = result.registry();
        registry = this.autoescape(registry, result.fileSet());
        this.optimize(registry, soyTree);
        this.throwIfErrorsPresent();
        ((PySrcMain)this.pySrcMainProvider.get()).genPyFiles(soyTree, registry, pySrcOptions, outputPathFormat, inputFilePathPrefix, this.errorReporter);
        this.throwIfErrorsPresent();
    }

    private SoyFileSetParser.ParseResult parse(SyntaxVersion defaultVersion) {
        return this.parse(defaultVersion, false, false, this.typeRegistry, this.soyFunctionMap);
    }

    private SoyFileSetParser.ParseResult parse(SyntaxVersion defaultVersion, boolean allowUnknownGlobals, boolean allowUnknownFunctions, SoyTypeRegistry typeRegistry, ImmutableMap<String, ? extends SoyFunction> soyFunctionMap) {
        SyntaxVersion declaredSyntaxVersion = this.generalOptions.getDeclaredSyntaxVersion(defaultVersion);
        PassManager.Builder builder = new PassManager.Builder().setTypeRegistry(typeRegistry).setGeneralOptions(this.generalOptions).setDeclaredSyntaxVersion(declaredSyntaxVersion).setSoyFunctionMap(soyFunctionMap).setErrorReporter(this.errorReporter);
        if (allowUnknownGlobals) {
            builder.allowUnknownGlobals();
        }
        if (allowUnknownFunctions) {
            builder.allowUnknownFunctions();
        }
        return new SoyFileSetParser(typeRegistry, this.cache, this.soyFileSuppliers, builder.build(), this.errorReporter).parse();
    }

    @CheckReturnValue
    private synchronized TemplateRegistry autoescape(TemplateRegistry registry, SoyFileSetNode soyTree) {
        this.doContextualEscaping(soyTree, registry);
        this.throwIfErrorsPresent();
        registry = new TemplateRegistry(soyTree, this.errorReporter);
        if (this.checkConformance != null) {
            this.checkConformance.check(ConformanceInput.create(soyTree, this.contextualAutoescaper.getSlicedRawTextNodes()), this.errorReporter);
        }
        ContentSecurityPolicyPass.blessAuthorSpecifiedScripts(this.contextualAutoescaper.getSlicedRawTextNodes());
        return registry;
    }

    private void optimize(TemplateRegistry registry, SoyFileSetNode soyTree) {
        new ChangeCallsToPassAllDataVisitor().exec(soyTree);
        this.simplifyVisitor.simplify(soyTree, registry);
    }

    private void doContextualEscaping(SoyFileSetNode soyTree, TemplateRegistry registry) {
        List<TemplateNode> extraTemplates = this.contextualAutoescaper.rewrite(soyTree, registry, this.errorReporter);
        if (!extraTemplates.isEmpty()) {
            HashMap containingFile = Maps.newHashMap();
            for (SoyFileNode fileNode : soyTree.getChildren()) {
                for (TemplateNode templateNode : fileNode.getChildren()) {
                    String name = templateNode instanceof TemplateDelegateNode ? ((TemplateDelegateNode)templateNode).getDelTemplateName() : templateNode.getTemplateName();
                    containingFile.put(DerivedTemplateUtils.getBaseName(name), fileNode);
                }
            }
            for (TemplateNode extraTemplate : extraTemplates) {
                String name = extraTemplate instanceof TemplateDelegateNode ? ((TemplateDelegateNode)extraTemplate).getDelTemplateName() : extraTemplate.getTemplateName();
                ((SoyFileNode)containingFile.get(DerivedTemplateUtils.getBaseName(name))).addChild(extraTemplate);
            }
        }
    }

    private void resetErrorReporter() {
        this.errorReporter = new ErrorReporterImpl(new PrettyErrorFactory(new SnippetFormatter(this.soyFileSuppliers)));
    }

    private void throwIfErrorsPresent() {
        if (this.errorReporter.hasErrors()) {
            Iterable<SoyError> errors = this.errorReporter.getErrors();
            this.errorReporter = null;
            throw new SoyCompilationException(errors);
        }
    }

    static /* synthetic */ Provider access$000() {
        return DEFAULT_SOY_MSG_BUNDLE_HANDLER_PROVIDER;
    }

    private static final class ServerCompilationPrimitives {
        final SoyFileSetNode soyTree;
        final TemplateRegistry registry;

        ServerCompilationPrimitives(TemplateRegistry registry, SoyFileSetNode soyTree) {
            this.registry = registry;
            this.soyTree = soyTree;
        }
    }

    public static final class Builder {
        private final ImmutableMap.Builder<String, SoyFileSupplier> filesBuilder;
        private SoyAstCache cache = null;
        private SoyGeneralOptions lazyGeneralOptions = null;
        private SoyTypeRegistry localTypeRegistry;
        private CoreDependencies coreDependencies;
        private CheckConformance checkConformance;
        private Provider<SoyMsgBundleHandler> msgBundleHandlerProvider = SoyFileSet.access$000();
        private final SoyProtoTypeProvider.Builder protoTypeProviderBuilder;

        @Inject
        @Deprecated
        Builder() {
            this.filesBuilder = ImmutableMap.builder();
            this.protoTypeProviderBuilder = new SoyProtoTypeProvider.Builder();
        }

        @Inject(optional=true)
        void setCoreDependencies(CoreDependencies coreDependencies) {
            this.coreDependencies = coreDependencies;
        }

        @Inject(optional=true)
        void setMsgBundleHandlerProvider(Provider<SoyMsgBundleHandler> msgBundleHandlerProvider) {
            this.msgBundleHandlerProvider = msgBundleHandlerProvider;
        }

        @Inject(optional=true)
        void setCheckConformance(CheckConformance checkConformance) {
            this.checkConformance = checkConformance;
        }

        public void setGeneralOptions(SoyGeneralOptions generalOptions) {
            Preconditions.checkState((this.lazyGeneralOptions == null ? 1 : 0) != 0, (Object)"Call SoyFileSet#setGeneralOptions before any other setters.");
            Preconditions.checkNotNull((Object)generalOptions, (Object)"Non-null argument expected.");
            this.lazyGeneralOptions = generalOptions.clone();
        }

        private SoyGeneralOptions getGeneralOptions() {
            if (this.lazyGeneralOptions == null) {
                this.lazyGeneralOptions = new SoyGeneralOptions();
            }
            return this.lazyGeneralOptions;
        }

        public SoyFileSet build() {
            if (this.coreDependencies == null) {
                this.coreDependencies = GuiceInitializer.getHackyCoreDependencies();
            }
            try {
                if (!this.protoTypeProviderBuilder.isEmpty()) {
                    ImmutableSet typeProviders = ImmutableSet.of((Object)this.protoTypeProviderBuilder.build());
                    this.localTypeRegistry = new SoyTypeRegistry((Set<SoyTypeProvider>)typeProviders);
                }
            }
            catch (Descriptors.DescriptorValidationException | IOException ex) {
                throw new RuntimeException("Malformed descriptor set", ex);
            }
            return new SoyFileSet(this.coreDependencies.baseTofuFactory, this.coreDependencies.soyTemplatesFactory, (Provider<JsSrcMain>)this.coreDependencies.jsSrcMainProvider, (Provider<IncrementalDomSrcMain>)this.coreDependencies.incrementalDomSrcMainProvider, (Provider<PySrcMain>)this.coreDependencies.pySrcMainProvider, this.coreDependencies.contextualAutoescaper, this.coreDependencies.simplifyVisitor, this.localTypeRegistry == null ? this.coreDependencies.typeRegistry : this.localTypeRegistry, (ImmutableMap<String, ? extends SoyFunction>)this.coreDependencies.soyFunctionMap, (ImmutableMap<String, ? extends SoyPrintDirective>)this.coreDependencies.printDirectives, (ImmutableMap<String, SoyFileSupplier>)this.filesBuilder.build(), this.getGeneralOptions(), this.cache, this.msgBundleHandlerProvider, this.checkConformance);
        }

        public Builder addWithKind(CharSource contentSource, SoyFileKind soyFileKind, String filePath) {
            return this.addFile(SoyFileSupplier.Factory.create(contentSource, soyFileKind, filePath));
        }

        public Builder add(CharSource contentSource, String filePath) {
            return this.addWithKind(contentSource, SoyFileKind.SRC, filePath);
        }

        public Builder addWithKind(File inputFile, SoyFileKind soyFileKind) {
            return this.addFile(SoyFileSupplier.Factory.create(inputFile, soyFileKind));
        }

        public Builder add(File inputFile) {
            return this.addWithKind(inputFile, SoyFileKind.SRC);
        }

        public Builder addVolatileWithKind(File inputFile, SoyFileKind soyFileKind) {
            return this.addFile(new VolatileSoyFileSupplier(inputFile, soyFileKind));
        }

        public Builder addVolatile(File inputFile) {
            return this.addVolatileWithKind(inputFile, SoyFileKind.SRC);
        }

        public Builder addWithKind(URL inputFileUrl, SoyFileKind soyFileKind, String filePath) {
            return this.addFile(SoyFileSupplier.Factory.create(inputFileUrl, soyFileKind, filePath));
        }

        public Builder add(URL inputFileUrl, String filePath) {
            return this.addWithKind(inputFileUrl, SoyFileKind.SRC, filePath);
        }

        public Builder addWithKind(URL inputFileUrl, SoyFileKind soyFileKind) {
            return this.addFile(SoyFileSupplier.Factory.create(inputFileUrl, soyFileKind));
        }

        public Builder add(URL inputFileUrl) {
            return this.addWithKind(inputFileUrl, SoyFileKind.SRC);
        }

        public Builder addWithKind(CharSequence content, SoyFileKind soyFileKind, String filePath) {
            return this.addFile(SoyFileSupplier.Factory.create(content, soyFileKind, filePath));
        }

        public Builder add(CharSequence content, String filePath) {
            return this.addWithKind(content, SoyFileKind.SRC, filePath);
        }

        public Builder setSoyAstCache(SoyAstCache cache) {
            this.cache = cache;
            return this;
        }

        public Builder setDeclaredSyntaxVersionName(@Nonnull String versionName) {
            this.getGeneralOptions().setDeclaredSyntaxVersionName(versionName);
            return this;
        }

        public Builder setAllowExternalCalls(boolean allowExternalCalls) {
            this.getGeneralOptions().setAllowExternalCalls(allowExternalCalls);
            return this;
        }

        public Builder setExperimentalFeatures(List<String> experimentalFeatures) {
            this.getGeneralOptions().setExperimentalFeatures(experimentalFeatures);
            return this;
        }

        public Builder setStrictAutoescapingRequired(boolean strictAutoescapingRequired) {
            this.getGeneralOptions().setStrictAutoescapingRequired(strictAutoescapingRequired);
            return this;
        }

        public Builder setCompileTimeGlobals(Map<String, ?> compileTimeGlobalsMap) {
            this.getGeneralOptions().setCompileTimeGlobals(compileTimeGlobalsMap);
            return this;
        }

        public Builder setCompileTimeGlobals(File compileTimeGlobalsFile) throws IOException {
            this.getGeneralOptions().setCompileTimeGlobals(compileTimeGlobalsFile);
            return this;
        }

        public Builder setCompileTimeGlobals(URL compileTimeGlobalsResource) throws IOException {
            this.getGeneralOptions().setCompileTimeGlobals(compileTimeGlobalsResource);
            return this;
        }

        Builder addProtoFileDescriptorSetFromFile(File descriptorFile) {
            this.protoTypeProviderBuilder.addFileDescriptorSetFromFile(descriptorFile);
            return this;
        }

        public Builder addProtoDescriptors(Iterable<? extends Descriptors.GenericDescriptor> descriptors) {
            this.protoTypeProviderBuilder.addDescriptors(descriptors);
            return this;
        }

        public Builder setLocalTypeRegistry(SoyTypeRegistry typeRegistry) {
            this.localTypeRegistry = typeRegistry;
            return this;
        }

        private Builder addFile(SoyFileSupplier supplier) {
            this.filesBuilder.put((Object)supplier.getFilePath(), (Object)supplier);
            return this;
        }
    }

    static final class CoreDependencies {
        private final BaseTofu.BaseTofuFactory baseTofuFactory;
        private final SoySauceImpl.Factory soyTemplatesFactory;
        private final Provider<JsSrcMain> jsSrcMainProvider;
        private final Provider<IncrementalDomSrcMain> incrementalDomSrcMainProvider;
        private final Provider<PySrcMain> pySrcMainProvider;
        private final ContextualAutoescaper contextualAutoescaper;
        private final SimplifyVisitor simplifyVisitor;
        private final SoyTypeRegistry typeRegistry;
        private final ImmutableMap<String, ? extends SoyFunction> soyFunctionMap;
        private final ImmutableMap<String, ? extends SoyPrintDirective> printDirectives;

        @Inject
        CoreDependencies(BaseTofu.BaseTofuFactory baseTofuFactory, SoySauceImpl.Factory soyTemplatesFactory, Provider<JsSrcMain> jsSrcMainProvider, Provider<IncrementalDomSrcMain> incrementalDomSrcMainProvider, Provider<PySrcMain> pySrcMainProvider, ContextualAutoescaper contextualAutoescaper, SimplifyVisitor simplifyVisitor, SoyTypeRegistry typeRegistry, ImmutableMap<String, ? extends SoyFunction> soyFunctionMap, ImmutableMap<String, ? extends SoyPrintDirective> printDirectives) {
            this.baseTofuFactory = baseTofuFactory;
            this.soyTemplatesFactory = soyTemplatesFactory;
            this.jsSrcMainProvider = jsSrcMainProvider;
            this.incrementalDomSrcMainProvider = incrementalDomSrcMainProvider;
            this.pySrcMainProvider = pySrcMainProvider;
            this.contextualAutoescaper = contextualAutoescaper;
            this.simplifyVisitor = simplifyVisitor;
            this.typeRegistry = typeRegistry;
            this.soyFunctionMap = soyFunctionMap;
            this.printDirectives = printDirectives;
        }
    }
}

