/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy;

import com.google.inject.Guice;
import com.google.inject.Module;
import com.google.inject.Provider;
import com.google.template.soy.SoyFileSet;
import com.google.template.soy.SoyModule;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.inject.Inject;

class GuiceInitializer {
    private static final Logger logger = Logger.getLogger(GuiceInitializer.class.getName());
    private static int initializationCount;
    @Inject
    private static Provider<SoyFileSet.CoreDependencies> coreDepsProvider;

    GuiceInitializer() {
    }

    @Inject
    static synchronized void markInitialized() {
        ++initializationCount;
    }

    private static synchronized void initializeIfNecessary() {
        if (initializationCount == 0) {
            Guice.createInjector((Module[])new Module[]{new SoyModule()});
            if (initializationCount == 0) {
                throw new AssertionError((Object)"Injector creation failed to do static injection.");
            }
        }
    }

    static synchronized SoyFileSet.CoreDependencies getHackyCoreDependencies() {
        GuiceInitializer.initializeIfNecessary();
        if (initializationCount > 1) {
            String message = "The SoyFileSet.Builder constructor is trying to guess which Injector to use, but multiple Injectors have already installed a new SoyModule(). We will essentially configure Soy at random, so you get an inconsistent set of plugins or Soy types. To fix, inject SoyFileSet.Builder (with SoyModule installed) instead of new'ing it.\n\nThis hack will soon be removed and may break your service.  Please Fix.";
            logger.log(Level.SEVERE, message, new IllegalStateException(message));
        } else {
            String message = "Falling back to statically-injected SoyFileSetFactory; unpredictable behavior is likely. Instead of constructing a SoyFileSet.Builder directly, either inject it using Guice (with SoyModule installed), or call the static SoyFileSet.builder() method.\n\nThis hack will soon be removed and may break your service.  Please Fix.";
            logger.log(Level.SEVERE, message, new IllegalStateException(message));
        }
        return (SoyFileSet.CoreDependencies)coreDepsProvider.get();
    }
}

