/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.errorprone.annotations.ForOverride;
import com.google.inject.Injector;
import com.google.inject.Module;
import com.google.template.soy.MainClassUtils;
import com.google.template.soy.SoyFileSet;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.CheckReturnValue;
import org.kohsuke.args4j.Argument;
import org.kohsuke.args4j.CmdLineParser;
import org.kohsuke.args4j.Option;

abstract class AbstractSoyCompiler {
    private final String usagePrefix = "Usage:\njava " + this.getClass().getName() + " \\\n" + "     [<flag1> <flag2> ...] --jar <jarName>  \\\n" + "     --srcs <soyFilePath>,... [--deps <soyFilePath>,...]\n";
    private final Function<String, Void> exitWithErrorFn = new Function<String, Void>(){

        public Void apply(String errorMsg) {
            AbstractSoyCompiler.this.exitWithError(errorMsg);
            return null;
        }
    };
    @Option(name="--inputPrefix", usage="If provided, this path prefix will be prepended to each input file path listed on the command line. This is a literal string prefix, so you'll need to include a trailing slash if necessary.")
    protected String inputPrefix = "";
    @Option(name="--srcs", usage="The list of source Soy files. Extra arguments are treated as srcs. Sources are required from either this flag or as extra arguments.", handler=MainClassUtils.StringListOptionHandler.class)
    private List<String> srcs = new ArrayList<String>();
    @Option(name="--deps", usage="The list of dependency Soy files (if applicable). The compiler needs deps for analysis/checking, but will not generate code for dep files.", handler=MainClassUtils.StringListOptionHandler.class)
    private List<String> deps = new ArrayList<String>();
    @Option(name="--indirectDeps", usage="Soy files required by deps, but which may not be used by srcs.", handler=MainClassUtils.StringListOptionHandler.class)
    private List<String> indirectDeps = new ArrayList<String>();
    @Option(name="--compileTimeGlobalsFile", usage="The path to a file containing the mappings for global names to be substituted at compile time. Each line of the file should have the format \"<global_name> = <primitive_data>\" where primitive_data is a valid Soy expression literal for a primitive type (null, boolean, integer, float, or string). Empty lines and lines beginning with \"//\" are ignored. The file should be encoded in UTF-8. If you need to generate a file in this format from Java, consider using the utility SoyUtils.generateCompileTimeGlobalsFile().")
    private File globalsFile = null;
    @Option(name="--pluginModules", usage="Specifies the full class names of Guice modules for function plugins and print directive plugins (comma-delimited list).", handler=MainClassUtils.ModuleListOptionHandler.class)
    private List<Module> pluginModules = new ArrayList<Module>();
    @Option(name="--protoFileDescriptors", usage="Location of protocol buffer definitions in the form of a file descriptor set.The compiler needs defs for parameter type checking and generating direct access support for proto types.", handler=MainClassUtils.FileListOptionHandler.class)
    private static final List<File> protoFileDescriptors = new ArrayList<File>();
    @Option(name="--enableExperimentalFeatures", usage="Enable experimental features that are not generally available. These experimental features may change, break, or disappear at any time. We make absolutely no guarantees about what may happen if you turn one of these experiments on. Please proceed with caution at your own risk.", handler=MainClassUtils.StringListOptionHandler.class)
    private static final List<String> experimentalFeatures = new ArrayList<String>();
    @Argument
    private final List<String> arguments = new ArrayList<String>();
    private CmdLineParser cmdLineParser;

    AbstractSoyCompiler() {
    }

    final void runMain(String ... args) {
        int status = this.run(args);
        System.exit(status);
    }

    @CheckReturnValue
    @VisibleForTesting
    int run(final String ... args) {
        return MainClassUtils.runInternal(new MainClassUtils.Main(){

            @Override
            public void main() throws IOException {
                AbstractSoyCompiler.this.doMain(args);
            }
        });
    }

    private void doMain(String[] args) throws IOException {
        this.cmdLineParser = MainClassUtils.parseFlags(this, args, this.usagePrefix);
        this.validateFlags();
        if (!this.arguments.isEmpty() && !this.acceptsSourcesAsArguments()) {
            this.exitWithError("Found old style sources passed on the command line, use --srcs=... instead");
        }
        ArrayList<Module> modules = new ArrayList<Module>();
        modules.addAll(this.pluginModules);
        modules.addAll(this.msgPluginModule().asSet());
        Injector injector = MainClassUtils.createInjector(modules);
        SoyFileSet.Builder sfsBuilder = (SoyFileSet.Builder)injector.getInstance(SoyFileSet.Builder.class);
        if (!protoFileDescriptors.isEmpty()) {
            for (File descriptor : protoFileDescriptors) {
                sfsBuilder.addProtoFileDescriptorSetFromFile(descriptor);
            }
        }
        MainClassUtils.addSoyFilesToBuilder(sfsBuilder, this.inputPrefix, this.srcs, this.arguments, this.deps, this.indirectDeps, this.exitWithErrorFn);
        if (this.globalsFile != null) {
            sfsBuilder.setCompileTimeGlobals(this.globalsFile);
        }
        sfsBuilder.setExperimentalFeatures(experimentalFeatures);
        this.compile(sfsBuilder, injector);
    }

    @ForOverride
    boolean acceptsSourcesAsArguments() {
        return true;
    }

    @ForOverride
    Optional<Module> msgPluginModule() {
        return Optional.absent();
    }

    @ForOverride
    void validateFlags() {
    }

    @ForOverride
    void compile(SoyFileSet.Builder sfsBuilder, Injector injector) throws IOException {
        this.compile(sfsBuilder);
    }

    @ForOverride
    void compile(SoyFileSet.Builder sfsBuilder) throws IOException {
        throw new AbstractMethodError("must override at least one overload of compile()");
    }

    final RuntimeException exitWithError(String errorMsg) {
        return MainClassUtils.exitWithError(errorMsg, this.cmdLineParser, this.usagePrefix);
    }
}

