/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.soytree;

import com.google.common.base.CharMatcher;
import com.google.common.base.Joiner;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.template.soy.base.SourceLocation;
import com.google.template.soy.base.internal.BaseUtils;
import com.google.template.soy.basetree.SyntaxVersion;
import com.google.template.soy.basetree.SyntaxVersionUpperBound;
import com.google.template.soy.data.SanitizedContent;
import com.google.template.soy.data.internalutils.NodeContentKinds;
import com.google.template.soy.error.ErrorReporter;
import com.google.template.soy.error.SoyErrorKind;
import com.google.template.soy.soytree.AutoescapeMode;
import com.google.template.soy.soytree.RequirecssUtils;
import com.google.template.soy.soytree.TemplateNode;
import com.google.template.soy.soytree.Visibility;
import com.google.template.soy.soytree.defn.HeaderParam;
import com.google.template.soy.soytree.defn.SoyDocParam;
import com.google.template.soy.soytree.defn.TemplateParam;
import com.google.template.soy.types.SoyType;
import com.google.template.soy.types.SoyTypeRegistry;
import com.google.template.soy.types.aggregate.UnionType;
import com.google.template.soy.types.parse.TypeParser;
import com.google.template.soy.types.primitive.NullType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nullable;

public abstract class TemplateNodeBuilder {
    private static final SoyErrorKind INVALID_CSS_BASE_NAMESPACE_NAME = SoyErrorKind.of("Invalid CSS base namespace name ''{0}''");
    private static final SoyErrorKind INVALID_SOYDOC_PARAM = SoyErrorKind.of("Found invalid soydoc param name ''{0}''");
    private static final SoyErrorKind INVALID_TEMPLATE_NAME = SoyErrorKind.of("Invalid template name ''{0}''");
    private static final SoyErrorKind INVALID_PARAM_NAMED_IJ = SoyErrorKind.of("Invalid param name ''ij'' (''ij'' is for injected data).");
    private static final SoyErrorKind KIND_BUT_NOT_STRICT = SoyErrorKind.of("kind=\"...\" attribute is only valid with autoescape=\"strict\".");
    private static final SoyErrorKind LEGACY_COMPATIBLE_PARAM_TAG = SoyErrorKind.of("Found invalid SoyDoc param tag ''{0}'', tags like this are only allowed in legacy templates marked ''deprecatedV1=\"true\"''.  The proper soydoc @param syntax is: ''@param <name> <optional comment>''. Soy does not understand JsDoc style type declarations in SoyDoc.");
    private static final SoyErrorKind PARAM_ALREADY_DECLARED = SoyErrorKind.of("Param ''{0}'' already declared");
    protected final TemplateNode.SoyFileHeaderInfo soyFileHeaderInfo;
    protected final ErrorReporter errorReporter;
    private final SoyTypeRegistry typeRegistry;
    protected Integer id;
    @Nullable
    protected SyntaxVersionUpperBound syntaxVersionBound;
    protected String cmdText;
    private String templateName;
    private String partialTemplateName;
    protected String templateNameForUserMsgs;
    protected Visibility visibility;
    private AutoescapeMode autoescapeMode;
    private ImmutableList<String> requiredCssNamespaces;
    private String cssBaseNamespace;
    private SanitizedContent.ContentKind contentKind;
    protected boolean isSoyDocSet;
    protected String soyDoc;
    protected String soyDocDesc;
    @Nullable
    protected ImmutableList<TemplateParam> params;
    protected boolean isMarkedV1;
    final SourceLocation sourceLocation;
    private static final Pattern NEWLINE = Pattern.compile("\\n|\\r\\n?");
    private static final Pattern SOY_DOC_START = Pattern.compile("^ [/][*][*] [\\ ]* \\r?\\n?", 4);
    private static final Pattern SOY_DOC_END = Pattern.compile("\\r?\\n? [\\ ]* [*][/] $", 4);
    private static final Pattern SOY_DOC_DECL_PATTERN = Pattern.compile("( @param[?]? ) \\s+ ( \\S+ )", 4);
    private static final Pattern SOY_DOC_PARAM_TEXT_PATTERN = Pattern.compile("[a-zA-Z_]\\w*", 4);

    protected TemplateNodeBuilder(TemplateNode.SoyFileHeaderInfo soyFileHeaderInfo, SourceLocation sourceLocation, ErrorReporter errorReporter, @Nullable SoyTypeRegistry typeRegistry) {
        this.soyFileHeaderInfo = soyFileHeaderInfo;
        this.sourceLocation = sourceLocation;
        this.errorReporter = errorReporter;
        this.typeRegistry = typeRegistry;
        this.syntaxVersionBound = null;
        this.isSoyDocSet = false;
    }

    public TemplateNodeBuilder setId(int id) {
        Preconditions.checkState((this.id == null ? 1 : 0) != 0);
        this.id = id;
        return this;
    }

    public abstract TemplateNodeBuilder setCmdText(String var1);

    public String getTemplateNameForUserMsgs() {
        return this.templateNameForUserMsgs;
    }

    public TemplateNodeBuilder setSoyDoc(String soyDoc) {
        Preconditions.checkState((!this.isSoyDocSet ? 1 : 0) != 0);
        Preconditions.checkState((this.cmdText != null ? 1 : 0) != 0);
        this.isSoyDocSet = true;
        this.soyDoc = soyDoc;
        if (soyDoc != null) {
            Preconditions.checkArgument((soyDoc.startsWith("/**") && soyDoc.endsWith("*/") ? 1 : 0) != 0);
            String cleanedSoyDoc = TemplateNodeBuilder.cleanSoyDocHelper(soyDoc);
            this.soyDocDesc = TemplateNodeBuilder.parseSoyDocDescHelper(cleanedSoyDoc);
            this.addParams(this.parseSoyDocDeclsHelper(cleanedSoyDoc));
        } else {
            this.soyDocDesc = null;
        }
        return this;
    }

    public TemplateNodeBuilder setHeaderDecls(Collection<DeclInfo> declInfos) {
        ArrayList<Object> params = new ArrayList<Object>(declInfos.size());
        for (DeclInfo declInfo : declInfos) {
            Optional<HeaderParam> headerParam = this.forDeclInfo(declInfo);
            if (!headerParam.isPresent()) continue;
            params.add(headerParam.get());
        }
        this.addParams(params);
        return this;
    }

    public TemplateNodeBuilder setHeaderDecls(DeclInfo ... declInfos) {
        ArrayList<Object> params = new ArrayList<Object>(declInfos.length);
        for (DeclInfo declInfo : declInfos) {
            Optional<HeaderParam> headerParam = this.forDeclInfo(declInfo);
            if (!headerParam.isPresent()) continue;
            params.add(headerParam.get());
        }
        this.addParams(params);
        return this;
    }

    private Optional<HeaderParam> forDeclInfo(DeclInfo declInfo) {
        boolean isInjected = declInfo.type == DeclInfo.Type.INJECTED_PARAM;
        boolean isRequired = true;
        Preconditions.checkNotNull((Object)this.typeRegistry);
        SoyType type = new TypeParser(declInfo.paramTypeExpr(), declInfo.location(), this.typeRegistry).parseTypeDeclaration();
        if (declInfo.optionalStatus == DeclInfo.OptionalStatus.OPTIONAL) {
            isRequired = false;
            type = this.typeRegistry.getOrCreateUnionType(type, NullType.getInstance());
        } else if (type instanceof UnionType && ((UnionType)type).isNullable()) {
            isRequired = false;
        }
        return Optional.of((Object)new HeaderParam(declInfo.name(), declInfo.paramTypeExpr(), type, isRequired, isInjected, declInfo.soyDoc));
    }

    protected TemplateNodeBuilder addParams(Iterable<? extends TemplateParam> params) {
        this.params = this.params == null ? ImmutableList.copyOf(params) : ImmutableList.builder().addAll(this.params).addAll(params).build();
        HashSet<String> seenParamKeys = new HashSet<String>();
        for (TemplateParam param : this.params) {
            if (param.name().equals("ij")) {
                this.errorReporter.report(this.sourceLocation, INVALID_PARAM_NAMED_IJ, new Object[0]);
            }
            if (seenParamKeys.contains(param.name())) {
                this.errorReporter.report(this.sourceLocation, PARAM_ALREADY_DECLARED, param.name());
            }
            seenParamKeys.add(param.name());
        }
        return this;
    }

    public abstract TemplateNode build();

    protected final void setAutoescapeCmdText(Map<String, String> attributes) {
        String autoescapeModeStr = attributes.get("autoescape");
        AutoescapeMode autoescapeMode = autoescapeModeStr != null ? AutoescapeMode.parseAutoEscapeMode(autoescapeModeStr) : this.soyFileHeaderInfo.defaultAutoescapeMode;
        SanitizedContent.ContentKind contentKind = attributes.get("kind") != null ? NodeContentKinds.forAttributeValue(attributes.get("kind")) : null;
        this.setAutoescapeInfo(autoescapeMode, contentKind);
    }

    protected final void setRequireCssCmdText(Map<String, String> attributes) {
        this.setRequiredCssNamespaces(RequirecssUtils.parseRequirecssAttr(attributes.get("requirecss"), this.sourceLocation));
    }

    protected final void setCssBaseCmdText(Map<String, String> attributes) {
        String cssBaseNamespace = attributes.get("cssbase");
        if (cssBaseNamespace != null) {
            if (!BaseUtils.isDottedIdentifier(cssBaseNamespace)) {
                this.errorReporter.report(this.sourceLocation, INVALID_CSS_BASE_NAMESPACE_NAME, cssBaseNamespace);
            }
            this.setCssBaseNamespace(cssBaseNamespace);
        }
    }

    protected final void setV1Marker(Map<String, String> attributes) {
        if ("true".equals(attributes.get("deprecatedV1"))) {
            this.isMarkedV1 = true;
            SyntaxVersionUpperBound newSyntaxVersionBound = new SyntaxVersionUpperBound(SyntaxVersion.V2_0, "Template is marked as deprecatedV1.");
            this.syntaxVersionBound = SyntaxVersionUpperBound.selectLower(this.syntaxVersionBound, newSyntaxVersionBound);
        }
    }

    protected void setAutoescapeInfo(AutoescapeMode autoescapeMode, @Nullable SanitizedContent.ContentKind contentKind) {
        Preconditions.checkArgument((autoescapeMode != null ? 1 : 0) != 0);
        this.autoescapeMode = autoescapeMode;
        if (contentKind == null && autoescapeMode == AutoescapeMode.STRICT) {
            contentKind = SanitizedContent.ContentKind.HTML;
        } else if (contentKind != null && autoescapeMode != AutoescapeMode.STRICT) {
            this.errorReporter.report(this.sourceLocation, KIND_BUT_NOT_STRICT, new Object[0]);
        }
        this.contentKind = contentKind;
    }

    Integer getId() {
        return this.id;
    }

    SyntaxVersionUpperBound getSyntaxVersionBound() {
        return this.syntaxVersionBound;
    }

    String getCmdText() {
        return this.cmdText;
    }

    String getSoyDoc() {
        return this.soyDoc;
    }

    String getSoyDocDesc() {
        return this.soyDocDesc;
    }

    protected AutoescapeMode getAutoescapeMode() {
        Preconditions.checkState((this.autoescapeMode != null ? 1 : 0) != 0);
        return this.autoescapeMode;
    }

    @Nullable
    protected SanitizedContent.ContentKind getContentKind() {
        return this.contentKind;
    }

    protected ImmutableList<String> getRequiredCssNamespaces() {
        return (ImmutableList)Preconditions.checkNotNull(this.requiredCssNamespaces);
    }

    protected void setRequiredCssNamespaces(ImmutableList<String> requiredCssNamespaces) {
        this.requiredCssNamespaces = (ImmutableList)Preconditions.checkNotNull(requiredCssNamespaces);
    }

    protected String getCssBaseNamespace() {
        return this.cssBaseNamespace;
    }

    protected void setCssBaseNamespace(String cssBaseNamespace) {
        this.cssBaseNamespace = cssBaseNamespace;
    }

    protected final void setTemplateNames(String templateName, @Nullable String partialTemplateName) {
        this.templateName = templateName;
        this.partialTemplateName = partialTemplateName;
        if (partialTemplateName != null && !BaseUtils.isIdentifierWithLeadingDot(partialTemplateName)) {
            this.errorReporter.report(this.sourceLocation, INVALID_TEMPLATE_NAME, partialTemplateName);
        }
        if (!BaseUtils.isDottedIdentifier(templateName)) {
            this.errorReporter.report(this.sourceLocation, INVALID_TEMPLATE_NAME, templateName);
        }
    }

    protected String getTemplateName() {
        return this.templateName;
    }

    @Nullable
    protected String getPartialTemplateName() {
        return this.partialTemplateName;
    }

    private static String cleanSoyDocHelper(String soyDoc) {
        soyDoc = NEWLINE.matcher(soyDoc).replaceAll("\n");
        soyDoc = soyDoc.replace("@deprecated", "&#64;deprecated");
        soyDoc = SOY_DOC_START.matcher(soyDoc).replaceFirst("");
        soyDoc = SOY_DOC_END.matcher(soyDoc).replaceFirst("");
        ArrayList lines = Lists.newArrayList((Iterable)Splitter.on((Pattern)NEWLINE).split((CharSequence)soyDoc));
        TemplateNodeBuilder.removeCommonStartCharHelper(lines, ' ', true);
        if (TemplateNodeBuilder.removeCommonStartCharHelper(lines, '*', false) == 1) {
            TemplateNodeBuilder.removeCommonStartCharHelper(lines, ' ', true);
        }
        return Joiner.on((char)'\n').join((Iterable)lines);
    }

    private static int removeCommonStartCharHelper(List<String> lines, char charToRemove, boolean shouldRemoveMultiple) {
        int numCharsToRemove = 0;
        boolean isStillCounting = true;
        do {
            boolean areAllLinesEmpty = true;
            for (String line : lines) {
                if (line.length() == 0) continue;
                areAllLinesEmpty = false;
                if (line.length() > numCharsToRemove && line.charAt(numCharsToRemove) == charToRemove) continue;
                isStillCounting = false;
                break;
            }
            if (areAllLinesEmpty) {
                isStillCounting = false;
            }
            if (!isStillCounting) continue;
            ++numCharsToRemove;
        } while (isStillCounting && shouldRemoveMultiple);
        if (numCharsToRemove > 0) {
            for (int i = 0; i < lines.size(); ++i) {
                String line = lines.get(i);
                if (line.length() == 0) continue;
                lines.set(i, line.substring(numCharsToRemove));
            }
        }
        return numCharsToRemove;
    }

    private static String parseSoyDocDescHelper(String cleanedSoyDoc) {
        Matcher paramMatcher = SOY_DOC_DECL_PATTERN.matcher(cleanedSoyDoc);
        int endOfDescPos = paramMatcher.find() ? paramMatcher.start() : cleanedSoyDoc.length();
        String soyDocDesc = cleanedSoyDoc.substring(0, endOfDescPos);
        return CharMatcher.whitespace().trimTrailingFrom((CharSequence)soyDocDesc);
    }

    private List<SoyDocParam> parseSoyDocDeclsHelper(String cleanedSoyDoc) {
        ArrayList<SoyDocParam> params = new ArrayList<SoyDocParam>();
        Matcher matcher = SOY_DOC_DECL_PATTERN.matcher(cleanedSoyDoc);
        boolean isFound = matcher.find();
        while (isFound) {
            String declKeyword = matcher.group(1);
            String declText = matcher.group(2);
            int descStart = matcher.end();
            isFound = matcher.find();
            int descEnd = isFound ? matcher.start() : cleanedSoyDoc.length();
            String desc = cleanedSoyDoc.substring(descStart, descEnd).trim();
            if (declKeyword.equals("@param") || declKeyword.equals("@param?")) {
                if (SOY_DOC_PARAM_TEXT_PATTERN.matcher(declText).matches()) {
                    params.add(new SoyDocParam(declText, declKeyword.equals("@param"), desc));
                    continue;
                }
                if (declText.startsWith("{")) {
                    if (this.isMarkedV1) continue;
                    this.errorReporter.report(this.sourceLocation, LEGACY_COMPATIBLE_PARAM_TAG, declText);
                    continue;
                }
                this.errorReporter.report(this.sourceLocation, INVALID_SOYDOC_PARAM, declText);
                continue;
            }
            throw new AssertionError();
        }
        return params;
    }

    public static final class DeclInfo {
        private final Type type;
        private final String name;
        private final String paramTypeExpr;
        private final OptionalStatus optionalStatus;
        private final SourceLocation sourceLocation;
        @Nullable
        private final String soyDoc;

        public DeclInfo(Type type, OptionalStatus optionalStatus, String name, String paramTypeExpr, @Nullable String soyDoc, SourceLocation sourceLocation) {
            this.type = type;
            this.name = name;
            this.paramTypeExpr = paramTypeExpr;
            this.soyDoc = soyDoc;
            this.sourceLocation = sourceLocation;
            this.optionalStatus = optionalStatus;
        }

        public Type type() {
            return this.type;
        }

        public String name() {
            return this.name;
        }

        public String paramTypeExpr() {
            return this.paramTypeExpr;
        }

        @Nullable
        public String soyDoc() {
            return this.soyDoc;
        }

        public SourceLocation location() {
            return this.sourceLocation;
        }

        public static enum OptionalStatus {
            REQUIRED,
            OPTIONAL;

        }

        public static enum Type {
            PARAM("@param"),
            INJECTED_PARAM("@inject");

            private final String name;

            private Type(String name) {
                this.name = name;
            }

            public String toString() {
                return this.name;
            }
        }
    }
}

