/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.soytree;

import com.google.common.collect.Lists;
import com.google.template.soy.base.SourceLocation;
import com.google.template.soy.basetree.CopyState;
import com.google.template.soy.exprparse.ExpressionParser;
import com.google.template.soy.exprparse.SoyParsingContext;
import com.google.template.soy.exprtree.ExprRootNode;
import com.google.template.soy.soytree.CaseOrDefaultNode;
import com.google.template.soy.soytree.ExprUnion;
import com.google.template.soy.soytree.SoyNode;
import java.util.List;

public final class SwitchCaseNode
extends CaseOrDefaultNode
implements SoyNode.ConditionalBlockNode,
SoyNode.ExprHolderNode {
    private final String exprListText;
    private final List<ExprRootNode> exprList;

    private SwitchCaseNode(int id, String commandText, List<ExprRootNode> exprList, SourceLocation sourceLocation) {
        super(id, sourceLocation, "case", commandText);
        this.exprList = exprList;
        this.exprListText = commandText;
    }

    private SwitchCaseNode(SwitchCaseNode orig, CopyState copyState) {
        super(orig, copyState);
        this.exprListText = orig.exprListText;
        this.exprList = Lists.newArrayListWithCapacity((int)orig.exprList.size());
        for (ExprRootNode origExpr : orig.exprList) {
            this.exprList.add(origExpr.copy(copyState));
        }
    }

    @Override
    public SoyNode.Kind getKind() {
        return SoyNode.Kind.SWITCH_CASE_NODE;
    }

    public String getExprListText() {
        return this.exprListText;
    }

    public List<ExprRootNode> getExprList() {
        return this.exprList;
    }

    @Override
    public List<ExprUnion> getAllExprUnions() {
        return ExprUnion.createList(this.exprList);
    }

    @Override
    public SwitchCaseNode copy(CopyState copyState) {
        return new SwitchCaseNode(this, copyState);
    }

    public static final class Builder {
        private final int id;
        private final String commandText;
        private final SourceLocation sourceLocation;

        public Builder(int id, String commandText, SourceLocation sourceLocation) {
            this.id = id;
            this.commandText = commandText;
            this.sourceLocation = sourceLocation;
        }

        public SwitchCaseNode build(SoyParsingContext context) {
            List<ExprRootNode> exprList = ExprRootNode.wrap(new ExpressionParser(this.commandText, this.sourceLocation, context).parseExpressionList());
            return new SwitchCaseNode(this.id, this.commandText, exprList, this.sourceLocation);
        }
    }
}

