/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.soytree;

import com.google.common.collect.ImmutableList;
import com.google.template.soy.base.SourceLocation;
import com.google.template.soy.base.internal.BaseUtils;
import com.google.template.soy.base.internal.LegacyInternalSyntaxException;
import javax.annotation.Nullable;

final class RequirecssUtils {
    private RequirecssUtils() {
    }

    static ImmutableList<String> parseRequirecssAttr(@Nullable String requirecssAttr, SourceLocation srcLoc) {
        Object[] namespaces;
        if (requirecssAttr == null) {
            return ImmutableList.of();
        }
        for (Object namespace : namespaces = requirecssAttr.trim().split("\\s*,\\s*")) {
            if (BaseUtils.isDottedIdentifier((String)namespace)) continue;
            throw LegacyInternalSyntaxException.createWithMetaInfo("Invalid required CSS namespace name \"" + (String)namespace + "\".", srcLoc);
        }
        return ImmutableList.copyOf((Object[])namespaces);
    }
}

