/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.soytree;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.template.soy.base.SourceLocation;
import com.google.template.soy.base.internal.BaseUtils;
import com.google.template.soy.basetree.CopyState;
import com.google.template.soy.basetree.SyntaxVersionUpperBound;
import com.google.template.soy.error.ErrorReporter;
import com.google.template.soy.error.SoyErrorKind;
import com.google.template.soy.exprparse.SoyParsingContext;
import com.google.template.soy.soytree.CallNode;
import com.google.template.soy.soytree.CommandTextAttributesParser;
import com.google.template.soy.soytree.SoyNode;
import com.google.template.soy.soytree.TemplateNode;
import com.google.template.soy.soytree.defn.TemplateParam;
import java.util.Collection;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;

public final class CallBasicNode
extends CallNode {
    public static final SoyErrorKind MISSING_CALLEE_NAME = SoyErrorKind.of("Invalid ''call'' command missing callee name: '{'call {0}'}'.");
    public static final SoyErrorKind BAD_CALLEE_NAME = SoyErrorKind.of("Invalid callee name \"{0}\" for ''call'' command.");
    private static final Pattern NONATTRIBUTE_CALLEE_NAME = Pattern.compile("^\\s* ([.\\w]+) (?= \\s | $)", 4);
    private static final CommandTextAttributesParser ATTRIBUTES_PARSER = new CommandTextAttributesParser("call", new CommandTextAttributesParser.Attribute("data", CommandTextAttributesParser.Attribute.ALLOW_ALL_VALUES, null));
    private final String sourceCalleeName;
    private String calleeName;
    private ImmutableList<TemplateParam> paramsToRuntimeTypeCheck;

    private CallBasicNode(int id, SourceLocation sourceLocation, CommandTextInfo commandTextInfo, ImmutableList<String> escapingDirectiveNames, @Nullable String calleeName) {
        super(id, sourceLocation, "call", commandTextInfo, escapingDirectiveNames);
        this.sourceCalleeName = commandTextInfo.srcCalleeName;
        this.calleeName = calleeName;
    }

    private CallBasicNode(CallBasicNode orig, CopyState copyState) {
        super(orig, copyState);
        this.sourceCalleeName = orig.sourceCalleeName;
        this.calleeName = orig.calleeName;
        this.paramsToRuntimeTypeCheck = orig.paramsToRuntimeTypeCheck;
    }

    @Override
    public SoyNode.Kind getKind() {
        return SoyNode.Kind.CALL_BASIC_NODE;
    }

    public String getSrcCalleeName() {
        return this.sourceCalleeName;
    }

    public void setCalleeName(String calleeName) {
        Preconditions.checkState((this.calleeName == null ? 1 : 0) != 0);
        Preconditions.checkArgument((boolean)BaseUtils.isDottedIdentifier(calleeName));
        this.calleeName = calleeName;
    }

    public void setParamsToRuntimeCheck(Collection<TemplateParam> paramNames) {
        this.paramsToRuntimeTypeCheck = ImmutableList.copyOf(paramNames);
    }

    @Override
    public Collection<TemplateParam> getParamsToRuntimeCheck(TemplateNode callee) {
        return this.paramsToRuntimeTypeCheck == null ? callee.getParams() : this.paramsToRuntimeTypeCheck;
    }

    public String getCalleeName() {
        return this.calleeName;
    }

    @Override
    public CallBasicNode copy(CopyState copyState) {
        return new CallBasicNode(this, copyState);
    }

    public static final class Builder {
        private final int id;
        private final SourceLocation sourceLocation;
        private ImmutableList<String> escapingDirectiveNames = ImmutableList.of();
        private CallNode.DataAttribute dataAttr = CallNode.DataAttribute.none();
        @Nullable
        private String commandText;
        @Nullable
        private String userSuppliedPlaceholderName;
        @Nullable
        private String calleeName;
        @Nullable
        private String sourceCalleeName;
        @Nullable
        private SyntaxVersionUpperBound syntaxVersionBound;

        private static CallBasicNode error() {
            return new Builder(-1, SourceLocation.UNKNOWN).commandText(".error").build(SoyParsingContext.exploding());
        }

        public Builder(int id, SourceLocation sourceLocation) {
            this.id = id;
            this.sourceLocation = sourceLocation;
        }

        public Builder calleeName(String calleeName) {
            this.calleeName = calleeName;
            return this;
        }

        public Builder commandText(String commandText) {
            this.commandText = commandText;
            return this;
        }

        public Builder escapingDirectiveNames(ImmutableList<String> escapingDirectiveNames) {
            this.escapingDirectiveNames = escapingDirectiveNames;
            return this;
        }

        public Builder dataAttribute(CallNode.DataAttribute dataAttr) {
            this.dataAttr = dataAttr;
            return this;
        }

        public Builder sourceCalleeName(String sourceCalleeName) {
            this.sourceCalleeName = sourceCalleeName;
            return this;
        }

        public Builder syntaxVersionBound(SyntaxVersionUpperBound syntaxVersionBound) {
            this.syntaxVersionBound = syntaxVersionBound;
            return this;
        }

        public Builder userSuppliedPlaceholderName(String userSuppliedPlaceholderName) {
            this.userSuppliedPlaceholderName = userSuppliedPlaceholderName;
            return this;
        }

        public CallBasicNode build(SoyParsingContext context) {
            CommandTextInfo commandTextInfo;
            ErrorReporter.Checkpoint c = context.errorReporter().checkpoint();
            CommandTextInfo commandTextInfo2 = commandTextInfo = this.commandText != null ? this.parseCommandText(context) : this.buildCommandText();
            if (context.errorReporter().errorsSince(c)) {
                return Builder.error();
            }
            CallBasicNode callBasicNode = new CallBasicNode(this.id, this.sourceLocation, commandTextInfo, this.escapingDirectiveNames, this.calleeName);
            return callBasicNode;
        }

        private CommandTextInfo parseCommandText(SoyParsingContext context) {
            String cmdText = this.commandText + (this.userSuppliedPlaceholderName != null ? " phname=\"" + this.userSuppliedPlaceholderName + "\"" : "");
            String cmdTextForParsing = this.commandText;
            SyntaxVersionUpperBound syntaxVersionBound = null;
            Matcher ncnMatcher = NONATTRIBUTE_CALLEE_NAME.matcher(cmdTextForParsing);
            if (ncnMatcher.find()) {
                this.sourceCalleeName = ncnMatcher.group(1);
                cmdTextForParsing = cmdTextForParsing.substring(ncnMatcher.end()).trim();
                if (!BaseUtils.isIdentifierWithLeadingDot(this.sourceCalleeName) && !BaseUtils.isDottedIdentifier(this.sourceCalleeName)) {
                    context.report(this.sourceLocation, BAD_CALLEE_NAME, this.sourceCalleeName);
                }
            } else {
                context.report(this.sourceLocation, MISSING_CALLEE_NAME, this.commandText);
            }
            Map<String, String> attributes = ATTRIBUTES_PARSER.parse(cmdTextForParsing, context, this.sourceLocation);
            CallNode.DataAttribute dataAttrInfo = CallNode.parseDataAttributeHelper(attributes.get("data"), this.sourceLocation, context);
            return new CommandTextInfo(cmdText, this.sourceCalleeName, dataAttrInfo, this.userSuppliedPlaceholderName, syntaxVersionBound);
        }

        private CommandTextInfo buildCommandText() {
            String commandText = this.sourceCalleeName;
            if (this.dataAttr.isPassingAllData()) {
                commandText = commandText + " data=\"all\"";
            } else if (this.dataAttr.isPassingData()) {
                assert (this.dataAttr.dataExpr() != null);
                commandText = commandText + " data=\"" + this.dataAttr.dataExpr().toSourceString() + '\"';
            }
            if (this.userSuppliedPlaceholderName != null) {
                commandText = commandText + " phname=\"" + this.userSuppliedPlaceholderName + '\"';
            }
            return new CommandTextInfo(commandText, this.sourceCalleeName, this.dataAttr, this.userSuppliedPlaceholderName, this.syntaxVersionBound);
        }
    }

    @Immutable
    private static final class CommandTextInfo
    extends CallNode.CommandTextInfo {
        private final String srcCalleeName;

        CommandTextInfo(String commandText, String srcCalleeName, CallNode.DataAttribute dataAttr, @Nullable String userSuppliedPlaceholderName, @Nullable SyntaxVersionUpperBound syntaxVersionBound) {
            super(commandText, dataAttr, userSuppliedPlaceholderName, syntaxVersionBound);
            this.srcCalleeName = srcCalleeName;
        }
    }
}

