/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.soyparse;

import com.google.common.base.CharMatcher;
import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicates;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.template.soy.base.SourceLocation;
import com.google.template.soy.base.internal.IdGenerator;
import com.google.template.soy.base.internal.LegacyInternalSyntaxException;
import com.google.template.soy.base.internal.SoyFileKind;
import com.google.template.soy.error.ErrorReporter;
import com.google.template.soy.error.SoyErrorKind;
import com.google.template.soy.exprparse.SoyParsingContext;
import com.google.template.soy.soyparse.ForeachBuilder;
import com.google.template.soy.soyparse.ParseErrors;
import com.google.template.soy.soyparse.ParseException;
import com.google.template.soy.soyparse.SimpleCharStream;
import com.google.template.soy.soyparse.SourceItemInfo;
import com.google.template.soy.soyparse.SoyFileParserConstants;
import com.google.template.soy.soyparse.SoyFileParserTokenManager;
import com.google.template.soy.soyparse.TemplateParseResult;
import com.google.template.soy.soyparse.Token;
import com.google.template.soy.soyparse.TokenMgrError;
import com.google.template.soy.soyparse.Tokens;
import com.google.template.soy.soytree.AbstractParentCommandNode;
import com.google.template.soy.soytree.AbstractSoyNode;
import com.google.template.soy.soytree.AliasDeclaration;
import com.google.template.soy.soytree.CallBasicNode;
import com.google.template.soy.soytree.CallDelegateNode;
import com.google.template.soy.soytree.CallNode;
import com.google.template.soy.soytree.CallParamContentNode;
import com.google.template.soy.soytree.CallParamNode;
import com.google.template.soy.soytree.CallParamValueNode;
import com.google.template.soy.soytree.CssNode;
import com.google.template.soy.soytree.DebuggerNode;
import com.google.template.soy.soytree.ForNode;
import com.google.template.soy.soytree.ForeachNode;
import com.google.template.soy.soytree.IfCondNode;
import com.google.template.soy.soytree.IfElseNode;
import com.google.template.soy.soytree.IfNode;
import com.google.template.soy.soytree.LetContentNode;
import com.google.template.soy.soytree.LetNode;
import com.google.template.soy.soytree.LetValueNode;
import com.google.template.soy.soytree.LogNode;
import com.google.template.soy.soytree.MsgFallbackGroupNode;
import com.google.template.soy.soytree.MsgHtmlTagNode;
import com.google.template.soy.soytree.MsgNode;
import com.google.template.soy.soytree.MsgPlaceholderNode;
import com.google.template.soy.soytree.MsgPluralCaseNode;
import com.google.template.soy.soytree.MsgPluralDefaultNode;
import com.google.template.soy.soytree.MsgPluralNode;
import com.google.template.soy.soytree.MsgSelectCaseNode;
import com.google.template.soy.soytree.MsgSelectDefaultNode;
import com.google.template.soy.soytree.MsgSelectNode;
import com.google.template.soy.soytree.NameAttributePair;
import com.google.template.soy.soytree.NamespaceDeclaration;
import com.google.template.soy.soytree.PrintDirectiveNode;
import com.google.template.soy.soytree.PrintNode;
import com.google.template.soy.soytree.RawTextNode;
import com.google.template.soy.soytree.SoyFileNode;
import com.google.template.soy.soytree.SoyNode;
import com.google.template.soy.soytree.SwitchCaseNode;
import com.google.template.soy.soytree.SwitchDefaultNode;
import com.google.template.soy.soytree.SwitchNode;
import com.google.template.soy.soytree.TemplateBasicNodeBuilder;
import com.google.template.soy.soytree.TemplateDelegateNodeBuilder;
import com.google.template.soy.soytree.TemplateNode;
import com.google.template.soy.soytree.TemplateNodeBuilder;
import com.google.template.soy.soytree.XidNode;
import com.google.template.soy.types.SoyTypeRegistry;
import java.io.InputStream;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class SoyFileParser
implements SoyFileParserConstants {
    private static final String LINE_BOUNDARY_REGEX = "\\s*?(\\n|\\r)\\s*";
    private static final Pattern LINE_BOUNDARY_PATTERN = Pattern.compile("\\s*?(\\n|\\r)\\s*");
    private static final Pattern START_EDGE_LINE_BOUNDARY_PATTERN = Pattern.compile("^\\s*?(\\n|\\r)\\s*");
    private static final Pattern END_EDGE_LINE_BOUNDARY_PATTERN = Pattern.compile("\\s*?(\\n|\\r)\\s*$");
    private static final Pattern NONEDGE_LINE_BOUNDARY_PATTERN = Pattern.compile("(?<=\\S)\\s*?(\\n|\\r)\\s*(?=\\S)");
    private static final Pattern INVALID_PRINT_PREFIX_PATTERN = Pattern.compile("^(" + Joiner.on((String)"|").join((Iterable)FluentIterable.from(Arrays.asList(tokenImage)).filter(Predicates.containsPattern((String)"^\"\\{[a-z]+\\}\"$")).transform((Function)new RegexFromTokenImageFunction())) + ")\\b.+");
    private static final Pattern INVALID_PRINT_FILE_PREFIX_PATTERN = Pattern.compile("^(namespace|(del)?template|typedef|alias)\\b.*");
    private static final SoyErrorKind UNCATEGORIZED = SoyErrorKind.of("In file {0}, template {1}: {2}");
    private static final SoyErrorKind MISMATCHED_CLOSING_TAG = SoyErrorKind.of("''{0}'' has mismatched closing tag ''{1}''.");
    private static final SoyErrorKind UNEXPECTED_CLOSING_TAG = SoyErrorKind.of("Unexpected closing tag ''{0}''.");
    private static final SoyErrorKind FOUND_DOUBLE_BRACE = SoyErrorKind.of("Soy '{{command}}' syntax is no longer supported.  Use single braces.");
    private static final SoyErrorKind INVALID_DECLARATION = SoyErrorKind.of("Invalid declaration ''{0}''.");
    private static final SoyErrorKind INVALID_PRINT_PREFIX = SoyErrorKind.of("Command ''{0}'' cannot have arguments.");
    private static final SoyErrorKind INVALID_PRINT_FILE_COMMAND = SoyErrorKind.of("Command ''{0}'' cannot appear in templates.");
    private static final SoyErrorKind PLURAL_AND_SELECT_NOT_ALLOWED_INSIDE_PLURAL_BLOCK = SoyErrorKind.of("Tags ''plural'' and ''select'' are not allowed inside ''plural'' blocks.");
    private static final SoyErrorKind MULTIPLE_PHNAME_ATTRIBUTES_IN_COMMAND = SoyErrorKind.of("Found multiple ''phname'' attributes in ''{0}'' command text \"{1}\".");
    private static final SoyErrorKind PRINT_COMMAND_WITH_EMPTY_TEXT = SoyErrorKind.of("Found ''print'' command with empty command text.");
    private static final SoyErrorKind INVALID_PRINT_COMMAND_TEXT = SoyErrorKind.of("Invalid ''print'' command text \"{0}\" (check the directives).");
    private SoyTypeRegistry typeRegistry;
    private IdGenerator nodeIdGen;
    private SoyFileKind soyFileKind;
    private String filePath;
    private ErrorReporter errorReporter;
    private SoyParsingContext context;
    public SoyFileParserTokenManager token_source;
    SimpleCharStream jj_input_stream;
    public Token token;
    public Token jj_nt;
    private int jj_ntk;
    private Token jj_scanpos;
    private Token jj_lastpos;
    private int jj_la;
    private int jj_gen;
    private final int[] jj_la1 = new int[57];
    private static int[] jj_la1_0;
    private static int[] jj_la1_1;
    private static int[] jj_la1_2;
    private static int[] jj_la1_3;
    private final JJCalls[] jj_2_rtns = new JJCalls[12];
    private boolean jj_rescan = false;
    private int jj_gc = 0;
    private final LookaheadSuccess jj_ls = new LookaheadSuccess();
    private List<int[]> jj_expentries = new ArrayList<int[]>();
    private int[] jj_expentry;
    private int jj_kind = -1;
    private int[] jj_lasttokens = new int[100];
    private int jj_endpos;

    public SoyFileParser(SoyTypeRegistry typeRegistry, IdGenerator nodeIdGen, Reader input, SoyFileKind soyFileKind, String filePath, ErrorReporter errorReporter) {
        this(input);
        Preconditions.checkNotNull((Object)typeRegistry);
        Preconditions.checkNotNull((Object)nodeIdGen);
        this.typeRegistry = typeRegistry;
        this.nodeIdGen = nodeIdGen;
        this.soyFileKind = soyFileKind;
        this.filePath = filePath;
        this.errorReporter = errorReporter;
    }

    public SoyFileNode parseSoyFile() {
        Preconditions.checkNotNull((Object)this.typeRegistry);
        Preconditions.checkNotNull((Object)this.nodeIdGen);
        ErrorReporter.Checkpoint checkpoint = this.errorReporter.checkpoint();
        SoyFileNode soyFileNode = null;
        try {
            soyFileNode = this.SoyFile();
        }
        catch (ParseException e) {
            ParseErrors.reportSoyFileParseException(this.errorReporter, this.filePath, e);
        }
        catch (LegacyInternalSyntaxException e) {
            ParseErrors.report(this.errorReporter, this.filePath, e);
        }
        catch (TokenMgrError e) {
            ParseErrors.reportUnexpected(this.errorReporter, this.filePath, e);
        }
        if (this.errorReporter.errorsSince(checkpoint)) {
            return null;
        }
        return soyFileNode;
    }

    private <T> SourceItemInfo<T> newSourceItemInfo(T parsed, Token token) {
        return this.newSourceItemInfo(parsed, token.beginLine, token.beginColumn, token.endLine, token.endColumn);
    }

    private <T> SourceItemInfo<T> newSourceItemInfo(T parsed, Token begin, Token end) {
        return this.newSourceItemInfo(parsed, begin.beginLine, begin.beginColumn, end.endLine, end.endColumn);
    }

    private <T> SourceItemInfo<T> newSourceItemInfo(T parsed, SourceItemInfo<?> begin, SourceItemInfo<?> end) {
        return new SourceItemInfo<T>(parsed, begin, end);
    }

    private <T> SourceItemInfo<T> newSourceItemInfo(T parsed, int lineNum, int columnNum, int lineNumEnd, int columnNumEnd) {
        return new SourceItemInfo<T>(this.filePath, parsed, lineNum, columnNum, lineNumEnd, columnNumEnd);
    }

    private SourceLocation createSrcLoc(Token tok1, Token ... rest) {
        return Tokens.createSrcLoc(this.filePath, tok1, rest);
    }

    private final SoyFileNode SoyFile() throws ParseException {
        String delpackageName = null;
        NamespaceDeclaration namespace = NamespaceDeclaration.NULL;
        ArrayList<TemplateNode> templates = new ArrayList<TemplateNode>();
        ArrayList<AliasDeclaration> aliases = new ArrayList<AliasDeclaration>();
        AliasDeclaration alias = null;
        int id = this.nodeIdGen.genId();
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 17: {
                delpackageName = this.DelPackage();
                break;
            }
            default: {
                this.jj_la1[0] = this.jj_gen;
            }
        }
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 14: {
                namespace = this.Namespace();
                break;
            }
            default: {
                this.jj_la1[1] = this.jj_gen;
            }
        }
        block15: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 12: {
                    break;
                }
                default: {
                    this.jj_la1[2] = this.jj_gen;
                    break block15;
                }
            }
            alias = this.Alias();
            aliases.add(alias);
        }
        TemplateNode.SoyFileHeaderInfo soyFileHeaderInfo = new TemplateNode.SoyFileHeaderInfo(this.errorReporter, delpackageName, namespace, aliases);
        this.context = SoyParsingContext.create(this.errorReporter, soyFileHeaderInfo.namespace, soyFileHeaderInfo.aliasToNamespaceMap);
        block16: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 21: 
                case 22: {
                    break;
                }
                default: {
                    this.jj_la1[3] = this.jj_gen;
                    break block16;
                }
            }
            try {
                TemplateNode template = this.Template(soyFileHeaderInfo);
                templates.add(template);
            }
            catch (ParseException e) {
                ParseErrors.reportSoyFileParseException(this.errorReporter, this.filePath, e);
                this.consumeUntilTemplateClose();
            }
            catch (SoyFileParserTokenManager.PoisonTokenException e) {
                this.errorReporter.report(this.createSrcLoc(e.token, new Token[0]), SoyErrorKind.of("{0}"), e.message);
                this.consumeUntilTemplateClose();
            }
        }
        this.jj_consume_token(0);
        SoyFileNode sfn = new SoyFileNode(id, this.filePath, this.soyFileKind, namespace, soyFileHeaderInfo);
        sfn.addChildren(templates);
        return sfn;
    }

    private final AliasDeclaration Alias() throws ParseException {
        Token alias = null;
        Token as = null;
        Token open = this.jj_consume_token(12);
        Token namespace = this.jj_consume_token(19);
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 11: {
                as = this.jj_consume_token(11);
                alias = this.jj_consume_token(19);
                break;
            }
            default: {
                this.jj_la1[4] = this.jj_gen;
            }
        }
        Token close = this.jj_consume_token(9);
        return alias == null ? new AliasDeclaration(namespace.image, this.errorReporter, this.createSrcLoc(open, namespace, close)) : new AliasDeclaration(namespace.image, alias.image, this.errorReporter, this.createSrcLoc(open, namespace, as, alias, close));
    }

    private final NamespaceDeclaration Namespace() throws ParseException {
        ArrayList<NameAttributePair> attributes = new ArrayList<NameAttributePair>();
        Token open = this.jj_consume_token(14);
        Token name = this.jj_consume_token(19);
        block3: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 13: 
                case 15: 
                case 16: {
                    break;
                }
                default: {
                    this.jj_la1[5] = this.jj_gen;
                    break block3;
                }
            }
            NameAttributePair attr = this.Attribute();
            attributes.add(attr);
        }
        Token close = this.jj_consume_token(9);
        return new NamespaceDeclaration(name.image, attributes, this.errorReporter);
    }

    private final NameAttributePair Attribute() throws ParseException {
        Token name;
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 15: {
                name = this.jj_consume_token(15);
                break;
            }
            case 16: {
                name = this.jj_consume_token(16);
                break;
            }
            case 13: {
                name = this.jj_consume_token(13);
                break;
            }
            default: {
                this.jj_la1[6] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        Token eq = this.jj_consume_token(10);
        Token value = this.jj_consume_token(18);
        return new NameAttributePair(name.image, value.image.substring(1, value.image.length() - 1), this.createSrcLoc(name, eq, value));
    }

    private final String DelPackage() throws ParseException {
        this.jj_consume_token(17);
        Token name = this.jj_consume_token(19);
        this.jj_consume_token(9);
        return name.image;
    }

    private final TemplateNode Template(TemplateNode.SoyFileHeaderInfo soyFileHeaderInfo) throws ParseException {
        boolean isBasicTemplate;
        Token open;
        List<TemplateNodeBuilder.DeclInfo> templateHeaderDecls = null;
        List<SoyNode.StandaloneNode> templateBodyNodes = null;
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 22: {
                open = this.jj_consume_token(22);
                isBasicTemplate = true;
                break;
            }
            case 21: {
                open = this.jj_consume_token(21);
                isBasicTemplate = false;
                break;
            }
            default: {
                this.jj_la1[7] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        SourceLocation srcLocation = this.createSrcLoc(open, new Token[0]);
        TemplateNodeBuilder templateNodeBuilder = isBasicTemplate ? new TemplateBasicNodeBuilder(soyFileHeaderInfo, srcLocation, this.errorReporter, this.typeRegistry) : new TemplateDelegateNodeBuilder(soyFileHeaderInfo, srcLocation, this.errorReporter, this.typeRegistry);
        templateNodeBuilder.setId(this.nodeIdGen.genId());
        String openTagName = open.image.substring(0, isBasicTemplate ? 10 : 13);
        String cmdText = open.image.substring(openTagName.length(), open.image.length() - 1);
        templateNodeBuilder.setCmdText(cmdText);
        Token soyDoc = open.specialToken;
        if (soyDoc != null && soyDoc.kind == 25) {
            templateNodeBuilder.setSoyDoc(soyDoc.image);
        } else {
            templateNodeBuilder.setSoyDoc(null);
        }
        if (this.jj_2_1(Integer.MAX_VALUE)) {
            templateHeaderDecls = this.TemplateHeader();
            templateNodeBuilder.setHeaderDecls(templateHeaderDecls);
        } else {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 33: 
                case 95: {
                    this.HeaderConsecWsNoNl();
                    break;
                }
                default: {
                    this.jj_la1[8] = this.jj_gen;
                }
            }
        }
        templateBodyNodes = this.TemplateBlock();
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 34: {
                Token close = this.jj_consume_token(34);
                if (isBasicTemplate) break;
                this.errorReporter.report(this.createSrcLoc(close, new Token[0]), MISMATCHED_CLOSING_TAG, openTagName + templateNodeBuilder.getTemplateNameForUserMsgs(), close.image);
                break;
            }
            case 35: {
                Token close = this.jj_consume_token(35);
                if (!isBasicTemplate) break;
                this.errorReporter.report(this.createSrcLoc(close, new Token[0]), MISMATCHED_CLOSING_TAG, openTagName + templateNodeBuilder.getTemplateNameForUserMsgs(), close.image);
                break;
            }
            default: {
                this.jj_la1[9] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        TemplateNode templateNode = templateNodeBuilder.build();
        if (templateBodyNodes != null) {
            templateNode.addChildren(templateBodyNodes);
        }
        return templateNode;
    }

    private void consumeUntilTemplateClose() throws ParseException {
        this.token_source.SwitchTo(5);
        Token t = null;
        do {
            try {
                t = this.getNextToken();
            }
            catch (SoyFileParserTokenManager.PoisonTokenException poisonTokenException) {
                // empty catch block
            }
        } while (t == null || t.kind != 0 && t.kind != 34 && t.kind != 35);
    }

    private final String CmdText() throws ParseException {
        List<String> cmdTextParts = this.CmdTextParts();
        return Joiner.on((String)"").join(cmdTextParts);
    }

    private final List<String> CmdTextParts() throws ParseException {
        StringBuilder currCmdTextPartSb;
        ArrayList cmdTextParts;
        block17: {
            cmdTextParts = Lists.newArrayList();
            currCmdTextPartSb = new StringBuilder();
            block11: while (true) {
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 82: 
                    case 83: 
                    case 88: {
                        break;
                    }
                    default: {
                        this.jj_la1[10] = this.jj_gen;
                        break block17;
                    }
                }
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 88: {
                        Token cmdTextChar = this.jj_consume_token(88);
                        currCmdTextPartSb.append(cmdTextChar.image);
                        continue block11;
                    }
                    case 82: 
                    case 83: {
                        Token cmdTextSpecialPart;
                        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                            case 82: {
                                cmdTextSpecialPart = this.jj_consume_token(82);
                                break;
                            }
                            case 83: {
                                cmdTextSpecialPart = this.jj_consume_token(83);
                                break;
                            }
                            default: {
                                this.jj_la1[11] = this.jj_gen;
                                this.jj_consume_token(-1);
                                throw new ParseException();
                            }
                        }
                        if (currCmdTextPartSb.length() > 0) {
                            cmdTextParts.add(currCmdTextPartSb.toString());
                            currCmdTextPartSb = new StringBuilder();
                        }
                        cmdTextParts.add(cmdTextSpecialPart.image);
                        continue block11;
                    }
                }
                break;
            }
            this.jj_la1[12] = this.jj_gen;
            this.jj_consume_token(-1);
            throw new ParseException();
        }
        if (currCmdTextPartSb.length() > 0) {
            cmdTextParts.add(currCmdTextPartSb.toString());
            currCmdTextPartSb = new StringBuilder();
        }
        int n = cmdTextParts.size();
        for (int i = 0; i < n; ++i) {
            String cmdTextPart = (String)cmdTextParts.get(i);
            if (i == 0) {
                cmdTextPart = CharMatcher.whitespace().trimLeadingFrom((CharSequence)cmdTextPart);
            }
            if (i == n - 1) {
                cmdTextPart = CharMatcher.whitespace().trimTrailingFrom((CharSequence)cmdTextPart);
            }
            cmdTextPart = LINE_BOUNDARY_PATTERN.matcher(cmdTextPart).replaceAll(" ");
            cmdTextParts.set(i, cmdTextPart);
        }
        return cmdTextParts;
    }

    private final void HeaderConsecWsNoNl() throws ParseException {
        block7: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 95: {
                    this.jj_consume_token(95);
                    break;
                }
                case 33: {
                    this.jj_consume_token(33);
                    break;
                }
                default: {
                    this.jj_la1[13] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 33: 
                case 95: {
                    continue block7;
                }
            }
            break;
        }
        this.jj_la1[14] = this.jj_gen;
    }

    private final void HeaderConsecWs() throws ParseException {
        block8: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 94: {
                    this.jj_consume_token(94);
                    break;
                }
                case 95: {
                    this.jj_consume_token(95);
                    break;
                }
                case 33: {
                    this.jj_consume_token(33);
                    break;
                }
                default: {
                    this.jj_la1[15] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 33: 
                case 94: 
                case 95: {
                    continue block8;
                }
            }
            break;
        }
        this.jj_la1[16] = this.jj_gen;
    }

    private final Token BlockCommentToken() throws ParseException {
        Token token;
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 32: {
                token = this.jj_consume_token(32);
                break;
            }
            case 33: {
                token = this.jj_consume_token(33);
                break;
            }
            default: {
                this.jj_la1[17] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return token;
    }

    private final Token BasicRawTextToken() throws ParseException {
        Token token;
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 94: {
                token = this.jj_consume_token(94);
                break;
            }
            case 95: {
                token = this.jj_consume_token(95);
                break;
            }
            case 96: {
                token = this.jj_consume_token(96);
                break;
            }
            default: {
                this.jj_la1[18] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return token;
    }

    private final SourceItemInfo<String> BasicRawText() throws ParseException {
        Token token;
        StringBuilder basicRawTextSb = new StringBuilder();
        int lineNum = -1;
        int columnNum = -1;
        do {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 94: 
                case 95: 
                case 96: {
                    token = this.BasicRawTextToken();
                    basicRawTextSb.append(token.image);
                    break;
                }
                case 32: 
                case 33: {
                    token = this.BlockCommentToken();
                    break;
                }
                default: {
                    this.jj_la1[19] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
            if (lineNum != -1) continue;
            lineNum = token.beginLine;
            columnNum = token.beginColumn;
        } while (this.jj_2_2(2));
        String basicRawText = basicRawTextSb.toString();
        basicRawText = START_EDGE_LINE_BOUNDARY_PATTERN.matcher(basicRawText).replaceFirst("");
        int numSpaceCharsRemovedFromFront = basicRawTextSb.length() - basicRawText.length();
        for (int i = 0; i < numSpaceCharsRemovedFromFront; ++i) {
            char ch = basicRawTextSb.charAt(i);
            if (ch == '\r') {
                if (i + 1 != numSpaceCharsRemovedFromFront && basicRawTextSb.charAt(i + 1) == '\n') continue;
                ++lineNum;
                columnNum = 1;
                continue;
            }
            if (ch != '\n') continue;
            ++lineNum;
            columnNum = 1;
        }
        basicRawText = END_EDGE_LINE_BOUNDARY_PATTERN.matcher(basicRawText).replaceFirst("");
        Matcher matcher = NONEDGE_LINE_BOUNDARY_PATTERN.matcher(basicRawText);
        StringBuffer basicRawTextWithoutNewlinesSb = new StringBuffer(basicRawText.length());
        while (matcher.find()) {
            char charBefore = basicRawText.charAt(matcher.start() - 1);
            char charAfter = basicRawText.charAt(matcher.end());
            matcher.appendReplacement(basicRawTextWithoutNewlinesSb, charBefore == '>' || charAfter == '<' ? "" : " ");
        }
        matcher.appendTail(basicRawTextWithoutNewlinesSb);
        return this.newSourceItemInfo(basicRawTextWithoutNewlinesSb.toString(), lineNum, columnNum, token.endLine, token.endColumn);
    }

    public final void MaybeWhitespace(String errorMessage) throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 32: 
            case 33: 
            case 94: 
            case 95: 
            case 96: {
                SourceItemInfo<String> basicRawText = this.BasicRawText();
                if (basicRawText.parsedContent().trim().length() == 0) break;
                this.errorReporter.report(basicRawText.srcLocation(), SoyErrorKind.of("{0}"), errorMessage);
                break;
            }
            default: {
                this.jj_la1[20] = this.jj_gen;
            }
        }
    }

    private final SourceItemInfo<String> LiteralRawText() throws ParseException {
        Token tag = this.jj_consume_token(46);
        Token literalRawTextContent = this.jj_consume_token(93);
        return this.newSourceItemInfo(literalRawTextContent.image, tag);
    }

    private final SourceItemInfo<String> SpecialCharRawText() throws ParseException {
        String value;
        Token command;
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 39: {
                command = this.jj_consume_token(39);
                value = " ";
                break;
            }
            case 40: {
                command = this.jj_consume_token(40);
                value = "";
                break;
            }
            case 42: {
                command = this.jj_consume_token(42);
                value = "\r";
                break;
            }
            case 41: {
                command = this.jj_consume_token(41);
                value = "\n";
                break;
            }
            case 43: {
                command = this.jj_consume_token(43);
                value = "\t";
                break;
            }
            case 44: {
                command = this.jj_consume_token(44);
                value = "{";
                break;
            }
            case 45: {
                command = this.jj_consume_token(45);
                value = "}";
                break;
            }
            default: {
                this.jj_la1[21] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return this.newSourceItemInfo(value, command);
    }

    private final SourceItemInfo<String> ContiguousRawText() throws ParseException {
        StringBuilder sb = new StringBuilder();
        SourceItemInfo<String> first = null;
        SourceItemInfo<String> last = null;
        do {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 32: 
                case 33: 
                case 94: 
                case 95: 
                case 96: {
                    SourceItemInfo<String> basicRawText = this.BasicRawText();
                    if (first == null) {
                        first = basicRawText;
                    }
                    last = basicRawText;
                    sb.append(basicRawText.parsedContent());
                    break;
                }
                case 46: {
                    SourceItemInfo<String> literalRawText = this.LiteralRawText();
                    if (first == null) {
                        first = literalRawText;
                    }
                    last = literalRawText;
                    sb.append(literalRawText.parsedContent());
                    break;
                }
                case 39: 
                case 40: 
                case 41: 
                case 42: 
                case 43: 
                case 44: 
                case 45: {
                    SourceItemInfo<String> specialCharRawText = this.SpecialCharRawText();
                    if (first == null) {
                        first = specialCharRawText;
                    }
                    last = specialCharRawText;
                    sb.append(specialCharRawText.parsedContent());
                    break;
                }
                default: {
                    this.jj_la1[22] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
        } while (this.jj_2_3(2));
        return this.newSourceItemInfo(sb.toString(), first, last);
    }

    private final SourceItemInfo<String> MsgTag() throws ParseException {
        Token tagBegin = this.jj_consume_token(51);
        String cmdText = this.CmdText();
        Token tagEnd = this.jj_consume_token(80);
        return this.newSourceItemInfo(cmdText, tagBegin, tagEnd);
    }

    private final SourceItemInfo<String> FallbackmsgTag() throws ParseException {
        Token tagBegin = this.jj_consume_token(52);
        String cmdText = this.CmdText();
        Token tagEnd = this.jj_consume_token(80);
        return this.newSourceItemInfo(cmdText, tagBegin, tagEnd);
    }

    private final SourceItemInfo<String> PluralTag() throws ParseException {
        Token tagBegin = this.jj_consume_token(65);
        String cmdText = this.CmdText();
        Token tagEnd = this.jj_consume_token(80);
        return this.newSourceItemInfo(cmdText, tagBegin, tagEnd);
    }

    private final SourceItemInfo<String> SelectTag() throws ParseException {
        Token tagBegin = this.jj_consume_token(67);
        String cmdText = this.CmdText();
        Token tagEnd = this.jj_consume_token(80);
        return this.newSourceItemInfo(cmdText, tagBegin, tagEnd);
    }

    private final SourceItemInfo<List<String>> PrintTag() throws ParseException {
        Token tagBegin;
        ArrayList printTagParts = Lists.newArrayList();
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 54: {
                tagBegin = this.jj_consume_token(54);
                printTagParts.add("print");
                break;
            }
            case 79: {
                tagBegin = this.jj_consume_token(79);
                break;
            }
            default: {
                this.jj_la1[23] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        List<String> cmdTextParts = this.CmdTextParts();
        printTagParts.addAll(cmdTextParts);
        Token tagEnd = this.jj_consume_token(80);
        if (!printTagParts.isEmpty()) {
            if (((String)printTagParts.get(0)).startsWith("/")) {
                this.errorReporter.report(this.createSrcLoc(tagBegin, tagEnd), UNEXPECTED_CLOSING_TAG, "{" + Joiner.on((String)"").join((Iterable)printTagParts) + "}");
            } else if (((String)printTagParts.get(0)).startsWith("@")) {
                this.errorReporter.report(this.createSrcLoc(tagBegin, tagEnd), INVALID_DECLARATION, "{" + (String)printTagParts.get(0));
            } else if (((String)printTagParts.get(0)).startsWith("{")) {
                this.errorReporter.report(this.createSrcLoc(tagBegin, tagEnd), FOUND_DOUBLE_BRACE, new Object[0]);
            } else if (INVALID_PRINT_FILE_PREFIX_PATTERN.matcher((CharSequence)printTagParts.get(0)).matches()) {
                this.errorReporter.report(this.createSrcLoc(tagBegin, tagEnd), INVALID_PRINT_FILE_COMMAND, "{" + (String)printTagParts.get(0));
            } else if (INVALID_PRINT_PREFIX_PATTERN.matcher((CharSequence)printTagParts.get(0)).matches()) {
                this.errorReporter.report(this.createSrcLoc(tagBegin, tagEnd), INVALID_PRINT_PREFIX, "{" + (String)printTagParts.get(0));
            }
        }
        return this.newSourceItemInfo(printTagParts, tagBegin, tagEnd);
    }

    private final SourceItemInfo<String> XidTag() throws ParseException {
        Token tagBegin = this.jj_consume_token(55);
        String cmdText = this.CmdText();
        Token tagEnd = this.jj_consume_token(80);
        return this.newSourceItemInfo(cmdText, tagBegin, tagEnd);
    }

    private final SourceItemInfo<String> CssTag() throws ParseException {
        Token tagBegin = this.jj_consume_token(56);
        String cmdText = this.CmdText();
        Token tagEnd = this.jj_consume_token(80);
        return this.newSourceItemInfo(cmdText, tagBegin, tagEnd);
    }

    private final SourceItemInfo<String> LetTagSelfEnding() throws ParseException {
        Token tagBegin = this.jj_consume_token(61);
        String cmdText = this.CmdText();
        Token tagEnd = this.jj_consume_token(81);
        return this.newSourceItemInfo(cmdText, tagBegin, tagEnd);
    }

    private final SourceItemInfo<String> LetTagNotSelfEnding() throws ParseException {
        Token tagBegin = this.jj_consume_token(61);
        String cmdText = this.CmdText();
        Token tagEnd = this.jj_consume_token(80);
        return this.newSourceItemInfo(cmdText, tagBegin, tagEnd);
    }

    private final SourceItemInfo<String> IfTag() throws ParseException {
        Token tagBegin = this.jj_consume_token(57);
        String cmdText = this.CmdText();
        Token tagEnd = this.jj_consume_token(80);
        return this.newSourceItemInfo(cmdText, tagBegin, tagEnd);
    }

    private final SourceItemInfo<String> ElseifTag() throws ParseException {
        Token tagBegin = this.jj_consume_token(58);
        String cmdText = this.CmdText();
        Token tagEnd = this.jj_consume_token(80);
        return this.newSourceItemInfo(cmdText, tagBegin, tagEnd);
    }

    private final SourceItemInfo<String> SwitchTag() throws ParseException {
        Token tagBegin = this.jj_consume_token(69);
        String cmdText = this.CmdText();
        Token tagEnd = this.jj_consume_token(80);
        return this.newSourceItemInfo(cmdText, tagBegin, tagEnd);
    }

    private final SourceItemInfo<String> ForeachTag() throws ParseException {
        Token tagBegin = this.jj_consume_token(73);
        String cmdText = this.CmdText();
        Token tagEnd = this.jj_consume_token(80);
        return this.newSourceItemInfo(cmdText, tagBegin, tagEnd);
    }

    private final SourceItemInfo<String> ForTag() throws ParseException {
        Token tagBegin = this.jj_consume_token(63);
        String cmdText = this.CmdText();
        Token tagEnd = this.jj_consume_token(80);
        return this.newSourceItemInfo(cmdText, tagBegin, tagEnd);
    }

    private final SourceItemInfo<List<String>> AnyCallTagSelfEnding() throws ParseException {
        ArrayList callTagParts = Lists.newArrayList();
        Token tagBegin = this.jj_consume_token(47);
        callTagParts.add(tagBegin.image.substring(1));
        List<String> cmdTextParts = this.CmdTextParts();
        callTagParts.addAll(cmdTextParts);
        Token tagEnd = this.jj_consume_token(81);
        return this.newSourceItemInfo(callTagParts, tagBegin, tagEnd);
    }

    private final SourceItemInfo<List<String>> AnyCallTagNotSelfEnding() throws ParseException {
        ArrayList callTagParts = Lists.newArrayList();
        Token tagBegin = this.jj_consume_token(47);
        callTagParts.add(tagBegin.image.substring(1));
        List<String> cmdTextParts = this.CmdTextParts();
        callTagParts.addAll(cmdTextParts);
        Token tagEnd = this.jj_consume_token(80);
        return this.newSourceItemInfo(callTagParts, tagBegin, tagEnd);
    }

    private final SourceItemInfo<String> ParamTagSelfEnding() throws ParseException {
        Token tagBegin = this.jj_consume_token(49);
        String cmdText = this.CmdText();
        Token tagEnd = this.jj_consume_token(81);
        return this.newSourceItemInfo(cmdText, tagBegin, tagEnd);
    }

    private final SourceItemInfo<String> ParamTagNotSelfEnding() throws ParseException {
        Token tagBegin = this.jj_consume_token(49);
        String cmdText = this.CmdText();
        Token tagEnd = this.jj_consume_token(80);
        return this.newSourceItemInfo(cmdText, tagBegin, tagEnd);
    }

    private final SourceItemInfo<String> CaseTag() throws ParseException {
        Token tagBegin = this.jj_consume_token(72);
        String cmdText = this.CmdText();
        Token tagEnd = this.jj_consume_token(80);
        return this.newSourceItemInfo(cmdText, tagBegin, tagEnd);
    }

    private final List<TemplateNodeBuilder.DeclInfo> TemplateHeader() throws ParseException {
        ArrayList declInfos = Lists.newArrayList();
        do {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 33: 
                case 94: 
                case 95: {
                    this.HeaderConsecWs();
                    break;
                }
                default: {
                    this.jj_la1[24] = this.jj_gen;
                }
            }
            TemplateNodeBuilder.DeclInfo declInfo = this.Decl();
            declInfos.add(declInfo);
        } while (this.jj_2_4(Integer.MAX_VALUE));
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 33: 
            case 95: {
                this.HeaderConsecWsNoNl();
                break;
            }
            default: {
                this.jj_la1[25] = this.jj_gen;
            }
        }
        this.jj_consume_token(94);
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 33: 
            case 95: {
                this.HeaderConsecWsNoNl();
                break;
            }
            default: {
                this.jj_la1[26] = this.jj_gen;
            }
        }
        return declInfos;
    }

    private final void TemplateHeaderLookaheadHelper() throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 33: 
            case 94: 
            case 95: {
                this.HeaderConsecWs();
                break;
            }
            default: {
                this.jj_la1[27] = this.jj_gen;
            }
        }
        block3 : switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 32: {
                this.jj_consume_token(32);
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 33: 
                    case 94: 
                    case 95: {
                        this.HeaderConsecWs();
                        break block3;
                    }
                }
                this.jj_la1[28] = this.jj_gen;
                break;
            }
            default: {
                this.jj_la1[29] = this.jj_gen;
            }
        }
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 36: {
                this.jj_consume_token(36);
                break;
            }
            case 37: {
                this.jj_consume_token(37);
                break;
            }
            default: {
                this.jj_la1[30] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
    }

    private final TemplateNodeBuilder.DeclInfo Decl() throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 36: 
            case 37: {
                TemplateNodeBuilder.DeclInfo declInfo = this.ParamDecl();
                return declInfo;
            }
            case 32: {
                TemplateNodeBuilder.DeclInfo declInfo = this.ParamDeclWithDocPrefix();
                return declInfo;
            }
        }
        this.jj_la1[31] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    private final TemplateNodeBuilder.DeclInfo ParamDecl() throws ParseException {
        String desc;
        Token tagBegin;
        TemplateNodeBuilder.DeclInfo.OptionalStatus optionalStatus = TemplateNodeBuilder.DeclInfo.OptionalStatus.REQUIRED;
        TemplateNodeBuilder.DeclInfo.Type type = TemplateNodeBuilder.DeclInfo.Type.PARAM;
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 36: {
                tagBegin = this.jj_consume_token(36);
                break;
            }
            case 37: {
                tagBegin = this.jj_consume_token(37);
                type = TemplateNodeBuilder.DeclInfo.Type.INJECTED_PARAM;
                break;
            }
            default: {
                this.jj_la1[32] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 105: {
                this.jj_consume_token(105);
                optionalStatus = TemplateNodeBuilder.DeclInfo.OptionalStatus.OPTIONAL;
                break;
            }
            default: {
                this.jj_la1[33] = this.jj_gen;
            }
        }
        block13: while (true) {
            this.jj_consume_token(98);
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 98: {
                    continue block13;
                }
            }
            break;
        }
        this.jj_la1[34] = this.jj_gen;
        Token name = this.jj_consume_token(85);
        this.jj_consume_token(86);
        Token paramType = this.jj_consume_token(87);
        Token tagEnd = this.jj_consume_token(80);
        if (this.jj_2_5(Integer.MAX_VALUE)) {
            block14: while (true) {
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 95: {
                        break;
                    }
                    default: {
                        this.jj_la1[35] = this.jj_gen;
                        break block14;
                    }
                }
                this.jj_consume_token(95);
            }
            Token blockDocComment = this.jj_consume_token(32);
            desc = blockDocComment.image;
        } else {
            desc = null;
        }
        return new TemplateNodeBuilder.DeclInfo(type, optionalStatus, name.image, paramType.image, desc, this.createSrcLoc(tagBegin, tagEnd));
    }

    private final TemplateNodeBuilder.DeclInfo ParamDeclWithDocPrefix() throws ParseException {
        TemplateNodeBuilder.DeclInfo.OptionalStatus optionalStatus = TemplateNodeBuilder.DeclInfo.OptionalStatus.REQUIRED;
        TemplateNodeBuilder.DeclInfo.Type type = TemplateNodeBuilder.DeclInfo.Type.PARAM;
        Token blockDocComment = this.jj_consume_token(32);
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 33: 
            case 94: 
            case 95: {
                this.HeaderConsecWs();
                break;
            }
            default: {
                this.jj_la1[36] = this.jj_gen;
            }
        }
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 36: {
                this.jj_consume_token(36);
                break;
            }
            case 37: {
                this.jj_consume_token(37);
                type = TemplateNodeBuilder.DeclInfo.Type.INJECTED_PARAM;
                break;
            }
            default: {
                this.jj_la1[37] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 105: {
                this.jj_consume_token(105);
                optionalStatus = TemplateNodeBuilder.DeclInfo.OptionalStatus.OPTIONAL;
                break;
            }
            default: {
                this.jj_la1[38] = this.jj_gen;
            }
        }
        block13: while (true) {
            this.jj_consume_token(98);
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 98: {
                    continue block13;
                }
            }
            break;
        }
        this.jj_la1[39] = this.jj_gen;
        Token name = this.jj_consume_token(85);
        this.jj_consume_token(86);
        Token paramType = this.jj_consume_token(87);
        this.jj_consume_token(80);
        return new TemplateNodeBuilder.DeclInfo(type, optionalStatus, name.image, paramType.image, blockDocComment.image, this.createSrcLoc(blockDocComment, new Token[0]));
    }

    private final List<SoyNode.StandaloneNode> TemplateBlock() throws ParseException {
        ArrayList templateBlock;
        block8: {
            templateBlock = Lists.newArrayList();
            block7: while (true) {
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 32: 
                    case 33: 
                    case 39: 
                    case 40: 
                    case 41: 
                    case 42: 
                    case 43: 
                    case 44: 
                    case 45: 
                    case 46: 
                    case 47: 
                    case 51: 
                    case 54: 
                    case 55: 
                    case 56: 
                    case 57: 
                    case 61: 
                    case 63: 
                    case 69: 
                    case 73: 
                    case 76: 
                    case 78: 
                    case 79: 
                    case 94: 
                    case 95: 
                    case 96: {
                        break;
                    }
                    default: {
                        this.jj_la1[40] = this.jj_gen;
                        break block8;
                    }
                }
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 32: 
                    case 33: 
                    case 39: 
                    case 40: 
                    case 41: 
                    case 42: 
                    case 43: 
                    case 44: 
                    case 45: 
                    case 46: 
                    case 94: 
                    case 95: 
                    case 96: {
                        RawTextNode contiguousRawTextAsNode = this.ContiguousRawTextAsNode();
                        if (contiguousRawTextAsNode == null) continue block7;
                        templateBlock.add(contiguousRawTextAsNode);
                        continue block7;
                    }
                    case 47: 
                    case 51: 
                    case 54: 
                    case 55: 
                    case 56: 
                    case 57: 
                    case 61: 
                    case 63: 
                    case 69: 
                    case 73: 
                    case 76: 
                    case 78: 
                    case 79: {
                        SoyNode.StatementNode stmt = this.Stmt();
                        if (stmt == null) continue block7;
                        templateBlock.add(stmt);
                        continue block7;
                    }
                }
                break;
            }
            this.jj_la1[41] = this.jj_gen;
            this.jj_consume_token(-1);
            throw new ParseException();
        }
        return templateBlock;
    }

    private final RawTextNode ContiguousRawTextAsNode() throws ParseException {
        SourceItemInfo<String> contiguousRawText = this.ContiguousRawText();
        if (contiguousRawText.parsedContent().isEmpty()) {
            return null;
        }
        return new RawTextNode(this.nodeIdGen.genId(), contiguousRawText.parsedContent(), contiguousRawText.srcLocation());
    }

    private final SoyNode.StatementNode Stmt() throws ParseException {
        AbstractSoyNode stmt;
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 51: {
                stmt = this.MsgStmt();
                break;
            }
            case 55: {
                stmt = this.XidStmt();
                break;
            }
            case 56: {
                stmt = this.CssStmt();
                break;
            }
            case 61: {
                stmt = this.LetStmt();
                break;
            }
            case 57: {
                stmt = this.IfStmt();
                break;
            }
            case 69: {
                stmt = this.SwitchStmt();
                break;
            }
            case 73: {
                stmt = this.ForeachStmt();
                break;
            }
            case 63: {
                stmt = this.ForStmt();
                break;
            }
            case 47: {
                stmt = this.CallStmt();
                break;
            }
            case 76: {
                stmt = this.LogStmt();
                break;
            }
            case 78: {
                stmt = this.DebuggerStmt();
                break;
            }
            case 54: 
            case 79: {
                stmt = this.PrintStmt();
                break;
            }
            default: {
                this.jj_la1[42] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return stmt;
    }

    private final MsgFallbackGroupNode MsgStmt() throws ParseException {
        SourceItemInfo<String> cmdText = this.MsgTag();
        MsgFallbackGroupNode msgFbGrpNode = new MsgFallbackGroupNode(this.nodeIdGen.genId(), cmdText.srcLocation());
        MsgNode msgNode = MsgNode.msg(this.nodeIdGen.genId(), cmdText.parsedContent(), cmdText.srcLocation()).build(this.context);
        msgFbGrpNode.addChild(msgNode);
        List<SoyNode.StandaloneNode> templateBlockForMsg = this.TemplateBlockForMsg();
        msgNode.addChildren(templateBlockForMsg);
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 52: {
                cmdText = this.FallbackmsgTag();
                msgNode = MsgNode.fallbackmsg(this.nodeIdGen.genId(), cmdText.parsedContent(), cmdText.srcLocation()).build(this.context);
                msgFbGrpNode.addChild(msgNode);
                templateBlockForMsg = this.TemplateBlockForMsg();
                msgNode.addChildren(templateBlockForMsg);
                break;
            }
            default: {
                this.jj_la1[43] = this.jj_gen;
            }
        }
        this.jj_consume_token(53);
        return msgFbGrpNode;
    }

    private final List<SoyNode.StandaloneNode> TemplateBlockForMsg() throws ParseException {
        ArrayList templateBlock;
        block14: {
            templateBlock = Lists.newArrayList();
            if (this.jj_2_6(Integer.MAX_VALUE)) {
                this.MaybeWhitespace("No message content is allowed before a 'plural' block.");
                MsgPluralNode msgPlural = this.MsgPlural();
                templateBlock.add(msgPlural);
                this.MaybeWhitespace("No message content is allowed after a 'plural' block.");
            } else if (this.jj_2_7(Integer.MAX_VALUE)) {
                this.MaybeWhitespace("No message content is allowed before a 'select' block.");
                MsgSelectNode msgSelect = this.MsgSelect();
                templateBlock.add(msgSelect);
                this.MaybeWhitespace("No message content is allowed after a 'select' block.");
            } else {
                block9: while (true) {
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 32: 
                        case 33: 
                        case 39: 
                        case 40: 
                        case 41: 
                        case 42: 
                        case 43: 
                        case 44: 
                        case 45: 
                        case 46: 
                        case 47: 
                        case 54: 
                        case 79: 
                        case 90: 
                        case 94: 
                        case 95: 
                        case 96: {
                            break;
                        }
                        default: {
                            this.jj_la1[44] = this.jj_gen;
                            break block14;
                        }
                    }
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 32: 
                        case 33: 
                        case 39: 
                        case 40: 
                        case 41: 
                        case 42: 
                        case 43: 
                        case 44: 
                        case 45: 
                        case 46: 
                        case 94: 
                        case 95: 
                        case 96: {
                            RawTextNode contiguousRawTextAsNode = this.ContiguousRawTextAsNode();
                            if (contiguousRawTextAsNode == null) continue block9;
                            templateBlock.add(contiguousRawTextAsNode);
                            continue block9;
                        }
                        case 47: {
                            AbstractParentCommandNode stmt = this.CallStmt();
                            templateBlock.add(new MsgPlaceholderNode(this.nodeIdGen.genId(), (SoyNode.MsgPlaceholderInitialNode)((Object)stmt)));
                            continue block9;
                        }
                        case 54: 
                        case 79: {
                            AbstractParentCommandNode stmt = this.PrintStmt();
                            if (stmt == null) continue block9;
                            templateBlock.add(new MsgPlaceholderNode(this.nodeIdGen.genId(), (SoyNode.MsgPlaceholderInitialNode)((Object)stmt)));
                            continue block9;
                        }
                        case 90: {
                            MsgHtmlTagNode msgHtmlTag = this.MsgHtmlTag();
                            templateBlock.add(new MsgPlaceholderNode(this.nodeIdGen.genId(), msgHtmlTag));
                            continue block9;
                        }
                    }
                    break;
                }
                this.jj_la1[45] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return templateBlock;
    }

    private final MsgPluralNode MsgPlural() throws ParseException {
        List<SoyNode.StandaloneNode> templateBlockForMsg;
        SourceItemInfo<String> cmdText = this.PluralTag();
        MsgPluralNode msgPluralNode = new MsgPluralNode.Builder(this.nodeIdGen.genId(), cmdText.parsedContent(), cmdText.srcLocation()).build(this.context);
        this.MaybeWhitespace("No content allowed between 'plural' and 'case' (whitespace and comments are okay).");
        block3: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 72: {
                    break;
                }
                default: {
                    this.jj_la1[46] = this.jj_gen;
                    break block3;
                }
            }
            cmdText = this.CaseTag();
            MsgPluralCaseNode msgPluralCaseNode = new MsgPluralCaseNode.Builder(this.nodeIdGen.genId(), cmdText.parsedContent(), cmdText.srcLocation()).build(this.errorReporter);
            msgPluralNode.addChild(msgPluralCaseNode);
            templateBlockForMsg = this.TemplateBlockForMsg();
            if (templateBlockForMsg.size() == 1 && (templateBlockForMsg.get(0) instanceof MsgPluralNode || templateBlockForMsg.get(0) instanceof MsgSelectNode)) {
                this.errorReporter.report(templateBlockForMsg.get(0).getSourceLocation(), PLURAL_AND_SELECT_NOT_ALLOWED_INSIDE_PLURAL_BLOCK, new Object[0]);
            }
            msgPluralCaseNode.addChildren(templateBlockForMsg);
        }
        Token defaultTag = this.jj_consume_token(71);
        MsgPluralDefaultNode msgPluralDefaultNode = new MsgPluralDefaultNode(this.nodeIdGen.genId(), this.createSrcLoc(defaultTag, new Token[0]));
        msgPluralNode.addChild(msgPluralDefaultNode);
        templateBlockForMsg = this.TemplateBlockForMsg();
        if (templateBlockForMsg.size() == 1 && (templateBlockForMsg.get(0) instanceof MsgPluralNode || templateBlockForMsg.get(0) instanceof MsgSelectNode)) {
            this.errorReporter.report(templateBlockForMsg.get(0).getSourceLocation(), PLURAL_AND_SELECT_NOT_ALLOWED_INSIDE_PLURAL_BLOCK, new Object[0]);
        }
        msgPluralDefaultNode.addChildren(templateBlockForMsg);
        this.jj_consume_token(66);
        return msgPluralNode;
    }

    private final MsgSelectNode MsgSelect() throws ParseException {
        List<SoyNode.StandaloneNode> templateBlockForMsg;
        SourceItemInfo<String> cmdText = this.SelectTag();
        MsgSelectNode msgSelectNode = new MsgSelectNode.Builder(this.nodeIdGen.genId(), cmdText.parsedContent(), cmdText.srcLocation()).build(this.context);
        this.MaybeWhitespace("No content allowed between 'select' and 'case' (whitespace and comments are okay).");
        block3: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 72: {
                    break;
                }
                default: {
                    this.jj_la1[47] = this.jj_gen;
                    break block3;
                }
            }
            cmdText = this.CaseTag();
            MsgSelectCaseNode msgSelectCaseNode = new MsgSelectCaseNode.Builder(this.nodeIdGen.genId(), cmdText.parsedContent(), cmdText.srcLocation()).build(this.context);
            msgSelectNode.addChild(msgSelectCaseNode);
            templateBlockForMsg = this.TemplateBlockForMsg();
            msgSelectCaseNode.addChildren(templateBlockForMsg);
        }
        Token defaultTag = this.jj_consume_token(71);
        MsgSelectDefaultNode msgSelectDefaultNode = new MsgSelectDefaultNode(this.nodeIdGen.genId(), this.createSrcLoc(defaultTag, new Token[0]));
        msgSelectNode.addChild(msgSelectDefaultNode);
        templateBlockForMsg = this.TemplateBlockForMsg();
        msgSelectDefaultNode.addChildren(templateBlockForMsg);
        this.jj_consume_token(68);
        return msgSelectNode;
    }

    private final MsgHtmlTagNode MsgHtmlTag() throws ParseException {
        Token htmlTagOpen = this.jj_consume_token(90);
        List<SoyNode.StandaloneNode> templateBlock = this.TemplateBlock();
        this.jj_consume_token(91);
        SourceLocation srcLoc = this.createSrcLoc(htmlTagOpen, new Token[0]);
        if (templateBlock.get(0) instanceof RawTextNode) {
            RawTextNode firstNode = (RawTextNode)templateBlock.get(0);
            RawTextNode newNode = new RawTextNode(this.nodeIdGen.genId(), "<" + firstNode.getRawText(), srcLoc);
            templateBlock.set(0, newNode);
        } else {
            templateBlock.add(0, new RawTextNode(this.nodeIdGen.genId(), "<", srcLoc));
        }
        int lastNodeIndex = templateBlock.size() - 1;
        if (templateBlock.get(lastNodeIndex) instanceof RawTextNode) {
            RawTextNode lastNode = (RawTextNode)templateBlock.get(lastNodeIndex);
            RawTextNode newNode = new RawTextNode(this.nodeIdGen.genId(), lastNode.getRawText() + ">", srcLoc);
            templateBlock.set(lastNodeIndex, newNode);
        } else {
            templateBlock.add(new RawTextNode(this.nodeIdGen.genId(), ">", srcLoc));
        }
        return new MsgHtmlTagNode.Builder(this.nodeIdGen.genId(), (ImmutableList<SoyNode.StandaloneNode>)ImmutableList.copyOf(templateBlock), this.createSrcLoc(htmlTagOpen, new Token[0])).build(this.errorReporter);
    }

    private final PrintNode PrintStmt() throws ParseException {
        String userSuppliedPhName;
        List<String> cmdTextParts;
        boolean isImplicit;
        SourceItemInfo<List<String>> printTagInfo = this.PrintTag();
        List<String> printTagParts = printTagInfo.parsedContent();
        if (!printTagParts.isEmpty() && printTagParts.get(0).equals("print")) {
            isImplicit = false;
            cmdTextParts = printTagParts.subList(1, printTagParts.size());
        } else {
            isImplicit = true;
            cmdTextParts = printTagParts;
        }
        String cmdText = Joiner.on((String)"").join(cmdTextParts);
        String phnameAttr = null;
        for (String cmdTextPart : cmdTextParts) {
            if (!cmdTextPart.startsWith(" phname=\"") || !cmdTextPart.endsWith("\"")) continue;
            if (phnameAttr != null) {
                this.errorReporter.report(printTagInfo.srcLocation(), MULTIPLE_PHNAME_ATTRIBUTES_IN_COMMAND, "print", cmdText);
            }
            phnameAttr = cmdTextPart;
        }
        if (phnameAttr != null) {
            cmdTextParts.remove(phnameAttr);
            userSuppliedPhName = phnameAttr.substring(9, phnameAttr.length() - 1);
        } else {
            userSuppliedPhName = null;
        }
        if (cmdTextParts.isEmpty()) {
            this.errorReporter.report(printTagInfo.srcLocation(), PRINT_COMMAND_WITH_EMPTY_TEXT, new Object[0]);
            return null;
        }
        String exprText = cmdTextParts.get(0).trim();
        PrintNode printNode = new PrintNode.Builder(this.nodeIdGen.genId(), isImplicit, printTagInfo.srcLocation()).exprText(exprText).userSuppliedPlaceholderName(userSuppliedPhName).build(this.context);
        String directiveName = null;
        int n = cmdTextParts.size();
        for (int i = 1; i < n; ++i) {
            String cmdTextPart = cmdTextParts.get(i);
            if (cmdTextPart.startsWith("|")) {
                if (directiveName != null) {
                    printNode.addChild(new PrintDirectiveNode.Builder(this.nodeIdGen.genId(), directiveName, "", printTagInfo.srcLocation()).build(this.context));
                }
                directiveName = cmdTextPart;
                continue;
            }
            if (cmdTextPart.startsWith(":")) {
                if (directiveName == null) {
                    throw new AssertionError();
                }
                String argsText = cmdTextPart.substring(1);
                printNode.addChild(new PrintDirectiveNode.Builder(this.nodeIdGen.genId(), directiveName, argsText, printTagInfo.srcLocation()).build(this.context));
                directiveName = null;
                continue;
            }
            if (cmdTextPart.trim().length() == 0) continue;
            this.errorReporter.report(printNode.getSourceLocation(), INVALID_PRINT_COMMAND_TEXT, cmdText);
        }
        if (directiveName != null) {
            printNode.addChild(new PrintDirectiveNode.Builder(this.nodeIdGen.genId(), directiveName, "", printTagInfo.srcLocation()).build(this.context));
        }
        return printNode;
    }

    private final XidNode XidStmt() throws ParseException {
        SourceItemInfo<String> cmdText = this.XidTag();
        return new XidNode.Builder(this.nodeIdGen.genId(), cmdText.parsedContent(), cmdText.srcLocation()).build(this.errorReporter);
    }

    private final CssNode CssStmt() throws ParseException {
        SourceItemInfo<String> cmdText = this.CssTag();
        return new CssNode.Builder(this.nodeIdGen.genId(), cmdText.parsedContent(), cmdText.srcLocation()).build(this.context);
    }

    private final LetNode LetStmt() throws ParseException {
        LetNode letNode = null;
        if (this.jj_2_8(Integer.MAX_VALUE)) {
            SourceItemInfo<String> cmdText = this.LetTagSelfEnding();
            letNode = new LetValueNode.Builder(this.nodeIdGen.genId(), cmdText.parsedContent(), cmdText.srcLocation()).build(this.context);
        } else {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 61: {
                    SourceItemInfo<String> cmdText = this.LetTagNotSelfEnding();
                    LetContentNode letContentNode = new LetContentNode.Builder(this.nodeIdGen.genId(), cmdText.parsedContent(), cmdText.srcLocation()).build(this.context);
                    List<SoyNode.StandaloneNode> templateBlock = this.TemplateBlock();
                    letContentNode.addChildren((List<? extends SoyNode.StandaloneNode>)templateBlock);
                    letNode = letContentNode;
                    this.jj_consume_token(62);
                    break;
                }
                default: {
                    this.jj_la1[48] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
        }
        return letNode;
    }

    private final IfNode IfStmt() throws ParseException {
        SourceItemInfo<String> cmdText = this.IfTag();
        IfNode ifNode = new IfNode(this.nodeIdGen.genId(), cmdText.srcLocation());
        IfCondNode ifCondNode = IfCondNode.ifBuilder(this.nodeIdGen.genId(), cmdText.parsedContent(), cmdText.srcLocation()).build(this.context);
        ifNode.addChild(ifCondNode);
        List<SoyNode.StandaloneNode> templateBlock = this.TemplateBlock();
        ifCondNode.addChildren(templateBlock);
        block6: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 58: {
                    break;
                }
                default: {
                    this.jj_la1[49] = this.jj_gen;
                    break block6;
                }
            }
            cmdText = this.ElseifTag();
            ifCondNode = IfCondNode.elseifBuilder(this.nodeIdGen.genId(), cmdText.parsedContent(), cmdText.srcLocation()).build(this.context);
            ifNode.addChild(ifCondNode);
            templateBlock = this.TemplateBlock();
            ifCondNode.addChildren(templateBlock);
        }
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 59: {
                Token elseTag = this.jj_consume_token(59);
                IfElseNode ifElseNode = new IfElseNode(this.nodeIdGen.genId(), this.createSrcLoc(elseTag, new Token[0]));
                ifNode.addChild(ifElseNode);
                templateBlock = this.TemplateBlock();
                ifElseNode.addChildren(templateBlock);
                break;
            }
            default: {
                this.jj_la1[50] = this.jj_gen;
            }
        }
        this.jj_consume_token(60);
        return ifNode;
    }

    private final SwitchNode SwitchStmt() throws ParseException {
        List<SoyNode.StandaloneNode> templateBlock;
        SourceItemInfo<String> cmdText = this.SwitchTag();
        SwitchNode switchNode = new SwitchNode.Builder(this.nodeIdGen.genId(), cmdText.parsedContent(), cmdText.srcLocation()).build(this.context);
        this.MaybeWhitespace("No content allowed between 'switch' and 'case' (whitespace and comments are okay).");
        block6: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 72: {
                    break;
                }
                default: {
                    this.jj_la1[51] = this.jj_gen;
                    break block6;
                }
            }
            cmdText = this.CaseTag();
            SwitchCaseNode switchCaseNode = new SwitchCaseNode.Builder(this.nodeIdGen.genId(), cmdText.parsedContent(), cmdText.srcLocation()).build(this.context);
            switchNode.addChild(switchCaseNode);
            templateBlock = this.TemplateBlock();
            switchCaseNode.addChildren(templateBlock);
        }
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 71: {
                Token defaultTag = this.jj_consume_token(71);
                SwitchDefaultNode switchDefaultNode = new SwitchDefaultNode(this.nodeIdGen.genId(), this.createSrcLoc(defaultTag, new Token[0]));
                switchNode.addChild(switchDefaultNode);
                templateBlock = this.TemplateBlock();
                switchDefaultNode.addChildren(templateBlock);
                break;
            }
            default: {
                this.jj_la1[52] = this.jj_gen;
            }
        }
        this.jj_consume_token(70);
        return switchNode;
    }

    private final ForeachNode ForeachStmt() throws ParseException {
        SourceItemInfo<String> cmdText = this.ForeachTag();
        ForeachBuilder builder = ForeachBuilder.create(this.nodeIdGen, this.context).setCommandLocation(cmdText.srcLocation()).setCommandText(cmdText.parsedContent());
        List<SoyNode.StandaloneNode> templateBlock = this.TemplateBlock();
        builder.setLoopBody(templateBlock);
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 74: {
                Token ifemptyTag = this.jj_consume_token(74);
                templateBlock = this.TemplateBlock();
                builder.setIfEmptyBody(this.createSrcLoc(ifemptyTag, new Token[0]), templateBlock);
                break;
            }
            default: {
                this.jj_la1[53] = this.jj_gen;
            }
        }
        this.jj_consume_token(75);
        return builder.build();
    }

    private final ForNode ForStmt() throws ParseException {
        SourceItemInfo<String> cmdText = this.ForTag();
        ForNode forNode = new ForNode(this.nodeIdGen.genId(), cmdText.parsedContent(), cmdText.srcLocation(), this.context);
        List<SoyNode.StandaloneNode> templateBlock = this.TemplateBlock();
        forNode.addChildren(templateBlock);
        this.jj_consume_token(64);
        return forNode;
    }

    private final CallNode CallStmt() throws ParseException {
        Token endCallTag;
        SourceItemInfo<List<String>> callTagInfo;
        ArrayList callParams = Lists.newArrayList();
        if (this.jj_2_9(Integer.MAX_VALUE)) {
            callTagInfo = this.AnyCallTagSelfEnding();
            endCallTag = null;
        } else {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 47: {
                    callTagInfo = this.AnyCallTagNotSelfEnding();
                    this.MaybeWhitespace("No content allowed between 'call' and 'param' (whitespace and comments are okay).");
                    block6: while (true) {
                        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                            case 49: {
                                break;
                            }
                            default: {
                                this.jj_la1[54] = this.jj_gen;
                                break block6;
                            }
                        }
                        CallParamNode callParam = this.CallParam();
                        callParams.add(callParam);
                        this.MaybeWhitespace("No content allowed between 'param' and 'param' (whitespace and comments are okay).");
                    }
                    endCallTag = this.jj_consume_token(48);
                    break;
                }
                default: {
                    this.jj_la1[55] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
        }
        List<String> callTagParts = callTagInfo.parsedContent();
        String cmdName = callTagParts.get(0);
        StringBuilder cmdTextSb = new StringBuilder();
        String phnameAttr = null;
        for (int i = 1; i < callTagParts.size(); ++i) {
            String cmdTextPart = callTagParts.get(i);
            if (cmdTextPart.startsWith(" phname=\"") && cmdTextPart.endsWith("\"")) {
                if (phnameAttr != null) {
                    this.errorReporter.report(callTagInfo.srcLocation(), MULTIPLE_PHNAME_ATTRIBUTES_IN_COMMAND, cmdName, Joiner.on((String)"").join(callTagParts.subList(1, callTagParts.size())));
                }
                phnameAttr = cmdTextPart;
                continue;
            }
            cmdTextSb.append(cmdTextPart);
        }
        String cmdText = cmdTextSb.toString();
        boolean isBasicCallTag = callTagParts.get(0).trim().equals("call");
        if (endCallTag != null && !endCallTag.image.equals("{/" + callTagParts.get(0).trim() + "}")) {
            if (isBasicCallTag) {
                this.errorReporter.report(this.createSrcLoc(endCallTag, new Token[0]), SoyErrorKind.of("{0}"), "Mismatched 'call' and '/delcall'.");
            } else {
                this.errorReporter.report(this.createSrcLoc(endCallTag, new Token[0]), SoyErrorKind.of("{0}"), "Mismatched 'delcall' and '/call'.");
            }
        }
        String userSuppliedPhName = phnameAttr != null ? phnameAttr.substring(9, phnameAttr.length() - 1) : null;
        CallNode callNode = null;
        callNode = isBasicCallTag ? new CallBasicNode.Builder(this.nodeIdGen.genId(), callTagInfo.srcLocation()).commandText(cmdText).userSuppliedPlaceholderName(userSuppliedPhName).build(this.context) : new CallDelegateNode.Builder(this.nodeIdGen.genId(), callTagInfo.srcLocation()).commandText(cmdText).userSuppliedPlaceholderName(userSuppliedPhName).build(this.context);
        callNode.addChildren((List)callParams);
        return callNode;
    }

    private final CallParamNode CallParam() throws ParseException {
        CallParamNode callParamNode = null;
        if (this.jj_2_10(Integer.MAX_VALUE)) {
            SourceItemInfo<String> cmdText = this.ParamTagSelfEnding();
            callParamNode = new CallParamValueNode.Builder(this.nodeIdGen.genId(), cmdText.parsedContent(), cmdText.srcLocation()).build(this.context);
        } else {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 49: {
                    SourceItemInfo<String> cmdText = this.ParamTagNotSelfEnding();
                    CallParamContentNode cpcn = new CallParamContentNode.Builder(this.nodeIdGen.genId(), cmdText.parsedContent(), cmdText.srcLocation()).build(this.context);
                    List<SoyNode.StandaloneNode> templateBlock = this.TemplateBlock();
                    cpcn.addChildren((List<? extends SoyNode.StandaloneNode>)templateBlock);
                    callParamNode = cpcn;
                    this.jj_consume_token(50);
                    break;
                }
                default: {
                    this.jj_la1[56] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
        }
        return callParamNode;
    }

    private final LogNode LogStmt() throws ParseException {
        Token open = this.jj_consume_token(76);
        LogNode logNode = new LogNode(this.nodeIdGen.genId(), this.createSrcLoc(open, new Token[0]));
        List<SoyNode.StandaloneNode> templateBlock = this.TemplateBlock();
        logNode.addChildren(templateBlock);
        this.jj_consume_token(77);
        return logNode;
    }

    private final DebuggerNode DebuggerStmt() throws ParseException {
        Token token = this.jj_consume_token(78);
        return new DebuggerNode(this.nodeIdGen.genId(), this.createSrcLoc(token, new Token[0]));
    }

    public final TemplateParseResult parseTemplateContent() throws ParseException {
        List<TemplateNodeBuilder.DeclInfo> headerDecls;
        this.context = SoyParsingContext.empty(this.errorReporter, "fake.namespace");
        this.token_source.SwitchTo(3);
        if (this.jj_2_12(Integer.MAX_VALUE)) {
            headerDecls = this.TemplateHeader();
        } else {
            if (this.jj_2_11(2)) {
                this.HeaderConsecWsNoNl();
            }
            headerDecls = null;
        }
        List<SoyNode.StandaloneNode> bodyNodes = this.TemplateBlock();
        this.jj_consume_token(0);
        if (this.token_source.curLexState == 7 || this.token_source.curLexState == 8) {
            throw new ParseException("At end of template, found comment block that is never closed.");
        }
        return new TemplateParseResult(headerDecls, bodyNodes);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_1(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_1();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(0, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_2(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_2();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(1, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_3(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_3();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(2, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_4(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_4();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(3, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_5(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_5();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(4, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_6(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_6();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(5, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_7(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_7();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(6, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_8(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_8();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(7, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_9(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_9();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(8, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_10(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_10();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(9, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_11(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_11();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(10, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_12(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_12();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(11, xla);
        }
    }

    private boolean jj_3R_40() {
        Token xsp;
        do {
            xsp = this.jj_scanpos;
        } while (!this.jj_3R_51());
        this.jj_scanpos = xsp;
        return false;
    }

    private boolean jj_3_12() {
        return this.jj_3R_20();
    }

    private boolean jj_3R_27() {
        if (this.jj_scan_token(61)) {
            return true;
        }
        if (this.jj_3R_39()) {
            return true;
        }
        return this.jj_scan_token(81);
    }

    private boolean jj_3R_23() {
        return this.jj_3R_35();
    }

    private boolean jj_3R_43() {
        return this.jj_3R_42();
    }

    private boolean jj_3_11() {
        return this.jj_3R_30();
    }

    private boolean jj_3_3() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_23()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_24()) {
                this.jj_scanpos = xsp;
                if (this.jj_3R_25()) {
                    return true;
                }
            }
        }
        return false;
    }

    private boolean jj_3_8() {
        return this.jj_3R_27();
    }

    private boolean jj_3R_34() {
        Token xsp = this.jj_scanpos;
        if (this.jj_scan_token(32)) {
            this.jj_scanpos = xsp;
            if (this.jj_scan_token(33)) {
                return true;
            }
        }
        return false;
    }

    private boolean jj_3R_39() {
        return this.jj_3R_40();
    }

    private boolean jj_3R_52() {
        Token xsp = this.jj_scanpos;
        if (this.jj_scan_token(94)) {
            this.jj_scanpos = xsp;
            if (this.jj_scan_token(95)) {
                this.jj_scanpos = xsp;
                if (this.jj_scan_token(33)) {
                    return true;
                }
            }
        }
        return false;
    }

    private boolean jj_3R_42() {
        Token xsp;
        if (this.jj_3R_52()) {
            return true;
        }
        do {
            xsp = this.jj_scanpos;
        } while (!this.jj_3R_52());
        this.jj_scanpos = xsp;
        return false;
    }

    private boolean jj_3R_32() {
        if (this.jj_scan_token(32)) {
            return true;
        }
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_43()) {
            this.jj_scanpos = xsp;
        }
        return false;
    }

    private boolean jj_3R_31() {
        return this.jj_3R_42();
    }

    private boolean jj_3R_29() {
        if (this.jj_scan_token(49)) {
            return true;
        }
        if (this.jj_3R_39()) {
            return true;
        }
        return this.jj_scan_token(81);
    }

    private boolean jj_3R_20() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_31()) {
            this.jj_scanpos = xsp;
        }
        xsp = this.jj_scanpos;
        if (this.jj_3R_32()) {
            this.jj_scanpos = xsp;
        }
        xsp = this.jj_scanpos;
        if (this.jj_scan_token(36)) {
            this.jj_scanpos = xsp;
            if (this.jj_scan_token(37)) {
                return true;
            }
        }
        return false;
    }

    private boolean jj_3R_50() {
        return this.jj_scan_token(45);
    }

    private boolean jj_3R_49() {
        return this.jj_scan_token(44);
    }

    private boolean jj_3R_48() {
        return this.jj_scan_token(43);
    }

    private boolean jj_3R_41() {
        Token xsp = this.jj_scanpos;
        if (this.jj_scan_token(95)) {
            this.jj_scanpos = xsp;
            if (this.jj_scan_token(33)) {
                return true;
            }
        }
        return false;
    }

    private boolean jj_3R_47() {
        return this.jj_scan_token(41);
    }

    private boolean jj_3R_46() {
        return this.jj_scan_token(42);
    }

    private boolean jj_3R_30() {
        Token xsp;
        if (this.jj_3R_41()) {
            return true;
        }
        do {
            xsp = this.jj_scanpos;
        } while (!this.jj_3R_41());
        this.jj_scanpos = xsp;
        return false;
    }

    private boolean jj_3R_45() {
        return this.jj_scan_token(40);
    }

    private boolean jj_3R_44() {
        return this.jj_scan_token(39);
    }

    private boolean jj_3R_37() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_44()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_45()) {
                this.jj_scanpos = xsp;
                if (this.jj_3R_46()) {
                    this.jj_scanpos = xsp;
                    if (this.jj_3R_47()) {
                        this.jj_scanpos = xsp;
                        if (this.jj_3R_48()) {
                            this.jj_scanpos = xsp;
                            if (this.jj_3R_49()) {
                                this.jj_scanpos = xsp;
                                if (this.jj_3R_50()) {
                                    return true;
                                }
                            }
                        }
                    }
                }
            }
        }
        return false;
    }

    private boolean jj_3_4() {
        return this.jj_3R_20();
    }

    private boolean jj_3_7() {
        if (this.jj_3R_26()) {
            return true;
        }
        return this.jj_scan_token(67);
    }

    private boolean jj_3R_22() {
        return this.jj_3R_34();
    }

    private boolean jj_3R_21() {
        return this.jj_3R_33();
    }

    private boolean jj_3_6() {
        if (this.jj_3R_26()) {
            return true;
        }
        return this.jj_scan_token(65);
    }

    private boolean jj_3R_36() {
        if (this.jj_scan_token(46)) {
            return true;
        }
        return this.jj_scan_token(93);
    }

    private boolean jj_3_2() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_21()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_22()) {
                return true;
            }
        }
        return false;
    }

    private boolean jj_3_5() {
        Token xsp;
        do {
            xsp = this.jj_scanpos;
        } while (!this.jj_scan_token(95));
        this.jj_scanpos = xsp;
        return this.jj_scan_token(32);
    }

    private boolean jj_3R_35() {
        Token xsp;
        if (this.jj_3_2()) {
            return true;
        }
        do {
            xsp = this.jj_scanpos;
        } while (!this.jj_3_2());
        this.jj_scanpos = xsp;
        return false;
    }

    private boolean jj_3R_38() {
        return this.jj_3R_35();
    }

    private boolean jj_3R_28() {
        if (this.jj_scan_token(47)) {
            return true;
        }
        if (this.jj_3R_40()) {
            return true;
        }
        return this.jj_scan_token(81);
    }

    private boolean jj_3R_26() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_38()) {
            this.jj_scanpos = xsp;
        }
        return false;
    }

    private boolean jj_3_1() {
        return this.jj_3R_20();
    }

    private boolean jj_3R_25() {
        return this.jj_3R_37();
    }

    private boolean jj_3_10() {
        return this.jj_3R_29();
    }

    private boolean jj_3R_54() {
        Token xsp = this.jj_scanpos;
        if (this.jj_scan_token(82)) {
            this.jj_scanpos = xsp;
            if (this.jj_scan_token(83)) {
                return true;
            }
        }
        return false;
    }

    private boolean jj_3R_53() {
        return this.jj_scan_token(88);
    }

    private boolean jj_3R_33() {
        Token xsp = this.jj_scanpos;
        if (this.jj_scan_token(94)) {
            this.jj_scanpos = xsp;
            if (this.jj_scan_token(95)) {
                this.jj_scanpos = xsp;
                if (this.jj_scan_token(96)) {
                    return true;
                }
            }
        }
        return false;
    }

    private boolean jj_3_9() {
        return this.jj_3R_28();
    }

    private boolean jj_3R_51() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_53()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_54()) {
                return true;
            }
        }
        return false;
    }

    private boolean jj_3R_24() {
        return this.jj_3R_36();
    }

    private static void jj_la1_init_0() {
        jj_la1_0 = new int[]{131072, 16384, 4096, 0x600000, 2048, 106496, 106496, 0x600000, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
    }

    private static void jj_la1_init_1() {
        jj_la1_1 = new int[]{0, 0, 0, 0, 0, 0, 0, 0, 2, 12, 0, 0, 0, 2, 2, 2, 2, 3, 0, 3, 3, 16256, 32643, 0x400000, 2, 2, 2, 2, 2, 1, 48, 49, 48, 0, 0, 0, 2, 48, 0, 0, -1547108477, -1547108477, -1547141120, 0x100000, 4259715, 4259715, 0, 0, 0x20000000, 0x4000000, 0x8000000, 0, 0, 0, 131072, 32768, 131072};
    }

    private static void jj_la1_init_2() {
        jj_la1_2 = new int[]{0, 0, 0, 0, 0, 0, 0, 0, Integer.MIN_VALUE, 0, 0x10C0000, 786432, 0x10C0000, Integer.MIN_VALUE, Integer.MIN_VALUE, -1073741824, -1073741824, 0, -1073741824, -1073741824, -1073741824, 0, -1073741824, 32768, -1073741824, Integer.MIN_VALUE, Integer.MIN_VALUE, -1073741824, -1073741824, 0, 0, 0, 0, 0, 0, Integer.MIN_VALUE, -1073741824, 0, 0, 0, -1073688032, -1073688032, 53792, 0, -1006600192, -1006600192, 256, 256, 0, 0, 0, 256, 128, 1024, 0, 0, 0};
    }

    private static void jj_la1_init_3() {
        jj_la1_3 = new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 512, 4, 0, 0, 0, 512, 4, 1, 1, 0, 0, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
    }

    public SoyFileParser(InputStream stream) {
        this(stream, null);
    }

    public SoyFileParser(InputStream stream, String encoding) {
        int i;
        try {
            this.jj_input_stream = new SimpleCharStream(stream, encoding, 1, 1);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        this.token_source = new SoyFileParserTokenManager(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (i = 0; i < 57; ++i) {
            this.jj_la1[i] = -1;
        }
        for (i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    public void ReInit(InputStream stream) {
        this.ReInit(stream, null);
    }

    public void ReInit(InputStream stream, String encoding) {
        int i;
        try {
            this.jj_input_stream.ReInit(stream, encoding, 1, 1);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        this.token_source.ReInit(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (i = 0; i < 57; ++i) {
            this.jj_la1[i] = -1;
        }
        for (i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    public SoyFileParser(Reader stream) {
        int i;
        this.jj_input_stream = new SimpleCharStream(stream, 1, 1);
        this.token_source = new SoyFileParserTokenManager(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (i = 0; i < 57; ++i) {
            this.jj_la1[i] = -1;
        }
        for (i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    public void ReInit(Reader stream) {
        int i;
        this.jj_input_stream.ReInit(stream, 1, 1);
        this.token_source.ReInit(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (i = 0; i < 57; ++i) {
            this.jj_la1[i] = -1;
        }
        for (i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    public SoyFileParser(SoyFileParserTokenManager tm) {
        int i;
        this.token_source = tm;
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (i = 0; i < 57; ++i) {
            this.jj_la1[i] = -1;
        }
        for (i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    public void ReInit(SoyFileParserTokenManager tm) {
        int i;
        this.token_source = tm;
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (i = 0; i < 57; ++i) {
            this.jj_la1[i] = -1;
        }
        for (i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    private Token jj_consume_token(int kind) throws ParseException {
        Token oldToken = this.token;
        this.token = oldToken.next != null ? this.token.next : (this.token.next = this.token_source.getNextToken());
        this.jj_ntk = -1;
        if (this.token.kind == kind) {
            ++this.jj_gen;
            if (++this.jj_gc > 100) {
                this.jj_gc = 0;
                for (int i = 0; i < this.jj_2_rtns.length; ++i) {
                    JJCalls c = this.jj_2_rtns[i];
                    while (c != null) {
                        if (c.gen < this.jj_gen) {
                            c.first = null;
                        }
                        c = c.next;
                    }
                }
            }
            return this.token;
        }
        this.token = oldToken;
        this.jj_kind = kind;
        throw this.generateParseException();
    }

    private boolean jj_scan_token(int kind) {
        if (this.jj_scanpos == this.jj_lastpos) {
            --this.jj_la;
            if (this.jj_scanpos.next == null) {
                this.jj_scanpos = this.jj_scanpos.next = this.token_source.getNextToken();
                this.jj_lastpos = this.jj_scanpos.next;
            } else {
                this.jj_lastpos = this.jj_scanpos = this.jj_scanpos.next;
            }
        } else {
            this.jj_scanpos = this.jj_scanpos.next;
        }
        if (this.jj_rescan) {
            int i = 0;
            Token tok = this.token;
            while (tok != null && tok != this.jj_scanpos) {
                ++i;
                tok = tok.next;
            }
            if (tok != null) {
                this.jj_add_error_token(kind, i);
            }
        }
        if (this.jj_scanpos.kind != kind) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            throw this.jj_ls;
        }
        return false;
    }

    public final Token getNextToken() {
        this.token = this.token.next != null ? this.token.next : (this.token.next = this.token_source.getNextToken());
        this.jj_ntk = -1;
        ++this.jj_gen;
        return this.token;
    }

    public final Token getToken(int index) {
        Token t = this.token;
        for (int i = 0; i < index; ++i) {
            t = t.next != null ? t.next : (t.next = this.token_source.getNextToken());
        }
        return t;
    }

    private int jj_ntk() {
        this.jj_nt = this.token.next;
        if (this.jj_nt == null) {
            this.token.next = this.token_source.getNextToken();
            this.jj_ntk = this.token.next.kind;
            return this.jj_ntk;
        }
        this.jj_ntk = this.jj_nt.kind;
        return this.jj_ntk;
    }

    private void jj_add_error_token(int kind, int pos) {
        if (pos >= 100) {
            return;
        }
        if (pos == this.jj_endpos + 1) {
            this.jj_lasttokens[this.jj_endpos++] = kind;
        } else if (this.jj_endpos != 0) {
            this.jj_expentry = new int[this.jj_endpos];
            for (int i = 0; i < this.jj_endpos; ++i) {
                this.jj_expentry[i] = this.jj_lasttokens[i];
            }
            block1: for (int[] oldentry : this.jj_expentries) {
                if (oldentry.length != this.jj_expentry.length) continue;
                for (int i = 0; i < this.jj_expentry.length; ++i) {
                    if (oldentry[i] != this.jj_expentry[i]) continue block1;
                }
                this.jj_expentries.add(this.jj_expentry);
                break;
            }
            if (pos != 0) {
                this.jj_endpos = pos;
                this.jj_lasttokens[this.jj_endpos - 1] = kind;
            }
        }
    }

    public ParseException generateParseException() {
        int i;
        this.jj_expentries.clear();
        boolean[] la1tokens = new boolean[107];
        if (this.jj_kind >= 0) {
            la1tokens[this.jj_kind] = true;
            this.jj_kind = -1;
        }
        for (i = 0; i < 57; ++i) {
            if (this.jj_la1[i] != this.jj_gen) continue;
            for (int j = 0; j < 32; ++j) {
                if ((jj_la1_0[i] & 1 << j) != 0) {
                    la1tokens[j] = true;
                }
                if ((jj_la1_1[i] & 1 << j) != 0) {
                    la1tokens[32 + j] = true;
                }
                if ((jj_la1_2[i] & 1 << j) != 0) {
                    la1tokens[64 + j] = true;
                }
                if ((jj_la1_3[i] & 1 << j) == 0) continue;
                la1tokens[96 + j] = true;
            }
        }
        for (i = 0; i < 107; ++i) {
            if (!la1tokens[i]) continue;
            this.jj_expentry = new int[1];
            this.jj_expentry[0] = i;
            this.jj_expentries.add(this.jj_expentry);
        }
        this.jj_endpos = 0;
        this.jj_rescan_token();
        this.jj_add_error_token(0, 0);
        int[][] exptokseq = new int[this.jj_expentries.size()][];
        for (int i2 = 0; i2 < this.jj_expentries.size(); ++i2) {
            exptokseq[i2] = this.jj_expentries.get(i2);
        }
        return new ParseException(this.token, exptokseq, tokenImage);
    }

    public final void enable_tracing() {
    }

    public final void disable_tracing() {
    }

    private void jj_rescan_token() {
        this.jj_rescan = true;
        for (int i = 0; i < 12; ++i) {
            try {
                JJCalls p = this.jj_2_rtns[i];
                do {
                    if (p.gen <= this.jj_gen) continue;
                    this.jj_la = p.arg;
                    this.jj_lastpos = this.jj_scanpos = p.first;
                    switch (i) {
                        case 0: {
                            this.jj_3_1();
                            break;
                        }
                        case 1: {
                            this.jj_3_2();
                            break;
                        }
                        case 2: {
                            this.jj_3_3();
                            break;
                        }
                        case 3: {
                            this.jj_3_4();
                            break;
                        }
                        case 4: {
                            this.jj_3_5();
                            break;
                        }
                        case 5: {
                            this.jj_3_6();
                            break;
                        }
                        case 6: {
                            this.jj_3_7();
                            break;
                        }
                        case 7: {
                            this.jj_3_8();
                            break;
                        }
                        case 8: {
                            this.jj_3_9();
                            break;
                        }
                        case 9: {
                            this.jj_3_10();
                            break;
                        }
                        case 10: {
                            this.jj_3_11();
                            break;
                        }
                        case 11: {
                            this.jj_3_12();
                        }
                    }
                } while ((p = p.next) != null);
                continue;
            }
            catch (LookaheadSuccess lookaheadSuccess) {
                // empty catch block
            }
        }
        this.jj_rescan = false;
    }

    private void jj_save(int index, int xla) {
        JJCalls p = this.jj_2_rtns[index];
        while (p.gen > this.jj_gen) {
            if (p.next == null) {
                p = p.next = new JJCalls();
                break;
            }
            p = p.next;
        }
        p.gen = this.jj_gen + xla - this.jj_la;
        p.first = this.token;
        p.arg = xla;
    }

    static {
        SoyFileParser.jj_la1_init_0();
        SoyFileParser.jj_la1_init_1();
        SoyFileParser.jj_la1_init_2();
        SoyFileParser.jj_la1_init_3();
    }

    static final class JJCalls {
        int gen;
        Token first;
        int arg;
        JJCalls next;

        JJCalls() {
        }
    }

    private static final class LookaheadSuccess
    extends Error {
        private LookaheadSuccess() {
        }
    }

    static class RegexFromTokenImageFunction
    implements Function<String, String> {
        RegexFromTokenImageFunction() {
        }

        public String apply(String o) {
            return Pattern.quote(o.substring(2, o.length() - 2));
        }
    }
}

