/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.jssrc.internal;

import com.google.common.base.Preconditions;
import com.google.template.soy.base.SourceLocation;
import com.google.template.soy.error.ErrorReporter;
import com.google.template.soy.exprtree.AbstractExprNodeVisitor;
import com.google.template.soy.exprtree.ExprNode;
import com.google.template.soy.exprtree.FunctionNode;
import com.google.template.soy.jssrc.internal.TranslateToJsExprVisitor;
import com.google.template.soy.jssrc.internal.V1JsExprTranslator;
import com.google.template.soy.jssrc.restricted.JsExpr;
import com.google.template.soy.jssrc.restricted.SoyJsSrcFunction;
import com.google.template.soy.shared.internal.BuiltinFunction;
import com.google.template.soy.shared.restricted.SoyFunction;
import com.google.template.soy.soytree.ExprUnion;
import java.util.Deque;
import java.util.Map;
import javax.annotation.Nullable;
import javax.inject.Inject;

public final class JsExprTranslator {
    private final TranslateToJsExprVisitor.TranslateToJsExprVisitorFactory translateToJsExprVisitorFactory;

    @Inject
    JsExprTranslator(TranslateToJsExprVisitor.TranslateToJsExprVisitorFactory translateToJsExprVisitorFactory) {
        this.translateToJsExprVisitorFactory = translateToJsExprVisitorFactory;
    }

    JsExpr translateToJsExpr(@Nullable ExprNode expr, @Nullable String exprText, Deque<Map<String, JsExpr>> localVarTranslations, ErrorReporter errorReporter) {
        if (expr != null && (exprText == null || new CheckAllFunctionsSupportedVisitor().exec(expr).booleanValue())) {
            return (JsExpr)this.translateToJsExprVisitorFactory.create(localVarTranslations, errorReporter).exec(expr);
        }
        SourceLocation sourceLocation = expr != null ? expr.getSourceLocation() : SourceLocation.UNKNOWN;
        Preconditions.checkNotNull((Object)exprText);
        return V1JsExprTranslator.translateToJsExpr(exprText, sourceLocation, localVarTranslations, errorReporter);
    }

    JsExpr translateToJsExpr(ExprNode expr, Deque<Map<String, JsExpr>> localVarTranslations, ErrorReporter errorReporter) {
        Preconditions.checkNotNull((Object)expr);
        return this.translateToJsExpr(expr, null, localVarTranslations, errorReporter);
    }

    JsExpr translateToJsExpr(ExprUnion union, Deque<Map<String, JsExpr>> localVarTranslations, ErrorReporter errorReporter) {
        return this.translateToJsExpr(union.getExpr(), union.getExprText(), localVarTranslations, errorReporter);
    }

    private static final class CheckAllFunctionsSupportedVisitor
    extends AbstractExprNodeVisitor<Boolean> {
        private boolean areAllFunctionsSupported;

        private CheckAllFunctionsSupportedVisitor() {
        }

        @Override
        public Boolean exec(ExprNode node) {
            this.areAllFunctionsSupported = true;
            this.visit(node);
            return this.areAllFunctionsSupported;
        }

        @Override
        protected void visitFunctionNode(FunctionNode node) {
            SoyFunction function = node.getSoyFunction();
            if (!(function instanceof SoyJsSrcFunction) && !(function instanceof BuiltinFunction)) {
                this.areAllFunctionsSupported = false;
                return;
            }
            this.visitChildren(node);
        }

        @Override
        protected void visitExprNode(ExprNode node) {
            if (node instanceof ExprNode.ParentExprNode) {
                if (!this.areAllFunctionsSupported) {
                    return;
                }
                this.visitChildren((ExprNode.ParentExprNode)node);
            }
        }
    }
}

