/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.jssrc.internal;

import com.google.template.soy.jssrc.internal.HighLevelJsCodeBuilder;
import com.google.template.soy.jssrc.restricted.JsExpr;
import com.google.template.soy.shared.internal.CodeBuilder;

final class HighLevelJsCodeBuilderImpl
implements HighLevelJsCodeBuilder {
    private final CodeBuilder<JsExpr> jsCodeBuilder;

    HighLevelJsCodeBuilderImpl(CodeBuilder<JsExpr> jsCodeBuilder) {
        this.jsCodeBuilder = jsCodeBuilder;
    }

    @Override
    public HighLevelJsCodeBuilder declareModule(String module) {
        this.jsCodeBuilder.appendLine("goog.module('", module, "');\n");
        return this;
    }

    @Override
    public HighLevelJsCodeBuilder declareNamespace(String namespace) {
        this.jsCodeBuilder.appendLine("goog.provide('", namespace, "');");
        return this;
    }

    @Override
    public HighLevelJsCodeBuilder provide(String symbol) {
        this.jsCodeBuilder.appendLine("goog.provide('", symbol, "');");
        return this;
    }

    @Override
    public HighLevelJsCodeBuilder.DeclarationBuilder declareVariable(String name) {
        return new DeclarationBuilderImpl(name);
    }

    @Override
    public HighLevelJsCodeBuilder.ConditionBuilder _if(String expr) {
        return new ConditionBuilderImpl(expr);
    }

    private final class ConditionBuilderImpl
    implements HighLevelJsCodeBuilder.ConditionBuilder {
        ConditionBuilderImpl(String expr) {
            HighLevelJsCodeBuilderImpl.this.jsCodeBuilder.appendLine("if (", expr, ") {").increaseIndent();
        }

        @Override
        public HighLevelJsCodeBuilder.ConditionBuilder _else() {
            HighLevelJsCodeBuilderImpl.this.jsCodeBuilder.decreaseIndent();
            HighLevelJsCodeBuilderImpl.this.jsCodeBuilder.appendLine("} else {").increaseIndent();
            return this;
        }

        @Override
        public HighLevelJsCodeBuilder endif() {
            HighLevelJsCodeBuilderImpl.this.jsCodeBuilder.decreaseIndent();
            HighLevelJsCodeBuilderImpl.this.jsCodeBuilder.appendLine("}");
            return HighLevelJsCodeBuilderImpl.this;
        }
    }

    private final class DeclarationBuilderImpl
    implements HighLevelJsCodeBuilder.DeclarationBuilder {
        final String varName;

        DeclarationBuilderImpl(String varName) {
            this.varName = varName;
        }

        @Override
        public HighLevelJsCodeBuilder withValue(String value) {
            HighLevelJsCodeBuilderImpl.this.jsCodeBuilder.appendLine("var ", this.varName, " = ", value, ";");
            return HighLevelJsCodeBuilderImpl.this;
        }
    }
}

