/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.jssrc.internal;

import com.google.common.base.Preconditions;
import com.google.inject.assistedinject.Assisted;
import com.google.inject.assistedinject.AssistedInject;
import com.google.template.soy.base.internal.BaseUtils;
import com.google.template.soy.error.ErrorReporter;
import com.google.template.soy.error.SoyErrorKind;
import com.google.template.soy.exprtree.ExprRootNode;
import com.google.template.soy.exprtree.Operator;
import com.google.template.soy.jssrc.internal.GenCallCodeUtils;
import com.google.template.soy.jssrc.internal.IsComputableAsJsExprsVisitor;
import com.google.template.soy.jssrc.internal.JsExprTranslator;
import com.google.template.soy.jssrc.internal.TemplateAliases;
import com.google.template.soy.jssrc.restricted.JsExpr;
import com.google.template.soy.jssrc.restricted.JsExprUtils;
import com.google.template.soy.jssrc.restricted.SoyJsSrcPrintDirective;
import com.google.template.soy.soytree.AbstractSoyNodeVisitor;
import com.google.template.soy.soytree.CallNode;
import com.google.template.soy.soytree.CallParamContentNode;
import com.google.template.soy.soytree.CssNode;
import com.google.template.soy.soytree.IfCondNode;
import com.google.template.soy.soytree.IfElseNode;
import com.google.template.soy.soytree.IfNode;
import com.google.template.soy.soytree.MsgHtmlTagNode;
import com.google.template.soy.soytree.MsgPlaceholderNode;
import com.google.template.soy.soytree.PrintDirectiveNode;
import com.google.template.soy.soytree.PrintNode;
import com.google.template.soy.soytree.RawTextNode;
import com.google.template.soy.soytree.SoyNode;
import com.google.template.soy.soytree.TemplateNode;
import com.google.template.soy.soytree.XidNode;
import java.util.ArrayList;
import java.util.Deque;
import java.util.List;
import java.util.Map;

public class GenJsExprsVisitor
extends AbstractSoyNodeVisitor<List<JsExpr>> {
    private static final SoyErrorKind ARITY_MISMATCH = SoyErrorKind.of("Print directive ''{0}'' called with {1} arguments, expected {2}.");
    private static final SoyErrorKind UNKNOWN_SOY_JS_SRC_PRINT_DIRECTIVE = SoyErrorKind.of("Unknown SoyJsSrcPrintDirective ''{0}''.");
    private final Map<String, SoyJsSrcPrintDirective> soyJsSrcDirectivesMap;
    private final JsExprTranslator jsExprTranslator;
    private final GenCallCodeUtils genCallCodeUtils;
    protected final IsComputableAsJsExprsVisitor isComputableAsJsExprsVisitor;
    private final GenJsExprsVisitorFactory genJsExprsVisitorFactory;
    private final ErrorReporter errorReporter;
    private final Deque<Map<String, JsExpr>> localVarTranslations;
    protected List<JsExpr> jsExprs;
    private final TemplateAliases templateAliases;

    @AssistedInject
    public GenJsExprsVisitor(Map<String, SoyJsSrcPrintDirective> soyJsSrcDirectivesMap, JsExprTranslator jsExprTranslator, GenCallCodeUtils genCallCodeUtils, IsComputableAsJsExprsVisitor isComputableAsJsExprsVisitor, GenJsExprsVisitorFactory genJsExprsVisitorFactory, @Assisted ErrorReporter errorReporter, @Assisted Deque<Map<String, JsExpr>> localVarTranslations, @Assisted TemplateAliases templateAliases) {
        this.errorReporter = errorReporter;
        this.soyJsSrcDirectivesMap = soyJsSrcDirectivesMap;
        this.jsExprTranslator = jsExprTranslator;
        this.genCallCodeUtils = genCallCodeUtils;
        this.isComputableAsJsExprsVisitor = isComputableAsJsExprsVisitor;
        this.genJsExprsVisitorFactory = genJsExprsVisitorFactory;
        this.localVarTranslations = localVarTranslations;
        this.templateAliases = templateAliases;
    }

    @Override
    public List<JsExpr> exec(SoyNode node) {
        Preconditions.checkArgument((boolean)((Boolean)this.isComputableAsJsExprsVisitor.exec(node)));
        this.jsExprs = new ArrayList<JsExpr>();
        this.visit(node);
        return this.jsExprs;
    }

    public List<JsExpr> execOnChildren(SoyNode.ParentSoyNode<?> node) {
        Preconditions.checkArgument((boolean)this.isComputableAsJsExprsVisitor.execOnChildren(node));
        this.jsExprs = new ArrayList<JsExpr>();
        this.visitChildren(node);
        return this.jsExprs;
    }

    @Override
    protected void visitTemplateNode(TemplateNode node) {
        this.visitChildren(node);
    }

    @Override
    protected void visitRawTextNode(RawTextNode node) {
        String exprText = BaseUtils.escapeToSoyString(node.getRawText(), true);
        exprText = exprText.replace("</script>", "<\\/script>");
        this.jsExprs.add(new JsExpr(exprText, Integer.MAX_VALUE));
    }

    @Override
    protected void visitMsgPlaceholderNode(MsgPlaceholderNode node) {
        this.visitChildren(node);
    }

    @Override
    protected void visitMsgHtmlTagNode(MsgHtmlTagNode node) {
        this.visitChildren(node);
    }

    @Override
    protected void visitPrintNode(PrintNode node) {
        JsExpr jsExpr = this.jsExprTranslator.translateToJsExpr(node.getExprUnion(), this.localVarTranslations, this.errorReporter);
        for (PrintDirectiveNode directiveNode : node.getChildren()) {
            SoyJsSrcPrintDirective directive = this.soyJsSrcDirectivesMap.get(directiveNode.getName());
            if (directive == null) {
                this.errorReporter.report(node.getSourceLocation(), UNKNOWN_SOY_JS_SRC_PRINT_DIRECTIVE, directiveNode.getName());
                return;
            }
            List<ExprRootNode> args = directiveNode.getArgs();
            if (!directive.getValidArgsSizes().contains(args.size())) {
                this.errorReporter.report(node.getSourceLocation(), ARITY_MISMATCH, directiveNode.getName(), args.size(), directive.getValidArgsSizes());
                return;
            }
            ArrayList<JsExpr> argsJsExprs = new ArrayList<JsExpr>(args.size());
            for (ExprRootNode arg : args) {
                argsJsExprs.add(this.jsExprTranslator.translateToJsExpr(arg, this.localVarTranslations, this.errorReporter));
            }
            jsExpr = directive.applyForJsSrc(jsExpr, argsJsExprs);
        }
        this.jsExprs.add(jsExpr);
    }

    @Override
    protected void visitXidNode(XidNode node) {
        String xid = node.getText();
        String js = "xid('" + xid + "')";
        this.jsExprs.add(new JsExpr(js, Integer.MAX_VALUE));
    }

    @Override
    protected void visitCssNode(CssNode node) {
        StringBuilder sb = new StringBuilder();
        sb.append("goog.getCssName(");
        ExprRootNode componentNameExpr = node.getComponentNameExpr();
        if (componentNameExpr != null) {
            JsExpr baseJsExpr = this.jsExprTranslator.translateToJsExpr(componentNameExpr, this.localVarTranslations, this.errorReporter);
            sb.append(baseJsExpr.getText()).append(", ");
        }
        sb.append('\'').append(node.getSelectorText()).append("')");
        this.jsExprs.add(new JsExpr(sb.toString(), Integer.MAX_VALUE));
    }

    @Override
    protected void visitIfNode(IfNode node) {
        GenJsExprsVisitor genJsExprsVisitor = this.genJsExprsVisitorFactory.create(this.localVarTranslations, this.templateAliases, this.errorReporter);
        StringBuilder jsExprTextSb = new StringBuilder();
        boolean hasElse = false;
        for (SoyNode child : node.getChildren()) {
            if (child instanceof IfCondNode) {
                IfCondNode icn = (IfCondNode)child;
                JsExpr condJsExpr = this.jsExprTranslator.translateToJsExpr(icn.getExprUnion(), this.localVarTranslations, this.errorReporter);
                jsExprTextSb.append('(').append(condJsExpr.getText()).append(") ? ");
                List<JsExpr> condBlockJsExprs = genJsExprsVisitor.exec(icn);
                jsExprTextSb.append(JsExprUtils.concatJsExprs(condBlockJsExprs).getText());
                jsExprTextSb.append(" : ");
                continue;
            }
            if (child instanceof IfElseNode) {
                hasElse = true;
                IfElseNode ien = (IfElseNode)child;
                List<JsExpr> elseBlockJsExprs = genJsExprsVisitor.exec(ien);
                jsExprTextSb.append(JsExprUtils.concatJsExprs(elseBlockJsExprs).getText());
                continue;
            }
            throw new AssertionError();
        }
        if (!hasElse) {
            jsExprTextSb.append("''");
        }
        this.jsExprs.add(new JsExpr(jsExprTextSb.toString(), Operator.CONDITIONAL.getPrecedence()));
    }

    @Override
    protected void visitIfCondNode(IfCondNode node) {
        this.visitChildren(node);
    }

    @Override
    protected void visitIfElseNode(IfElseNode node) {
        this.visitChildren(node);
    }

    @Override
    protected void visitCallNode(CallNode node) {
        this.jsExprs.add(this.genCallCodeUtils.genCallExpr(node, this.localVarTranslations, this.templateAliases, this.errorReporter));
    }

    @Override
    protected void visitCallParamContentNode(CallParamContentNode node) {
        this.visitChildren(node);
    }

    public static interface GenJsExprsVisitorFactory {
        public GenJsExprsVisitor create(Deque<Map<String, JsExpr>> var1, TemplateAliases var2, ErrorReporter var3);
    }
}

