/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.jssrc.internal;

import com.google.common.base.CaseFormat;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.template.soy.base.internal.BaseUtils;
import com.google.template.soy.error.ErrorReporter;
import com.google.template.soy.jssrc.SoyJsSrcOptions;
import com.google.template.soy.jssrc.internal.GenCallCodeUtils;
import com.google.template.soy.jssrc.internal.GenJsCodeVisitor;
import com.google.template.soy.jssrc.internal.GenJsExprsVisitor;
import com.google.template.soy.jssrc.internal.IsComputableAsJsExprsVisitor;
import com.google.template.soy.jssrc.internal.JsExprTranslator;
import com.google.template.soy.jssrc.internal.TemplateAliases;
import com.google.template.soy.jssrc.restricted.JsExpr;
import com.google.template.soy.jssrc.restricted.JsExprUtils;
import com.google.template.soy.msgs.internal.IcuSyntaxUtils;
import com.google.template.soy.msgs.internal.MsgUtils;
import com.google.template.soy.msgs.restricted.SoyMsgPart;
import com.google.template.soy.msgs.restricted.SoyMsgPlaceholderPart;
import com.google.template.soy.msgs.restricted.SoyMsgRawTextPart;
import com.google.template.soy.shared.internal.CodeBuilder;
import com.google.template.soy.soytree.AbstractSoyNodeVisitor;
import com.google.template.soy.soytree.CallNode;
import com.google.template.soy.soytree.CallParamContentNode;
import com.google.template.soy.soytree.CallParamNode;
import com.google.template.soy.soytree.CaseOrDefaultNode;
import com.google.template.soy.soytree.MsgFallbackGroupNode;
import com.google.template.soy.soytree.MsgHtmlTagNode;
import com.google.template.soy.soytree.MsgNode;
import com.google.template.soy.soytree.MsgPlaceholderNode;
import com.google.template.soy.soytree.MsgPluralNode;
import com.google.template.soy.soytree.MsgSelectNode;
import com.google.template.soy.soytree.RawTextNode;
import com.google.template.soy.soytree.SoyNode;
import java.util.ArrayList;
import java.util.Deque;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class GenJsCodeVisitorAssistantForMsgs
extends AbstractSoyNodeVisitor<Void> {
    private static final Pattern UNDERSCORE_NUMBER_SUFFIX = Pattern.compile("_[0-9]+$");
    private final SoyJsSrcOptions jsSrcOptions;
    protected final GenJsCodeVisitor master;
    private final JsExprTranslator jsExprTranslator;
    private final GenCallCodeUtils genCallCodeUtils;
    private final IsComputableAsJsExprsVisitor isComputableAsJsExprsVisitor;
    private final GenJsExprsVisitor genJsExprsVisitor;
    protected final CodeBuilder<JsExpr> jsCodeBuilder;
    private final Deque<Map<String, JsExpr>> localVarTranslations;
    private final TemplateAliases templateAliases;
    private final ErrorReporter errorReporter;

    protected GenJsCodeVisitorAssistantForMsgs(GenJsCodeVisitor master, SoyJsSrcOptions jsSrcOptions, JsExprTranslator jsExprTranslator, GenCallCodeUtils genCallCodeUtils, IsComputableAsJsExprsVisitor isComputableAsJsExprsVisitor, CodeBuilder<JsExpr> jsCodeBuilder, Deque<Map<String, JsExpr>> localVarTranslations, TemplateAliases functionAliases, GenJsExprsVisitor genJsExprsVisitor, ErrorReporter errorReporter) {
        this.master = master;
        this.jsSrcOptions = jsSrcOptions;
        this.jsExprTranslator = jsExprTranslator;
        this.genCallCodeUtils = genCallCodeUtils;
        this.isComputableAsJsExprsVisitor = isComputableAsJsExprsVisitor;
        this.jsCodeBuilder = jsCodeBuilder;
        this.localVarTranslations = localVarTranslations;
        this.templateAliases = functionAliases;
        this.genJsExprsVisitor = genJsExprsVisitor;
        this.errorReporter = errorReporter;
    }

    @Override
    public Void exec(SoyNode node) {
        throw new AssertionError();
    }

    public String generateMsgGroupVariable(MsgFallbackGroupNode node) {
        String tmpVarName = "msg_s" + node.getId();
        if (node.numChildren() == 1) {
            return this.generateSingleMsgVariable((MsgNode)node.getChild(0), tmpVarName);
        }
        this.generateMsgGroupVariable(node, tmpVarName);
        return tmpVarName;
    }

    private String generateSingleMsgVariable(MsgNode msgNode, String tmpVarName) {
        String googMsgVarName = this.buildGoogMsgVarNameHelper(msgNode);
        GoogMsgCodeGenInfo googMsgCodeGenInfo = this.genGoogGetMsgCallHelper(googMsgVarName, msgNode);
        if (!msgNode.isPlrselMsg()) {
            return googMsgVarName;
        }
        this.jsCodeBuilder.appendLineStart("var ", tmpVarName, " = ");
        this.appendMessageFormatCall(googMsgCodeGenInfo);
        this.jsCodeBuilder.appendLineEnd(";");
        return tmpVarName;
    }

    private void generateMsgGroupVariable(MsgFallbackGroupNode node, String tmpVarName) {
        ArrayList childGoogMsgCodeGenInfos = Lists.newArrayListWithCapacity((int)node.numChildren());
        for (MsgNode msgNode : node.getChildren()) {
            String googMsgVarName = this.buildGoogMsgVarNameHelper(msgNode);
            childGoogMsgCodeGenInfos.add(this.genGoogGetMsgCallHelper(googMsgVarName, msgNode));
        }
        this.jsCodeBuilder.appendLineStart("var ", tmpVarName, " = goog.getMsgWithFallback(");
        boolean isFirst = true;
        for (GoogMsgCodeGenInfo childGoogMsgCodeGenInfo : childGoogMsgCodeGenInfos) {
            if (isFirst) {
                isFirst = false;
            } else {
                this.jsCodeBuilder.append(", ");
            }
            this.jsCodeBuilder.append(childGoogMsgCodeGenInfo.googMsgVarName);
        }
        this.jsCodeBuilder.appendLineEnd(");");
        for (GoogMsgCodeGenInfo childGoogMsgCodeGenInfo : childGoogMsgCodeGenInfos) {
            if (!childGoogMsgCodeGenInfo.isPlrselMsg) continue;
            this.jsCodeBuilder.appendLine("if (", tmpVarName, " == ", childGoogMsgCodeGenInfo.googMsgVarName, ") {");
            this.jsCodeBuilder.increaseIndent();
            this.jsCodeBuilder.appendLineStart(tmpVarName, " = ");
            this.appendMessageFormatCall(childGoogMsgCodeGenInfo);
            this.jsCodeBuilder.appendLineEnd(";");
            this.jsCodeBuilder.decreaseIndent();
            this.jsCodeBuilder.appendLine("}");
        }
    }

    private String buildGoogMsgVarNameHelper(MsgNode msgNode) {
        return this.jsSrcOptions.googMsgsAreExternal() ? "MSG_EXTERNAL_" + MsgUtils.computeMsgIdForDualFormat(msgNode) : "MSG_UNNAMED_" + msgNode.getId();
    }

    private GoogMsgCodeGenInfo genGoogGetMsgCallHelper(String googMsgVarName, MsgNode msgNode) {
        ImmutableList<SoyMsgPart> msgParts = MsgUtils.buildMsgParts(msgNode);
        String googMsgContentStr = GenJsCodeVisitorAssistantForMsgs.buildGoogMsgContentStr(msgParts, msgNode.isPlrselMsg());
        String googMsgContentStrCode = BaseUtils.escapeToSoyString(googMsgContentStr, true);
        GoogMsgCodeGenInfo googMsgCodeGenInfo = new GoogMsgCodeGenInfo(googMsgVarName, msgNode.isPlrselMsg());
        this.genGoogMsgCodeBitsForChildren(msgNode, msgNode, googMsgCodeGenInfo);
        this.jsCodeBuilder.appendLineStart("/** ");
        if (msgNode.getMeaning() != null) {
            this.jsCodeBuilder.appendLineEnd("@meaning ", msgNode.getMeaning());
            this.jsCodeBuilder.appendLineStart(" *  ");
        }
        this.jsCodeBuilder.append("@desc ", msgNode.getDesc());
        if (msgNode.isHidden()) {
            this.jsCodeBuilder.appendLineEnd(new String[0]);
            this.jsCodeBuilder.appendLineStart(" *  @hidden");
        }
        this.jsCodeBuilder.appendLineEnd(" */");
        this.jsCodeBuilder.appendLineStart("var ", googMsgCodeGenInfo.googMsgVarName, " = goog.getMsg(");
        if (msgNode.isPlrselMsg()) {
            this.jsCodeBuilder.appendLineEnd(googMsgContentStrCode, ");");
        } else if (googMsgCodeGenInfo.placeholderCodeBits.isEmpty()) {
            this.jsCodeBuilder.appendLineEnd(googMsgContentStrCode, ");");
        } else {
            this.jsCodeBuilder.appendLineEnd(new String[0]);
            this.jsCodeBuilder.appendLine("    ", googMsgContentStrCode, ",");
            this.appendObjectLiteral(googMsgCodeGenInfo.placeholderCodeBits);
            this.jsCodeBuilder.appendLineEnd(");");
        }
        return googMsgCodeGenInfo;
    }

    private static String buildGoogMsgContentStr(ImmutableList<SoyMsgPart> msgParts, boolean doUseBracedPhs) {
        msgParts = IcuSyntaxUtils.convertMsgPartsToEmbeddedIcuSyntax(msgParts, false);
        StringBuilder msgStrSb = new StringBuilder();
        for (SoyMsgPart msgPart : msgParts) {
            if (msgPart instanceof SoyMsgRawTextPart) {
                msgStrSb.append(((SoyMsgRawTextPart)msgPart).getRawText());
                continue;
            }
            if (msgPart instanceof SoyMsgPlaceholderPart) {
                String placeholderName = ((SoyMsgPlaceholderPart)msgPart).getPlaceholderName();
                if (doUseBracedPhs) {
                    msgStrSb.append("{").append(placeholderName).append("}");
                    continue;
                }
                String googMsgPlaceholderName = GenJsCodeVisitorAssistantForMsgs.genGoogMsgPlaceholderName(placeholderName);
                msgStrSb.append("{$").append(googMsgPlaceholderName).append("}");
                continue;
            }
            throw new AssertionError();
        }
        return msgStrSb.toString();
    }

    private void appendMessageFormatCall(GoogMsgCodeGenInfo googMsgCodeGenInfo) {
        List<String> codeBitsForMfCall = googMsgCodeGenInfo.plrselVarCodeBits;
        codeBitsForMfCall.addAll(googMsgCodeGenInfo.placeholderCodeBits);
        this.jsCodeBuilder.appendLineEnd("(new goog.i18n.MessageFormat(", googMsgCodeGenInfo.googMsgVarName, ")).formatIgnoringPound(");
        this.appendObjectLiteral(codeBitsForMfCall);
        this.jsCodeBuilder.append(")");
    }

    private void appendObjectLiteral(List<String> properties) {
        boolean isFirst = true;
        for (String property : properties) {
            if (isFirst) {
                this.jsCodeBuilder.appendLineStart("    {");
                isFirst = false;
            } else {
                this.jsCodeBuilder.appendLineEnd(",");
                this.jsCodeBuilder.appendLineStart("     ");
            }
            this.jsCodeBuilder.append(property);
        }
        this.jsCodeBuilder.append("}");
    }

    private void genGoogMsgCodeBitsForChildren(SoyNode.BlockNode parentNode, MsgNode msgNode, GoogMsgCodeGenInfo googMsgCodeGenInfo) {
        for (SoyNode.StandaloneNode child : parentNode.getChildren()) {
            if (child instanceof RawTextNode) continue;
            if (child instanceof MsgPlaceholderNode) {
                this.genGoogMsgCodeBitsForPlaceholder((MsgPlaceholderNode)child, msgNode, googMsgCodeGenInfo);
                continue;
            }
            if (child instanceof MsgPluralNode) {
                this.genGoogMsgCodeBitsForPluralNode((MsgPluralNode)child, msgNode, googMsgCodeGenInfo);
                continue;
            }
            if (child instanceof MsgSelectNode) {
                this.genGoogMsgCodeBitsForSelectNode((MsgSelectNode)child, msgNode, googMsgCodeGenInfo);
                continue;
            }
            String nodeStringForErrorMsg = child instanceof SoyNode.CommandNode ? "Tag " + ((SoyNode.CommandNode)((Object)child)).getTagString() : "Node " + child;
            throw new AssertionError((Object)(nodeStringForErrorMsg + " is not allowed to be a direct child of a 'msg' tag. At :" + child.getSourceLocation()));
        }
    }

    private void genGoogMsgCodeBitsForPluralNode(MsgPluralNode pluralNode, MsgNode msgNode, GoogMsgCodeGenInfo googMsgCodeGenInfo) {
        GenJsCodeVisitorAssistantForMsgs.updatePlrselVarCodeBits(googMsgCodeGenInfo, msgNode.getPluralVarName(pluralNode), this.jsExprTranslator.translateToJsExpr(pluralNode.getExpr(), this.localVarTranslations, this.errorReporter).getText());
        for (CaseOrDefaultNode child : pluralNode.getChildren()) {
            this.genGoogMsgCodeBitsForChildren(child, msgNode, googMsgCodeGenInfo);
        }
    }

    private void genGoogMsgCodeBitsForSelectNode(MsgSelectNode selectNode, MsgNode msgNode, GoogMsgCodeGenInfo googMsgCodeGenInfo) {
        GenJsCodeVisitorAssistantForMsgs.updatePlrselVarCodeBits(googMsgCodeGenInfo, msgNode.getSelectVarName(selectNode), this.jsExprTranslator.translateToJsExpr(selectNode.getExpr(), this.localVarTranslations, this.errorReporter).getText());
        for (CaseOrDefaultNode child : selectNode.getChildren()) {
            this.genGoogMsgCodeBitsForChildren(child, msgNode, googMsgCodeGenInfo);
        }
    }

    private static void updatePlrselVarCodeBits(GoogMsgCodeGenInfo googMsgCodeGenInfo, String plrselVarName, String exprText) {
        if (googMsgCodeGenInfo.seenPlrselVarNames.contains(plrselVarName)) {
            return;
        }
        googMsgCodeGenInfo.seenPlrselVarNames.add(plrselVarName);
        String placeholderCodeBit = "'" + plrselVarName + "': " + exprText;
        googMsgCodeGenInfo.plrselVarCodeBits.add(placeholderCodeBit);
    }

    private void genGoogMsgCodeBitsForPlaceholder(MsgPlaceholderNode node, MsgNode msgNode, GoogMsgCodeGenInfo googMsgCodeGenInfo) {
        String placeholderName = msgNode.getPlaceholderName(node);
        if (googMsgCodeGenInfo.seenPlaceholderNames.contains(placeholderName)) {
            return;
        }
        googMsgCodeGenInfo.seenPlaceholderNames.add(placeholderName);
        String googMsgPlaceholderName = googMsgCodeGenInfo.isPlrselMsg ? placeholderName : GenJsCodeVisitorAssistantForMsgs.genGoogMsgPlaceholderName(placeholderName);
        String placeholderCodeBit = "'" + googMsgPlaceholderName + "': " + this.genGoogMsgPlaceholderExpr(node).getText();
        googMsgCodeGenInfo.placeholderCodeBits.add(placeholderCodeBit);
    }

    private static String genGoogMsgPlaceholderName(String placeholderName) {
        Matcher suffixMatcher = UNDERSCORE_NUMBER_SUFFIX.matcher(placeholderName);
        if (suffixMatcher.find()) {
            String base = placeholderName.substring(0, suffixMatcher.start());
            String suffix = suffixMatcher.group();
            return CaseFormat.UPPER_UNDERSCORE.to(CaseFormat.LOWER_CAMEL, base) + suffix;
        }
        return CaseFormat.UPPER_UNDERSCORE.to(CaseFormat.LOWER_CAMEL, placeholderName);
    }

    protected JsExpr genGoogMsgPlaceholderExpr(MsgPlaceholderNode msgPhNode) {
        ArrayList contentJsExprs = Lists.newArrayList();
        for (SoyNode.StandaloneNode contentNode : msgPhNode.getChildren()) {
            if (contentNode instanceof MsgHtmlTagNode && !((Boolean)this.isComputableAsJsExprsVisitor.exec(contentNode)).booleanValue()) {
                this.visit(contentNode);
                contentJsExprs.add(new JsExpr("htmlTag" + contentNode.getId(), Integer.MAX_VALUE));
                continue;
            }
            if (contentNode instanceof CallNode) {
                CallNode callNode = (CallNode)contentNode;
                for (CallParamNode grandchild : callNode.getChildren()) {
                    if (!(grandchild instanceof CallParamContentNode) || ((Boolean)this.isComputableAsJsExprsVisitor.exec(grandchild)).booleanValue()) continue;
                    this.visit(grandchild);
                }
                contentJsExprs.add(this.genCallCodeUtils.genCallExpr(callNode, this.localVarTranslations, this.templateAliases, this.errorReporter));
                continue;
            }
            contentJsExprs.addAll(this.genJsExprsVisitor.exec(contentNode));
        }
        return JsExprUtils.concatJsExprs(contentJsExprs);
    }

    @Override
    protected void visitMsgHtmlTagNode(MsgHtmlTagNode node) {
        if (((Boolean)this.isComputableAsJsExprsVisitor.exec(node)).booleanValue()) {
            throw new AssertionError((Object)"Should only define 'htmlTag<n>' when not computable as JS expressions.");
        }
        this.jsCodeBuilder.pushOutputVar("htmlTag" + node.getId());
        this.visitChildren(node);
        this.jsCodeBuilder.popOutputVar();
    }

    @Override
    protected void visitSoyNode(SoyNode node) {
        this.master.visitForUseByAssistants(node);
    }

    private static class GoogMsgCodeGenInfo {
        final String googMsgVarName;
        final boolean isPlrselMsg;
        final List<String> placeholderCodeBits;
        final Set<String> seenPlaceholderNames;
        final List<String> plrselVarCodeBits;
        final Set<String> seenPlrselVarNames;

        public GoogMsgCodeGenInfo(String googMsgVarName, boolean isPlrselMsg) {
            this.googMsgVarName = googMsgVarName;
            this.isPlrselMsg = isPlrselMsg;
            this.placeholderCodeBits = Lists.newArrayList();
            this.seenPlaceholderNames = Sets.newHashSet();
            this.plrselVarCodeBits = Lists.newArrayList();
            this.seenPlrselVarNames = Sets.newHashSet();
        }
    }
}

