/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.jbcsrc;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.template.soy.data.SanitizedContent;
import com.google.template.soy.data.SoyRecord;
import com.google.template.soy.data.restricted.IntegerData;
import com.google.template.soy.exprtree.ExprNode;
import com.google.template.soy.exprtree.ExprRootNode;
import com.google.template.soy.jbcsrc.AppendableExpression;
import com.google.template.soy.jbcsrc.AutoValue_SoyNodeCompiler_CompiledMethodBody;
import com.google.template.soy.jbcsrc.AutoValue_SoyNodeCompiler_CompiledRangeArgs;
import com.google.template.soy.jbcsrc.BytecodeUtils;
import com.google.template.soy.jbcsrc.CodeBuilder;
import com.google.template.soy.jbcsrc.CompiledTemplateMetadata;
import com.google.template.soy.jbcsrc.CompiledTemplateRegistry;
import com.google.template.soy.jbcsrc.ConstructorRef;
import com.google.template.soy.jbcsrc.ControlFlow;
import com.google.template.soy.jbcsrc.DetachState;
import com.google.template.soy.jbcsrc.Expression;
import com.google.template.soy.jbcsrc.ExpressionCompiler;
import com.google.template.soy.jbcsrc.ExpressionToSoyValueProviderCompiler;
import com.google.template.soy.jbcsrc.FieldRef;
import com.google.template.soy.jbcsrc.InnerClasses;
import com.google.template.soy.jbcsrc.LazyClosureCompiler;
import com.google.template.soy.jbcsrc.MethodRef;
import com.google.template.soy.jbcsrc.MsgCompiler;
import com.google.template.soy.jbcsrc.SoyExpression;
import com.google.template.soy.jbcsrc.Statement;
import com.google.template.soy.jbcsrc.SyntheticVarName;
import com.google.template.soy.jbcsrc.TemplateParameterLookup;
import com.google.template.soy.jbcsrc.TemplateVariableManager;
import com.google.template.soy.jbcsrc.UnexpectedCompilerFailureException;
import com.google.template.soy.msgs.internal.MsgUtils;
import com.google.template.soy.soytree.AbstractReturningSoyNodeVisitor;
import com.google.template.soy.soytree.CallBasicNode;
import com.google.template.soy.soytree.CallDelegateNode;
import com.google.template.soy.soytree.CallNode;
import com.google.template.soy.soytree.CallParamContentNode;
import com.google.template.soy.soytree.CallParamNode;
import com.google.template.soy.soytree.CallParamValueNode;
import com.google.template.soy.soytree.CssNode;
import com.google.template.soy.soytree.DebuggerNode;
import com.google.template.soy.soytree.ForNode;
import com.google.template.soy.soytree.ForeachIfemptyNode;
import com.google.template.soy.soytree.ForeachNode;
import com.google.template.soy.soytree.ForeachNonemptyNode;
import com.google.template.soy.soytree.IfCondNode;
import com.google.template.soy.soytree.IfElseNode;
import com.google.template.soy.soytree.IfNode;
import com.google.template.soy.soytree.LetContentNode;
import com.google.template.soy.soytree.LetValueNode;
import com.google.template.soy.soytree.LogNode;
import com.google.template.soy.soytree.MsgFallbackGroupNode;
import com.google.template.soy.soytree.MsgHtmlTagNode;
import com.google.template.soy.soytree.MsgNode;
import com.google.template.soy.soytree.PrintDirectiveNode;
import com.google.template.soy.soytree.PrintNode;
import com.google.template.soy.soytree.RawTextNode;
import com.google.template.soy.soytree.SoyNode;
import com.google.template.soy.soytree.SwitchCaseNode;
import com.google.template.soy.soytree.SwitchDefaultNode;
import com.google.template.soy.soytree.SwitchNode;
import com.google.template.soy.soytree.TemplateNode;
import com.google.template.soy.soytree.XidNode;
import java.util.ArrayList;
import java.util.List;
import org.objectweb.asm.Label;
import org.objectweb.asm.Type;

final class SoyNodeCompiler
extends AbstractReturningSoyNodeVisitor<Statement> {
    private final Expression thisVar;
    private final CompiledTemplateRegistry registry;
    private final DetachState detachState;
    private final TemplateVariableManager variables;
    private final TemplateParameterLookup parameterLookup;
    private final AppendableExpression appendableExpression;
    private final ExpressionCompiler exprCompiler;
    private final ExpressionToSoyValueProviderCompiler expressionToSoyValueProviderCompiler;
    private final LazyClosureCompiler lazyClosureCompiler;
    private TemplateVariableManager.Scope currentScope;

    static SoyNodeCompiler create(CompiledTemplateRegistry registry, InnerClasses innerClasses, FieldRef stateField, Expression thisVar, AppendableExpression appendableVar, TemplateVariableManager variables, TemplateParameterLookup parameterLookup) {
        DetachState detachState = new DetachState(variables, thisVar, stateField);
        ExpressionCompiler expressionCompiler = ExpressionCompiler.create(detachState, parameterLookup, variables);
        ExpressionToSoyValueProviderCompiler soyValueProviderCompiler = ExpressionToSoyValueProviderCompiler.create(expressionCompiler, parameterLookup);
        return new SoyNodeCompiler(thisVar, registry, detachState, variables, parameterLookup, appendableVar, expressionCompiler, soyValueProviderCompiler, new LazyClosureCompiler(registry, innerClasses, parameterLookup, variables, soyValueProviderCompiler));
    }

    SoyNodeCompiler(Expression thisVar, CompiledTemplateRegistry registry, DetachState detachState, TemplateVariableManager variables, TemplateParameterLookup parameterLookup, AppendableExpression appendableExpression, ExpressionCompiler exprCompiler, ExpressionToSoyValueProviderCompiler expressionToSoyValueProviderCompiler, LazyClosureCompiler lazyClosureCompiler) {
        this.thisVar = (Expression)Preconditions.checkNotNull((Object)thisVar);
        this.registry = (CompiledTemplateRegistry)Preconditions.checkNotNull((Object)registry);
        this.detachState = (DetachState)Preconditions.checkNotNull((Object)detachState);
        this.variables = (TemplateVariableManager)Preconditions.checkNotNull((Object)variables);
        this.parameterLookup = (TemplateParameterLookup)Preconditions.checkNotNull((Object)parameterLookup);
        this.appendableExpression = (AppendableExpression)Preconditions.checkNotNull((Object)appendableExpression);
        this.exprCompiler = (ExpressionCompiler)Preconditions.checkNotNull((Object)exprCompiler);
        this.expressionToSoyValueProviderCompiler = (ExpressionToSoyValueProviderCompiler)Preconditions.checkNotNull((Object)expressionToSoyValueProviderCompiler);
        this.lazyClosureCompiler = (LazyClosureCompiler)Preconditions.checkNotNull((Object)lazyClosureCompiler);
    }

    CompiledMethodBody compile(TemplateNode node) {
        Statement templateBody = this.visit(node);
        return this.getCompiledBody(templateBody);
    }

    CompiledMethodBody compileChildren(SoyNode.RenderUnitNode node) {
        Statement templateBody = this.visitChildrenInNewScope(node);
        return this.getCompiledBody(templateBody);
    }

    private CompiledMethodBody getCompiledBody(Statement templateBody) {
        Statement jumpTable = this.detachState.generateReattachTable();
        return CompiledMethodBody.create(Statement.concat(jumpTable, templateBody), this.detachState.getNumberOfDetaches());
    }

    @Override
    protected Statement visit(SoyNode node) {
        try {
            return (Statement)super.visit(node);
        }
        catch (UnexpectedCompilerFailureException e) {
            e.addLocation(node.getSourceLocation());
            throw e;
        }
        catch (Throwable t) {
            throw new UnexpectedCompilerFailureException(node.getSourceLocation(), t);
        }
    }

    @Override
    protected Statement visitTemplateNode(TemplateNode node) {
        return this.visitChildrenInNewScope(node);
    }

    private Statement visitChildrenInNewScope(SoyNode.BlockNode node) {
        TemplateVariableManager.Scope prev = this.currentScope;
        this.currentScope = this.variables.enterScope();
        List children = this.visitChildren(node);
        Statement leave = this.currentScope.exitScope();
        children.add(leave);
        this.currentScope = prev;
        return Statement.concat(children).withSourceLocation(node.getSourceLocation());
    }

    @Override
    protected Statement visitIfNode(IfNode node) {
        ArrayList<ControlFlow.IfBlock> ifs = new ArrayList<ControlFlow.IfBlock>();
        Optional elseBlock = Optional.absent();
        for (SoyNode child : node.getChildren()) {
            if (child instanceof IfCondNode) {
                IfCondNode icn = (IfCondNode)child;
                SoyExpression cond = this.exprCompiler.compile(icn.getExprUnion().getExpr()).coerceToBoolean();
                Statement block = this.visitChildrenInNewScope(icn);
                ifs.add(ControlFlow.IfBlock.create(cond, block));
                continue;
            }
            IfElseNode ien = (IfElseNode)child;
            elseBlock = Optional.of((Object)this.visitChildrenInNewScope(ien));
        }
        return ControlFlow.ifElseChain(ifs, (Optional<Statement>)elseBlock).withSourceLocation(node.getSourceLocation());
    }

    @Override
    protected Statement visitSwitchNode(SwitchNode node) {
        List children = node.getChildren();
        if (children.isEmpty()) {
            return Statement.NULL_STATEMENT;
        }
        if (children.size() == 1 && children.get(0) instanceof SwitchDefaultNode) {
            return this.visitChildrenInNewScope((SwitchDefaultNode)children.get(0));
        }
        SoyExpression expression = this.exprCompiler.compile(node.getExpr());
        ArrayList<ControlFlow.IfBlock> cases = new ArrayList<ControlFlow.IfBlock>();
        Optional defaultBlock = Optional.absent();
        TemplateVariableManager.Scope scope = this.variables.enterScope();
        TemplateVariableManager.Variable variable = scope.createSynthetic(SyntheticVarName.forSwitch(node), expression, TemplateVariableManager.SaveStrategy.STORE);
        Statement init = variable.initializer();
        expression = expression.withSource(variable.local());
        for (SoyNode child : children) {
            if (child instanceof SwitchCaseNode) {
                SwitchCaseNode caseNode = (SwitchCaseNode)child;
                Label reattachPoint = new Label();
                ArrayList<Expression> comparisons = new ArrayList<Expression>();
                for (ExprRootNode caseExpr : caseNode.getExprList()) {
                    comparisons.add(BytecodeUtils.compareSoyEquals(expression, this.exprCompiler.compile(caseExpr, reattachPoint)));
                }
                Expression condition = BytecodeUtils.logicalOr(comparisons).labelStart(reattachPoint);
                Statement block = this.visitChildrenInNewScope(caseNode);
                cases.add(ControlFlow.IfBlock.create(condition, block));
                continue;
            }
            SwitchDefaultNode defaultNode = (SwitchDefaultNode)child;
            defaultBlock = Optional.of((Object)this.visitChildrenInNewScope(defaultNode));
        }
        Statement exitScope = scope.exitScope();
        return Statement.concat(init, ControlFlow.ifElseChain(cases, (Optional<Statement>)defaultBlock), exitScope).withSourceLocation(node.getSourceLocation());
    }

    @Override
    protected Statement visitForNode(ForNode node) {
        TemplateVariableManager.Scope scope = this.variables.enterScope();
        final CompiledRangeArgs rangeArgs = this.calculateRangeArgs(node, scope);
        final Statement loopBody = this.visitChildrenInNewScope(node);
        final Statement exitScope = scope.exitScope();
        return new Statement(node.getSourceLocation()){

            @Override
            void doGen(CodeBuilder adapter) {
                for (Statement initializer : rangeArgs.initStatements()) {
                    initializer.gen(adapter);
                }
                Label loopStart = adapter.mark();
                rangeArgs.currentIndex().gen(adapter);
                rangeArgs.limit().gen(adapter);
                Label end = new Label();
                adapter.ifCmp(Type.INT_TYPE, 156, end);
                loopBody.gen(adapter);
                rangeArgs.increment().gen(adapter);
                adapter.goTo(loopStart);
                adapter.mark(end);
                exitScope.gen(adapter);
            }
        };
    }

    private CompiledRangeArgs calculateRangeArgs(ForNode forNode, TemplateVariableManager.Scope scope) {
        Statement incrementCurrentIndex;
        Label detachPoint;
        TemplateVariableManager.Variable currentIndex;
        ForNode.RangeArgs rangeArgs = forNode.getRangeArgs();
        ImmutableList.Builder initStatements = ImmutableList.builder();
        if (rangeArgs.start().isPresent()) {
            Label startDetachPoint = new Label();
            Expression startIndex = MethodRef.INTS_CHECKED_CAST.invoke(this.exprCompiler.compile((ExprNode)rangeArgs.start().get(), startDetachPoint).unboxAs(Long.TYPE));
            currentIndex = scope.create(forNode.getVarName(), startIndex, TemplateVariableManager.SaveStrategy.STORE);
            initStatements.add((Object)currentIndex.initializer().labelStart(startDetachPoint));
        } else {
            currentIndex = scope.create(forNode.getVarName(), BytecodeUtils.constant(0), TemplateVariableManager.SaveStrategy.STORE);
            initStatements.add((Object)currentIndex.initializer());
        }
        if (rangeArgs.increment().isPresent()) {
            detachPoint = new Label();
            Expression increment = MethodRef.INTS_CHECKED_CAST.invoke(this.exprCompiler.compile((ExprNode)rangeArgs.increment().get(), detachPoint).unboxAs(Long.TYPE));
            final TemplateVariableManager.Variable incrementVariable = scope.createSynthetic(SyntheticVarName.forLoopIncrement(forNode), increment, increment.isCheap() ? TemplateVariableManager.SaveStrategy.DERIVED : TemplateVariableManager.SaveStrategy.STORE);
            initStatements.add((Object)incrementVariable.initializer().labelStart(detachPoint));
            incrementVariable.local();
            incrementCurrentIndex = new Statement(){

                @Override
                void doGen(CodeBuilder adapter) {
                    currentIndex.local().gen(adapter);
                    incrementVariable.local().gen(adapter);
                    adapter.visitInsn(96);
                    adapter.visitVarInsn(54, currentIndex.local().index());
                }
            };
        } else {
            incrementCurrentIndex = new Statement(){

                @Override
                void doGen(CodeBuilder adapter) {
                    adapter.iinc(currentIndex.local().index(), 1);
                }
            };
        }
        detachPoint = new Label();
        Expression limit = MethodRef.INTS_CHECKED_CAST.invoke(this.exprCompiler.compile(rangeArgs.limit(), detachPoint).unboxAs(Long.TYPE));
        TemplateVariableManager.Variable variable = scope.createSynthetic(SyntheticVarName.forLoopLimit(forNode), limit, limit.isCheap() ? TemplateVariableManager.SaveStrategy.DERIVED : TemplateVariableManager.SaveStrategy.STORE);
        initStatements.add((Object)variable.initializer().labelStart(detachPoint));
        limit = variable.local();
        return new AutoValue_SoyNodeCompiler_CompiledRangeArgs(currentIndex.local(), limit, incrementCurrentIndex, (ImmutableList<Statement>)initStatements.build());
    }

    @Override
    protected Statement visitForeachNode(ForeachNode node) {
        ForeachNonemptyNode nonEmptyNode = (ForeachNonemptyNode)node.getChild(0);
        SoyExpression expr = this.exprCompiler.compile(node.getExpr()).unboxAs(List.class);
        TemplateVariableManager.Scope scope = this.variables.enterScope();
        final TemplateVariableManager.Variable listVar = scope.createSynthetic(SyntheticVarName.foreachLoopList(nonEmptyNode), expr, TemplateVariableManager.SaveStrategy.STORE);
        final TemplateVariableManager.Variable indexVar = scope.createSynthetic(SyntheticVarName.foreachLoopIndex(nonEmptyNode), BytecodeUtils.constant(0), TemplateVariableManager.SaveStrategy.STORE);
        final TemplateVariableManager.Variable listSizeVar = scope.createSynthetic(SyntheticVarName.foreachLoopLength(nonEmptyNode), MethodRef.LIST_SIZE.invoke(listVar.local()), TemplateVariableManager.SaveStrategy.DERIVED);
        final TemplateVariableManager.Variable itemVar = scope.create(nonEmptyNode.getVarName(), MethodRef.LIST_GET.invoke(listVar.local(), indexVar.local()).cast(BytecodeUtils.SOY_VALUE_PROVIDER_TYPE), TemplateVariableManager.SaveStrategy.DERIVED);
        final Statement loopBody = this.visitChildrenInNewScope(nonEmptyNode);
        final Statement exitScope = scope.exitScope();
        final Statement emptyBlock = node.numChildren() == 2 ? this.visitChildrenInNewScope((ForeachIfemptyNode)node.getChild(1)) : null;
        return new Statement(){

            @Override
            void doGen(CodeBuilder adapter) {
                listVar.initializer().gen(adapter);
                listSizeVar.initializer().gen(adapter);
                listSizeVar.local().gen(adapter);
                Label emptyListLabel = new Label();
                adapter.ifZCmp(153, emptyListLabel);
                indexVar.initializer().gen(adapter);
                Label loopStart = adapter.mark();
                itemVar.initializer().gen(adapter);
                loopBody.gen(adapter);
                adapter.iinc(indexVar.local().index(), 1);
                indexVar.local().gen(adapter);
                listSizeVar.local().gen(adapter);
                adapter.ifICmp(155, loopStart);
                exitScope.gen(adapter);
                if (emptyBlock != null) {
                    Label skipIfEmptyBlock = new Label();
                    adapter.goTo(skipIfEmptyBlock);
                    adapter.mark(emptyListLabel);
                    emptyBlock.gen(adapter);
                    adapter.mark(skipIfEmptyBlock);
                } else {
                    adapter.mark(emptyListLabel);
                }
            }
        };
    }

    @Override
    protected Statement visitPrintNode(PrintNode node) {
        Label reattachPoint;
        if (node.getChildren().isEmpty()) {
            reattachPoint = new Label();
            ExprRootNode expr = node.getExprUnion().getExpr();
            Optional<Expression> asSoyValueProvider = this.expressionToSoyValueProviderCompiler.compileAvoidingBoxing(expr, reattachPoint);
            if (asSoyValueProvider.isPresent()) {
                return this.renderIncrementally(node, (Expression)asSoyValueProvider.get(), reattachPoint);
            }
        }
        reattachPoint = new Label();
        SoyExpression value = this.compilePrintNodeAsExpression(node, reattachPoint);
        AppendableExpression renderSoyValue = this.appendableExpression.appendString(value.coerceToString()).labelStart(reattachPoint);
        return this.detachState.detachLimited(renderSoyValue).withSourceLocation(node.getSourceLocation());
    }

    private SoyExpression compilePrintNodeAsExpression(PrintNode node, Label reattachPoint) {
        ExpressionCompiler.BasicExpressionCompiler basic = this.exprCompiler.asBasicCompiler(reattachPoint);
        SoyExpression value = basic.compile(node.getExprUnion().getExpr());
        for (PrintDirectiveNode printDirective : node.getChildren()) {
            value = value.applyPrintDirective(this.parameterLookup.getRenderContext(), printDirective.getName(), basic.compileToList(printDirective.getArgs()));
        }
        return value;
    }

    private Statement renderIncrementally(PrintNode node, Expression soyValueProvider, Label reattachPoint) {
        FieldRef currentRendereeField = this.variables.getCurrentRenderee();
        Statement initRenderee = currentRendereeField.putInstanceField(this.thisVar, soyValueProvider).labelStart(reattachPoint);
        Expression callRenderAndResolve = currentRendereeField.accessor(this.thisVar).invoke(MethodRef.SOY_VALUE_PROVIDER_RENDER_AND_RESOLVE, this.appendableExpression, BytecodeUtils.constant(false));
        Statement doCall = this.detachState.detachForRender(callRenderAndResolve);
        Statement clearRenderee = currentRendereeField.putInstanceField(this.thisVar, BytecodeUtils.constantNull(BytecodeUtils.SOY_VALUE_PROVIDER_TYPE));
        return Statement.concat(initRenderee, doCall, clearRenderee).withSourceLocation(node.getSourceLocation());
    }

    @Override
    protected Statement visitRawTextNode(RawTextNode node) {
        AppendableExpression render = this.appendableExpression.appendString(BytecodeUtils.constant(node.getRawText(), this.variables));
        return this.detachState.detachLimited(render).withSourceLocation(node.getSourceLocation());
    }

    @Override
    protected Statement visitDebuggerNode(DebuggerNode node) {
        return Statement.NULL_STATEMENT.withSourceLocation(node.getSourceLocation());
    }

    @Override
    protected Statement visitXidNode(XidNode node) {
        return this.appendableExpression.appendString(this.parameterLookup.getRenderContext().invoke(MethodRef.RENDER_CONTEXT_RENAME_XID, BytecodeUtils.constant(node.getText()))).toStatement().withSourceLocation(node.getSourceLocation());
    }

    @Override
    protected Statement visitCssNode(CssNode node) {
        Expression renamedSelector = this.parameterLookup.getRenderContext().invoke(MethodRef.RENDER_CONTEXT_RENAME_CSS_SELECTOR, BytecodeUtils.constant(node.getSelectorText()));
        if (node.getComponentNameExpr() != null) {
            Label reattachPoint = new Label();
            SoyExpression compiledComponent = this.exprCompiler.compile(node.getComponentNameExpr(), reattachPoint).coerceToString();
            return this.appendableExpression.appendString(compiledComponent).appendChar(BytecodeUtils.constant('-')).appendString(renamedSelector).labelStart(reattachPoint).toStatement().withSourceLocation(node.getSourceLocation());
        }
        return this.appendableExpression.appendString(renamedSelector).toStatement().withSourceLocation(node.getSourceLocation());
    }

    @Override
    protected Statement visitMsgFallbackGroupNode(MsgFallbackGroupNode node) {
        MsgNode msg = node.getMsg();
        MsgUtils.MsgPartsAndIds idAndParts = MsgUtils.buildMsgPartsAndComputeMsgIdForDualFormat(msg);
        ImmutableList<String> escapingDirectives = node.getEscapingDirectiveNames();
        Statement renderDefault = this.getMsgCompiler().compileMessage(idAndParts, msg, (List<String>)escapingDirectives);
        if (node.hasFallbackMsg()) {
            MsgNode fallback = node.getFallbackMsg();
            MsgUtils.MsgPartsAndIds fallbackIdAndParts = MsgUtils.buildMsgPartsAndComputeMsgIdForDualFormat(fallback);
            ControlFlow.IfBlock ifAvailableRenderDefault = ControlFlow.IfBlock.create(this.parameterLookup.getRenderContext().invoke(MethodRef.RENDER_CONTEXT_USE_PRIMARY_MSG, BytecodeUtils.constant(idAndParts.id), BytecodeUtils.constant(fallbackIdAndParts.id)), renderDefault);
            return ControlFlow.ifElseChain((List<ControlFlow.IfBlock>)ImmutableList.of((Object)ifAvailableRenderDefault), (Optional<Statement>)Optional.of((Object)this.getMsgCompiler().compileMessage(fallbackIdAndParts, fallback, (List<String>)escapingDirectives)));
        }
        return renderDefault;
    }

    @Override
    protected Statement visitCallDelegateNode(CallDelegateNode node) {
        Label reattachPoint = new Label();
        Expression variantExpr = node.getDelCalleeVariantExpr() == null ? BytecodeUtils.constant("") : this.exprCompiler.compile(node.getDelCalleeVariantExpr(), reattachPoint).coerceToString();
        Expression calleeExpression = this.parameterLookup.getRenderContext().invoke(MethodRef.RENDER_CONTEXT_GET_DELTEMPLATE, BytecodeUtils.constant(node.getDelCalleeName()), variantExpr, BytecodeUtils.constant(node.allowsEmptyDefault()), this.prepareParamsHelper(node, reattachPoint), this.parameterLookup.getIjRecord());
        if (!node.getEscapingDirectiveNames().isEmpty()) {
            Expression directives = this.getEscapingDirectivesList(node);
            if (this.registry.hasDelTemplateDefinition(node.getDelCalleeName())) {
                SanitizedContent.ContentKind kind = this.registry.getDelTemplateContentKind(node.getDelCalleeName());
                calleeExpression = MethodRef.RUNTIME_APPLY_ESCAPERS.invoke(calleeExpression, BytecodeUtils.constant(kind), directives);
            } else {
                calleeExpression = MethodRef.RUNTIME_APPLY_ESCAPERS_DYNAMIC.invoke(calleeExpression, directives);
            }
        }
        return this.visitCallNodeHelper(node, reattachPoint, calleeExpression);
    }

    @Override
    protected Statement visitCallBasicNode(CallBasicNode node) {
        CompiledTemplateMetadata callee = this.registry.getTemplateInfoByTemplateName(node.getCalleeName());
        Label reattachPoint = new Label();
        Expression calleeExpression = callee.constructor().construct(this.prepareParamsHelper(node, reattachPoint), this.parameterLookup.getIjRecord());
        if (!node.getEscapingDirectiveNames().isEmpty()) {
            calleeExpression = MethodRef.RUNTIME_APPLY_ESCAPERS.invoke(calleeExpression, BytecodeUtils.constant(callee.node().getContentKind()), this.getEscapingDirectivesList(node));
        }
        return this.visitCallNodeHelper(node, reattachPoint, calleeExpression);
    }

    private Statement visitCallNodeHelper(CallNode node, Label reattachPoint, Expression calleeExpression) {
        FieldRef currentCalleeField = this.variables.getCurrentCalleeField();
        Statement initCallee = currentCalleeField.putInstanceField(this.thisVar, calleeExpression).labelStart(reattachPoint);
        Expression callRender = currentCalleeField.accessor(this.thisVar).invoke(MethodRef.COMPILED_TEMPLATE_RENDER, this.appendableExpression, this.parameterLookup.getRenderContext());
        Statement callCallee = this.detachState.detachForRender(callRender);
        Statement clearCallee = currentCalleeField.putInstanceField(this.thisVar, BytecodeUtils.constantNull(BytecodeUtils.COMPILED_TEMPLATE_TYPE));
        return Statement.concat(initCallee, callCallee, clearCallee).withSourceLocation(node.getSourceLocation());
    }

    private Expression getEscapingDirectivesList(CallNode node) {
        ArrayList<Expression> directiveExprs = new ArrayList<Expression>(node.getEscapingDirectiveNames().size());
        for (String directive : node.getEscapingDirectiveNames()) {
            directiveExprs.add(this.parameterLookup.getRenderContext().invoke(MethodRef.RENDER_CONTEXT_GET_PRINT_DIRECTIVE, BytecodeUtils.constant(directive)));
        }
        return BytecodeUtils.asList(directiveExprs);
    }

    private Expression prepareParamsHelper(CallNode node, Label reattachPoint) {
        CallNode.DataAttribute dataAttribute = node.dataAttribute();
        if (node.numChildren() == 0) {
            return this.getDataExpression(dataAttribute, reattachPoint);
        }
        Expression paramStoreExpression = this.getParamStoreExpression(node, dataAttribute, reattachPoint);
        for (CallParamNode child : node.getChildren()) {
            String paramKey = child.getKey();
            Expression valueExpr = child instanceof CallParamContentNode ? this.lazyClosureCompiler.compileLazyContent("param", (CallParamContentNode)child, paramKey) : this.lazyClosureCompiler.compileLazyExpression("param", child, paramKey, ((CallParamValueNode)child).getValueExprUnion().getExpr());
            paramStoreExpression = MethodRef.PARAM_STORE_SET_FIELD.invoke(paramStoreExpression, BytecodeUtils.constant(paramKey), valueExpr);
        }
        return paramStoreExpression;
    }

    private Expression getParamStoreExpression(CallNode node, CallNode.DataAttribute dataAttribute, Label reattachPoint) {
        Expression paramStoreExpression = dataAttribute.isPassingData() ? ConstructorRef.AUGMENTED_PARAM_STORE.construct(this.getDataExpression(dataAttribute, reattachPoint), BytecodeUtils.constant(node.numChildren())) : ConstructorRef.BASIC_PARAM_STORE.construct(BytecodeUtils.constant(node.numChildren()));
        return paramStoreExpression;
    }

    private Expression getDataExpression(CallNode.DataAttribute dataAttribute, Label reattachPoint) {
        if (dataAttribute.isPassingData()) {
            if (dataAttribute.isPassingAllData()) {
                return this.parameterLookup.getParamsRecord();
            }
            return this.exprCompiler.compile(dataAttribute.dataExpr(), reattachPoint).box().cast(SoyRecord.class);
        }
        return FieldRef.EMPTY_DICT.accessor();
    }

    @Override
    protected Statement visitLogNode(LogNode node) {
        return this.compilerWithNewAppendable(AppendableExpression.logger()).visitChildrenInNewScope(node);
    }

    @Override
    protected Statement visitLetValueNode(LetValueNode node) {
        Expression newLetValue = this.lazyClosureCompiler.compileLazyExpression("let", node, node.getVarName(), node.getValueExpr());
        return this.currentScope.create(node.getVarName(), newLetValue, TemplateVariableManager.SaveStrategy.STORE).initializer();
    }

    @Override
    protected Statement visitLetContentNode(LetContentNode node) {
        Expression newLetValue = this.lazyClosureCompiler.compileLazyContent("let", node, node.getVarName());
        return this.currentScope.create(node.getVarName(), newLetValue, TemplateVariableManager.SaveStrategy.STORE).initializer();
    }

    @Override
    protected Statement visitMsgHtmlTagNode(MsgHtmlTagNode node) {
        return Statement.concat(this.visitChildren(node)).withSourceLocation(node.getSourceLocation());
    }

    @Override
    protected Statement visitSoyNode(SoyNode node) {
        throw new UnsupportedOperationException("The jbcsrc backend doesn't support: " + (Object)((Object)node.getKind()) + " nodes yet.");
    }

    private MsgCompiler getMsgCompiler() {
        return new MsgCompiler(this.thisVar, this.detachState, this.variables, this.parameterLookup, this.appendableExpression, new MsgCompiler.SoyNodeToStringCompiler(){

            @Override
            public Statement compileToBuffer(MsgHtmlTagNode htmlTagNode, AppendableExpression appendable) {
                return SoyNodeCompiler.this.compilerWithNewAppendable(appendable).visit(htmlTagNode);
            }

            @Override
            public Expression compileToString(PrintNode node, Label reattachPoint) {
                return SoyNodeCompiler.this.compilePrintNodeAsExpression(node, reattachPoint).coerceToString();
            }

            @Override
            public Statement compileToBuffer(CallNode call, AppendableExpression appendable) {
                return SoyNodeCompiler.this.compilerWithNewAppendable(appendable).visit(call);
            }

            @Override
            public Expression compileToString(ExprRootNode node, Label reattachPoint) {
                return SoyNodeCompiler.this.exprCompiler.compile(node, reattachPoint).coerceToString();
            }

            @Override
            public Expression compileToInt(ExprRootNode node, Label reattachPoint) {
                return SoyNodeCompiler.this.exprCompiler.compile(node, reattachPoint).box().cast(IntegerData.class);
            }
        });
    }

    private SoyNodeCompiler compilerWithNewAppendable(AppendableExpression appendable) {
        return new SoyNodeCompiler(this.thisVar, this.registry, this.detachState, this.variables, this.parameterLookup, appendable, this.exprCompiler, this.expressionToSoyValueProviderCompiler, this.lazyClosureCompiler);
    }

    static abstract class CompiledRangeArgs {
        CompiledRangeArgs() {
        }

        abstract Expression currentIndex();

        abstract Expression limit();

        abstract Statement increment();

        abstract ImmutableList<Statement> initStatements();
    }

    static abstract class CompiledMethodBody {
        CompiledMethodBody() {
        }

        static CompiledMethodBody create(Statement body, int numDetaches) {
            return new AutoValue_SoyNodeCompiler_CompiledMethodBody(body, numDetaches);
        }

        abstract Statement body();

        abstract int numberOfDetachStates();
    }
}

