/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.jbcsrc;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.html.types.SafeHtmlProto;
import com.google.common.html.types.SafeScriptProto;
import com.google.common.html.types.SafeStyleProto;
import com.google.common.html.types.SafeStyleSheetProto;
import com.google.common.html.types.SafeUrlProto;
import com.google.common.html.types.TrustedResourceUrlProto;
import com.google.common.io.BaseEncoding;
import com.google.protobuf.ByteString;
import com.google.protobuf.Descriptors;
import com.google.protobuf.ExtensionLite;
import com.google.protobuf.GeneratedMessage;
import com.google.protobuf.Message;
import com.google.protobuf.ProtocolMessageEnum;
import com.google.template.soy.base.SoyBackendKind;
import com.google.template.soy.data.SanitizedContent;
import com.google.template.soy.exprtree.FieldAccessNode;
import com.google.template.soy.jbcsrc.BytecodeProducer;
import com.google.template.soy.jbcsrc.BytecodeUtils;
import com.google.template.soy.jbcsrc.CodeBuilder;
import com.google.template.soy.jbcsrc.Expression;
import com.google.template.soy.jbcsrc.FieldRef;
import com.google.template.soy.jbcsrc.MethodRef;
import com.google.template.soy.jbcsrc.SoyExpression;
import com.google.template.soy.jbcsrc.shared.RenderContext;
import com.google.template.soy.types.primitive.SanitizedType;
import com.google.template.soy.types.proto.JavaQualifiedNames;
import com.google.template.soy.types.proto.Protos;
import com.google.template.soy.types.proto.SoyProtoTypeImpl;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import org.objectweb.asm.Label;
import org.objectweb.asm.Type;

final class ProtoUtils {
    private static final Type BYTE_STRING_TYPE = Type.getType(ByteString.class);
    static final MethodRef SOY_PROTO_VALUE_GET_PROTO = MethodRef.forMethod(SoyProtoTypeImpl.Value.class, "getProto", new Class[0]).asNonNullable().asCheap();
    static final MethodRef RENDER_CONTEXT_BOX = MethodRef.create(RenderContext.class, "box", Message.class).asNonNullable();
    static final MethodRef PROTO_ENUM_GET_NUMBER = MethodRef.forMethod(ProtocolMessageEnum.class, "getNumber", new Class[0]).asCheap();
    static final MethodRef BYTE_STRING_TO_BYTE_ARRAY = MethodRef.forMethod(ByteString.class, "toByteArray", new Class[0]).asNonNullable();
    static final MethodRef BASE_64 = MethodRef.forMethod(BaseEncoding.class, "base64", new Class[0]).asNonNullable().asCheap();
    static final MethodRef BASE_ENCODING_ENCODE = MethodRef.forMethod(BaseEncoding.class, "encode", byte[].class).asNonNullable().asCheap();
    static final MethodRef EXTENDABLE_MESSAGE_GET_EXTENSION = MethodRef.forMethod(GeneratedMessage.ExtendableMessage.class, "getExtension", ExtensionLite.class).asNonNullable().asCheap();
    static final MethodRef EXTENDABLE_MESSAGE_HAS_EXTENSION = MethodRef.forMethod(GeneratedMessage.ExtendableMessage.class, "hasExtension", ExtensionLite.class).asNonNullable().asCheap();
    private static final ImmutableMap<Descriptors.Descriptor, MethodRef> SAFE_PROTO_TO_ACCESSOR = ImmutableMap.builder().put((Object)SafeHtmlProto.getDescriptor(), (Object)ProtoUtils.createSafeAccessor(SafeHtmlProto.class)).put((Object)SafeScriptProto.getDescriptor(), (Object)ProtoUtils.createSafeAccessor(SafeScriptProto.class)).put((Object)SafeStyleProto.getDescriptor(), (Object)ProtoUtils.createSafeAccessor(SafeStyleProto.class)).put((Object)SafeStyleSheetProto.getDescriptor(), (Object)ProtoUtils.createSafeAccessor(SafeStyleSheetProto.class)).put((Object)SafeUrlProto.getDescriptor(), (Object)ProtoUtils.createSafeAccessor(SafeUrlProto.class)).put((Object)TrustedResourceUrlProto.getDescriptor(), (Object)ProtoUtils.createSafeAccessor(TrustedResourceUrlProto.class)).build();

    ProtoUtils() {
    }

    private static MethodRef createSafeAccessor(Class<?> clazz) {
        String simpleName = clazz.getSimpleName();
        simpleName = simpleName.substring(0, simpleName.length() - "Proto".length());
        return MethodRef.forMethod(clazz, "getPrivateDoNotAccessOrElse" + simpleName + "WrappedValue", new Class[0]).asNonNullable().asCheap();
    }

    static SoyExpression accessField(SoyProtoTypeImpl protoType, SoyExpression baseExpr, FieldAccessNode node, Expression renderContext) {
        return new AccessorGenerator(protoType, baseExpr, node, renderContext).generateAccessor();
    }

    static SoyExpression unbox(SoyProtoTypeImpl protoType, SoyExpression baseExpr) {
        return baseExpr.unboxAs(ProtoUtils.messageClass(protoType));
    }

    private static boolean shouldReinterpretAsString(Descriptors.FieldDescriptor descriptor) {
        Protos.JsType jsType;
        boolean reinterpretAsString = false;
        if (Protos.hasJsType(descriptor) && (jsType = Protos.getJsType(descriptor)) == Protos.JsType.STRING) {
            reinterpretAsString = true;
        }
        return reinterpretAsString;
    }

    private static Class<? extends Message> messageClass(SoyProtoTypeImpl protoType) {
        try {
            return Class.forName(protoType.getNameForBackend(SoyBackendKind.JBC_SRC)).asSubclass(Message.class);
        }
        catch (ClassNotFoundException e) {
            throw new AssertionError((Object)e);
        }
    }

    private static Class<? extends Message> descriptorClass(Descriptors.Descriptor descriptor) {
        String className = JavaQualifiedNames.getClassName(descriptor);
        ClassLoader cl = descriptor.getClass().getClassLoader();
        if (cl == null) {
            cl = ClassLoader.getSystemClassLoader();
        }
        try {
            return cl.loadClass(className).asSubclass(Message.class);
        }
        catch (ClassNotFoundException ex) {
            throw new AssertionError((Object)("Could not resolve java class for descriptor " + descriptor.getFullName()));
        }
    }

    public static Method getGetterMethod(Descriptors.FieldDescriptor descriptor) throws SecurityException {
        Preconditions.checkArgument((!descriptor.isExtension() ? 1 : 0) != 0, (String)"extensions do not have getter methods. %s", (Object[])new Object[]{descriptor});
        Class<? extends Message> owner = ProtoUtils.descriptorClass(descriptor.getContainingType());
        try {
            return owner.getMethod("get" + JavaQualifiedNames.underscoresToCamelCase(descriptor.getName(), true), new Class[0]);
        }
        catch (NoSuchMethodException e) {
            throw new IllegalStateException("Could not find getter method for " + descriptor, e);
        }
    }

    private static Method getHasserMethod(Descriptors.FieldDescriptor descriptor) throws SecurityException {
        Class<? extends Message> owner = ProtoUtils.descriptorClass(descriptor.getContainingType());
        try {
            return owner.getMethod("has" + JavaQualifiedNames.underscoresToCamelCase(descriptor.getName(), true), new Class[0]);
        }
        catch (NoSuchMethodException e) {
            throw new IllegalStateException("Could not find hasser method for " + descriptor, e);
        }
    }

    public static Method getOneOfCaseMethod(Descriptors.OneofDescriptor descriptor) throws SecurityException {
        Class<? extends Message> owner = ProtoUtils.descriptorClass(descriptor.getContainingType());
        try {
            return owner.getMethod("get" + JavaQualifiedNames.underscoresToCamelCase(descriptor.getName(), true) + "Case", new Class[0]);
        }
        catch (NoSuchMethodException e) {
            throw new IllegalStateException("Could not find case method for " + descriptor, e);
        }
    }

    public static Field getExtensionField(Descriptors.FieldDescriptor descriptor) throws SecurityException {
        Preconditions.checkArgument((boolean)descriptor.isExtension(), (String)"%s is not an extension", (Object[])new Object[]{descriptor});
        String extensionFieldName = JavaQualifiedNames.underscoresToCamelCase(descriptor.getName(), false);
        if (descriptor.getExtensionScope() != null) {
            Class<? extends Message> owner = ProtoUtils.descriptorClass(descriptor.getExtensionScope());
            try {
                return owner.getField(extensionFieldName);
            }
            catch (NoSuchFieldException e) {
                throw new IllegalStateException("Could not find extension field for " + descriptor, e);
            }
        }
        String containingClass = JavaQualifiedNames.getPackage(descriptor.getFile()) + "." + JavaQualifiedNames.getOuterClassname(descriptor.getFile());
        try {
            return Class.forName(containingClass).getField(extensionFieldName);
        }
        catch (ReflectiveOperationException e) {
            throw new IllegalStateException("Could not find extension field for " + descriptor, e);
        }
    }

    private static final class AccessorGenerator {
        final Class<?> protoClass;
        final SoyExpression baseExpr;
        final FieldAccessNode node;
        final Expression renderContext;
        final Descriptors.FieldDescriptor descriptor;
        final boolean isProto3;

        AccessorGenerator(SoyProtoTypeImpl protoType, SoyExpression baseExpr, FieldAccessNode node, Expression renderContext) {
            this.protoClass = ProtoUtils.messageClass(protoType);
            this.baseExpr = baseExpr;
            this.node = node;
            this.renderContext = renderContext;
            this.descriptor = protoType.getFieldDescriptor(node.getFieldName());
            this.isProto3 = this.descriptor.getFile().getSyntax() == Descriptors.FileDescriptor.Syntax.PROTO3;
        }

        SoyExpression generateAccessor() {
            if (this.descriptor.isRepeated()) {
                return this.handleRepeated();
            }
            SoyExpression typedBaseExpr = this.baseExpr.withRenderContext(this.renderContext).unboxAs(this.protoClass);
            if (this.descriptor.isExtension()) {
                return this.handleExtension(typedBaseExpr);
            }
            return this.handleNormalField(typedBaseExpr);
        }

        private SoyExpression handleNormalField(final SoyExpression typedBaseExpr) {
            final MethodRef getMethodRef = MethodRef.create(ProtoUtils.getGetterMethod(this.descriptor)).asNonNullable().asCheap();
            if (this.shouldCheckForFieldPresence()) {
                BytecodeProducer hasCheck;
                final Label hasFieldLabel = new Label();
                Descriptors.OneofDescriptor containingOneof = this.descriptor.getContainingOneof();
                if (containingOneof != null) {
                    final MethodRef getCaseRef = MethodRef.create(ProtoUtils.getOneOfCaseMethod(containingOneof));
                    final Expression fieldNumber = BytecodeUtils.constant(this.descriptor.getNumber());
                    hasCheck = new BytecodeProducer(){

                        @Override
                        void doGen(CodeBuilder adapter) {
                            getCaseRef.invokeUnchecked(adapter);
                            adapter.visitMethodInsn(182, getCaseRef.returnType().getInternalName(), "getNumber", "()I", false);
                            fieldNumber.gen(adapter);
                            adapter.ifCmp(Type.INT_TYPE, 153, hasFieldLabel);
                        }
                    };
                } else {
                    final MethodRef hasMethodRef = MethodRef.create(ProtoUtils.getHasserMethod(this.descriptor)).asCheap();
                    hasCheck = new BytecodeProducer(){

                        @Override
                        void doGen(CodeBuilder adapter) {
                            hasMethodRef.invokeUnchecked(adapter);
                            adapter.ifZCmp(154, hasFieldLabel);
                        }
                    };
                }
                final Label endLabel = new Label();
                SoyExpression interpretedField = this.interpretField(new Expression(getMethodRef.returnType(), getMethodRef.features().minus(Expression.Feature.NON_NULLABLE)){

                    @Override
                    void doGen(CodeBuilder adapter) {
                        typedBaseExpr.gen(adapter);
                        adapter.dup();
                        hasCheck.gen(adapter);
                        adapter.pop();
                        adapter.visitInsn(1);
                        adapter.goTo(endLabel);
                        adapter.mark(hasFieldLabel);
                        getMethodRef.invokeUnchecked(adapter);
                    }
                });
                if (BytecodeUtils.isPrimitive(interpretedField.resultType())) {
                    interpretedField = interpretedField.box();
                }
                return interpretedField.labelEnd(endLabel).asNullable();
            }
            return this.interpretField(typedBaseExpr.invoke(getMethodRef, new Expression[0]));
        }

        private boolean shouldCheckForFieldPresence() {
            if (this.descriptor.hasDefaultValue()) {
                return false;
            }
            if (!this.isProto3) {
                return true;
            }
            return this.descriptor.getContainingOneof() != null || this.descriptor.getType() == Descriptors.FieldDescriptor.Type.MESSAGE;
        }

        private SoyExpression interpretField(Expression field) throws AssertionError {
            switch (this.descriptor.getJavaType()) {
                case FLOAT: {
                    return SoyExpression.forFloat(BytecodeUtils.numericConversion(field, Type.DOUBLE_TYPE));
                }
                case DOUBLE: {
                    return SoyExpression.forFloat(field);
                }
                case ENUM: {
                    return SoyExpression.forInt(BytecodeUtils.numericConversion(field.invoke(PROTO_ENUM_GET_NUMBER, new Expression[0]), Type.LONG_TYPE));
                }
                case INT: {
                    if (ProtoUtils.shouldReinterpretAsString(this.descriptor)) {
                        return SoyExpression.forString(MethodRef.INTEGER_TO_STRING.invoke(field));
                    }
                    return SoyExpression.forInt(BytecodeUtils.numericConversion(field, Type.LONG_TYPE));
                }
                case LONG: {
                    if (ProtoUtils.shouldReinterpretAsString(this.descriptor)) {
                        return SoyExpression.forString(MethodRef.LONG_TO_STRING.invoke(field));
                    }
                    return SoyExpression.forInt(field);
                }
                case BOOLEAN: {
                    return SoyExpression.forBool(field);
                }
                case STRING: {
                    return SoyExpression.forString(field);
                }
                case MESSAGE: {
                    return this.messageToSoyExpression(field);
                }
                case BYTE_STRING: {
                    return this.byteStringToBase64String(field);
                }
            }
            throw new AssertionError((Object)("unsupported field type: " + this.descriptor));
        }

        private SoyExpression handleExtension(final SoyExpression typedBaseExpr) {
            FieldRef extensionField = FieldRef.staticFieldReference(ProtoUtils.getExtensionField(this.descriptor));
            final Expression extensionFieldAccessor = extensionField.accessor();
            if (!this.descriptor.hasDefaultValue()) {
                final Label endLabel = new Label();
                SoyExpression interpretedField = this.intepretExtensionField(new Expression(EXTENDABLE_MESSAGE_GET_EXTENSION.returnType(), EXTENDABLE_MESSAGE_GET_EXTENSION.features().minus(Expression.Feature.NON_NULLABLE)){

                    @Override
                    void doGen(CodeBuilder adapter) {
                        typedBaseExpr.gen(adapter);
                        adapter.dup();
                        extensionFieldAccessor.gen(adapter);
                        EXTENDABLE_MESSAGE_HAS_EXTENSION.invokeUnchecked(adapter);
                        Label hasFieldLabel = new Label();
                        adapter.ifZCmp(154, hasFieldLabel);
                        adapter.pop();
                        adapter.visitInsn(1);
                        adapter.goTo(endLabel);
                        adapter.mark(hasFieldLabel);
                        extensionFieldAccessor.gen(adapter);
                        EXTENDABLE_MESSAGE_GET_EXTENSION.invokeUnchecked(adapter);
                    }
                });
                if (BytecodeUtils.isPrimitive(interpretedField.resultType())) {
                    interpretedField = interpretedField.box();
                }
                return interpretedField.labelEnd(endLabel).asNullable();
            }
            return this.intepretExtensionField(typedBaseExpr.invoke(EXTENDABLE_MESSAGE_GET_EXTENSION, extensionFieldAccessor));
        }

        private SoyExpression intepretExtensionField(Expression field) throws AssertionError {
            switch (this.descriptor.getJavaType()) {
                case FLOAT: 
                case DOUBLE: {
                    return SoyExpression.forFloat(field.cast(Number.class).invoke(MethodRef.DOUBLE_VALUE, new Expression[0]));
                }
                case ENUM: {
                    return SoyExpression.forInt(BytecodeUtils.numericConversion(field.cast(ProtocolMessageEnum.class).invoke(PROTO_ENUM_GET_NUMBER, new Expression[0]), Type.LONG_TYPE));
                }
                case INT: 
                case LONG: {
                    if (ProtoUtils.shouldReinterpretAsString(this.descriptor)) {
                        return SoyExpression.forString(field.invoke(MethodRef.OBJECT_TO_STRING, new Expression[0]));
                    }
                    return SoyExpression.forInt(field.cast(Number.class).invoke(MethodRef.LONG_VALUE, new Expression[0]));
                }
                case BOOLEAN: {
                    return SoyExpression.forBool(field.cast(Boolean.class).invoke(MethodRef.BOOLEAN_VALUE, new Expression[0]));
                }
                case STRING: {
                    return SoyExpression.forString(field.cast(String.class));
                }
                case MESSAGE: {
                    return this.messageToSoyExpression(field);
                }
                case BYTE_STRING: {
                    return this.byteStringToBase64String(field.cast(ByteString.class));
                }
            }
            throw new AssertionError((Object)("unsupported field type: " + this.descriptor));
        }

        private SoyExpression byteStringToBase64String(Expression byteString) {
            byteString.checkAssignableTo(BYTE_STRING_TYPE);
            final Expression byteArray = byteString.invoke(BYTE_STRING_TO_BYTE_ARRAY, new Expression[0]);
            return SoyExpression.forString(new Expression(BytecodeUtils.STRING_TYPE, Expression.Feature.NON_NULLABLE, new Expression.Feature[0]){

                @Override
                void doGen(CodeBuilder adapter) {
                    byteArray.gen(adapter);
                    BASE_64.invokeUnchecked(adapter);
                    adapter.swap();
                    BASE_ENCODING_ENCODE.invokeUnchecked(adapter);
                }
            });
        }

        private SoyExpression messageToSoyExpression(Expression field) {
            if (this.node.getType() instanceof SoyProtoTypeImpl) {
                SoyProtoTypeImpl fieldProtoType = (SoyProtoTypeImpl)this.node.getType();
                Class messageClass = ProtoUtils.messageClass(fieldProtoType);
                return SoyExpression.forProto(fieldProtoType, messageClass, field.cast(messageClass), this.renderContext);
            }
            SanitizedContent.ContentKind kind = ((SanitizedType)this.node.getType()).getContentKind();
            Descriptors.Descriptor messageType = this.descriptor.getMessageType();
            MethodRef methodRef = (MethodRef)SAFE_PROTO_TO_ACCESSOR.get((Object)messageType);
            return SoyExpression.forSanitizedString(field.cast(methodRef.owner().type()).invoke(methodRef, new Expression[0]), kind);
        }

        private SoyExpression handleRepeated() {
            return SoyExpression.forSoyValue(this.node.getType(), MethodRef.RUNTIME_GET_FIELD_PROVIDER.invoke(this.baseExpr.box(), BytecodeUtils.constant(this.node.getFieldName())).invoke(MethodRef.SOY_VALUE_PROVIDER_RESOLVE, new Expression[0]).cast(this.node.getType().javaType()));
        }
    }
}

