/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.incrementaldomsrc;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Maps;
import com.google.template.soy.base.internal.BaseUtils;
import com.google.template.soy.basetree.ParentNode;
import com.google.template.soy.data.SanitizedContent;
import com.google.template.soy.error.ErrorReporter;
import com.google.template.soy.error.SoyErrorKind;
import com.google.template.soy.exprtree.ExprNode;
import com.google.template.soy.exprtree.ExprRootNode;
import com.google.template.soy.exprtree.OperatorNodes;
import com.google.template.soy.exprtree.StringNode;
import com.google.template.soy.exprtree.VarRefNode;
import com.google.template.soy.html.HtmlAttributeNode;
import com.google.template.soy.html.HtmlCloseTagNode;
import com.google.template.soy.html.HtmlDefinitions;
import com.google.template.soy.html.HtmlOpenTagEndNode;
import com.google.template.soy.html.HtmlOpenTagNode;
import com.google.template.soy.html.HtmlOpenTagStartNode;
import com.google.template.soy.html.HtmlVoidTagNode;
import com.google.template.soy.incrementaldomsrc.AssistantForHtmlMsgs;
import com.google.template.soy.incrementaldomsrc.GenIncrementalDomExprsVisitor;
import com.google.template.soy.incrementaldomsrc.IncrementalDomCodeBuilder;
import com.google.template.soy.incrementaldomsrc.IncrementalDomDelTemplateNamer;
import com.google.template.soy.incrementaldomsrc.IncrementalDomGenCallCodeUtils;
import com.google.template.soy.incrementaldomsrc.IncrementalDomSrcUtils;
import com.google.template.soy.incrementaldomsrc.IsComputableAsIncrementalDomExprsVisitor;
import com.google.template.soy.jssrc.SoyJsSrcOptions;
import com.google.template.soy.jssrc.internal.CanInitOutputVarVisitor;
import com.google.template.soy.jssrc.internal.GenCallCodeUtils;
import com.google.template.soy.jssrc.internal.GenDirectivePluginRequiresVisitor;
import com.google.template.soy.jssrc.internal.GenJsCodeVisitor;
import com.google.template.soy.jssrc.internal.GenJsCodeVisitorAssistantForMsgs;
import com.google.template.soy.jssrc.internal.GenJsExprsVisitor;
import com.google.template.soy.jssrc.internal.IsComputableAsJsExprsVisitor;
import com.google.template.soy.jssrc.internal.JsExprTranslator;
import com.google.template.soy.jssrc.internal.JsSrcUtils;
import com.google.template.soy.jssrc.internal.TemplateAliases;
import com.google.template.soy.jssrc.restricted.JsExpr;
import com.google.template.soy.jssrc.restricted.JsExprUtils;
import com.google.template.soy.shared.internal.CodeBuilder;
import com.google.template.soy.soytree.CallNode;
import com.google.template.soy.soytree.CallParamContentNode;
import com.google.template.soy.soytree.CallParamNode;
import com.google.template.soy.soytree.ExprUnion;
import com.google.template.soy.soytree.HtmlContext;
import com.google.template.soy.soytree.IfNode;
import com.google.template.soy.soytree.LetContentNode;
import com.google.template.soy.soytree.MsgFallbackGroupNode;
import com.google.template.soy.soytree.MsgHtmlTagNode;
import com.google.template.soy.soytree.MsgPlaceholderNode;
import com.google.template.soy.soytree.PrintNode;
import com.google.template.soy.soytree.RawTextNode;
import com.google.template.soy.soytree.SoyFileNode;
import com.google.template.soy.soytree.SoyNode;
import com.google.template.soy.soytree.TemplateNode;
import com.google.template.soy.types.SoyType;
import com.google.template.soy.types.SoyTypeOps;
import java.util.Deque;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;

public final class GenIncrementalDomCodeVisitor
extends GenJsCodeVisitor {
    private static final SoyErrorKind PRINT_ATTR_INVALID_KIND = SoyErrorKind.of("For Incremental DOM, '{print}' statements in attributes context can only be of kind attributes (since they must compile to semantic attribute declarations).  {0} is not allowed.");
    private static final SoyErrorKind PRINT_ATTR_INVALID_VALUE = SoyErrorKind.of("Attribute values that cannot be evalutated to simple expressions are not yet supported for Incremental DOM code generation.");
    private static final SoyErrorKind NULL_COALESCING_NON_EMPTY = SoyErrorKind.of("The only supported conditional for attribute and HTML values in incremental DOM is '{'$value ?: '''''}'.  The right operand must be empty.");
    private static final String NAMESPACE_EXTENSION = ".incrementaldom";
    private static final String KEY_ATTRIBUTE_NAME = "key";
    private static int idGenerator = 0;

    @Inject
    GenIncrementalDomCodeVisitor(SoyJsSrcOptions jsSrcOptions, JsExprTranslator jsExprTranslator, IncrementalDomDelTemplateNamer incrementalDomDelTemplateNamer, IncrementalDomGenCallCodeUtils genCallCodeUtils, IsComputableAsIncrementalDomExprsVisitor isComputableAsJsExprsVisitor, CanInitOutputVarVisitor canInitOutputVarVisitor, GenIncrementalDomExprsVisitor.GenIncrementalDomExprsVisitorFactory genIncrementalDomExprsVisitorFactory, GenDirectivePluginRequiresVisitor genDirectivePluginRequiresVisitor, SoyTypeOps typeOps) {
        super(jsSrcOptions, jsExprTranslator, incrementalDomDelTemplateNamer, genCallCodeUtils, isComputableAsJsExprsVisitor, canInitOutputVarVisitor, genIncrementalDomExprsVisitorFactory, genDirectivePluginRequiresVisitor, typeOps);
    }

    @Override
    protected CodeBuilder<JsExpr> createCodeBuilder() {
        return new IncrementalDomCodeBuilder();
    }

    protected IncrementalDomCodeBuilder getJsCodeBuilder() {
        return (IncrementalDomCodeBuilder)super.getJsCodeBuilder();
    }

    @Override
    protected String getGoogModuleNamespace(String soyNamespace) {
        return soyNamespace + NAMESPACE_EXTENSION;
    }

    @Override
    protected void addCodeToRequireGeneralDeps(SoyFileNode soyFile) {
        super.addCodeToRequireGeneralDeps(soyFile);
        this.addGoogRequire("goog.asserts", true);
        this.addGoogRequire("goog.string", true);
        this.getJsCodeBuilder().appendLine("var IncrementalDom = goog.require('incrementaldom');").appendLine("var ie_open = IncrementalDom.elementOpen;").appendLine("var ie_close = IncrementalDom.elementClose;").appendLine("var ie_void = IncrementalDom.elementVoid;").appendLine("var ie_open_start = IncrementalDom.elementOpenStart;").appendLine("var ie_open_end = IncrementalDom.elementOpenEnd;").appendLine("var itext = IncrementalDom.text;").appendLine("var iattr = IncrementalDom.attr;");
    }

    @Override
    protected String getJsTypeName(SoyType type) {
        return IncrementalDomSrcUtils.getJsTypeName(type);
    }

    @Override
    protected String getTemplateReturnType(TemplateNode node) {
        if (node.getContentKind() == SanitizedContent.ContentKind.TEXT) {
            return "string";
        }
        return "void";
    }

    @Override
    protected void visitTemplateNode(TemplateNode node) {
        this.getJsCodeBuilder().setContentKind(node.getContentKind());
        super.visitTemplateNode(node);
    }

    @Override
    protected void generateFunctionBody(TemplateNode node) {
        IncrementalDomCodeBuilder jsCodeBuilder = this.getJsCodeBuilder();
        boolean isTextTemplate = this.isTextContent(node.getContentKind());
        this.localVarTranslations.push(Maps.newHashMap());
        if (isTextTemplate) {
            jsCodeBuilder.appendLine("var output = '';");
            jsCodeBuilder.pushOutputVar("output");
        }
        this.genParamTypeChecks(node);
        this.visitChildren(node);
        if (isTextTemplate) {
            jsCodeBuilder.appendLine("return output;");
            jsCodeBuilder.popOutputVar();
        }
        this.localVarTranslations.pop();
    }

    @Override
    protected void visitChildren(SoyNode.ParentSoyNode<?> node) {
        for (SoyNode child : node.getChildren()) {
            this.visit(child);
        }
    }

    private void visitLetParamContentNode(SoyNode.RenderUnitNode node, String generatedVarName) {
        IncrementalDomCodeBuilder jsCodeBuilder = this.getJsCodeBuilder();
        SanitizedContent.ContentKind prevContentKind = jsCodeBuilder.getContentKind();
        this.localVarTranslations.push(Maps.newHashMap());
        jsCodeBuilder.pushOutputVar(generatedVarName);
        jsCodeBuilder.setContentKind(node.getContentKind());
        Preconditions.checkState((node.getContentKind() != null ? 1 : 0) != 0);
        switch (node.getContentKind()) {
            case HTML: 
            case ATTRIBUTES: {
                jsCodeBuilder.appendLine("var " + generatedVarName, " = function() {");
                jsCodeBuilder.increaseIndent();
                this.visitChildren(node);
                jsCodeBuilder.decreaseIndent();
                jsCodeBuilder.appendLine("};");
                break;
            }
            default: {
                jsCodeBuilder.appendLine("var ", generatedVarName, " = '';");
                this.visitChildren(node);
            }
        }
        jsCodeBuilder.setContentKind(prevContentKind);
        jsCodeBuilder.popOutputVar();
        this.localVarTranslations.pop();
    }

    @Override
    protected void visitLetContentNode(LetContentNode node) {
        String generatedVarName = node.getUniqueVarName();
        this.visitLetParamContentNode(node, generatedVarName);
        ((Map)this.localVarTranslations.peek()).put(node.getVarName(), new JsExpr(generatedVarName, Integer.MAX_VALUE));
    }

    @Override
    protected void visitCallParamContentNode(CallParamContentNode node) {
        String generatedVarName = "param" + node.getId();
        this.visitLetParamContentNode(node, generatedVarName);
    }

    @Override
    protected void visitCallNode(CallNode node) {
        for (CallParamNode child : node.getChildren()) {
            if (!(child instanceof CallParamContentNode) || ((Boolean)this.isComputableAsJsExprsVisitor.exec(child)).booleanValue()) continue;
            this.visit(child);
        }
        JsExpr callExpr = this.genCallCodeUtils.genCallExpr(node, this.localVarTranslations, this.templateAliases, this.errorReporter);
        IncrementalDomCodeBuilder jsCodeBuilder = this.getJsCodeBuilder();
        SanitizedContent.ContentKind currentContentKind = jsCodeBuilder.getContentKind();
        switch (currentContentKind) {
            case ATTRIBUTES: {
                jsCodeBuilder.appendLine(callExpr.getText() + ";");
                break;
            }
            case HTML: {
                Optional<SanitizedContent.ContentKind> kind = this.templateRegistry.getCallContentKind(node);
                if (!kind.isPresent()) {
                    this.generateDynamicTextCall(callExpr.getText());
                    break;
                }
                if (this.isTextContent((SanitizedContent.ContentKind)((Object)kind.get()))) {
                    this.generateTextCall(callExpr.getText());
                    break;
                }
                jsCodeBuilder.appendLine(callExpr.getText() + ";");
                break;
            }
            case JS: 
            case URI: 
            case TRUSTED_RESOURCE_URI: 
            case CSS: 
            case TEXT: {
                jsCodeBuilder.addToOutputVar((List<? extends JsExpr>)ImmutableList.of((Object)callExpr));
            }
        }
    }

    @Override
    protected void visitIfNode(IfNode node) {
        IncrementalDomCodeBuilder jsCodeBuilder = this.getJsCodeBuilder();
        SanitizedContent.ContentKind currentContentKind = jsCodeBuilder.getContentKind();
        if (currentContentKind == SanitizedContent.ContentKind.ATTRIBUTES || currentContentKind == SanitizedContent.ContentKind.HTML) {
            super.generateNonExpressionIfNode(node);
        } else {
            super.visitIfNode(node);
        }
    }

    private void generateTextCall(String exprText) {
        String text = "(goog.asserts.assert((" + exprText + ") != null), " + exprText + ")";
        this.getJsCodeBuilder().appendLine("itext(", text, ");");
    }

    private void generateDynamicTextCall(String exprText) {
        String dynamicString = "dyn" + idGenerator++;
        this.getJsCodeBuilder().appendLine("var " + dynamicString + " = " + exprText + ";");
        this.getJsCodeBuilder().appendLine("if (typeof " + dynamicString + " == 'function') " + dynamicString + "(); " + "else if (" + dynamicString + " != null) itext(" + dynamicString + ");");
    }

    private boolean isTextContent(SanitizedContent.ContentKind contentKind) {
        return contentKind != SanitizedContent.ContentKind.HTML && contentKind != SanitizedContent.ContentKind.ATTRIBUTES;
    }

    private void printStaticAndDynamicAttributes(List<SoyNode.StandaloneNode> attributes) {
        IncrementalDomCodeBuilder jsCodeBuilder = this.getJsCodeBuilder();
        if (!attributes.isEmpty()) {
            jsCodeBuilder.append(", null");
            jsCodeBuilder.increaseIndent();
            jsCodeBuilder.appendLineEnd(",");
            this.printAttributeList(attributes);
            jsCodeBuilder.decreaseIndent();
        }
    }

    private void printAttributeValues(HtmlAttributeNode node) {
        IncrementalDomCodeBuilder jsCodeBuilder = this.getJsCodeBuilder();
        List children = node.getChildren();
        if (children.isEmpty()) {
            jsCodeBuilder.append("''");
        } else {
            if (!this.isComputableAsJsExprsVisitor.execOnChildren(node).booleanValue()) {
                this.errorReporter.report(node.getSourceLocation(), PRINT_ATTR_INVALID_VALUE, new Object[0]);
                return;
            }
            jsCodeBuilder.addToOutput(this.genJsExprsVisitor.execOnChildren(node));
        }
    }

    private void printAttributeList(List<SoyNode.StandaloneNode> attributes) {
        if (attributes.isEmpty()) {
            return;
        }
        IncrementalDomCodeBuilder jsCodeBuilder = this.getJsCodeBuilder();
        jsCodeBuilder.increaseIndent();
        int lastIndex = attributes.size() - 1;
        for (int i = 0; i < lastIndex; ++i) {
            this.printAttribute(attributes.get(i));
            jsCodeBuilder.appendLineEnd(",");
        }
        this.printAttribute(attributes.get(lastIndex));
        jsCodeBuilder.decreaseIndent();
    }

    private void printAttribute(SoyNode.StandaloneNode node) {
        IncrementalDomCodeBuilder jsCodeBuilder = this.getJsCodeBuilder();
        HtmlAttributeNode htmlAttributeNode = (HtmlAttributeNode)node;
        jsCodeBuilder.appendLineStart("'", htmlAttributeNode.getName(), "', ");
        this.printAttributeValues(htmlAttributeNode);
    }

    private void emitClose(String tagName) {
        IncrementalDomCodeBuilder jsCodeBuilder = this.getJsCodeBuilder();
        jsCodeBuilder.decreaseIndent();
        jsCodeBuilder.appendLine("ie_close('", tagName, "');");
    }

    @Override
    protected void visitHtmlAttributeNode(HtmlAttributeNode node) {
        IncrementalDomCodeBuilder jsCodeBuilder = this.getJsCodeBuilder();
        jsCodeBuilder.appendLineStart("iattr('", node.getName(), "', ");
        this.printAttributeValues(node);
        jsCodeBuilder.appendLineEnd(");");
    }

    @Override
    protected void visitHtmlOpenTagNode(HtmlOpenTagNode node) {
        IncrementalDomCodeBuilder jsCodeBuilder = this.getJsCodeBuilder();
        Optional<String> keyValue = this.getKeyNodeValue(node);
        List<SoyNode.StandaloneNode> attributes = node.getChildren();
        if (!keyValue.isPresent() && attributes.isEmpty()) {
            jsCodeBuilder.appendLineStart("ie_open('", node.getTagName(), "'");
        } else {
            jsCodeBuilder.appendLineStart("ie_open('", node.getTagName(), "', ", (String)keyValue.or((Object)"null"));
            this.printStaticAndDynamicAttributes(attributes);
        }
        jsCodeBuilder.appendLineEnd(");");
        jsCodeBuilder.increaseIndent();
        if (HtmlDefinitions.HTML5_VOID_ELEMENTS.contains((Object)node.getTagName())) {
            this.emitClose(node.getTagName());
        }
    }

    private Optional<String> getKeyNodeValue(ParentNode<SoyNode.StandaloneNode> parentNode) {
        for (SoyNode.StandaloneNode childNode : parentNode.getChildren()) {
            HtmlAttributeNode htmlAttributeNode;
            if (!(childNode instanceof HtmlAttributeNode) || !(htmlAttributeNode = (HtmlAttributeNode)childNode).getName().equals(KEY_ATTRIBUTE_NAME)) continue;
            Preconditions.checkState((boolean)this.isComputableAsJsExprsVisitor.execOnChildren(htmlAttributeNode), (Object)"Attribute values that cannot be evalutated to simple expressions is not yet supported for Incremental DOM code generation");
            List<JsExpr> jsExprs = this.genJsExprsVisitor.execOnChildren(htmlAttributeNode);
            return Optional.of((Object)JsExprUtils.concatJsExprs(jsExprs).getText());
        }
        return Optional.absent();
    }

    @Override
    protected void visitHtmlCloseTagNode(HtmlCloseTagNode node) {
        if (!HtmlDefinitions.HTML5_VOID_ELEMENTS.contains((Object)node.getTagName())) {
            this.emitClose(node.getTagName());
        }
    }

    @Override
    protected void visitHtmlOpenTagStartNode(HtmlOpenTagStartNode node) {
        IncrementalDomCodeBuilder jsCodeBuilder = this.getJsCodeBuilder();
        jsCodeBuilder.appendLine("ie_open_start('", node.getTagName(), "');");
        jsCodeBuilder.increaseIndentTwice();
        jsCodeBuilder.setContentKind(SanitizedContent.ContentKind.ATTRIBUTES);
    }

    @Override
    protected void visitHtmlOpenTagEndNode(HtmlOpenTagEndNode node) {
        IncrementalDomCodeBuilder jsCodeBuilder = this.getJsCodeBuilder();
        jsCodeBuilder.decreaseIndentTwice();
        jsCodeBuilder.appendLine("ie_open_end();");
        jsCodeBuilder.increaseIndent();
        jsCodeBuilder.setContentKind(SanitizedContent.ContentKind.HTML);
        if (HtmlDefinitions.HTML5_VOID_ELEMENTS.contains((Object)node.getTagName())) {
            this.emitClose(node.getTagName());
        }
    }

    @Override
    protected void visitHtmlVoidTagNode(HtmlVoidTagNode node) {
        IncrementalDomCodeBuilder jsCodeBuilder = this.getJsCodeBuilder();
        Optional<String> keyValue = this.getKeyNodeValue(node);
        List<SoyNode.StandaloneNode> attributes = node.getChildren();
        if (!keyValue.isPresent() && attributes.isEmpty()) {
            jsCodeBuilder.appendLineStart("ie_void('", node.getTagName(), "'");
        } else {
            jsCodeBuilder.appendLineStart("ie_void('", node.getTagName(), "', ", (String)keyValue.or((Object)"null"));
            this.printStaticAndDynamicAttributes(attributes);
        }
        jsCodeBuilder.appendLineEnd(");");
    }

    @Override
    protected void visitRawTextNode(RawTextNode node) {
        String text = BaseUtils.escapeToSoyString(node.getRawText(), true);
        if (node.getHtmlContext() == HtmlContext.HTML_PCDATA) {
            this.getJsCodeBuilder().appendLine("itext(", text, ");");
        } else {
            this.getJsCodeBuilder().addToOutputVar((List<? extends JsExpr>)ImmutableList.of((Object)new JsExpr(text, Integer.MAX_VALUE)));
        }
    }

    @Override
    protected void visitPrintNode(PrintNode node) {
        ExprUnion exprUnion = node.getExprUnion();
        ExprRootNode expr = exprUnion.getExpr();
        List<ExprNode> exprNodes = expr.getChildren();
        ExprNode firstNode = exprNodes.get(0);
        switch (node.getHtmlContext()) {
            case HTML_TAG: {
                if (this.tryGenerateFunctionCall(SoyType.Kind.ATTRIBUTES, firstNode) != GenerateFunctionCallResult.INDIRECT_NODE) break;
                this.errorReporter.report(node.getSourceLocation(), PRINT_ATTR_INVALID_KIND, new Object[]{firstNode.getType().getKind()});
                break;
            }
            case HTML_PCDATA: {
                if (this.tryGenerateFunctionCall(SoyType.Kind.HTML, firstNode) != GenerateFunctionCallResult.INDIRECT_NODE) break;
                StringBuilder exprText = new StringBuilder();
                for (JsExpr jsExpr : this.genJsExprsVisitor.exec(node)) {
                    exprText.append(jsExpr.getText());
                }
                this.generateDynamicTextCall(exprText.toString());
                break;
            }
            default: {
                super.visitPrintNode(node);
            }
        }
    }

    private GenerateFunctionCallResult tryGenerateFunctionCall(SoyType.Kind expectedKind, ExprNode expr) {
        IncrementalDomCodeBuilder jsCodeBuilder = this.getJsCodeBuilder();
        if (expr instanceof VarRefNode && expr.getType().getKind() == expectedKind) {
            VarRefNode varRefNode = (VarRefNode)expr;
            String varName = JsSrcUtils.getVariableName(varRefNode.getName(), this.localVarTranslations);
            jsCodeBuilder.appendLine(varName, "();");
            return GenerateFunctionCallResult.EMITTED;
        }
        if (!(expr instanceof OperatorNodes.NullCoalescingOpNode)) {
            return GenerateFunctionCallResult.INDIRECT_NODE;
        }
        OperatorNodes.NullCoalescingOpNode opNode = (OperatorNodes.NullCoalescingOpNode)expr;
        if (!(opNode.getLeftChild() instanceof VarRefNode) || !(opNode.getRightChild() instanceof StringNode) || opNode.getLeftChild().getType().getKind() != expectedKind) {
            return GenerateFunctionCallResult.INDIRECT_NODE;
        }
        if (!((StringNode)opNode.getRightChild()).getValue().isEmpty()) {
            this.errorReporter.report(expr.getSourceLocation(), NULL_COALESCING_NON_EMPTY, new Object[0]);
            return GenerateFunctionCallResult.ILLEGAL_NODE;
        }
        VarRefNode varRefNode = (VarRefNode)opNode.getLeftChild();
        String varName = JsSrcUtils.getVariableName(varRefNode.getName(), this.localVarTranslations);
        jsCodeBuilder.appendLine("if (", varName, ") ", varName, "();");
        return GenerateFunctionCallResult.EMITTED;
    }

    @Override
    protected void visitMsgFallbackGroupNode(MsgFallbackGroupNode node) {
        switch (node.getHtmlContext()) {
            case HTML_PCDATA: {
                new AssistantForHtmlMsgs(this, this.jsSrcOptions, this.jsExprTranslator, this.genCallCodeUtils, this.isComputableAsJsExprsVisitor, (CodeBuilder<JsExpr>)this.getJsCodeBuilder(), (Deque<Map<String, JsExpr>>)this.localVarTranslations, this.templateAliases, this.genJsExprsVisitor, this.errorReporter).generateMsgGroupCode(node);
                break;
            }
            case HTML_NORMAL_ATTR_VALUE: {
                String msgExpression = new AssistantForAttributeMsgs(this, this.jsSrcOptions, this.jsExprTranslator, this.genCallCodeUtils, this.isComputableAsJsExprsVisitor, (CodeBuilder<JsExpr>)this.getJsCodeBuilder(), (Deque<Map<String, JsExpr>>)this.localVarTranslations, this.templateAliases, this.genJsExprsVisitor, this.errorReporter).generateMsgGroupVariable(node);
                msgExpression = "goog.string.unescapeEntities(" + msgExpression + ")";
                this.getJsCodeBuilder().addToOutputVar((List<? extends JsExpr>)ImmutableList.of((Object)new JsExpr(msgExpression, Integer.MAX_VALUE)));
                break;
            }
            default: {
                String msgExpression = this.getAssistantForMsgs().generateMsgGroupVariable(node);
                this.getJsCodeBuilder().addToOutputVar((List<? extends JsExpr>)ImmutableList.of((Object)new JsExpr(msgExpression, Integer.MAX_VALUE)));
            }
        }
    }

    @Override
    protected void visitMsgHtmlTagNode(MsgHtmlTagNode node) {
        this.visitChildren(node);
    }

    private static final class AssistantForAttributeMsgs
    extends GenJsCodeVisitorAssistantForMsgs {
        AssistantForAttributeMsgs(GenIncrementalDomCodeVisitor master, SoyJsSrcOptions jsSrcOptions, JsExprTranslator jsExprTranslator, GenCallCodeUtils genCallCodeUtils, IsComputableAsJsExprsVisitor isComputableAsJsExprsVisitor, CodeBuilder<JsExpr> jsCodeBuilder, Deque<Map<String, JsExpr>> localVarTranslations, TemplateAliases functionAliases, GenJsExprsVisitor genJsExprsVisitor, ErrorReporter errorReporter) {
            super(master, jsSrcOptions, jsExprTranslator, genCallCodeUtils, isComputableAsJsExprsVisitor, jsCodeBuilder, localVarTranslations, functionAliases, genJsExprsVisitor, errorReporter);
        }

        @Override
        protected JsExpr genGoogMsgPlaceholderExpr(MsgPlaceholderNode msgPhNode) {
            String expr = super.genGoogMsgPlaceholderExpr(msgPhNode).getText();
            return new JsExpr("soy.$$escapeHtml(" + expr + ")", Integer.MAX_VALUE);
        }
    }

    private static enum GenerateFunctionCallResult {
        EMITTED,
        ILLEGAL_NODE,
        INDIRECT_NODE;

    }
}

