/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.incrementaldomsrc;

import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import com.google.template.soy.base.internal.BaseUtils;
import com.google.template.soy.error.ErrorReporter;
import com.google.template.soy.incrementaldomsrc.GenIncrementalDomCodeVisitor;
import com.google.template.soy.jssrc.SoyJsSrcOptions;
import com.google.template.soy.jssrc.internal.GenCallCodeUtils;
import com.google.template.soy.jssrc.internal.GenJsCodeVisitorAssistantForMsgs;
import com.google.template.soy.jssrc.internal.GenJsExprsVisitor;
import com.google.template.soy.jssrc.internal.IsComputableAsJsExprsVisitor;
import com.google.template.soy.jssrc.internal.JsExprTranslator;
import com.google.template.soy.jssrc.internal.TemplateAliases;
import com.google.template.soy.jssrc.restricted.JsExpr;
import com.google.template.soy.shared.internal.CodeBuilder;
import com.google.template.soy.soytree.HtmlContext;
import com.google.template.soy.soytree.MsgFallbackGroupNode;
import com.google.template.soy.soytree.MsgPlaceholderNode;
import java.util.Deque;
import java.util.Map;

final class AssistantForHtmlMsgs
extends GenJsCodeVisitorAssistantForMsgs {
    private final Map<String, MsgPlaceholderNode> placeholderNames = Maps.newHashMap();
    private static final String PLACEHOLDER_WRAPPER = "\u0001";
    private static final String PLACEHOLDER_REGEX = "/\\x01\\d+\\x01/g";

    AssistantForHtmlMsgs(GenIncrementalDomCodeVisitor master, SoyJsSrcOptions jsSrcOptions, JsExprTranslator jsExprTranslator, GenCallCodeUtils genCallCodeUtils, IsComputableAsJsExprsVisitor isComputableAsJsExprsVisitor, CodeBuilder<JsExpr> jsCodeBuilder, Deque<Map<String, JsExpr>> localVarTranslations, TemplateAliases functionAliases, GenJsExprsVisitor genJsExprsVisitor, ErrorReporter errorReporter) {
        super(master, jsSrcOptions, jsExprTranslator, genCallCodeUtils, isComputableAsJsExprsVisitor, jsCodeBuilder, localVarTranslations, functionAliases, genJsExprsVisitor, errorReporter);
    }

    @Override
    public String generateMsgGroupVariable(MsgFallbackGroupNode node) {
        throw new IllegalStateException("This class should only be used for via the new idom entry-point.");
    }

    void generateMsgGroupCode(MsgFallbackGroupNode node) {
        Preconditions.checkState((boolean)this.placeholderNames.isEmpty(), (Object)"This class is not reusable.");
        Preconditions.checkArgument((node.getHtmlContext() == HtmlContext.HTML_PCDATA ? 1 : 0) != 0, (Object)"AssistantForHtmlMsgs is only for HTML {msg}s.");
        String translationVar = super.generateMsgGroupVariable(node);
        if (this.placeholderNames.isEmpty()) {
            this.jsCodeBuilder.appendLine("itext(goog.string.unescapeEntities(", translationVar, "));");
            return;
        }
        String regexVar = "partRe_" + node.getId();
        String matchVar = "match_" + node.getId();
        String lastIndexVar = "lastIndex_" + node.getId();
        this.jsCodeBuilder.appendLineStart("var ", lastIndexVar, " = 0, ");
        this.jsCodeBuilder.appendLineEnd(regexVar, " = ", PLACEHOLDER_REGEX, ", ", matchVar, ";");
        this.jsCodeBuilder.appendLine("do {");
        this.jsCodeBuilder.increaseIndent();
        this.jsCodeBuilder.appendLine(matchVar, " = ", regexVar, ".exec(", translationVar, ") || undefined;");
        this.jsCodeBuilder.appendLine("itext(goog.string.unescapeEntities(", translationVar, ".substring(", lastIndexVar, ", ", matchVar, " && ", matchVar, ".index)));");
        this.jsCodeBuilder.appendLine(lastIndexVar, " = ", regexVar, ".lastIndex;");
        this.jsCodeBuilder.appendLine("switch (", matchVar, " && ", matchVar, "[0]) {");
        this.jsCodeBuilder.increaseIndent();
        for (Map.Entry<String, MsgPlaceholderNode> ph : this.placeholderNames.entrySet()) {
            this.jsCodeBuilder.appendLine("case ", BaseUtils.escapeToSoyString(ph.getKey(), true), ":");
            this.jsCodeBuilder.increaseIndent();
            this.master.visitForUseByAssistants(ph.getValue());
            this.jsCodeBuilder.appendLine("break;");
            this.jsCodeBuilder.decreaseIndent();
        }
        this.jsCodeBuilder.decreaseIndent();
        this.jsCodeBuilder.appendLine("}");
        this.jsCodeBuilder.decreaseIndent();
        this.jsCodeBuilder.appendLine("} while (", matchVar, ");");
    }

    @Override
    protected JsExpr genGoogMsgPlaceholderExpr(MsgPlaceholderNode msgPhNode) {
        String name = PLACEHOLDER_WRAPPER + this.placeholderNames.size() + PLACEHOLDER_WRAPPER;
        this.placeholderNames.put(name, msgPhNode);
        return new JsExpr(BaseUtils.escapeToSoyString(name, true), Integer.MAX_VALUE);
    }
}

