/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.exprtree;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableTable;
import com.google.template.soy.base.SourceLocation;
import com.google.template.soy.exprtree.ExprNode;
import com.google.template.soy.exprtree.OperatorNodes;
import java.util.List;
import javax.annotation.Nullable;

public enum Operator {
    NEGATIVE((List)ImmutableList.of((Object)new Token("-"), (Object)Constants.OPERAND_0), 8, Associativity.RIGHT, "- (unary)"){

        @Override
        public ExprNode.OperatorNode createNode(SourceLocation location) {
            return new OperatorNodes.NegativeOpNode(location);
        }
    }
    ,
    NOT((List)ImmutableList.of((Object)new Token("not"), (Object)Constants.SP, (Object)Constants.OPERAND_0), 8, Associativity.RIGHT){

        @Override
        public ExprNode.OperatorNode createNode(SourceLocation location) {
            return new OperatorNodes.NotOpNode(location);
        }
    }
    ,
    TIMES((List)ImmutableList.of((Object)Constants.OPERAND_0, (Object)Constants.SP, (Object)new Token("*"), (Object)Constants.SP, (Object)Constants.OPERAND_1), 7, Associativity.LEFT){

        @Override
        public ExprNode.OperatorNode createNode(SourceLocation location) {
            return new OperatorNodes.TimesOpNode(location);
        }
    }
    ,
    DIVIDE_BY((List)ImmutableList.of((Object)Constants.OPERAND_0, (Object)Constants.SP, (Object)new Token("/"), (Object)Constants.SP, (Object)Constants.OPERAND_1), 7, Associativity.LEFT){

        @Override
        public ExprNode.OperatorNode createNode(SourceLocation location) {
            return new OperatorNodes.DivideByOpNode(location);
        }
    }
    ,
    MOD((List)ImmutableList.of((Object)Constants.OPERAND_0, (Object)Constants.SP, (Object)new Token("%"), (Object)Constants.SP, (Object)Constants.OPERAND_1), 7, Associativity.LEFT){

        @Override
        public ExprNode.OperatorNode createNode(SourceLocation location) {
            return new OperatorNodes.ModOpNode(location);
        }
    }
    ,
    PLUS((List)ImmutableList.of((Object)Constants.OPERAND_0, (Object)Constants.SP, (Object)new Token("+"), (Object)Constants.SP, (Object)Constants.OPERAND_1), 6, Associativity.LEFT){

        @Override
        public ExprNode.OperatorNode createNode(SourceLocation location) {
            return new OperatorNodes.PlusOpNode(location);
        }
    }
    ,
    MINUS((List)ImmutableList.of((Object)Constants.OPERAND_0, (Object)Constants.SP, (Object)new Token("-"), (Object)Constants.SP, (Object)Constants.OPERAND_1), 6, Associativity.LEFT, "- (binary)"){

        @Override
        public ExprNode.OperatorNode createNode(SourceLocation location) {
            return new OperatorNodes.MinusOpNode(location);
        }
    }
    ,
    LESS_THAN((List)ImmutableList.of((Object)Constants.OPERAND_0, (Object)Constants.SP, (Object)new Token("<"), (Object)Constants.SP, (Object)Constants.OPERAND_1), 5, Associativity.LEFT){

        @Override
        public ExprNode.OperatorNode createNode(SourceLocation location) {
            return new OperatorNodes.LessThanOpNode(location);
        }
    }
    ,
    GREATER_THAN((List)ImmutableList.of((Object)Constants.OPERAND_0, (Object)Constants.SP, (Object)new Token(">"), (Object)Constants.SP, (Object)Constants.OPERAND_1), 5, Associativity.LEFT){

        @Override
        public ExprNode.OperatorNode createNode(SourceLocation location) {
            return new OperatorNodes.GreaterThanOpNode(location);
        }
    }
    ,
    LESS_THAN_OR_EQUAL((List)ImmutableList.of((Object)Constants.OPERAND_0, (Object)Constants.SP, (Object)new Token("<="), (Object)Constants.SP, (Object)Constants.OPERAND_1), 5, Associativity.LEFT){

        @Override
        public ExprNode.OperatorNode createNode(SourceLocation location) {
            return new OperatorNodes.LessThanOrEqualOpNode(location);
        }
    }
    ,
    GREATER_THAN_OR_EQUAL((List)ImmutableList.of((Object)Constants.OPERAND_0, (Object)Constants.SP, (Object)new Token(">="), (Object)Constants.SP, (Object)Constants.OPERAND_1), 5, Associativity.LEFT){

        @Override
        public ExprNode.OperatorNode createNode(SourceLocation location) {
            return new OperatorNodes.GreaterThanOrEqualOpNode(location);
        }
    }
    ,
    EQUAL((List)ImmutableList.of((Object)Constants.OPERAND_0, (Object)Constants.SP, (Object)new Token("=="), (Object)Constants.SP, (Object)Constants.OPERAND_1), 4, Associativity.LEFT){

        @Override
        public ExprNode.OperatorNode createNode(SourceLocation location) {
            return new OperatorNodes.EqualOpNode(location);
        }
    }
    ,
    NOT_EQUAL((List)ImmutableList.of((Object)Constants.OPERAND_0, (Object)Constants.SP, (Object)new Token("!="), (Object)Constants.SP, (Object)Constants.OPERAND_1), 4, Associativity.LEFT){

        @Override
        public ExprNode.OperatorNode createNode(SourceLocation location) {
            return new OperatorNodes.NotEqualOpNode(location);
        }
    }
    ,
    AND((List)ImmutableList.of((Object)Constants.OPERAND_0, (Object)Constants.SP, (Object)new Token("and"), (Object)Constants.SP, (Object)Constants.OPERAND_1), 3, Associativity.LEFT){

        @Override
        public ExprNode.OperatorNode createNode(SourceLocation location) {
            return new OperatorNodes.AndOpNode(location);
        }
    }
    ,
    OR((List)ImmutableList.of((Object)Constants.OPERAND_0, (Object)Constants.SP, (Object)new Token("or"), (Object)Constants.SP, (Object)Constants.OPERAND_1), 2, Associativity.LEFT){

        @Override
        public ExprNode.OperatorNode createNode(SourceLocation location) {
            return new OperatorNodes.OrOpNode(location);
        }
    }
    ,
    NULL_COALESCING((List)ImmutableList.of((Object)Constants.OPERAND_0, (Object)Constants.SP, (Object)new Token("?:"), (Object)Constants.SP, (Object)Constants.OPERAND_1), 1, Associativity.RIGHT){

        @Override
        public ExprNode.OperatorNode createNode(SourceLocation location) {
            return new OperatorNodes.NullCoalescingOpNode(location);
        }
    }
    ,
    CONDITIONAL((List)ImmutableList.of((Object)Constants.OPERAND_0, (Object)Constants.SP, (Object)new Token("?"), (Object)Constants.SP, (Object)Constants.OPERAND_1, (Object)Constants.SP, (Object)new Token(":"), (Object)Constants.SP, (Object)Constants.OPERAND_2), 1, Associativity.RIGHT){

        @Override
        public ExprNode.OperatorNode createNode(SourceLocation location) {
            return new OperatorNodes.ConditionalOpNode(location);
        }
    };

    private static final ImmutableTable<String, Integer, Operator> OPERATOR_TABLE;
    private final List<SyntaxElement> syntax;
    private final String tokenString;
    private final int numOperands;
    private final int precedence;
    private final Associativity associativity;
    private final String description;

    public static Operator of(String tokenString, int numOperands) {
        Operator op = (Operator)((Object)OPERATOR_TABLE.get((Object)tokenString, (Object)numOperands));
        if (op != null) {
            return op;
        }
        throw new IllegalArgumentException();
    }

    private Operator(List<SyntaxElement> syntax, int precedence, Associativity associativity) {
        this(syntax, precedence, associativity, null);
    }

    private Operator(List<SyntaxElement> syntax, @Nullable int precedence, Associativity associativity, String description) {
        this.syntax = ImmutableList.copyOf(syntax);
        String tokenString = null;
        int numOperands = 0;
        for (SyntaxElement syntaxEl : syntax) {
            if (syntaxEl instanceof Operand) {
                ++numOperands;
                continue;
            }
            if (!(syntaxEl instanceof Token)) continue;
            if (tokenString == null) {
                tokenString = ((Token)syntaxEl).getValue();
                continue;
            }
            tokenString = tokenString + " " + ((Token)syntaxEl).getValue();
        }
        Preconditions.checkArgument((tokenString != null && numOperands > 0 ? 1 : 0) != 0);
        this.tokenString = tokenString;
        this.numOperands = numOperands;
        this.precedence = precedence;
        this.associativity = associativity;
        this.description = description != null ? description : tokenString;
    }

    public List<SyntaxElement> getSyntax() {
        return this.syntax;
    }

    public String getTokenString() {
        return this.tokenString;
    }

    public int getNumOperands() {
        return this.numOperands;
    }

    public int getPrecedence() {
        return this.precedence;
    }

    public Associativity getAssociativity() {
        return this.associativity;
    }

    public String getDescription() {
        return this.description;
    }

    public abstract ExprNode.OperatorNode createNode(SourceLocation var1);

    public final ExprNode.OperatorNode createNode(ExprNode ... children) {
        Preconditions.checkArgument((children.length == this.getNumOperands() ? 1 : 0) != 0);
        ExprNode.OperatorNode node = this.createNode(children[0].getSourceLocation());
        for (ExprNode child : children) {
            node.addChild(child);
        }
        return node;
    }

    static {
        ImmutableTable.Builder builder = ImmutableTable.builder();
        for (Operator op : Operator.values()) {
            builder.put((Object)op.getTokenString(), (Object)op.getNumOperands(), (Object)op);
        }
        OPERATOR_TABLE = builder.build();
    }

    public static class Spacer
    implements SyntaxElement {
        private Spacer() {
        }
    }

    public static class Token
    implements SyntaxElement {
        private final String value;

        private Token(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }
    }

    public static class Operand
    implements SyntaxElement {
        private final int index;

        private Operand(int index) {
            this.index = index;
        }

        public int getIndex() {
            return this.index;
        }
    }

    public static interface SyntaxElement {
    }

    public static enum Associativity {
        LEFT,
        RIGHT;

    }

    static class Constants {
        static final Spacer SP = new Spacer();
        static final Operand OPERAND_0 = new Operand(0);
        static final Operand OPERAND_1 = new Operand(1);
        static final Operand OPERAND_2 = new Operand(2);

        Constants() {
        }
    }
}

