/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.error;

import com.google.template.soy.base.SourceLocation;
import com.google.template.soy.error.AutoValue_SoyError;
import com.google.template.soy.error.SoyErrorKind;

public abstract class SoyError {
    public static final Factory DEFAULT_FACTORY = new Factory(){

        @Override
        public SoyError create(SourceLocation location, SoyErrorKind kind, Object ... args) {
            String message = kind.format(args);
            return SoyError.createError(location, kind, message, "In file " + location + ": " + message);
        }
    };

    static SoyError createError(SourceLocation location, SoyErrorKind kind, String message, String formattedError) {
        return new AutoValue_SoyError(location, kind, message, formattedError);
    }

    SoyError() {
    }

    public abstract SourceLocation location();

    public abstract SoyErrorKind errorKind();

    public abstract String message();

    abstract String formattedMessage();

    public String toString() {
        return this.formattedMessage();
    }

    public static interface Factory {
        public SoyError create(SourceLocation var1, SoyErrorKind var2, Object ... var3);
    }
}

