/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.error;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.template.soy.base.SoySyntaxException;
import com.google.template.soy.error.SoyError;

public final class SoyCompilationException
extends SoySyntaxException {
    private final ImmutableList<SoyError> errors;

    public SoyCompilationException(Iterable<SoyError> specificErrors) {
        this.errors = ImmutableList.copyOf(specificErrors);
        Preconditions.checkArgument((!this.errors.isEmpty() ? 1 : 0) != 0);
    }

    public ImmutableList<SoyError> getErrors() {
        return this.errors;
    }

    @Override
    public String getMessage() {
        StringBuilder sb = new StringBuilder("errors during Soy compilation\n");
        Joiner.on((String)"\n").appendTo(sb, this.errors);
        return sb.toString();
    }
}

