/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy;

import com.google.common.base.Function;
import com.google.common.collect.ImmutableMap;
import com.google.common.io.Files;
import com.google.inject.Injector;
import com.google.template.soy.MainClassUtils;
import com.google.template.soy.SoyFileSet;
import com.google.template.soy.base.SoySyntaxException;
import com.google.template.soy.basetree.SyntaxVersion;
import com.google.template.soy.pysrc.SoyPySrcOptions;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.kohsuke.args4j.Argument;
import org.kohsuke.args4j.CmdLineParser;
import org.kohsuke.args4j.Option;

public final class SoyToPySrcCompiler {
    private static final String USAGE_PREFIX = "Usage:\njava com.google.template.soy.SoyToPySrcCompiler  \\\n     [<flag1> <flag2> ...] --outputPathFormat <formatString>  \\\n     --runtimePath <runtimeModulePath>  \\\n     --srcs <soyFilePath>,... [--deps <soyFilePath>,...]\n";
    @Option(name="--srcs", usage="The list of source Soy files. Extra arguments are treated as srcs. Sources are required from either this flag or as extra arguments.", handler=MainClassUtils.StringListOptionHandler.class)
    private List<String> srcs = new ArrayList<String>();
    @Option(name="--runtimePath", required=true, usage="[Required] The module path used to find the python runtime libraries. This should be in dot notation format.")
    private String runtimePath = "";
    @Option(name="--environmentModulePath", usage="A custom python module which will override the environment.py module if custom functionality is required for interacting with your runtime environment. This module must implement all functions of the environment module if provided.")
    private String environmentModulePath = "";
    @Option(name="--inputPrefix", usage="If provided, this path prefix will be prepended to each input file path listed on the command line. This is a literal string prefix, so you'll need to include a trailing slash if necessary.")
    private String inputPrefix = "";
    @Option(name="--deps", usage="The list of dependency Soy files (if applicable). The compiler needs deps for analysis/checking, but will not generate code for dep files.", handler=MainClassUtils.StringListOptionHandler.class)
    private List<String> deps = new ArrayList<String>();
    @Option(name="--indirectDeps", usage="Soy files required by deps, but which may not be used by srcs.", handler=MainClassUtils.StringListOptionHandler.class)
    private List<String> indirectDeps = new ArrayList<String>();
    @Option(name="--outputPathFormat", required=true, usage="[Required] A format string that specifies how to build the path to each output file. There will be one output Python file (UTF-8) for each input Soy file. The format string can include literal characters as well as the placeholders {INPUT_PREFIX}, {INPUT_DIRECTORY}, {INPUT_FILE_NAME}, and {INPUT_FILE_NAME_NO_EXT}. Additionally periods are not allowed in the outputted filename outside of the final py extension.")
    private String outputPathFormat = "";
    @Option(name="--translationClass", usage="The full class name of the python runtime translation class. The name should include the absolute module path and class name in dot notation format (e.g. \"my.package.module.TranslatorClass\"). It is required for {msg} command.")
    private String translationClass = "";
    @Option(name="--bidiIsRtlFn", usage="The full name of a function used to determine if bidi is rtl for setting global directionality. The name should include the absolute module path and functionname in dot notation format (e.g. \"my.app.bidi.is_rtl\"). Only applicable if your Soy code uses bidi functions/directives.")
    private String bidiIsRtlFn = "";
    @Option(name="--syntaxVersion", usage="User-declared syntax version for the Soy file bundle (e.g. 2.2, 2.3).")
    private String syntaxVersion = "";
    @Option(name="--namespaceManifestPath", usage="A list of paths to a manifest file which provides a map of soy namespaces to their Python paths. If this is provided, direct imports will be used, drastically improving runtime performance.", handler=MainClassUtils.StringListOptionHandler.class)
    private List<String> namespaceManifestPaths = new ArrayList<String>();
    @Option(name="--outputNamespaceManifest", usage="Output a manifest file containing a map of all soy namespaces to their Python paths.", handler=MainClassUtils.BooleanOptionHandler.class)
    private boolean outputNamespaceManifest = false;
    @Option(name="--compileTimeGlobalsFile", usage="The path to a file containing the mappings for global names to be substituted at compile time. Each line of the file should have the format \"<global_name> = <primitive_data>\" where primitive_data is a valid Soy expression literal for a primitive type (null, boolean, integer, float, or string). Empty lines and lines beginning with \"//\" are ignored. The file should be encoded in UTF-8. If you need to generate a file in this format from Java, consider using the utility SoyUtils.generateCompileTimeGlobalsFile().")
    private String compileTimeGlobalsFile = "";
    @Option(name="--pluginModules", usage="Specifies the full class names of Guice modules for function plugins and print directive plugins (comma-delimited list).")
    private String pluginModules = "";
    @Argument
    private List<String> arguments = new ArrayList<String>();

    public static void main(final String[] args) throws IOException, SoySyntaxException {
        MainClassUtils.run(new MainClassUtils.Main(){

            @Override
            public void main() throws IOException {
                new SoyToPySrcCompiler().execMain(args);
            }
        });
    }

    private SoyToPySrcCompiler() {
    }

    private void execMain(String[] args) throws IOException {
        final CmdLineParser cmdLineParser = MainClassUtils.parseFlags(this, args, USAGE_PREFIX);
        Function<String, Void> exitWithErrorFn = new Function<String, Void>(){

            public Void apply(String errorMsg) {
                MainClassUtils.exitWithError(errorMsg, cmdLineParser, SoyToPySrcCompiler.USAGE_PREFIX);
                return null;
            }
        };
        if (this.runtimePath.length() == 0) {
            exitWithErrorFn.apply((Object)"Must provide the Python runtime library path.");
        }
        if (this.outputPathFormat.length() == 0) {
            exitWithErrorFn.apply((Object)"Must provide the output path format.");
        }
        Injector injector = MainClassUtils.createInjectorForPlugins(this.pluginModules);
        SoyFileSet.Builder sfsBuilder = (SoyFileSet.Builder)injector.getInstance(SoyFileSet.Builder.class);
        MainClassUtils.addSoyFilesToBuilder(sfsBuilder, this.inputPrefix, this.srcs, this.arguments, this.deps, this.indirectDeps, exitWithErrorFn);
        if (this.syntaxVersion.length() > 0) {
            SyntaxVersion parsedVersion = SyntaxVersion.forName(this.syntaxVersion);
            if (parsedVersion.num < SyntaxVersion.V2_0.num) {
                exitWithErrorFn.apply((Object)"Declared syntax version must be 2.0 or greater.");
            }
            sfsBuilder.setDeclaredSyntaxVersionName(this.syntaxVersion);
        }
        sfsBuilder.setAllowExternalCalls(false);
        sfsBuilder.setStrictAutoescapingRequired(true);
        if (this.compileTimeGlobalsFile.length() > 0) {
            sfsBuilder.setCompileTimeGlobals(new File(this.compileTimeGlobalsFile));
        }
        SoyFileSet sfs = sfsBuilder.build();
        ImmutableMap<String, String> manifest = this.loadNamespaceManifest(this.namespaceManifestPaths, exitWithErrorFn);
        if (!manifest.isEmpty() && !this.outputNamespaceManifest) {
            exitWithErrorFn.apply((Object)"Namespace manifests provided without outputting a new manifest.");
        }
        SoyPySrcOptions pySrcOptions = new SoyPySrcOptions(this.runtimePath, this.environmentModulePath, this.bidiIsRtlFn, this.translationClass, manifest, this.outputNamespaceManifest);
        sfs.compileToPySrcFiles(this.outputPathFormat, this.inputPrefix, pySrcOptions);
    }

    private ImmutableMap<String, String> loadNamespaceManifest(List<String> namespaceManifestPaths, Function<String, Void> exitWithErrorFn) {
        if (namespaceManifestPaths.isEmpty()) {
            return ImmutableMap.of();
        }
        ImmutableMap.Builder manifest = new ImmutableMap.Builder();
        for (String manifestPath : namespaceManifestPaths) {
            try {
                BufferedReader manifestFile = Files.newReader((File)new File(manifestPath), (Charset)StandardCharsets.UTF_8);
                Throwable throwable = null;
                try {
                    Properties prop = new Properties();
                    prop.load(manifestFile);
                    for (String namespace : prop.stringPropertyNames()) {
                        manifest.put((Object)namespace, (Object)prop.getProperty(namespace));
                    }
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (manifestFile == null) continue;
                    if (throwable != null) {
                        try {
                            ((Reader)manifestFile).close();
                        }
                        catch (Throwable x2) {
                            throwable.addSuppressed(x2);
                        }
                        continue;
                    }
                    ((Reader)manifestFile).close();
                }
            }
            catch (IOException e) {
                exitWithErrorFn.apply((Object)("Unable to read the namespaceManifest file at " + manifestPath));
            }
        }
        return manifest.build();
    }
}

