/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy;

import com.google.common.annotations.Beta;
import com.google.template.soy.AbstractSoyCompiler;
import com.google.template.soy.SoyFileSet;
import com.google.template.soy.base.SoySyntaxException;
import com.google.template.soy.jssrc.SoyJsSrcOptions;
import java.io.IOException;
import org.kohsuke.args4j.Option;

@Beta
public final class SoyToIncrementalDomSrcCompiler
extends AbstractSoyCompiler {
    @Option(name="--outputPathFormat", required=true, usage="[Required] A format string that specifies how to build the path to each output file. If not generating localized JS, then there will be one output JS file (UTF-8) for each input Soy file. If generating localized JS, then there will be one output JS file for each combination of input Soy file and locale. The format string can include literal characters as well as the placeholders {INPUT_PREFIX}, {INPUT_DIRECTORY}, {INPUT_FILE_NAME}, {INPUT_FILE_NAME_NO_EXT}, {LOCALE}, {LOCALE_LOWER_CASE}. Note {LOCALE_LOWER_CASE} also turns dash into underscore, e.g. pt-BR becomes pt_br.")
    private String outputPathFormat;

    public static void main(String[] args) throws IOException, SoySyntaxException {
        new SoyToIncrementalDomSrcCompiler().run(args);
    }

    private SoyToIncrementalDomSrcCompiler() {
    }

    @Override
    void compile(SoyFileSet.Builder sfsBuilder) throws IOException {
        sfsBuilder.setAllowExternalCalls(false);
        SoyFileSet sfs = sfsBuilder.build();
        SoyJsSrcOptions jsSrcOptions = new SoyJsSrcOptions();
        jsSrcOptions.setShouldAllowDeprecatedSyntax(false);
        jsSrcOptions.setShouldProvideRequireSoyNamespaces(false);
        jsSrcOptions.setShouldProvideRequireJsFunctions(false);
        jsSrcOptions.setShouldProvideBothSoyNamespacesAndJsFunctions(false);
        jsSrcOptions.setShouldDeclareTopLevelNamespaces(false);
        jsSrcOptions.setShouldGenerateJsdoc(true);
        jsSrcOptions.setShouldGenerateGoogModules(true);
        jsSrcOptions.setShouldGenerateGoogMsgDefs(true);
        jsSrcOptions.setGoogMsgsAreExternal(true);
        jsSrcOptions.setBidiGlobalDir(0);
        jsSrcOptions.setUseGoogIsRtlForBidiGlobalDir(true);
        sfs.compileToIncrementalDomSrcFiles(this.outputPathFormat, jsSrcOptions);
    }
}

