/* Generated By:JavaCC: Do not edit this line. SoyFileParser.java */
package com.google.template.soy.soyparse;

import com.google.common.base.CharMatcher;
import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicates;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.template.soy.base.SourceLocation;
import com.google.template.soy.base.internal.IdGenerator;
import com.google.template.soy.base.internal.LegacyInternalSyntaxException;
import com.google.template.soy.base.internal.SoyFileKind;
import com.google.template.soy.base.internal.SoyFileSupplier.Version;
import com.google.template.soy.error.ErrorReporter.Checkpoint;
import com.google.template.soy.error.ErrorReporter;
import com.google.template.soy.error.SoyErrorKind;
import com.google.template.soy.exprparse.SoyParsingContext;
import com.google.template.soy.soytree.AliasDeclaration;
import com.google.template.soy.soytree.CallBasicNode;
import com.google.template.soy.soytree.CallDelegateNode;
import com.google.template.soy.soytree.CallNode;
import com.google.template.soy.soytree.CallParamContentNode;
import com.google.template.soy.soytree.CallParamNode;
import com.google.template.soy.soytree.CallParamValueNode;
import com.google.template.soy.soytree.CssNode;
import com.google.template.soy.soytree.DebuggerNode;
import com.google.template.soy.soytree.ForNode;
import com.google.template.soy.soytree.ForeachNode;
import com.google.template.soy.soytree.IfCondNode;
import com.google.template.soy.soytree.IfElseNode;
import com.google.template.soy.soytree.IfNode;
import com.google.template.soy.soytree.LetContentNode;
import com.google.template.soy.soytree.LetNode;
import com.google.template.soy.soytree.LetValueNode;
import com.google.template.soy.soytree.LogNode;
import com.google.template.soy.soytree.MsgFallbackGroupNode;
import com.google.template.soy.soytree.MsgHtmlTagNode;
import com.google.template.soy.soytree.MsgNode;
import com.google.template.soy.soytree.MsgPlaceholderNode;
import com.google.template.soy.soytree.MsgPluralCaseNode;
import com.google.template.soy.soytree.MsgPluralDefaultNode;
import com.google.template.soy.soytree.MsgPluralNode;
import com.google.template.soy.soytree.MsgSelectCaseNode;
import com.google.template.soy.soytree.MsgSelectDefaultNode;
import com.google.template.soy.soytree.MsgSelectNode;
import com.google.template.soy.soytree.NameAttributePair;
import com.google.template.soy.soytree.NamespaceDeclaration;
import com.google.template.soy.soytree.PrintDirectiveNode;
import com.google.template.soy.soytree.PrintNode;
import com.google.template.soy.soytree.RawTextNode;
import com.google.template.soy.soytree.SoyFileNode;
import com.google.template.soy.soytree.SoyNode.MsgPlaceholderInitialNode;
import com.google.template.soy.soytree.SoyNode.StandaloneNode;
import com.google.template.soy.soytree.SoyNode.StatementNode;
import com.google.template.soy.soytree.SwitchCaseNode;
import com.google.template.soy.soytree.SwitchDefaultNode;
import com.google.template.soy.soytree.SwitchNode;
import com.google.template.soy.soytree.TemplateBasicNodeBuilder;
import com.google.template.soy.soytree.TemplateDelegateNodeBuilder;
import com.google.template.soy.soytree.TemplateNode.SoyFileHeaderInfo;
import com.google.template.soy.soytree.TemplateNode;
import com.google.template.soy.soytree.TemplateNodeBuilder.DeclInfo;
import com.google.template.soy.soytree.TemplateNodeBuilder;
import com.google.template.soy.soytree.XidNode;
import com.google.template.soy.types.SoyTypeRegistry;

import java.io.*;
import java.util.*;
import java.util.regex.*;


/**
 * This parser's specification is in SoyFileParser.jj, which is read by JavaCC and transformed
 * into SoyFileParser.java. To modify this parser, please edit SoyFileParser.jj. Do not edit
 * SoyFileParser.java directly.
 *
 * <p> Important: Do not use outside of Soy code (treat as superpackage-private).
 *
 * <pre>
 * This parser parses the following Soy file structure:
 *
 * 1. Delegate package (delpackage):
 *    + Optional.
 *    + The file must contain 0 or 1 delpackage declaration.
 *    + It must appear before the namespace declaration.
 *    + It must appear on its own line and start at the start of a line.
 *    Example:  {delpackage MySecretFeature}
 *
 * 2. Namespace:
 *    + The file must contain exactly one namespace declaration.
 *    + It must appear before any templates.
 *    + It must appear on its own line and start at the start of a line.
 *    Examples:
 *    {namespace boo.foo}
 *    {namespace boo.foo autoescape="..."}
 *
 * 3. Alias:
 *    + Alias declarations must appear after the namespace declaration.
 *    + They must appear before any templates.
 *    + Each must appear on its own line and start at the start of a line.
 *    Examples:
 *    {alias boo.foo.goo.moo}
 *    {alias boo.foo.goo.moo as zoo}
 *
 * 4. SoyDoc:
 *    + Starts with slash-star-star (/**) and ends with star-slash (*&#47;) like JavaDoc.
 *    + SoyDoc must appear on its own line(s) and start at the start of a line.
 *    + Currently recognizes two tags: "&#64;param keyName" and "&#64;param? optionalKeyName".
 *    Example:
 *    /**
 *     * &#64;param boo Something scary.
 *     * &#64;param? goo Something slimy (optional).
 *     *&#47;
 *
 * 5. Template:
 *    + Each template must be immediately preceded by a SoyDoc block.
 *    + The 'template' tag and the '/template' tag much each appear on its own line(s) and start
 *      at the start of a line.
 *    + The template content is parsed by TemplateParser.jj.
 *    Examples:
 *    /**
 *     * New style.
 *     * &#64;param boo Something scary.
 *     * &#64;param? goo Something slimy (optional).
 *     *&#47;
 *    {template .foo autoescape="..."}
 *      {msg desc=""}
 *        {$boo} has a friend named {$goo.firstName}.
 *      {/msg}
 *    {/template}
 *
 * 6. Misc:
 *    + Other than the items specified above, everything else is ignored.
 *    + SoyDoc blocks not immediately followed by a template are ignored.
 *    + The file must end with a newline.
 *
 * Template contents are parsed as follows:
 * Header:
 *
 * 1. Comments:
 *    + Comments are only allowed outside of Soy tags.
 *    + Standard "//" for a rest-of-line comment. Must appear at start of line or after a space.
 *    + Standard slash-star (/*) ... star-slash (*&#47;) for a block comment.
 *    + Doc comments are not allowed, except when attached to a valid declaration.
 *
 * 2. Param declaration:
 *    + Soy tag with command name "@param" and command text "key: type".
 *    + Optional desc string is written as a block doc comment, which either must
 *      precede the param tag, or must start on the same line as the end of the '@param' tag.
 *    + Examples:
 *    {@param foo: bool}
 *    {@param foo: list<int>}  /** A list of numbers. *&#47;
 *    {@param? foo:
 *        list<int>}  /**
 *        A list of numbers. *&#47;
 *
 * 3. Injected param declaration:
 *    + Works exactly like @param except that parameter values are taken from the
 *      implicit $ij scope.
 *    + Soy tag with command name "@inject" and command text "key: type".
 *    + Optional desc string is written as a block doc comment, which either must
 *      precede the param tag, or must start on the same line as the end of the '@inject' tag.
 *    + Examples:
 *    {@inject foo: bool}
 *    {@inject foo: list<int>}  /** A list of numbers. *&#47;
 *    {@inject? foo:
 *        list<int>}  /**
 *        A list of numbers. *&#47;
 *
 * Body:
 *
 * 1. Soy tag format:
 *    + Can be delimited by single braces "{...}".
 *    + } characters are only allowed in tags if they're inside string literals.
 *    + Some Soy tags are allowed to end in "/}" to denote immediate ending of a block.
 *    + It is an error to use "/}" when it's not applicable to the command.
 *    + If there is a command name, it must come immediately after the opening delimiter.
 *    + The command name must be followed by either the closing delimiter (if the command does not
 *      take any command text) or a whitespace (if the command takes command text).
 *    + It is an error to provide command text when it's not applicable, and vice versa.
 *    + This parser does not parse command text (that will be separate).
 *    Examples:
 *    {print $boo}   // explicit 'print' command
 *    {$boo.foo}   // implicit 'print' command
 *    {printer}   // implicit 'print' command (the prefix 'print' here is not a command name)
 *    {\n}   // a command that doesn't take any command text
 *    {call .gooMoo data="all" /}   // self-ending block
 *    {call .gooMoo data="all"}...{/call}   // block with separate start and end tags
 *
 * 2. Raw text:
 *    + Raw text is fixed text that will be part of the template output. There are 3 types.
 *    + Any text outside of Soy tags is raw text.
 *    + There are 7 special character commands that produce raw text strings:
 *      {sp} = space   {nil} = empty string   {\n} = newline (line feed)   {\r} = carriage return
 *      {\t} = tab   {lb} = left brace   {rb} = right brace
 *    + A section of raw text (may contain braces) can be enclosed within a 'literal' block:
 *      {literal}...{/literal}
 *
 * 3. Msg blocks:
 *    + A block between 'msg' and '/msg' tags represents a message for translation.
 *    + It is an error to nest 'msg' blocks.
 *    + Within a 'msg' block, the parsing of Soy tags is the same. The only difference is that we
 *      also recognize "&lt;" and "&gt;" as opening and closing an HTML tag. This is because each
 *      HTML tag as a whole needs to be turned into a single placeholder in the message.
 *    + A 'msg' block may have a 'plural' or 'select' block as its only content.
 *    + A 'msg' block may be followed by optional additional 'fallbackmsg' blocks.
 *    Example:
 *    {msg desc="Event title."}
 *      Join event &lt;a href="{$event.url}"&gt;{$event.title}&lt;/a&gt;.
 *    {fallbackmsg desc="Event title."}
 *      Join event {$event.title}.
 *    {/msg}
 *
 * 4. Other Soy commands:
 *    {print ...}
 *    {...}    // implied 'print' command
 *    {xid ...}
 *    {css ...}
 *    {let ... /}
 *    {let ...}...{/let}
 *    {if ...}...{elseif ...}...{else ...}...{/if}
 *    {switch ...}{case ...}...{default}...{/switch}
 *    {foreach ...}...{ifempty}...{/foreach}
 *    {for ...}...{/for}
 *    {call ... /}
 *    {delcall ... /}
 *    {call ...}{param ... /}{param ...}...{/param}{/call}
 *    {delcall ...}{param ... /}{param ...}...{/param}{/delcall}
 *    {log}...{/log}
 *    {debugger}
 *
 * 5. Misc:
 *    + The following commands are not allowed to appear in a template:
 *      {namespace ...}   {template ...}   {/template}
 * </pre>
 *
 * <p>TODO(lukes):  This parser has a lot of issues:
 * Too much parsing logic is handled by the AST nodes with regular expressions.  This is probably
 * slower than handling it in the parser and it leads to redundant error handling code.
 *
 */
public class SoyFileParser implements SoyFileParserConstants {
  // Template parser regexes:
  /** Regex string used in patterns below. Note the first set of spaces is reluctant. */
  private static final String LINE_BOUNDARY_REGEX = "\u005c\u005cs*?(\u005c\u005cn|\u005c\u005cr)\u005c\u005cs*";

  /** Pattern for a line boundary. */
  private static final Pattern LINE_BOUNDARY_PATTERN = Pattern.compile(LINE_BOUNDARY_REGEX);

  /** Pattern for a line boundary appearing at the start edge of the string being matched. */
  private static final Pattern START_EDGE_LINE_BOUNDARY_PATTERN =
      Pattern.compile("^" + LINE_BOUNDARY_REGEX);

  /** Pattern for a line boundary appearing at the end edge of the string being matched. */
  private static final Pattern END_EDGE_LINE_BOUNDARY_PATTERN =
      Pattern.compile(LINE_BOUNDARY_REGEX + "$");

  /** Pattern for a line boundary not appearing at either edge of the string being matched. */
  private static final Pattern NONEDGE_LINE_BOUNDARY_PATTERN =
      Pattern.compile("(?<=\u005c\u005cS)" + LINE_BOUNDARY_REGEX + "(?=\u005c\u005cS)");

  static class RegexFromTokenImageFunction implements Function<String, String> {
    @Override public String apply(String o) {
      // Strip the surrounding quotes and braces.
      return Pattern.quote(o.substring(2, o.length() - 2));
    }
  };
  /** Pattern for invalid implicit print prefixes (used to throw errors for invalid commands). */
  private static final Pattern INVALID_PRINT_PREFIX_PATTERN = Pattern.compile(
      // tokenImage contains token names for error messages. For literal tokens, it stores the token
      // value as-is, wrapped in quotes. Use this to extract simple token names without duplication.
      "^(" + Joiner.on("|").join(FluentIterable.from(Arrays.asList(tokenImage))
              .filter(Predicates.containsPattern("^\u005c"\u005c\u005c{[a-z]+\u005c\u005c}\u005c"$"))
              .transform(new RegexFromTokenImageFunction()))
      + ")\u005c\u005cb.+");

  /** Pattern for invalid implicit print prefixes (used to throw errors for invalid commands). */
  private static final Pattern INVALID_PRINT_FILE_PREFIX_PATTERN = Pattern.compile(
      "^(namespace|(del)?template|typedef|alias)\u005c\u005cb.*");


  private static final SoyErrorKind UNCATEGORIZED = SoyErrorKind.of("In file {0}, template {1}: {2}");

  private static final SoyErrorKind MISMATCHED_CLOSING_TAG =
      SoyErrorKind.of("''{0}'' has mismatched closing tag ''{1}''.");

  // Template errors:
  private static final SoyErrorKind UNEXPECTED_CLOSING_TAG =
      SoyErrorKind.of("Unexpected closing tag ''{0}''.");

  private static final SoyErrorKind FOUND_DOUBLE_BRACE =
      SoyErrorKind.of("Soy '{{command}}' syntax is no longer supported.  Use single braces.");

  private static final SoyErrorKind INVALID_DECLARATION =
      SoyErrorKind.of("Invalid declaration ''{0}''.");

  private static final SoyErrorKind INVALID_PRINT_PREFIX =
      SoyErrorKind.of("Command ''{0}'' cannot have arguments.");

  private static final SoyErrorKind INVALID_PRINT_FILE_COMMAND =
      SoyErrorKind.of("Command ''{0}'' cannot appear in templates.");

  private static final SoyErrorKind PLURAL_AND_SELECT_NOT_ALLOWED_INSIDE_PLURAL_BLOCK =
      SoyErrorKind.of("Tags ''plural'' and ''select'' are not allowed inside ''plural'' blocks.");

  private static final SoyErrorKind MULTIPLE_PHNAME_ATTRIBUTES_IN_COMMAND = SoyErrorKind.of(
      "Found multiple ''phname'' attributes in ''{0}'' command text \u005c"{1}\u005c".");

  private static final SoyErrorKind PRINT_COMMAND_WITH_EMPTY_TEXT =
      SoyErrorKind.of("Found ''print'' command with empty command text.");

  private static final SoyErrorKind INVALID_PRINT_COMMAND_TEXT =
      SoyErrorKind.of("Invalid ''print'' command text \u005c"{0}\u005c" (check the directives).");


  /** Type registry for resolving type names. */
  private SoyTypeRegistry typeRegistry;

  /** Node id generator for the tree being built. */
  private IdGenerator nodeIdGen;

  /** The kind of this Soy file. */
  private SoyFileKind soyFileKind;

  /** Path of source being parsed. This is descriptive, not a means to refetch source. */
  private String filePath;

  private ErrorReporter errorReporter;

  /** Can only be used in templates. */
  private SoyParsingContext context;

  /**
   * Constructor that takes a reader object providing the input.
   * @param typeRegistry The type registry for resolving type names.
   * @param nodeIdGen The node id generator for the tree being built.
   * @param input The input to parse.
   * @param soyFileKind The kind of this Soy file.
   * @param filePath The path of the source being parsed. Used for reporting.
   * @param errorReporter For reporting parse errors.
   */
  public SoyFileParser(
      SoyTypeRegistry typeRegistry,
      IdGenerator nodeIdGen,
      Reader input,
      SoyFileKind soyFileKind,
      String filePath,
      ErrorReporter errorReporter) {
    this(input);
    Preconditions.checkNotNull(typeRegistry);
    Preconditions.checkNotNull(nodeIdGen);
    this.typeRegistry = typeRegistry;
    this.nodeIdGen = nodeIdGen;
    this.soyFileKind = soyFileKind;
    this.filePath = filePath;
    this.errorReporter = errorReporter;
  }

  /**
   * Attempts to parse the given input as a Soy file, returns null if parsing fails.
   */
  public SoyFileNode parseSoyFile() {
    Preconditions.checkNotNull(typeRegistry);
    Preconditions.checkNotNull(nodeIdGen);
    Checkpoint checkpoint = errorReporter.checkpoint();
    SoyFileNode soyFileNode = null;
    try {
      soyFileNode = SoyFile();
    } catch (ParseException e) {
      ParseErrors.reportSoyFileParseException(errorReporter, filePath, e);
    } catch (LegacyInternalSyntaxException e) {
      ParseErrors.report(errorReporter, filePath, e);
    } catch (TokenMgrError e) {
      // Should only happen if we make a mistake in the token manager.
      // TODO(lukes): Make sure this really never happens, then remove the catch block.
      ParseErrors.reportUnexpected(errorReporter, filePath, e);
    }
    // our callers expect us to return null when encountering parsing errors.
    if (errorReporter.errorsSince(checkpoint)) {
      return null;
    }
    return soyFileNode;
  }

  private <T> SourceItemInfo<T> newSourceItemInfo(T parsed, Token token) {
    return newSourceItemInfo(
        parsed, token.beginLine, token.beginColumn, token.endLine, token.endColumn);
  }
  private <T> SourceItemInfo<T> newSourceItemInfo(T parsed, Token begin, Token end) {
    return newSourceItemInfo(
        parsed, begin.beginLine, begin.beginColumn, end.endLine, end.endColumn);
  }

  private <T> SourceItemInfo<T> newSourceItemInfo(T parsed, SourceItemInfo<?> begin,
      SourceItemInfo<?> end) {
    return new SourceItemInfo<T>(parsed, begin, end);
  }

  private <T> SourceItemInfo<T> newSourceItemInfo(
      T parsed, int lineNum, int columnNum, int lineNumEnd, int columnNumEnd) {
    return new SourceItemInfo<T>(filePath, parsed,
        lineNum, columnNum,
        lineNumEnd, columnNumEnd);
  }


  private SourceLocation createSrcLoc(Token tok1, Token ...rest) {
    return Tokens.createSrcLoc(filePath, tok1, rest);
  }

  final private SoyFileNode SoyFile() throws ParseException {
  TemplateNode template;
  String delpackageName = null;
  NamespaceDeclaration namespace = NamespaceDeclaration.NULL;
  List<TemplateNode> templates = new ArrayList<TemplateNode>();
  List<AliasDeclaration> aliases = new ArrayList<AliasDeclaration>();
  AliasDeclaration alias = null;
  // note we generate the id first to avoid having to edit every test that asserts on node ids.
  int id = nodeIdGen.genId();
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case DELPACKAGE_OPEN:
      delpackageName = DelPackage();
      break;
    default:
      jj_la1[0] = jj_gen;
      ;
    }
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case NAMESPACE_OPEN:
      namespace = Namespace();
      break;
    default:
      jj_la1[1] = jj_gen;
      ;
    }
    label_1:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case ALIAS_OPEN:
        ;
        break;
      default:
        jj_la1[2] = jj_gen;
        break label_1;
      }
      alias = Alias();
      aliases.add(alias);
    }
    SoyFileHeaderInfo soyFileHeaderInfo = new SoyFileHeaderInfo(errorReporter,
      delpackageName, namespace, aliases);
    context = SoyParsingContext.create(errorReporter, soyFileHeaderInfo.namespace,
        soyFileHeaderInfo.aliasToNamespaceMap);
    label_2:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case DELTEMPLATE_OPEN:
      case TEMPLATE_OPEN:
        ;
        break;
      default:
        jj_la1[3] = jj_gen;
        break label_2;
      }
      try {
        template = Template(soyFileHeaderInfo);
        templates.add(template);
      } catch (ParseException e) {
      ParseErrors.reportSoyFileParseException(errorReporter, filePath, e);
      consumeUntilTemplateClose();
      } catch (SoyFileParserTokenManager.PoisonTokenException e) {
      errorReporter.report(createSrcLoc(e.token), SoyErrorKind.of("{0}"), e.message);
      consumeUntilTemplateClose();
      // TODO(slaks): Also check the the close token matches open?

      }
    }
    jj_consume_token(0);
    SoyFileNode sfn =
        new SoyFileNode(
            id,
            filePath,
            soyFileKind,
            namespace,
            soyFileHeaderInfo);
    sfn.addChildren(templates);
    {if (true) return sfn;}
    throw new Error("Missing return statement in function");
  }

  final private AliasDeclaration Alias() throws ParseException {
  Token open, namespace, close;
  Token alias = null, as = null;
    open = jj_consume_token(ALIAS_OPEN);
    namespace = jj_consume_token(DOTTED_IDENT);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case AS:
      as = jj_consume_token(AS);
      alias = jj_consume_token(DOTTED_IDENT);
      break;
    default:
      jj_la1[4] = jj_gen;
      ;
    }
    close = jj_consume_token(RBRACE);
    {if (true) return alias == null
        ? new AliasDeclaration(
            namespace.image,
            errorReporter,
            createSrcLoc(open, namespace, close))
        : new AliasDeclaration(
            namespace.image,
            alias.image,
            errorReporter,
            createSrcLoc(open, namespace, as, alias, close));}
    throw new Error("Missing return statement in function");
  }

  final private NamespaceDeclaration Namespace() throws ParseException {
  Token open, name, close;
  NameAttributePair attr;
  List<NameAttributePair> attributes = new ArrayList<NameAttributePair>();
    open = jj_consume_token(NAMESPACE_OPEN);
    name = jj_consume_token(DOTTED_IDENT);
    label_3:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case CSSBASE:
      case AUTOESCAPE:
      case REQUIRECSS:
        ;
        break;
      default:
        jj_la1[5] = jj_gen;
        break label_3;
      }
      attr = Attribute();
      attributes.add(attr);
    }
    close = jj_consume_token(RBRACE);
    {if (true) return new NamespaceDeclaration(name.image, attributes, errorReporter);}
    throw new Error("Missing return statement in function");
  }

  final private NameAttributePair Attribute() throws ParseException {
  Token name;
  Token eq;
  Token value;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case AUTOESCAPE:
      name = jj_consume_token(AUTOESCAPE);
      break;
    case REQUIRECSS:
      name = jj_consume_token(REQUIRECSS);
      break;
    case CSSBASE:
      name = jj_consume_token(CSSBASE);
      break;
    default:
      jj_la1[6] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    eq = jj_consume_token(EQ);
    value = jj_consume_token(ATTRIBUTE_VALUE);
    {if (true) return new NameAttributePair(
        name.image,
        // trim quotes off the token
        value.image.substring(1, value.image.length() - 1),
        createSrcLoc(name, eq, value));}
    throw new Error("Missing return statement in function");
  }

  final private String DelPackage() throws ParseException {
  Token name;
    jj_consume_token(DELPACKAGE_OPEN);
    name = jj_consume_token(DOTTED_IDENT);
    jj_consume_token(RBRACE);
    {if (true) return name.image;}
    throw new Error("Missing return statement in function");
  }

  final private TemplateNode Template(SoyFileHeaderInfo soyFileHeaderInfo) throws ParseException {
  Token open, close;
  boolean isBasicTemplate;
  List<DeclInfo> templateHeaderDecls = null;
  List<StandaloneNode> templateBodyNodes = null;
  String openTagName;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case TEMPLATE_OPEN:
      open = jj_consume_token(TEMPLATE_OPEN);
          isBasicTemplate = true;
      break;
    case DELTEMPLATE_OPEN:
      open = jj_consume_token(DELTEMPLATE_OPEN);
          isBasicTemplate = false;
      break;
    default:
      jj_la1[7] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    SourceLocation srcLocation = createSrcLoc(open);

    TemplateNodeBuilder templateNodeBuilder = isBasicTemplate
        ? new TemplateBasicNodeBuilder(
            soyFileHeaderInfo, srcLocation, errorReporter, typeRegistry)
        : new TemplateDelegateNodeBuilder(
            soyFileHeaderInfo, srcLocation, errorReporter, typeRegistry);

    templateNodeBuilder.setId(nodeIdGen.genId());

    // --- Set the command text. ---
    // trim the leading tag name and the trailing '}'
    openTagName = open.image.substring(0, isBasicTemplate ? 10 : 13);
    String cmdText = open.image.substring(openTagName.length(), open.image.length() - 1);
    templateNodeBuilder.setCmdText(cmdText);

    // --- Set the SoyDoc. ---
    // special tokens are accessible from the non-special tokens that come after them.
    Token soyDoc = open.specialToken;
    if (soyDoc != null && soyDoc.kind == SOYDOC) {
      templateNodeBuilder.setSoyDoc(soyDoc.image);
    } else {
      templateNodeBuilder.setSoyDoc(null);
    }
    if (jj_2_1(2147483647)) {
      templateHeaderDecls = TemplateHeader();
      templateNodeBuilder.setHeaderDecls(templateHeaderDecls);
    } else {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case BLOCK_NONDOC_COMMENT:
      case TOKEN_WS_NOT_NL:
        HeaderConsecWsNoNl();
        break;
      default:
        jj_la1[8] = jj_gen;
        ;
      }
    }
    // Next, parse the actual content.
      templateBodyNodes = TemplateBlock();
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case CMD_CLOSE_TEMPLATE:
      close = jj_consume_token(CMD_CLOSE_TEMPLATE);
          if (!isBasicTemplate) {
            errorReporter.report(createSrcLoc(close), MISMATCHED_CLOSING_TAG,
                openTagName + templateNodeBuilder.getTemplateNameForUserMsgs(), close.image);
          }
      break;
    case CMD_CLOSE_DELTEMPLATE:
      close = jj_consume_token(CMD_CLOSE_DELTEMPLATE);
          if (isBasicTemplate) {
            errorReporter.report(createSrcLoc(close), MISMATCHED_CLOSING_TAG,
                openTagName + templateNodeBuilder.getTemplateNameForUserMsgs(), close.image);
          }
      break;
    default:
      jj_la1[9] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    TemplateNode templateNode = templateNodeBuilder.build();
    if (templateBodyNodes != null) {
        templateNode.addChildren(templateBodyNodes);
    }
    {if (true) return templateNode;}
    throw new Error("Missing return statement in function");
  }

  private void consumeUntilTemplateClose() throws ParseException {
  token_source.SwitchTo(TEMPLATE_DEFAULT_NOT_SOL);
  Token t = null;
  do {
    // Ignore errors from the tokens we consume.
    try {
      t = getNextToken();
    } catch (SoyFileParserTokenManager.PoisonTokenException e) {}
  } while (t == null || // Ignore other posion tokens
      (t.kind != EOF && t.kind != CMD_CLOSE_TEMPLATE && t.kind != CMD_CLOSE_DELTEMPLATE));
  }

  final private String CmdText() throws ParseException {
  List<String> cmdTextParts;
    cmdTextParts = CmdTextParts();
    {if (true) return Joiner.on("").join(cmdTextParts);}
    throw new Error("Missing return statement in function");
  }

  final private List<String> CmdTextParts() throws ParseException {
  Token cmdTextChar;
  Token cmdTextSpecialPart;
    List<String> cmdTextParts = Lists.newArrayList();
    StringBuilder currCmdTextPartSb = new StringBuilder();
    label_4:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case CMD_TEXT_DIRECTIVE_NAME:
      case CMD_TEXT_PHNAME_ATTR:
      case CMD_TEXT_ARBITRARY_TOKEN:
        ;
        break;
      default:
        jj_la1[10] = jj_gen;
        break label_4;
      }
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case CMD_TEXT_ARBITRARY_TOKEN:
        cmdTextChar = jj_consume_token(CMD_TEXT_ARBITRARY_TOKEN);
                                                 currCmdTextPartSb.append(cmdTextChar.image);
        break;
      case CMD_TEXT_DIRECTIVE_NAME:
      case CMD_TEXT_PHNAME_ATTR:
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case CMD_TEXT_DIRECTIVE_NAME:
          cmdTextSpecialPart = jj_consume_token(CMD_TEXT_DIRECTIVE_NAME);
          break;
        case CMD_TEXT_PHNAME_ATTR:
          cmdTextSpecialPart = jj_consume_token(CMD_TEXT_PHNAME_ATTR);
          break;
        default:
          jj_la1[11] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
        // Add the preceding part if nonempty.
        if (currCmdTextPartSb.length() > 0) {
          cmdTextParts.add(currCmdTextPartSb.toString());
          currCmdTextPartSb = new StringBuilder();
        }
        // Add the special part.
        cmdTextParts.add(cmdTextSpecialPart.image);
        break;
      default:
        jj_la1[12] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
    // Add the last part if nonempty.
    if (currCmdTextPartSb.length() > 0) {
      cmdTextParts.add(currCmdTextPartSb.toString());
      currCmdTextPartSb = new StringBuilder();
    }

    // Process whitespace.
    // TODO(user): this is the beginning of a code path that should be eliminated.
    // These trimmed command strings are typically passed into Node constructors and then
    // re-passed into the expression parser for further parsing. The trimming and re-parsing
    // makes it hard to reconstruct accurate source location information for expression trees.
    // This file should be the source of truth for all source location information in Soy.
    for (int i = 0, n = cmdTextParts.size(); i < n; i++) {
      String cmdTextPart = cmdTextParts.get(i);
      if (i == 0) {
        cmdTextPart = CharMatcher.whitespace().trimLeadingFrom(cmdTextPart);
      }
      if (i == n - 1) {
        cmdTextPart = CharMatcher.whitespace().trimTrailingFrom(cmdTextPart);
      }
      cmdTextPart = LINE_BOUNDARY_PATTERN.matcher(cmdTextPart).replaceAll(" ");
      cmdTextParts.set(i, cmdTextPart);
    }

    {if (true) return cmdTextParts;}
    throw new Error("Missing return statement in function");
  }

  final private void HeaderConsecWsNoNl() throws ParseException {
    label_5:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case TOKEN_WS_NOT_NL:
        jj_consume_token(TOKEN_WS_NOT_NL);
        break;
      case BLOCK_NONDOC_COMMENT:
        jj_consume_token(BLOCK_NONDOC_COMMENT);
        break;
      default:
        jj_la1[13] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case BLOCK_NONDOC_COMMENT:
      case TOKEN_WS_NOT_NL:
        ;
        break;
      default:
        jj_la1[14] = jj_gen;
        break label_5;
      }
    }
  }

  final private void HeaderConsecWs() throws ParseException {
    label_6:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case TOKEN_NL:
        jj_consume_token(TOKEN_NL);
        break;
      case TOKEN_WS_NOT_NL:
        jj_consume_token(TOKEN_WS_NOT_NL);
        break;
      case BLOCK_NONDOC_COMMENT:
        jj_consume_token(BLOCK_NONDOC_COMMENT);
        break;
      default:
        jj_la1[15] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case BLOCK_NONDOC_COMMENT:
      case TOKEN_NL:
      case TOKEN_WS_NOT_NL:
        ;
        break;
      default:
        jj_la1[16] = jj_gen;
        break label_6;
      }
    }
  }

  final private Token BlockCommentToken() throws ParseException {
  Token token;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case BLOCK_DOC_COMMENT:
      token = jj_consume_token(BLOCK_DOC_COMMENT);
      break;
    case BLOCK_NONDOC_COMMENT:
      token = jj_consume_token(BLOCK_NONDOC_COMMENT);
      break;
    default:
      jj_la1[17] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    {if (true) return token;}
    throw new Error("Missing return statement in function");
  }

  final private Token BasicRawTextToken() throws ParseException {
  Token token;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case TOKEN_NL:
      token = jj_consume_token(TOKEN_NL);
      break;
    case TOKEN_WS_NOT_NL:
      token = jj_consume_token(TOKEN_WS_NOT_NL);
      break;
    case TOKEN_NOT_WS:
      token = jj_consume_token(TOKEN_NOT_WS);
      break;
    default:
      jj_la1[18] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    {if (true) return token;}
    throw new Error("Missing return statement in function");
  }

  final private SourceItemInfo<String> BasicRawText() throws ParseException {
  Token token;
    StringBuilder basicRawTextSb = new StringBuilder();
    int lineNum = -1;
    int columnNum = -1;
    label_7:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case TOKEN_NL:
      case TOKEN_WS_NOT_NL:
      case TOKEN_NOT_WS:
        token = BasicRawTextToken();
        basicRawTextSb.append(token.image);
        break;
      case BLOCK_DOC_COMMENT:
      case BLOCK_NONDOC_COMMENT:
        // Skip block comments (doc and nondoc).
              token = BlockCommentToken();
        break;
      default:
        jj_la1[19] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      if (lineNum == -1) {
        lineNum = token.beginLine;
        columnNum = token.beginColumn;
      }
      if (jj_2_2(2)) {
        ;
      } else {
        break label_7;
      }
    }
    String basicRawText = basicRawTextSb.toString();
    // TODO(lukes): Move all of this logic to RawTextNode.
    // Handle line boundaries after Soy tags (includes stripping end-of-template space since input
    // ends with a newline).
    basicRawText = START_EDGE_LINE_BOUNDARY_PATTERN.matcher(basicRawText).replaceFirst("");

    // Adjust line by counting forward for each newline removed.
    // So far, we have only removed content from the beginning of the string.
    int numSpaceCharsRemovedFromFront = basicRawTextSb.length() - basicRawText.length();
    for (int i = 0; i < numSpaceCharsRemovedFromFront; ++i) {
      char ch = basicRawTextSb.charAt(i);
       if (ch == '\u005cr') {
        if (i + 1 == numSpaceCharsRemovedFromFront || basicRawTextSb.charAt(i + 1) != '\u005cn') {
          ++lineNum;  // Only count this CR if it is not part of a CRLF.
          columnNum = 1;
        }
      } else if (ch == '\u005cn') {
        ++lineNum;
        columnNum = 1;
      }
    }

    // Handle line boundaries before Soy tags (includes stripping end-of-template space since input
    // ends with a newline).
    basicRawText = END_EDGE_LINE_BOUNDARY_PATTERN.matcher(basicRawText).replaceFirst("");

    // Handle line boundaries in the middle of the raw text. Note we have to check the characters
    // before and after because the line boundaries may be adjacent to HTML tags.
    Matcher matcher = NONEDGE_LINE_BOUNDARY_PATTERN.matcher(basicRawText);
    StringBuffer basicRawTextWithoutNewlinesSb = new StringBuffer(basicRawText.length());
    while (matcher.find()) {
      char charBefore = basicRawText.charAt(matcher.start() - 1);
      char charAfter = basicRawText.charAt(matcher.end());
      matcher.appendReplacement(
          basicRawTextWithoutNewlinesSb, (charBefore == '>' || charAfter == '<') ? "" : " ");
    }
    matcher.appendTail(basicRawTextWithoutNewlinesSb);

    {if (true) return newSourceItemInfo(
      basicRawTextWithoutNewlinesSb.toString(),
      lineNum,
      columnNum,
      token.endLine,
      token.endColumn
    );}
    throw new Error("Missing return statement in function");
  }

/**
 * Matches empty string or BasicRawText, and if the latter, then ensures it's all whitespace.
 * Used for areas that should not have any content (e.g. between 'call' and 'param' tags).
 * TODO(slaks): Change parameters to SoyErrorKind, Object...
 *
 * MaybeWhitespace -> [ BasicRawText ]
 *
 * Package visible for testing.
 */
  final public void MaybeWhitespace(String errorMessage) throws ParseException {
  SourceItemInfo<String> basicRawText;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case BLOCK_DOC_COMMENT:
    case BLOCK_NONDOC_COMMENT:
    case TOKEN_NL:
    case TOKEN_WS_NOT_NL:
    case TOKEN_NOT_WS:
      basicRawText = BasicRawText();
      if (basicRawText.parsedContent().trim().length() != 0) {
        errorReporter.report(basicRawText.srcLocation(), SoyErrorKind.of("{0}"), errorMessage);
      }
      break;
    default:
      jj_la1[20] = jj_gen;
      ;
    }
  }

  final private SourceItemInfo<String> LiteralRawText() throws ParseException {
  Token tag;
  Token literalRawTextContent;
    tag = jj_consume_token(CMD_OPEN_LITERAL);
    literalRawTextContent = jj_consume_token(LITERAL_RAW_TEXT_CONTENT);
    {if (true) return newSourceItemInfo(literalRawTextContent.image, tag);}
    throw new Error("Missing return statement in function");
  }

  final private SourceItemInfo<String> SpecialCharRawText() throws ParseException {
  Token command; String value;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case CMD_FULL_SP:
      command = jj_consume_token(CMD_FULL_SP);
                               value = " ";
      break;
    case CMD_FULL_NIL:
      command = jj_consume_token(CMD_FULL_NIL);
                               value = "";
      break;
    case CMD_FULL_CR:
      command = jj_consume_token(CMD_FULL_CR);
                               value = "\u005cr";
      break;
    case CMD_FULL_LF:
      command = jj_consume_token(CMD_FULL_LF);
                               value = "\u005cn";
      break;
    case CMD_FULL_TAB:
      command = jj_consume_token(CMD_FULL_TAB);
                               value = "\u005ct";
      break;
    case CMD_FULL_LB:
      command = jj_consume_token(CMD_FULL_LB);
                               value = "{";
      break;
    case CMD_FULL_RB:
      command = jj_consume_token(CMD_FULL_RB);
                               value = "}";
      break;
    default:
      jj_la1[21] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    {if (true) return newSourceItemInfo(value, command);}
    throw new Error("Missing return statement in function");
  }

  final private SourceItemInfo<String> ContiguousRawText() throws ParseException {
  SourceItemInfo<String> basicRawText, literalRawText, specialCharRawText;
    StringBuilder sb = new StringBuilder();
    SourceItemInfo<String> first = null;
    SourceItemInfo<String> last = null;
    label_8:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case BLOCK_DOC_COMMENT:
      case BLOCK_NONDOC_COMMENT:
      case TOKEN_NL:
      case TOKEN_WS_NOT_NL:
      case TOKEN_NOT_WS:
        basicRawText = BasicRawText();
        if (first == null) {
          first = basicRawText;
        }
        last = basicRawText;
        sb.append(basicRawText.parsedContent());
        break;
      case CMD_OPEN_LITERAL:
        literalRawText = LiteralRawText();
        if (first == null) {
          first = literalRawText;
        }
        last = literalRawText;
        sb.append(literalRawText.parsedContent());
        break;
      case CMD_FULL_SP:
      case CMD_FULL_NIL:
      case CMD_FULL_LF:
      case CMD_FULL_CR:
      case CMD_FULL_TAB:
      case CMD_FULL_LB:
      case CMD_FULL_RB:
        specialCharRawText = SpecialCharRawText();
        if (first == null) {
          first = specialCharRawText;
        }
        last = specialCharRawText;
        sb.append(specialCharRawText.parsedContent());
        break;
      default:
        jj_la1[22] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      if (jj_2_3(2)) {
        ;
      } else {
        break label_8;
      }
    }
    {if (true) return newSourceItemInfo(sb.toString(), first, last);}
    throw new Error("Missing return statement in function");
  }

  final private SourceItemInfo<String> MsgTag() throws ParseException {
  Token tagBegin, tagEnd;
  String cmdText;
    tagBegin = jj_consume_token(CMD_BEGIN_MSG);
    cmdText = CmdText();
    tagEnd = jj_consume_token(CMD_END);
    {if (true) return newSourceItemInfo(cmdText, tagBegin, tagEnd);}
    throw new Error("Missing return statement in function");
  }

  final private SourceItemInfo<String> FallbackmsgTag() throws ParseException {
  Token tagBegin, tagEnd;
  String cmdText;
    tagBegin = jj_consume_token(CMD_BEGIN_FALLBACK_MSG);
    cmdText = CmdText();
    tagEnd = jj_consume_token(CMD_END);
    {if (true) return newSourceItemInfo(cmdText, tagBegin, tagEnd);}
    throw new Error("Missing return statement in function");
  }

  final private SourceItemInfo<String> PluralTag() throws ParseException {
  Token tagBegin, tagEnd;
  String cmdText;
    tagBegin = jj_consume_token(CMD_BEGIN_PLURAL);
    cmdText = CmdText();
    tagEnd = jj_consume_token(CMD_END);
    {if (true) return newSourceItemInfo(cmdText, tagBegin, tagEnd);}
    throw new Error("Missing return statement in function");
  }

  final private SourceItemInfo<String> SelectTag() throws ParseException {
  Token tagBegin, tagEnd;
  String cmdText;
    tagBegin = jj_consume_token(CMD_BEGIN_SELECT);
    cmdText = CmdText();
    tagEnd = jj_consume_token(CMD_END);
    {if (true) return newSourceItemInfo(cmdText, tagBegin, tagEnd);}
    throw new Error("Missing return statement in function");
  }

  final private SourceItemInfo<List<String>> PrintTag() throws ParseException {
  Token tagBegin, tagEnd;
  List<String> cmdTextParts;
  List<String> printTagParts = Lists.newArrayList();
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case CMD_BEGIN_PRINT:
      tagBegin = jj_consume_token(CMD_BEGIN_PRINT);
                                    printTagParts.add("print");
      break;
    case CMD_BEGIN_IMPLICIT_PRINT:
      tagBegin = jj_consume_token(CMD_BEGIN_IMPLICIT_PRINT);
      break;
    default:
      jj_la1[23] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    cmdTextParts = CmdTextParts();
    printTagParts.addAll(cmdTextParts);
    tagEnd = jj_consume_token(CMD_END);
    if (printTagParts.isEmpty()) {
      // This error is reported in the command, to catch both {print} and {}.
    } else if (printTagParts.get(0).startsWith("/")) {
      errorReporter.report(createSrcLoc(tagBegin, tagEnd), UNEXPECTED_CLOSING_TAG,
          "{" + Joiner.on("").join(printTagParts) + "}");
    } else if (printTagParts.get(0).startsWith("@")) {
      errorReporter.report(createSrcLoc(tagBegin, tagEnd), INVALID_DECLARATION,
          "{" + printTagParts.get(0));
    } else if (printTagParts.get(0).startsWith("{")) {
      errorReporter.report(createSrcLoc(tagBegin, tagEnd), FOUND_DOUBLE_BRACE);
    } else if (INVALID_PRINT_FILE_PREFIX_PATTERN.matcher(printTagParts.get(0)).matches()) {
      errorReporter.report(createSrcLoc(tagBegin, tagEnd), INVALID_PRINT_FILE_COMMAND,
          "{" + printTagParts.get(0));
    } else if (INVALID_PRINT_PREFIX_PATTERN.matcher(printTagParts.get(0)).matches()) {
      errorReporter.report(createSrcLoc(tagBegin, tagEnd), INVALID_PRINT_PREFIX,
          "{" + printTagParts.get(0));
    }
    {if (true) return newSourceItemInfo(printTagParts, tagBegin, tagEnd);}
    throw new Error("Missing return statement in function");
  }

  final private SourceItemInfo<String> XidTag() throws ParseException {
  Token tagBegin, tagEnd;
  String cmdText;
    tagBegin = jj_consume_token(CMD_BEGIN_XID);
    cmdText = CmdText();
    tagEnd = jj_consume_token(CMD_END);
    {if (true) return newSourceItemInfo(cmdText, tagBegin, tagEnd);}
    throw new Error("Missing return statement in function");
  }

  final private SourceItemInfo<String> CssTag() throws ParseException {
  Token tagBegin, tagEnd;
  String cmdText;
    tagBegin = jj_consume_token(CMD_BEGIN_CSS);
    cmdText = CmdText();
    tagEnd = jj_consume_token(CMD_END);
    {if (true) return newSourceItemInfo(cmdText, tagBegin, tagEnd);}
    throw new Error("Missing return statement in function");
  }

  final private SourceItemInfo<String> LetTagSelfEnding() throws ParseException {
  Token tagBegin, tagEnd;
  String cmdText;
    tagBegin = jj_consume_token(CMD_BEGIN_LET);
    cmdText = CmdText();
    tagEnd = jj_consume_token(CMD_SELF_CLOSE);
    {if (true) return newSourceItemInfo(cmdText, tagBegin, tagEnd);}
    throw new Error("Missing return statement in function");
  }

  final private SourceItemInfo<String> LetTagNotSelfEnding() throws ParseException {
  Token tagBegin, tagEnd;
  String cmdText;
    tagBegin = jj_consume_token(CMD_BEGIN_LET);
    cmdText = CmdText();
    tagEnd = jj_consume_token(CMD_END);
    {if (true) return newSourceItemInfo(cmdText, tagBegin, tagEnd);}
    throw new Error("Missing return statement in function");
  }

  final private SourceItemInfo<String> IfTag() throws ParseException {
  Token tagBegin, tagEnd;
  String cmdText;
    tagBegin = jj_consume_token(CMD_BEGIN_IF);
    cmdText = CmdText();
    tagEnd = jj_consume_token(CMD_END);
    {if (true) return newSourceItemInfo(cmdText, tagBegin, tagEnd);}
    throw new Error("Missing return statement in function");
  }

  final private SourceItemInfo<String> ElseifTag() throws ParseException {
  Token tagBegin, tagEnd;
  String cmdText;
    tagBegin = jj_consume_token(CMD_BEGIN_ELSEIF);
    cmdText = CmdText();
    tagEnd = jj_consume_token(CMD_END);
    {if (true) return newSourceItemInfo(cmdText, tagBegin, tagEnd);}
    throw new Error("Missing return statement in function");
  }

  final private SourceItemInfo<String> SwitchTag() throws ParseException {
  Token tagBegin, tagEnd;
  String cmdText;
    tagBegin = jj_consume_token(CMD_BEGIN_SWITCH);
    cmdText = CmdText();
    tagEnd = jj_consume_token(CMD_END);
    {if (true) return newSourceItemInfo(cmdText, tagBegin, tagEnd);}
    throw new Error("Missing return statement in function");
  }

  final private SourceItemInfo<String> ForeachTag() throws ParseException {
  Token tagBegin, tagEnd;
  String cmdText;
    tagBegin = jj_consume_token(CMD_BEGIN_FOREACH);
    cmdText = CmdText();
    tagEnd = jj_consume_token(CMD_END);
    {if (true) return newSourceItemInfo(cmdText, tagBegin, tagEnd);}
    throw new Error("Missing return statement in function");
  }

  final private SourceItemInfo<String> ForTag() throws ParseException {
  Token tagBegin, tagEnd;
  String cmdText;
    tagBegin = jj_consume_token(CMD_BEGIN_FOR);
    cmdText = CmdText();
    tagEnd = jj_consume_token(CMD_END);
    {if (true) return newSourceItemInfo(cmdText, tagBegin, tagEnd);}
    throw new Error("Missing return statement in function");
  }

  final private SourceItemInfo<List<String>> AnyCallTagSelfEnding() throws ParseException {
  Token tagBegin, tagEnd;
  List<String> cmdTextParts;
    List<String> callTagParts = Lists.newArrayList();
    tagBegin = jj_consume_token(CMD_BEGIN_CALL);
    callTagParts.add(tagBegin.image.substring(1));
    // Strip {
      cmdTextParts = CmdTextParts();
    callTagParts.addAll(cmdTextParts);
    tagEnd = jj_consume_token(CMD_SELF_CLOSE);
    {if (true) return newSourceItemInfo(callTagParts, tagBegin, tagEnd);}
    throw new Error("Missing return statement in function");
  }

  final private SourceItemInfo<List<String>> AnyCallTagNotSelfEnding() throws ParseException {
  Token tagBegin, tagEnd;
  List<String> cmdTextParts;
    List<String> callTagParts = Lists.newArrayList();
    tagBegin = jj_consume_token(CMD_BEGIN_CALL);
    callTagParts.add(tagBegin.image.substring(1));
    // Strip {
      cmdTextParts = CmdTextParts();
    callTagParts.addAll(cmdTextParts);
    tagEnd = jj_consume_token(CMD_END);
    {if (true) return newSourceItemInfo(callTagParts, tagBegin, tagEnd);}
    throw new Error("Missing return statement in function");
  }

  final private SourceItemInfo<String> ParamTagSelfEnding() throws ParseException {
  Token tagBegin, tagEnd;
  String cmdText;
    tagBegin = jj_consume_token(CMD_BEGIN_PARAM);
    cmdText = CmdText();
    tagEnd = jj_consume_token(CMD_SELF_CLOSE);
    {if (true) return newSourceItemInfo(cmdText, tagBegin, tagEnd);}
    throw new Error("Missing return statement in function");
  }

  final private SourceItemInfo<String> ParamTagNotSelfEnding() throws ParseException {
  Token tagBegin, tagEnd;
  String cmdText;
    tagBegin = jj_consume_token(CMD_BEGIN_PARAM);
    cmdText = CmdText();
    tagEnd = jj_consume_token(CMD_END);
    {if (true) return newSourceItemInfo(cmdText, tagBegin, tagEnd);}
    throw new Error("Missing return statement in function");
  }

  final private SourceItemInfo<String> CaseTag() throws ParseException {
  Token tagBegin, tagEnd;
  String cmdText;
    tagBegin = jj_consume_token(CMD_BEGIN_CASE);
    cmdText = CmdText();
    tagEnd = jj_consume_token(CMD_END);
    {if (true) return newSourceItemInfo(cmdText, tagBegin, tagEnd);}
    throw new Error("Missing return statement in function");
  }

  final private List<DeclInfo> TemplateHeader() throws ParseException {
  DeclInfo declInfo;
    List<DeclInfo> declInfos = Lists.newArrayList();
    label_9:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case BLOCK_NONDOC_COMMENT:
      case TOKEN_NL:
      case TOKEN_WS_NOT_NL:
        HeaderConsecWs();
        break;
      default:
        jj_la1[24] = jj_gen;
        ;
      }
      declInfo = Decl();
                        declInfos.add(declInfo);
      if (jj_2_4(2147483647)) {
        ;
      } else {
        break label_9;
      }
    }
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case BLOCK_NONDOC_COMMENT:
    case TOKEN_WS_NOT_NL:
      HeaderConsecWsNoNl();
      break;
    default:
      jj_la1[25] = jj_gen;
      ;
    }
    jj_consume_token(TOKEN_NL);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case BLOCK_NONDOC_COMMENT:
    case TOKEN_WS_NOT_NL:
      HeaderConsecWsNoNl();
      break;
    default:
      jj_la1[26] = jj_gen;
      ;
    }
    {if (true) return declInfos;}
    throw new Error("Missing return statement in function");
  }

  final private void TemplateHeaderLookaheadHelper() throws ParseException {
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case BLOCK_NONDOC_COMMENT:
    case TOKEN_NL:
    case TOKEN_WS_NOT_NL:
      HeaderConsecWs();
      break;
    default:
      jj_la1[27] = jj_gen;
      ;
    }
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case BLOCK_DOC_COMMENT:
      jj_consume_token(BLOCK_DOC_COMMENT);
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case BLOCK_NONDOC_COMMENT:
      case TOKEN_NL:
      case TOKEN_WS_NOT_NL:
        HeaderConsecWs();
        break;
      default:
        jj_la1[28] = jj_gen;
        ;
      }
      break;
    default:
      jj_la1[29] = jj_gen;
      ;
    }
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case DECL_BEGIN_PARAM:
      jj_consume_token(DECL_BEGIN_PARAM);
      break;
    case DECL_BEGIN_INJECT_PARAM:
      jj_consume_token(DECL_BEGIN_INJECT_PARAM);
      break;
    default:
      jj_la1[30] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
  }

  final private DeclInfo Decl() throws ParseException {
  DeclInfo declInfo;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case DECL_BEGIN_PARAM:
    case DECL_BEGIN_INJECT_PARAM:
      declInfo = ParamDecl();
      {if (true) return declInfo;}
      break;
    case BLOCK_DOC_COMMENT:
      declInfo = ParamDeclWithDocPrefix();
      {if (true) return declInfo;}
      break;
    default:
      jj_la1[31] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    throw new Error("Missing return statement in function");
  }

  final private DeclInfo ParamDecl() throws ParseException {
  Token tagBegin, name, paramType, tagEnd;
  String cmdText;
  String desc;
  Token blockDocComment;
  DeclInfo.OptionalStatus optionalStatus = DeclInfo.OptionalStatus.REQUIRED;
  DeclInfo.Type type = DeclInfo.Type.PARAM;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case DECL_BEGIN_PARAM:
      tagBegin = jj_consume_token(DECL_BEGIN_PARAM);
      break;
    case DECL_BEGIN_INJECT_PARAM:
      tagBegin = jj_consume_token(DECL_BEGIN_INJECT_PARAM);
                                           type = DeclInfo.Type.INJECTED_PARAM;
      break;
    default:
      jj_la1[32] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case QMARK:
      jj_consume_token(QMARK);
              optionalStatus = DeclInfo.OptionalStatus.OPTIONAL;
      break;
    default:
      jj_la1[33] = jj_gen;
      ;
    }
    label_10:
    while (true) {
      jj_consume_token(WS);
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case WS:
        ;
        break;
      default:
        jj_la1[34] = jj_gen;
        break label_10;
      }
    }
    name = jj_consume_token(NAME);
    jj_consume_token(CMD_TYPE_PREFIX);
    paramType = jj_consume_token(CMD_TYPE_LITERAL);
    // TODO(slaks): Directly invoke type parser.
      tagEnd = jj_consume_token(CMD_END);
    if (jj_2_5(2147483647)) {
      label_11:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case TOKEN_WS_NOT_NL:
          ;
          break;
        default:
          jj_la1[35] = jj_gen;
          break label_11;
        }
        jj_consume_token(TOKEN_WS_NOT_NL);
      }
      blockDocComment = jj_consume_token(BLOCK_DOC_COMMENT);
      desc = blockDocComment.image;
    } else {
      desc = null;
    }
    {if (true) return new DeclInfo(type, optionalStatus, name.image, paramType.image, desc,
        createSrcLoc(tagBegin, tagEnd));}
    throw new Error("Missing return statement in function");
  }

  final private DeclInfo ParamDeclWithDocPrefix() throws ParseException {
  Token blockDocComment, name, paramType;
  DeclInfo.OptionalStatus optionalStatus = DeclInfo.OptionalStatus.REQUIRED;
  DeclInfo.Type type = DeclInfo.Type.PARAM;
    blockDocComment = jj_consume_token(BLOCK_DOC_COMMENT);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case BLOCK_NONDOC_COMMENT:
    case TOKEN_NL:
    case TOKEN_WS_NOT_NL:
      HeaderConsecWs();
      break;
    default:
      jj_la1[36] = jj_gen;
      ;
    }
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case DECL_BEGIN_PARAM:
      jj_consume_token(DECL_BEGIN_PARAM);
      break;
    case DECL_BEGIN_INJECT_PARAM:
      jj_consume_token(DECL_BEGIN_INJECT_PARAM);
                                type = DeclInfo.Type.INJECTED_PARAM;
      break;
    default:
      jj_la1[37] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case QMARK:
      jj_consume_token(QMARK);
              optionalStatus = DeclInfo.OptionalStatus.OPTIONAL;
      break;
    default:
      jj_la1[38] = jj_gen;
      ;
    }
    label_12:
    while (true) {
      jj_consume_token(WS);
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case WS:
        ;
        break;
      default:
        jj_la1[39] = jj_gen;
        break label_12;
      }
    }
    name = jj_consume_token(NAME);
    jj_consume_token(CMD_TYPE_PREFIX);
    paramType = jj_consume_token(CMD_TYPE_LITERAL);
    jj_consume_token(CMD_END);
    {if (true) return new DeclInfo(type, optionalStatus, name.image, paramType.image, blockDocComment.image,
        createSrcLoc(blockDocComment));}
    throw new Error("Missing return statement in function");
  }

  final private List<StandaloneNode> TemplateBlock() throws ParseException {
  RawTextNode contiguousRawTextAsNode;
  StatementNode stmt;
    List<StandaloneNode> templateBlock = Lists.newArrayList();
    label_13:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case BLOCK_DOC_COMMENT:
      case BLOCK_NONDOC_COMMENT:
      case CMD_FULL_SP:
      case CMD_FULL_NIL:
      case CMD_FULL_LF:
      case CMD_FULL_CR:
      case CMD_FULL_TAB:
      case CMD_FULL_LB:
      case CMD_FULL_RB:
      case CMD_OPEN_LITERAL:
      case CMD_BEGIN_CALL:
      case CMD_BEGIN_MSG:
      case CMD_BEGIN_PRINT:
      case CMD_BEGIN_XID:
      case CMD_BEGIN_CSS:
      case CMD_BEGIN_IF:
      case CMD_BEGIN_LET:
      case CMD_BEGIN_FOR:
      case CMD_BEGIN_SWITCH:
      case CMD_BEGIN_FOREACH:
      case CMD_OPEN_LOG:
      case CMD_FULL_DEBUGGER:
      case CMD_BEGIN_IMPLICIT_PRINT:
      case TOKEN_NL:
      case TOKEN_WS_NOT_NL:
      case TOKEN_NOT_WS:
        ;
        break;
      default:
        jj_la1[40] = jj_gen;
        break label_13;
      }
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case BLOCK_DOC_COMMENT:
      case BLOCK_NONDOC_COMMENT:
      case CMD_FULL_SP:
      case CMD_FULL_NIL:
      case CMD_FULL_LF:
      case CMD_FULL_CR:
      case CMD_FULL_TAB:
      case CMD_FULL_LB:
      case CMD_FULL_RB:
      case CMD_OPEN_LITERAL:
      case TOKEN_NL:
      case TOKEN_WS_NOT_NL:
      case TOKEN_NOT_WS:
        contiguousRawTextAsNode = ContiguousRawTextAsNode();
      if (contiguousRawTextAsNode != null) templateBlock.add(contiguousRawTextAsNode);
        break;
      case CMD_BEGIN_CALL:
      case CMD_BEGIN_MSG:
      case CMD_BEGIN_PRINT:
      case CMD_BEGIN_XID:
      case CMD_BEGIN_CSS:
      case CMD_BEGIN_IF:
      case CMD_BEGIN_LET:
      case CMD_BEGIN_FOR:
      case CMD_BEGIN_SWITCH:
      case CMD_BEGIN_FOREACH:
      case CMD_OPEN_LOG:
      case CMD_FULL_DEBUGGER:
      case CMD_BEGIN_IMPLICIT_PRINT:
        stmt = Stmt();
                    if (stmt != null) { templateBlock.add(stmt); }
        break;
      default:
        jj_la1[41] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
    {if (true) return templateBlock;}
    throw new Error("Missing return statement in function");
  }

  final private RawTextNode ContiguousRawTextAsNode() throws ParseException {
  SourceItemInfo<String> contiguousRawText;
    contiguousRawText = ContiguousRawText();
    if (contiguousRawText.parsedContent().isEmpty()) {
      {if (true) return null;}
    }
    {if (true) return new RawTextNode(
        nodeIdGen.genId(), contiguousRawText.parsedContent(), contiguousRawText.srcLocation());}
    throw new Error("Missing return statement in function");
  }

  final private StatementNode Stmt() throws ParseException {
  StatementNode stmt;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case CMD_BEGIN_MSG:
      stmt = MsgStmt();
      break;
    case CMD_BEGIN_XID:
      stmt = XidStmt();
      break;
    case CMD_BEGIN_CSS:
      stmt = CssStmt();
      break;
    case CMD_BEGIN_LET:
      stmt = LetStmt();
      break;
    case CMD_BEGIN_IF:
      stmt = IfStmt();
      break;
    case CMD_BEGIN_SWITCH:
      stmt = SwitchStmt();
      break;
    case CMD_BEGIN_FOREACH:
      stmt = ForeachStmt();
      break;
    case CMD_BEGIN_FOR:
      stmt = ForStmt();
      break;
    case CMD_BEGIN_CALL:
      stmt = CallStmt();
      break;
    case CMD_OPEN_LOG:
      stmt = LogStmt();
      break;
    case CMD_FULL_DEBUGGER:
      stmt = DebuggerStmt();
      break;
    case CMD_BEGIN_PRINT:
    case CMD_BEGIN_IMPLICIT_PRINT:
      stmt = PrintStmt();
      break;
    default:
      jj_la1[42] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    {if (true) return stmt;}
    throw new Error("Missing return statement in function");
  }

  final private MsgFallbackGroupNode MsgStmt() throws ParseException {
  SourceItemInfo<String> cmdText;
  List<StandaloneNode> templateBlockForMsg;
    MsgNode msgNode;
    cmdText = MsgTag();
    MsgFallbackGroupNode msgFbGrpNode = new MsgFallbackGroupNode(
        nodeIdGen.genId(), cmdText.srcLocation());
    msgNode = MsgNode.msg(nodeIdGen.genId(), cmdText.parsedContent(), cmdText.srcLocation())
        .build(context);
    msgFbGrpNode.addChild(msgNode);
    templateBlockForMsg = TemplateBlockForMsg();
    msgNode.addChildren(templateBlockForMsg);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case CMD_BEGIN_FALLBACK_MSG:
      cmdText = FallbackmsgTag();
      msgNode = MsgNode.fallbackmsg(
          nodeIdGen.genId(), cmdText.parsedContent(), cmdText.srcLocation())
          .build(context);
      msgFbGrpNode.addChild(msgNode);
      templateBlockForMsg = TemplateBlockForMsg();
      msgNode.addChildren(templateBlockForMsg);
      break;
    default:
      jj_la1[43] = jj_gen;
      ;
    }
    jj_consume_token(CMD_CLOSE_MSG);
    {if (true) return msgFbGrpNode;}
    throw new Error("Missing return statement in function");
  }

  final private List<StandaloneNode> TemplateBlockForMsg() throws ParseException {
  RawTextNode contiguousRawTextAsNode;
  MsgPlaceholderInitialNode stmt;
  MsgHtmlTagNode msgHtmlTag;
  MsgPluralNode msgPlural;
  MsgSelectNode msgSelect;
    List<StandaloneNode> templateBlock = Lists.newArrayList();
    if (jj_2_6(2147483647)) {
      MaybeWhitespace("No message content is allowed before a 'plural' block.");
      msgPlural = MsgPlural();
      templateBlock.add(msgPlural);
      MaybeWhitespace("No message content is allowed after a 'plural' block.");
    } else if (jj_2_7(2147483647)) {
      MaybeWhitespace("No message content is allowed before a 'select' block.");
      msgSelect = MsgSelect();
      templateBlock.add(msgSelect);
      MaybeWhitespace("No message content is allowed after a 'select' block.");
    } else {
      label_14:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case BLOCK_DOC_COMMENT:
        case BLOCK_NONDOC_COMMENT:
        case CMD_FULL_SP:
        case CMD_FULL_NIL:
        case CMD_FULL_LF:
        case CMD_FULL_CR:
        case CMD_FULL_TAB:
        case CMD_FULL_LB:
        case CMD_FULL_RB:
        case CMD_OPEN_LITERAL:
        case CMD_BEGIN_CALL:
        case CMD_BEGIN_PRINT:
        case CMD_BEGIN_IMPLICIT_PRINT:
        case MSG_HTML_TAG_OPEN:
        case TOKEN_NL:
        case TOKEN_WS_NOT_NL:
        case TOKEN_NOT_WS:
          ;
          break;
        default:
          jj_la1[44] = jj_gen;
          break label_14;
        }
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case BLOCK_DOC_COMMENT:
        case BLOCK_NONDOC_COMMENT:
        case CMD_FULL_SP:
        case CMD_FULL_NIL:
        case CMD_FULL_LF:
        case CMD_FULL_CR:
        case CMD_FULL_TAB:
        case CMD_FULL_LB:
        case CMD_FULL_RB:
        case CMD_OPEN_LITERAL:
        case TOKEN_NL:
        case TOKEN_WS_NOT_NL:
        case TOKEN_NOT_WS:
          contiguousRawTextAsNode = ContiguousRawTextAsNode();
          if (contiguousRawTextAsNode != null) templateBlock.add(contiguousRawTextAsNode);
          break;
        case CMD_BEGIN_CALL:
          stmt = CallStmt();
                             templateBlock.add(new MsgPlaceholderNode(nodeIdGen.genId(), stmt));
          break;
        case CMD_BEGIN_PRINT:
        case CMD_BEGIN_IMPLICIT_PRINT:
          stmt = PrintStmt();
                              // TODO(lukes): Figure out something non-null to return instead.
        if (stmt != null) { templateBlock.add(new MsgPlaceholderNode(nodeIdGen.genId(), stmt)); }
          break;
        case MSG_HTML_TAG_OPEN:
          msgHtmlTag = MsgHtmlTag();
          templateBlock.add(new MsgPlaceholderNode(nodeIdGen.genId(), msgHtmlTag));
          break;
        default:
          jj_la1[45] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
      }
    }
    {if (true) return templateBlock;}
    throw new Error("Missing return statement in function");
  }

  final private MsgPluralNode MsgPlural() throws ParseException {
  Token defaultTag;
  SourceItemInfo<String> cmdText;
  List<StandaloneNode> templateBlockForMsg;
    cmdText = PluralTag();
    MsgPluralNode msgPluralNode = new MsgPluralNode.Builder(
        nodeIdGen.genId(), cmdText.parsedContent(), cmdText.srcLocation())
        .build(context);
    MaybeWhitespace("No content allowed between 'plural' and 'case'" +
          " (whitespace and comments are okay).");
    label_15:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case CMD_BEGIN_CASE:
        ;
        break;
      default:
        jj_la1[46] = jj_gen;
        break label_15;
      }
      cmdText = CaseTag();
      MsgPluralCaseNode msgPluralCaseNode = new MsgPluralCaseNode.Builder(
          nodeIdGen.genId(), cmdText.parsedContent(), cmdText.srcLocation())
          .build(errorReporter);
      msgPluralNode.addChild(msgPluralCaseNode);
      templateBlockForMsg = TemplateBlockForMsg();
      if (templateBlockForMsg.size() == 1 &&
          (templateBlockForMsg.get(0) instanceof MsgPluralNode ||
           templateBlockForMsg.get(0) instanceof MsgSelectNode )) {
        errorReporter.report(
            templateBlockForMsg.get(0).getSourceLocation(),
            PLURAL_AND_SELECT_NOT_ALLOWED_INSIDE_PLURAL_BLOCK);
      }
      msgPluralCaseNode.addChildren(templateBlockForMsg);
    }
    defaultTag = jj_consume_token(CMD_FULL_DEFAULT);
    MsgPluralDefaultNode msgPluralDefaultNode = new MsgPluralDefaultNode(
        nodeIdGen.genId(), createSrcLoc(defaultTag));
    msgPluralNode.addChild(msgPluralDefaultNode);
    templateBlockForMsg = TemplateBlockForMsg();
    if (templateBlockForMsg.size() == 1 &&
        (templateBlockForMsg.get(0) instanceof MsgPluralNode ||
         templateBlockForMsg.get(0) instanceof MsgSelectNode )) {
      errorReporter.report(
          templateBlockForMsg.get(0).getSourceLocation(),
          PLURAL_AND_SELECT_NOT_ALLOWED_INSIDE_PLURAL_BLOCK);
    }
    msgPluralDefaultNode.addChildren(templateBlockForMsg);
    jj_consume_token(CMD_CLOSE_PLURAL);
    {if (true) return msgPluralNode;}
    throw new Error("Missing return statement in function");
  }

  final private MsgSelectNode MsgSelect() throws ParseException {
  Token defaultTag;
  SourceItemInfo<String> cmdText;
  List<StandaloneNode> templateBlockForMsg;
    cmdText = SelectTag();
    MsgSelectNode msgSelectNode = new MsgSelectNode.Builder(
        nodeIdGen.genId(), cmdText.parsedContent(), cmdText.srcLocation()).build(context);
    MaybeWhitespace("No content allowed between 'select' and 'case'" +
          " (whitespace and comments are okay).");
    label_16:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case CMD_BEGIN_CASE:
        ;
        break;
      default:
        jj_la1[47] = jj_gen;
        break label_16;
      }
      cmdText = CaseTag();
      MsgSelectCaseNode msgSelectCaseNode = new MsgSelectCaseNode.Builder(
          nodeIdGen.genId(), cmdText.parsedContent(), cmdText.srcLocation())
          .build(context);
      msgSelectNode.addChild(msgSelectCaseNode);
      templateBlockForMsg = TemplateBlockForMsg();
      msgSelectCaseNode.addChildren(templateBlockForMsg);
    }
    defaultTag = jj_consume_token(CMD_FULL_DEFAULT);
    MsgSelectDefaultNode msgSelectDefaultNode
        = new MsgSelectDefaultNode(nodeIdGen.genId(), createSrcLoc(defaultTag));
    msgSelectNode.addChild(msgSelectDefaultNode);
    templateBlockForMsg = TemplateBlockForMsg();
    msgSelectDefaultNode.addChildren(templateBlockForMsg);
    jj_consume_token(CMD_CLOSE_SELECT);
    {if (true) return msgSelectNode;}
    throw new Error("Missing return statement in function");
  }

  final private MsgHtmlTagNode MsgHtmlTag() throws ParseException {
  Token htmlTagOpen;
  List<StandaloneNode> templateBlock;
    htmlTagOpen = jj_consume_token(MSG_HTML_TAG_OPEN);
    templateBlock = TemplateBlock();
    jj_consume_token(MSG_HTML_TAG_CLOSE);
    SourceLocation srcLoc = createSrcLoc(htmlTagOpen);
    // TODO(lukes): Massively simplify this by creating more nodes.  Also fix SourceLocation.
    // First, we add back the HTML tag's opening and closing angle brackets.
    // Minor note: If there's only one RawTextNode, we'll replace it twice. No big deal.
    if (templateBlock.get(0) instanceof RawTextNode) {
      RawTextNode firstNode = (RawTextNode) templateBlock.get(0);
      RawTextNode newNode = new RawTextNode(
          nodeIdGen.genId(), "<" + firstNode.getRawText(), srcLoc);
      templateBlock.set(0, newNode);
    } else {
      templateBlock.add(0, new RawTextNode(nodeIdGen.genId(), "<", srcLoc));
    }
    int lastNodeIndex = templateBlock.size() - 1;
    if (templateBlock.get(lastNodeIndex) instanceof RawTextNode) {
      RawTextNode lastNode = (RawTextNode) templateBlock.get(lastNodeIndex);
      RawTextNode newNode = new RawTextNode(nodeIdGen.genId(), lastNode.getRawText() + ">", srcLoc);
      templateBlock.set(lastNodeIndex, newNode);
    } else {
      templateBlock.add(new RawTextNode(nodeIdGen.genId(), ">", srcLoc));
    }
    {if (true) return new MsgHtmlTagNode.Builder(
        nodeIdGen.genId(),
        ImmutableList.copyOf(templateBlock),
        createSrcLoc(htmlTagOpen))
        .build(errorReporter);}
    throw new Error("Missing return statement in function");
  }

  final private PrintNode PrintStmt() throws ParseException {
  SourceItemInfo<List<String>> printTagInfo;
    printTagInfo = PrintTag();
    List<String> printTagParts = printTagInfo.parsedContent();

    // ------ Process command name (implicit or explicit). ------
    boolean isImplicit;
    List<String> cmdTextParts;
    if (!printTagParts.isEmpty() && printTagParts.get(0).equals("print")) {
      isImplicit = false;
      cmdTextParts = printTagParts.subList(1, printTagParts.size());
    } else {
      isImplicit = true;
      cmdTextParts = printTagParts;
    }
    String cmdText = Joiner.on("").join(cmdTextParts);

    // ------ Process 'phname' attribute (if any). ------
    String phnameAttr = null;
    for (String cmdTextPart : cmdTextParts) {
      if (cmdTextPart.startsWith(" phname=\u005c"") && cmdTextPart.endsWith("\u005c"")) {
        if (phnameAttr != null) {
          errorReporter.report(
              printTagInfo.srcLocation(), MULTIPLE_PHNAME_ATTRIBUTES_IN_COMMAND, "print", cmdText);
        }
        phnameAttr = cmdTextPart;
      }
    }
    String userSuppliedPhName;
    if (phnameAttr != null) {
      cmdTextParts.remove(phnameAttr);
      userSuppliedPhName = phnameAttr.substring(9, phnameAttr.length() - 1);
    } else {
      userSuppliedPhName = null;
    }

    // ------ Process expression. ------
    // Note: First part is expression, rest of parts are directives or directive args.
    if (cmdTextParts.isEmpty()) {
      errorReporter.report(printTagInfo.srcLocation(), PRINT_COMMAND_WITH_EMPTY_TEXT);
      {if (true) return null;}
    }
    String exprText = cmdTextParts.get(0).trim();
    PrintNode printNode
        = new PrintNode.Builder(nodeIdGen.genId(), isImplicit, printTagInfo.srcLocation())
            .exprText(exprText)
            .userSuppliedPlaceholderName(userSuppliedPhName)
            .build(context);

    // ------ Process directives (if any). ------
    String directiveName = null;
    for (int i = 1, n = cmdTextParts.size(); i < n; i++) {
      String cmdTextPart = cmdTextParts.get(i);

      if (cmdTextPart.startsWith("|")) {
        // Create previous directive and save current directive name.
        if (directiveName != null) {
          printNode.addChild(new PrintDirectiveNode.Builder(
              nodeIdGen.genId(), directiveName, "", printTagInfo.srcLocation())
              .build(context));
        }
        directiveName = cmdTextPart;

      } else if (cmdTextPart.startsWith(":")) {
        // Create previous directive with current args text.
        if (directiveName == null) {
          {if (true) throw new AssertionError();}
        }
        String argsText = cmdTextPart.substring(1);
        printNode.addChild(new PrintDirectiveNode.Builder(
            nodeIdGen.genId(), directiveName, argsText, printTagInfo.srcLocation())
            .build(context));
        directiveName = null;

      } else if (cmdTextPart.trim().length() == 0) {
        continue;

      } else {
        errorReporter.report(printNode.getSourceLocation(), INVALID_PRINT_COMMAND_TEXT, cmdText);
      }
    }
    // Add last directive.
    if (directiveName != null) {
      printNode.addChild(new PrintDirectiveNode.Builder(
          nodeIdGen.genId(), directiveName, "", printTagInfo.srcLocation())
          .build(context));
    }

    {if (true) return printNode;}
    throw new Error("Missing return statement in function");
  }

  final private XidNode XidStmt() throws ParseException {
  SourceItemInfo<String> cmdText;
    cmdText = XidTag();
    {if (true) return new XidNode.Builder(nodeIdGen.genId(), cmdText.parsedContent(), cmdText.srcLocation())
        .build(errorReporter);}
    throw new Error("Missing return statement in function");
  }

  final private CssNode CssStmt() throws ParseException {
  SourceItemInfo<String> cmdText;
    cmdText = CssTag();
    {if (true) return new CssNode.Builder(nodeIdGen.genId(), cmdText.parsedContent(), cmdText.srcLocation())
        .build(context);}
    throw new Error("Missing return statement in function");
  }

  final private LetNode LetStmt() throws ParseException {
  SourceItemInfo<String> cmdText;
  List<StandaloneNode> templateBlock;
    LetNode letNode = null;
    if (jj_2_8(2147483647)) {
      cmdText = LetTagSelfEnding();
      letNode = new LetValueNode.Builder(
          nodeIdGen.genId(), cmdText.parsedContent(), cmdText.srcLocation())
          .build(context);
    } else {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case CMD_BEGIN_LET:
        cmdText = LetTagNotSelfEnding();
      LetContentNode letContentNode = new LetContentNode.Builder(
            nodeIdGen.genId(), cmdText.parsedContent(), cmdText.srcLocation())
            .build(context);
        templateBlock = TemplateBlock();
      letContentNode.addChildren(templateBlock);
      letNode = letContentNode;
        jj_consume_token(CMD_CLOSE_LET);
        break;
      default:
        jj_la1[48] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
    {if (true) return letNode;}
    throw new Error("Missing return statement in function");
  }

  final private IfNode IfStmt() throws ParseException {
  SourceItemInfo<String> cmdText;
  List<StandaloneNode> templateBlock;
  Token elseTag;
    IfCondNode ifCondNode;
    cmdText = IfTag();
    IfNode ifNode = new IfNode(nodeIdGen.genId(), cmdText.srcLocation());
    ifCondNode = IfCondNode.ifBuilder(
        nodeIdGen.genId(), cmdText.parsedContent(), cmdText.srcLocation())
        .build(context);
    ifNode.addChild(ifCondNode);
    templateBlock = TemplateBlock();
    ifCondNode.addChildren(templateBlock);
    label_17:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case CMD_BEGIN_ELSEIF:
        ;
        break;
      default:
        jj_la1[49] = jj_gen;
        break label_17;
      }
      cmdText = ElseifTag();
      ifCondNode = IfCondNode.elseifBuilder(
          nodeIdGen.genId(), cmdText.parsedContent(), cmdText.srcLocation()).build(context);
      ifNode.addChild(ifCondNode);
      templateBlock = TemplateBlock();
      ifCondNode.addChildren(templateBlock);
    }
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case CMD_FULL_ELSE:
      elseTag = jj_consume_token(CMD_FULL_ELSE);
      IfElseNode ifElseNode = new IfElseNode(nodeIdGen.genId(), createSrcLoc(elseTag));
      ifNode.addChild(ifElseNode);
      templateBlock = TemplateBlock();
      ifElseNode.addChildren(templateBlock);
      break;
    default:
      jj_la1[50] = jj_gen;
      ;
    }
    jj_consume_token(CMD_CLOSE_IF);
    {if (true) return ifNode;}
    throw new Error("Missing return statement in function");
  }

  final private SwitchNode SwitchStmt() throws ParseException {
  SourceItemInfo<String> cmdText;
  Token defaultTag;
  List<StandaloneNode> templateBlock;
    cmdText = SwitchTag();
    SwitchNode switchNode = new SwitchNode.Builder(
        nodeIdGen.genId(), cmdText.parsedContent(), cmdText.srcLocation())
        .build(context);
    MaybeWhitespace("No content allowed between 'switch' and 'case'" +
          " (whitespace and comments are okay).");
    label_18:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case CMD_BEGIN_CASE:
        ;
        break;
      default:
        jj_la1[51] = jj_gen;
        break label_18;
      }
      cmdText = CaseTag();
      SwitchCaseNode switchCaseNode = new SwitchCaseNode.Builder(
          nodeIdGen.genId(), cmdText.parsedContent(), cmdText.srcLocation())
          .build(context);
      switchNode.addChild(switchCaseNode);
      templateBlock = TemplateBlock();
      switchCaseNode.addChildren(templateBlock);
    }
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case CMD_FULL_DEFAULT:
      defaultTag = jj_consume_token(CMD_FULL_DEFAULT);
      SwitchDefaultNode switchDefaultNode = new SwitchDefaultNode(
          nodeIdGen.genId(), createSrcLoc(defaultTag));
      switchNode.addChild(switchDefaultNode);
      templateBlock = TemplateBlock();
      switchDefaultNode.addChildren(templateBlock);
      break;
    default:
      jj_la1[52] = jj_gen;
      ;
    }
    jj_consume_token(CMD_CLOSE_SWITCH);
    {if (true) return switchNode;}
    throw new Error("Missing return statement in function");
  }

  final private ForeachNode ForeachStmt() throws ParseException {
  SourceItemInfo<String> cmdText;
  List<StandaloneNode> templateBlock;
  Token ifemptyTag;
    cmdText = ForeachTag();
    ForeachBuilder builder = ForeachBuilder.create(nodeIdGen, context)
        .setCommandLocation(cmdText.srcLocation())
        .setCommandText(cmdText.parsedContent());
    templateBlock = TemplateBlock();
    builder.setLoopBody(templateBlock);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case CMD_FULL_IFEMPTY:
      ifemptyTag = jj_consume_token(CMD_FULL_IFEMPTY);
      templateBlock = TemplateBlock();
      builder.setIfEmptyBody(createSrcLoc(ifemptyTag), templateBlock);
      break;
    default:
      jj_la1[53] = jj_gen;
      ;
    }
    jj_consume_token(CMD_CLOSE_FOREACH);
    {if (true) return builder.build();}
    throw new Error("Missing return statement in function");
  }

  final private ForNode ForStmt() throws ParseException {
  SourceItemInfo<String> cmdText;
  List<StandaloneNode> templateBlock;
    cmdText = ForTag();
    ForNode forNode = new ForNode(
        nodeIdGen.genId(),
        cmdText.parsedContent(),
        cmdText.srcLocation(),
        context);
    templateBlock = TemplateBlock();
    forNode.addChildren(templateBlock);
    jj_consume_token(CMD_CLOSE_FOR);
    {if (true) return forNode;}
    throw new Error("Missing return statement in function");
  }

  final private CallNode CallStmt() throws ParseException {
  SourceItemInfo<List<String>> callTagInfo;
  CallParamNode callParam;
  Token endCallTag;
    List<CallParamNode> callParams = Lists.newArrayList();
    if (jj_2_9(2147483647)) {
      callTagInfo = AnyCallTagSelfEnding();
      endCallTag = null;
    } else {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case CMD_BEGIN_CALL:
        callTagInfo = AnyCallTagNotSelfEnding();
        MaybeWhitespace("No content allowed between 'call' and 'param'" +
                " (whitespace and comments are okay).");
        label_19:
        while (true) {
          switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
          case CMD_BEGIN_PARAM:
            ;
            break;
          default:
            jj_la1[54] = jj_gen;
            break label_19;
          }
          callParam = CallParam();
        callParams.add(callParam);
          MaybeWhitespace("No content allowed between 'param' and 'param'" +
                    " (whitespace and comments are okay).");
        }
        endCallTag = jj_consume_token(CMD_CLOSE_CALL);
        break;
      default:
        jj_la1[55] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
    List<String> callTagParts = callTagInfo.parsedContent();

    // ------ Divide callTagParts into cmdName, cmdText, and phnameAttr (if any). ------
    String cmdName = callTagParts.get(0);

    StringBuilder cmdTextSb = new StringBuilder();
    String phnameAttr = null;

    for (int i = 1; i < callTagParts.size(); i++) {
      String cmdTextPart = callTagParts.get(i);
      if (cmdTextPart.startsWith(" phname=\u005c"") && cmdTextPart.endsWith("\u005c"")) {
        if (phnameAttr != null) {
          errorReporter.report(
              callTagInfo.srcLocation(),
              MULTIPLE_PHNAME_ATTRIBUTES_IN_COMMAND,
              cmdName,
              Joiner.on("").join(callTagParts.subList(1, callTagParts.size())));
        }
        phnameAttr = cmdTextPart;
      } else {
        cmdTextSb.append(cmdTextPart);
      }
    }

    String cmdText = cmdTextSb.toString();

    // ------ Compute isBasicCallTag and userSuppliedPhName. ------
    boolean isBasicCallTag = callTagParts.get(0).trim().equals("call");
    if (endCallTag != null && !endCallTag.image.equals("{/" + callTagParts.get(0).trim() + "}")) {
      // TODO(slaks): Port to SoyErrorKind.
      if (isBasicCallTag) {
        errorReporter.report(createSrcLoc(endCallTag),
            SoyErrorKind.of("{0}"), "Mismatched 'call' and '/delcall'.");
      } else {
        errorReporter.report(createSrcLoc(endCallTag),
            SoyErrorKind.of("{0}"), "Mismatched 'delcall' and '/call'.");
      }
    }

    String userSuppliedPhName =
        (phnameAttr != null) ? phnameAttr.substring(9, phnameAttr.length() - 1) : null;

    // ------ Create the CallNode. ------
    CallNode callNode = null;
    if (isBasicCallTag) {
      callNode = new CallBasicNode.Builder(nodeIdGen.genId(), callTagInfo.srcLocation())
          .commandText(cmdText)
          .userSuppliedPlaceholderName(userSuppliedPhName)
          .build(context);
    } else {
      callNode = new CallDelegateNode.Builder(nodeIdGen.genId(), callTagInfo.srcLocation())
          .commandText(cmdText)
          .userSuppliedPlaceholderName(userSuppliedPhName)
          .build(context);
    }
    callNode.addChildren(callParams);

    {if (true) return callNode;}
    throw new Error("Missing return statement in function");
  }

  final private CallParamNode CallParam() throws ParseException {
  SourceItemInfo<String> cmdText;
  List<StandaloneNode> templateBlock;
    CallParamNode callParamNode = null;
    if (jj_2_10(2147483647)) {
      cmdText = ParamTagSelfEnding();
      callParamNode = new CallParamValueNode.Builder(
          nodeIdGen.genId(), cmdText.parsedContent(), cmdText.srcLocation())
          .build(context);
    } else {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case CMD_BEGIN_PARAM:
        cmdText = ParamTagNotSelfEnding();
      CallParamContentNode cpcn = new CallParamContentNode.Builder(
          nodeIdGen.genId(), cmdText.parsedContent(), cmdText.srcLocation())
          .build(context);
        templateBlock = TemplateBlock();
      cpcn.addChildren(templateBlock);
      callParamNode = cpcn;
        jj_consume_token(CMD_CLOSE_PARAM);
        break;
      default:
        jj_la1[56] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
    {if (true) return callParamNode;}
    throw new Error("Missing return statement in function");
  }

  final private LogNode LogStmt() throws ParseException {
  Token open;
  List<StandaloneNode> templateBlock;
    open = jj_consume_token(CMD_OPEN_LOG);
    LogNode logNode = new LogNode(nodeIdGen.genId(), createSrcLoc(open));
    templateBlock = TemplateBlock();
    logNode.addChildren(templateBlock);
    jj_consume_token(CMD_CLOSE_LOG);
    {if (true) return logNode;}
    throw new Error("Missing return statement in function");
  }

  final private DebuggerNode DebuggerStmt() throws ParseException {
  Token token;
    token = jj_consume_token(CMD_FULL_DEBUGGER);
    {if (true) return new DebuggerNode(nodeIdGen.genId(), createSrcLoc(token));}
    throw new Error("Missing return statement in function");
  }

/**
 * TODO(lukes): Delete after porting tests
 */
  final public TemplateParseResult parseTemplateContent() throws ParseException {
  List<DeclInfo> headerDecls;
  List<StandaloneNode> bodyNodes;
    context = SoyParsingContext.empty(errorReporter, "fake.namespace");
    token_source.SwitchTo(TEMPLATE_DEFAULT_AT_SOL);
    if (jj_2_12(2147483647)) {
      headerDecls = TemplateHeader();
    } else {
      if (jj_2_11(2)) {
        HeaderConsecWsNoNl();
      } else {
        ;
      }
      headerDecls = null;
    }
    bodyNodes = TemplateBlock();
    jj_consume_token(0);
    // Note: We're using an undocumented API to check the token manager's state. If this ever
    // breaks due to changes in JavaCC (extremely unlikely since many users around the world are
    // depending on it), then we'll have to use a different method to detect whether we're within
    // a comment block.
    if (token_source.curLexState == IN_BLOCK_DOC_COMMENT ||
        token_source.curLexState == IN_BLOCK_NONDOC_COMMENT) {
      {if (true) throw new ParseException("At end of template, found comment block that is never closed.");}
    }
    {if (true) return new TemplateParseResult(headerDecls, bodyNodes);}
    throw new Error("Missing return statement in function");
  }

  private boolean jj_2_1(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_1(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(0, xla); }
  }

  private boolean jj_2_2(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_2(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(1, xla); }
  }

  private boolean jj_2_3(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_3(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(2, xla); }
  }

  private boolean jj_2_4(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_4(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(3, xla); }
  }

  private boolean jj_2_5(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_5(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(4, xla); }
  }

  private boolean jj_2_6(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_6(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(5, xla); }
  }

  private boolean jj_2_7(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_7(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(6, xla); }
  }

  private boolean jj_2_8(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_8(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(7, xla); }
  }

  private boolean jj_2_9(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_9(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(8, xla); }
  }

  private boolean jj_2_10(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_10(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(9, xla); }
  }

  private boolean jj_2_11(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_11(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(10, xla); }
  }

  private boolean jj_2_12(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_12(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(11, xla); }
  }

  private boolean jj_3R_40() {
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_51()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3_12() {
    if (jj_3R_20()) return true;
    return false;
  }

  private boolean jj_3R_27() {
    if (jj_scan_token(CMD_BEGIN_LET)) return true;
    if (jj_3R_39()) return true;
    if (jj_scan_token(CMD_SELF_CLOSE)) return true;
    return false;
  }

  private boolean jj_3R_23() {
    if (jj_3R_35()) return true;
    return false;
  }

  private boolean jj_3R_43() {
    if (jj_3R_42()) return true;
    return false;
  }

  private boolean jj_3_11() {
    if (jj_3R_30()) return true;
    return false;
  }

  private boolean jj_3_3() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_23()) {
    jj_scanpos = xsp;
    if (jj_3R_24()) {
    jj_scanpos = xsp;
    if (jj_3R_25()) return true;
    }
    }
    return false;
  }

  private boolean jj_3_8() {
    if (jj_3R_27()) return true;
    return false;
  }

  private boolean jj_3R_34() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(32)) {
    jj_scanpos = xsp;
    if (jj_scan_token(33)) return true;
    }
    return false;
  }

  private boolean jj_3R_39() {
    if (jj_3R_40()) return true;
    return false;
  }

  private boolean jj_3R_52() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(94)) {
    jj_scanpos = xsp;
    if (jj_scan_token(95)) {
    jj_scanpos = xsp;
    if (jj_scan_token(33)) return true;
    }
    }
    return false;
  }

  private boolean jj_3R_42() {
    Token xsp;
    if (jj_3R_52()) return true;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_52()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_32() {
    if (jj_scan_token(BLOCK_DOC_COMMENT)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_43()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_31() {
    if (jj_3R_42()) return true;
    return false;
  }

  private boolean jj_3R_29() {
    if (jj_scan_token(CMD_BEGIN_PARAM)) return true;
    if (jj_3R_39()) return true;
    if (jj_scan_token(CMD_SELF_CLOSE)) return true;
    return false;
  }

  private boolean jj_3R_20() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_31()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3R_32()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(36)) {
    jj_scanpos = xsp;
    if (jj_scan_token(37)) return true;
    }
    return false;
  }

  private boolean jj_3R_50() {
    if (jj_scan_token(CMD_FULL_RB)) return true;
    return false;
  }

  private boolean jj_3R_49() {
    if (jj_scan_token(CMD_FULL_LB)) return true;
    return false;
  }

  private boolean jj_3R_48() {
    if (jj_scan_token(CMD_FULL_TAB)) return true;
    return false;
  }

  private boolean jj_3R_41() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(95)) {
    jj_scanpos = xsp;
    if (jj_scan_token(33)) return true;
    }
    return false;
  }

  private boolean jj_3R_47() {
    if (jj_scan_token(CMD_FULL_LF)) return true;
    return false;
  }

  private boolean jj_3R_46() {
    if (jj_scan_token(CMD_FULL_CR)) return true;
    return false;
  }

  private boolean jj_3R_30() {
    Token xsp;
    if (jj_3R_41()) return true;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_41()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_45() {
    if (jj_scan_token(CMD_FULL_NIL)) return true;
    return false;
  }

  private boolean jj_3R_44() {
    if (jj_scan_token(CMD_FULL_SP)) return true;
    return false;
  }

  private boolean jj_3R_37() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_44()) {
    jj_scanpos = xsp;
    if (jj_3R_45()) {
    jj_scanpos = xsp;
    if (jj_3R_46()) {
    jj_scanpos = xsp;
    if (jj_3R_47()) {
    jj_scanpos = xsp;
    if (jj_3R_48()) {
    jj_scanpos = xsp;
    if (jj_3R_49()) {
    jj_scanpos = xsp;
    if (jj_3R_50()) return true;
    }
    }
    }
    }
    }
    }
    return false;
  }

  private boolean jj_3_4() {
    if (jj_3R_20()) return true;
    return false;
  }

  private boolean jj_3_7() {
    if (jj_3R_26()) return true;
    if (jj_scan_token(CMD_BEGIN_SELECT)) return true;
    return false;
  }

  private boolean jj_3R_22() {
    if (jj_3R_34()) return true;
    return false;
  }

  private boolean jj_3R_21() {
    if (jj_3R_33()) return true;
    return false;
  }

  private boolean jj_3_6() {
    if (jj_3R_26()) return true;
    if (jj_scan_token(CMD_BEGIN_PLURAL)) return true;
    return false;
  }

  private boolean jj_3R_36() {
    if (jj_scan_token(CMD_OPEN_LITERAL)) return true;
    if (jj_scan_token(LITERAL_RAW_TEXT_CONTENT)) return true;
    return false;
  }

  private boolean jj_3_2() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_21()) {
    jj_scanpos = xsp;
    if (jj_3R_22()) return true;
    }
    return false;
  }

  private boolean jj_3_5() {
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_scan_token(95)) { jj_scanpos = xsp; break; }
    }
    if (jj_scan_token(BLOCK_DOC_COMMENT)) return true;
    return false;
  }

  private boolean jj_3R_35() {
    Token xsp;
    if (jj_3_2()) return true;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3_2()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_38() {
    if (jj_3R_35()) return true;
    return false;
  }

  private boolean jj_3R_28() {
    if (jj_scan_token(CMD_BEGIN_CALL)) return true;
    if (jj_3R_40()) return true;
    if (jj_scan_token(CMD_SELF_CLOSE)) return true;
    return false;
  }

  private boolean jj_3R_26() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_38()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3_1() {
    if (jj_3R_20()) return true;
    return false;
  }

  private boolean jj_3R_25() {
    if (jj_3R_37()) return true;
    return false;
  }

  private boolean jj_3_10() {
    if (jj_3R_29()) return true;
    return false;
  }

  private boolean jj_3R_54() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(82)) {
    jj_scanpos = xsp;
    if (jj_scan_token(83)) return true;
    }
    return false;
  }

  private boolean jj_3R_53() {
    if (jj_scan_token(CMD_TEXT_ARBITRARY_TOKEN)) return true;
    return false;
  }

  private boolean jj_3R_33() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(94)) {
    jj_scanpos = xsp;
    if (jj_scan_token(95)) {
    jj_scanpos = xsp;
    if (jj_scan_token(96)) return true;
    }
    }
    return false;
  }

  private boolean jj_3_9() {
    if (jj_3R_28()) return true;
    return false;
  }

  private boolean jj_3R_51() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_53()) {
    jj_scanpos = xsp;
    if (jj_3R_54()) return true;
    }
    return false;
  }

  private boolean jj_3R_24() {
    if (jj_3R_36()) return true;
    return false;
  }

  /** Generated Token Manager. */
  public SoyFileParserTokenManager token_source;
  SimpleCharStream jj_input_stream;
  /** Current token. */
  public Token token;
  /** Next token. */
  public Token jj_nt;
  private int jj_ntk;
  private Token jj_scanpos, jj_lastpos;
  private int jj_la;
  private int jj_gen;
  final private int[] jj_la1 = new int[57];
  static private int[] jj_la1_0;
  static private int[] jj_la1_1;
  static private int[] jj_la1_2;
  static private int[] jj_la1_3;
  static {
      jj_la1_init_0();
      jj_la1_init_1();
      jj_la1_init_2();
      jj_la1_init_3();
   }
   private static void jj_la1_init_0() {
      jj_la1_0 = new int[] {0x20000,0x4000,0x1000,0x600000,0x800,0x1a000,0x1a000,0x600000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,};
   }
   private static void jj_la1_init_1() {
      jj_la1_1 = new int[] {0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x2,0xc,0x0,0x0,0x0,0x2,0x2,0x2,0x2,0x3,0x0,0x3,0x3,0x3f80,0x7f83,0x400000,0x2,0x2,0x2,0x2,0x2,0x1,0x30,0x31,0x30,0x0,0x0,0x0,0x2,0x30,0x0,0x0,0xa3c8ff83,0xa3c8ff83,0xa3c88000,0x100000,0x40ff83,0x40ff83,0x0,0x0,0x20000000,0x4000000,0x8000000,0x0,0x0,0x0,0x20000,0x8000,0x20000,};
   }
   private static void jj_la1_init_2() {
      jj_la1_2 = new int[] {0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x80000000,0x0,0x10c0000,0xc0000,0x10c0000,0x80000000,0x80000000,0xc0000000,0xc0000000,0x0,0xc0000000,0xc0000000,0xc0000000,0x0,0xc0000000,0x8000,0xc0000000,0x80000000,0x80000000,0xc0000000,0xc0000000,0x0,0x0,0x0,0x0,0x0,0x0,0x80000000,0xc0000000,0x0,0x0,0x0,0xc000d220,0xc000d220,0xd220,0x0,0xc4008000,0xc4008000,0x100,0x100,0x0,0x0,0x0,0x100,0x80,0x400,0x0,0x0,0x0,};
   }
   private static void jj_la1_init_3() {
      jj_la1_3 = new int[] {0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x1,0x1,0x1,0x0,0x1,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x200,0x4,0x0,0x0,0x0,0x200,0x4,0x1,0x1,0x0,0x0,0x1,0x1,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,};
   }
  final private JJCalls[] jj_2_rtns = new JJCalls[12];
  private boolean jj_rescan = false;
  private int jj_gc = 0;

  /** Constructor with InputStream. */
  public SoyFileParser(java.io.InputStream stream) {
     this(stream, null);
  }
  /** Constructor with InputStream and supplied encoding */
  public SoyFileParser(java.io.InputStream stream, String encoding) {
    try { jj_input_stream = new SimpleCharStream(stream, encoding, 1, 1); } catch(java.io.UnsupportedEncodingException e) { throw new RuntimeException(e); }
    token_source = new SoyFileParserTokenManager(jj_input_stream);
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 57; i++) jj_la1[i] = -1;
    for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
  }

  /** Reinitialise. */
  public void ReInit(java.io.InputStream stream) {
     ReInit(stream, null);
  }
  /** Reinitialise. */
  public void ReInit(java.io.InputStream stream, String encoding) {
    try { jj_input_stream.ReInit(stream, encoding, 1, 1); } catch(java.io.UnsupportedEncodingException e) { throw new RuntimeException(e); }
    token_source.ReInit(jj_input_stream);
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 57; i++) jj_la1[i] = -1;
    for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
  }

  /** Constructor. */
  public SoyFileParser(java.io.Reader stream) {
    jj_input_stream = new SimpleCharStream(stream, 1, 1);
    token_source = new SoyFileParserTokenManager(jj_input_stream);
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 57; i++) jj_la1[i] = -1;
    for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
  }

  /** Reinitialise. */
  public void ReInit(java.io.Reader stream) {
    jj_input_stream.ReInit(stream, 1, 1);
    token_source.ReInit(jj_input_stream);
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 57; i++) jj_la1[i] = -1;
    for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
  }

  /** Constructor with generated Token Manager. */
  public SoyFileParser(SoyFileParserTokenManager tm) {
    token_source = tm;
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 57; i++) jj_la1[i] = -1;
    for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
  }

  /** Reinitialise. */
  public void ReInit(SoyFileParserTokenManager tm) {
    token_source = tm;
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 57; i++) jj_la1[i] = -1;
    for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
  }

  private Token jj_consume_token(int kind) throws ParseException {
    Token oldToken;
    if ((oldToken = token).next != null) token = token.next;
    else token = token.next = token_source.getNextToken();
    jj_ntk = -1;
    if (token.kind == kind) {
      jj_gen++;
      if (++jj_gc > 100) {
        jj_gc = 0;
        for (int i = 0; i < jj_2_rtns.length; i++) {
          JJCalls c = jj_2_rtns[i];
          while (c != null) {
            if (c.gen < jj_gen) c.first = null;
            c = c.next;
          }
        }
      }
      return token;
    }
    token = oldToken;
    jj_kind = kind;
    throw generateParseException();
  }

  static private final class LookaheadSuccess extends java.lang.Error { }
  final private LookaheadSuccess jj_ls = new LookaheadSuccess();
  private boolean jj_scan_token(int kind) {
    if (jj_scanpos == jj_lastpos) {
      jj_la--;
      if (jj_scanpos.next == null) {
        jj_lastpos = jj_scanpos = jj_scanpos.next = token_source.getNextToken();
      } else {
        jj_lastpos = jj_scanpos = jj_scanpos.next;
      }
    } else {
      jj_scanpos = jj_scanpos.next;
    }
    if (jj_rescan) {
      int i = 0; Token tok = token;
      while (tok != null && tok != jj_scanpos) { i++; tok = tok.next; }
      if (tok != null) jj_add_error_token(kind, i);
    }
    if (jj_scanpos.kind != kind) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) throw jj_ls;
    return false;
  }


/** Get the next Token. */
  final public Token getNextToken() {
    if (token.next != null) token = token.next;
    else token = token.next = token_source.getNextToken();
    jj_ntk = -1;
    jj_gen++;
    return token;
  }

/** Get the specific Token. */
  final public Token getToken(int index) {
    Token t = token;
    for (int i = 0; i < index; i++) {
      if (t.next != null) t = t.next;
      else t = t.next = token_source.getNextToken();
    }
    return t;
  }

  private int jj_ntk() {
    if ((jj_nt=token.next) == null)
      return (jj_ntk = (token.next=token_source.getNextToken()).kind);
    else
      return (jj_ntk = jj_nt.kind);
  }

  private java.util.List<int[]> jj_expentries = new java.util.ArrayList<int[]>();
  private int[] jj_expentry;
  private int jj_kind = -1;
  private int[] jj_lasttokens = new int[100];
  private int jj_endpos;

  private void jj_add_error_token(int kind, int pos) {
    if (pos >= 100) return;
    if (pos == jj_endpos + 1) {
      jj_lasttokens[jj_endpos++] = kind;
    } else if (jj_endpos != 0) {
      jj_expentry = new int[jj_endpos];
      for (int i = 0; i < jj_endpos; i++) {
        jj_expentry[i] = jj_lasttokens[i];
      }
      jj_entries_loop: for (java.util.Iterator<?> it = jj_expentries.iterator(); it.hasNext();) {
        int[] oldentry = (int[])(it.next());
        if (oldentry.length == jj_expentry.length) {
          for (int i = 0; i < jj_expentry.length; i++) {
            if (oldentry[i] != jj_expentry[i]) {
              continue jj_entries_loop;
            }
          }
          jj_expentries.add(jj_expentry);
          break jj_entries_loop;
        }
      }
      if (pos != 0) jj_lasttokens[(jj_endpos = pos) - 1] = kind;
    }
  }

  /** Generate ParseException. */
  public ParseException generateParseException() {
    jj_expentries.clear();
    boolean[] la1tokens = new boolean[107];
    if (jj_kind >= 0) {
      la1tokens[jj_kind] = true;
      jj_kind = -1;
    }
    for (int i = 0; i < 57; i++) {
      if (jj_la1[i] == jj_gen) {
        for (int j = 0; j < 32; j++) {
          if ((jj_la1_0[i] & (1<<j)) != 0) {
            la1tokens[j] = true;
          }
          if ((jj_la1_1[i] & (1<<j)) != 0) {
            la1tokens[32+j] = true;
          }
          if ((jj_la1_2[i] & (1<<j)) != 0) {
            la1tokens[64+j] = true;
          }
          if ((jj_la1_3[i] & (1<<j)) != 0) {
            la1tokens[96+j] = true;
          }
        }
      }
    }
    for (int i = 0; i < 107; i++) {
      if (la1tokens[i]) {
        jj_expentry = new int[1];
        jj_expentry[0] = i;
        jj_expentries.add(jj_expentry);
      }
    }
    jj_endpos = 0;
    jj_rescan_token();
    jj_add_error_token(0, 0);
    int[][] exptokseq = new int[jj_expentries.size()][];
    for (int i = 0; i < jj_expentries.size(); i++) {
      exptokseq[i] = jj_expentries.get(i);
    }
    return new ParseException(token, exptokseq, tokenImage);
  }

  /** Enable tracing. */
  final public void enable_tracing() {
  }

  /** Disable tracing. */
  final public void disable_tracing() {
  }

  private void jj_rescan_token() {
    jj_rescan = true;
    for (int i = 0; i < 12; i++) {
    try {
      JJCalls p = jj_2_rtns[i];
      do {
        if (p.gen > jj_gen) {
          jj_la = p.arg; jj_lastpos = jj_scanpos = p.first;
          switch (i) {
            case 0: jj_3_1(); break;
            case 1: jj_3_2(); break;
            case 2: jj_3_3(); break;
            case 3: jj_3_4(); break;
            case 4: jj_3_5(); break;
            case 5: jj_3_6(); break;
            case 6: jj_3_7(); break;
            case 7: jj_3_8(); break;
            case 8: jj_3_9(); break;
            case 9: jj_3_10(); break;
            case 10: jj_3_11(); break;
            case 11: jj_3_12(); break;
          }
        }
        p = p.next;
      } while (p != null);
      } catch(LookaheadSuccess ls) { }
    }
    jj_rescan = false;
  }

  private void jj_save(int index, int xla) {
    JJCalls p = jj_2_rtns[index];
    while (p.gen > jj_gen) {
      if (p.next == null) { p = p.next = new JJCalls(); break; }
      p = p.next;
    }
    p.gen = jj_gen + xla - jj_la; p.first = token; p.arg = xla;
  }

  static final class JJCalls {
    int gen;
    Token first;
    int arg;
    JJCalls next;
  }

}
