/* Generated By:JavaCC: Do not edit this line. TemplateParserTokenManager.java */
package com.google.template.soy.soyparse;
import com.google.common.base.CharMatcher;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.template.soy.soyparse.ErrorReporter;
import com.google.template.soy.base.SourceLocation;
import com.google.template.soy.base.internal.IdGenerator;
import com.google.template.soy.soytree.CallBasicNode;
import com.google.template.soy.soytree.CallDelegateNode;
import com.google.template.soy.soytree.CallNode;
import com.google.template.soy.soytree.CallParamContentNode;
import com.google.template.soy.soytree.CallParamNode;
import com.google.template.soy.soytree.CallParamValueNode;
import com.google.template.soy.soytree.CssNode;
import com.google.template.soy.soytree.DebuggerNode;
import com.google.template.soy.soytree.ForNode;
import com.google.template.soy.soytree.ForeachNode;
import com.google.template.soy.soytree.IfCondNode;
import com.google.template.soy.soytree.IfElseNode;
import com.google.template.soy.soytree.IfNode;
import com.google.template.soy.soytree.LetContentNode;
import com.google.template.soy.soytree.LetNode;
import com.google.template.soy.soytree.LetValueNode;
import com.google.template.soy.soytree.LogNode;
import com.google.template.soy.soytree.MsgFallbackGroupNode;
import com.google.template.soy.soytree.MsgHtmlTagNode;
import com.google.template.soy.soytree.MsgNode;
import com.google.template.soy.soytree.MsgPlaceholderNode;
import com.google.template.soy.soytree.MsgPluralCaseNode;
import com.google.template.soy.soytree.MsgPluralDefaultNode;
import com.google.template.soy.soytree.MsgPluralNode;
import com.google.template.soy.soytree.MsgSelectCaseNode;
import com.google.template.soy.soytree.MsgSelectDefaultNode;
import com.google.template.soy.soytree.MsgSelectNode;
import com.google.template.soy.soytree.PrintDirectiveNode;
import com.google.template.soy.soytree.PrintNode;
import com.google.template.soy.soytree.RawTextNode;
import com.google.template.soy.soytree.SoyNode.CommandNode;
import com.google.template.soy.soytree.SoyNode.MsgPlaceholderInitialNode;
import com.google.template.soy.soytree.SoyNode.StandaloneNode;
import com.google.template.soy.soytree.SoyNode.StatementNode;
import com.google.template.soy.soytree.SwitchCaseNode;
import com.google.template.soy.soytree.SwitchDefaultNode;
import com.google.template.soy.soytree.SwitchNode;
import com.google.template.soy.soytree.TemplateNodeBuilder.DeclInfo;
import com.google.template.soy.soytree.XidNode;
import java.io.*;
import java.util.*;
import java.util.regex.*;

/** Token Manager. */
public class TemplateParserTokenManager implements TemplateParserConstants
{
  /** Enum for the two types of Soy tag delimiters. */
  private static enum SoyTagDelimiter {
    SINGLE_BRACES, DOUBLE_BRACES;
  }


  /**
   * Within a Soy tag, this records what the opening delimiter was (affects what is allowed in the
   * command text and what the closing delimiter should be). Not applicable outside of Soy tags.
   */
  private SoyTagDelimiter currSoyTagDelim = SoyTagDelimiter.SINGLE_BRACES;

  /**
   * Within some Soy tags (the commands requiring special case processing), this records the
   * current command name. Within the rest of the Soy tags, this should be null. Not applicable
   * outside of Soy tags.
   */
  private String currCmdName = null;

  /**
   * Whether we're currently within a 'literal' block. Currently only used to tell when we should
   * be switching to state IN_LITERAL_BLOCK.
   */
  private boolean isInLiteralBlock = false;

  /**
   * Whether we're within a 'msg' block. We need to record this because we sometimes leave
   * states DEFAULT* (e.g. to parse a Soy tag) and then when we're done, we need to know which
   * DEFAULT* state to return to. See switchToStateDefault*() below.
   */
  private boolean isInMsgBlock = false;

  /** Whether we're within an HTML tag. Only applicable within a 'msg' block */
  private boolean isInMsgHtmlTag = false;


  /**
   * Special case processing for tags without command text.
   */
  private void handleSpecialCaseCmdsWithoutCmdText(Token matchedToken) {

    if (currCmdName == null) {
      return;  // not a special case command

    } else if (currCmdName.equals("literal")) {
      isInLiteralBlock = true;

    } else if (currCmdName.equals("/literal")) {
      throwTokenMgrError("Found '/literal' tag outside of any 'literal' block", matchedToken);

    } else if (currCmdName.equals("msg")) {
      throwTokenMgrError("Tag 'msg' must have command text", matchedToken);

    } else if (currCmdName.equals("/msg")) {
      if (! isInMsgBlock) {
        throwTokenMgrError("Found unmatched '/msg' tag", matchedToken);
      }
      if (isInMsgHtmlTag) {
        throwTokenMgrError(
            "Found '/msg' tag while within an HTML tag in a 'msg' block. Please close the HTML" +
            " tag before ending the 'msg' block", matchedToken);
      }
      isInMsgBlock = false;

    } else {
      throw new AssertionError();
    }
  }


  /**
   * Special case processing for tags with command text.
   */
  private void handleSpecialCaseCmdsWithCmdText(Token matchedToken) {

    if (currCmdName == null) {
      return;  // not a special case command

    } else if (currCmdName.equals("literal")) {
      throwTokenMgrError("Tag 'literal' must not have command text", matchedToken);

    } else if (currCmdName.equals("/literal")) {
      throwTokenMgrError("Found '/literal' tag outside of any 'literal' block", matchedToken);

    } else if (currCmdName.equals("msg")) {
      if (isInMsgBlock) {
        throwTokenMgrError("Nested 'msg' tags not allowed", matchedToken);
      }
      isInMsgBlock = true;
      isInMsgHtmlTag = false;

    } else if (currCmdName.equals("/msg")) {
      throwTokenMgrError("Tag '/msg' must not have command text", matchedToken);

    } else {
      throw new AssertionError();
    }
  }


  /**
   * Helper for lexical actions to switch back to one of the states DEFAULT or
   * DEFAULT_IN_MSG_BLOCK_AT_SOL, depending on whether we're currently within a 'msg' block.
   *
   * Note: DEFAULT should really be named DEFAULT_AT_SOL, but since we have to jump through a lot of
   * hoops to change the starting state name in JavaCC, I opted to leave it as DEFAULT.
   */
  private void switchToStateDefaultAtSol() {
    if (isInMsgBlock) {
      SwitchTo(DEFAULT_IN_MSG_BLOCK_AT_SOL);
    } else {
      SwitchTo(DEFAULT);
    }
  }


  /**
   * Helper for lexical actions to switch back to one of the states DEFAULT_NOT_SOL or
   * DEFAULT_IN_MSG_BLOCK_NOT_SOL, depending on whether we're currently within a 'msg' block.
   */
  private void switchToStateDefaultNotSol() {
    if (isInMsgBlock) {
      SwitchTo(DEFAULT_IN_MSG_BLOCK_NOT_SOL);
    } else {
      SwitchTo(DEFAULT_NOT_SOL);
    }
  }


  /**
   * Helper for lexical actions to switch to one of the states DEFAULT_NOT_SOL,
   * DEFAULT_IN_MSG_BLOCK_NOT_SOL, or IN_LITERAL_BLOCK, depending on whether we're currently within
   * a 'literal' block, a 'msg' block (but not a 'literal' block), or neither.
   */
  private void switchToStateDefaultNotSolOrLiteral() {
    if (isInLiteralBlock) {
      SwitchTo(IN_LITERAL_BLOCK);
    } else if (isInMsgBlock) {
      SwitchTo(DEFAULT_IN_MSG_BLOCK_NOT_SOL);
    } else {
      SwitchTo(DEFAULT_NOT_SOL);
    }
  }


  /**
   * Helper for lexical actions to switch to one of the states AFTER_CMD_NAME_1 or AFTER_CMD_NAME_2,
   * depending on the current Soy tag's opening delimiter.
   */
  private void switchToStateAfterCmdName() {
    if (currSoyTagDelim == SoyTagDelimiter.SINGLE_BRACES) {
      SwitchTo(AFTER_CMD_NAME_1);
    } else {
      SwitchTo(AFTER_CMD_NAME_2);
    }
  }


  /**
   * Helper for lexical actions to switch to one of the states IN_CMD_TEXT_1 or IN_CMD_TEXT_2,
   * depending on the current Soy tag's opening delimiter.
   */
  private void switchToStateInCmdText() {
    if (currSoyTagDelim == SoyTagDelimiter.SINGLE_BRACES) {
      SwitchTo(IN_CMD_TEXT_1);
    } else {
      SwitchTo(IN_CMD_TEXT_2);
    }
  }


  /**
   * Creates a new TokenMgrError with the given message and line/column numbers and throws it.
   * @param msg The error message. Should not end with a period because the suffix
   *     " [line ..., column ...]" will be appended.
   * @param matchedToken The current matched token to get the line/column numbers from.
   * @throws TokenMgrError Always.
   */
  private static void throwTokenMgrError(String msg, Token matchedToken) throws TokenMgrError {
    throw new TokenMgrError(
        msg + " [line " + matchedToken.beginLine + ", column " + matchedToken.beginColumn + "].",
        TokenMgrError.LEXICAL_ERROR);
  }

  /** Debug output. */
  public  java.io.PrintStream debugStream = System.out;
  /** Set debug output. */
  public  void setDebugStream(java.io.PrintStream ds) { debugStream = ds; }
private final int jjStopStringLiteralDfa_4(int pos, long active0)
{
   switch (pos)
   {
      case 0:
         if ((active0 & 0x40L) != 0L)
         {
            jjmatchedKind = 5;
            return -1;
         }
         return -1;
      default :
         return -1;
   }
}
private final int jjStartNfa_4(int pos, long active0)
{
   return jjMoveNfa_4(jjStopStringLiteralDfa_4(pos, active0), pos + 1);
}
private int jjStopAtPos(int pos, int kind)
{
   jjmatchedKind = kind;
   jjmatchedPos = pos;
   return pos + 1;
}
private int jjMoveStringLiteralDfa0_4()
{
   switch(curChar)
   {
      case 42:
         return jjMoveStringLiteralDfa1_4(0x40L);
      default :
         return jjMoveNfa_4(0, 0);
   }
}
private int jjMoveStringLiteralDfa1_4(long active0)
{
   try { curChar = input_stream.readChar(); }
   catch(java.io.IOException e) {
      jjStopStringLiteralDfa_4(0, active0);
      return 1;
   }
   switch(curChar)
   {
      case 47:
         if ((active0 & 0x40L) != 0L)
            return jjStopAtPos(1, 6);
         break;
      default :
         break;
   }
   return jjStartNfa_4(0, active0);
}
static final long[] jjbitVec0 = {
   0xfffffffffffffffeL, 0xffffffffffffffffL, 0xffffffffffffffffL, 0xffffffffffffffffL
};
static final long[] jjbitVec2 = {
   0x0L, 0x0L, 0xffffffffffffffffL, 0xffffffffffffffffL
};
private int jjMoveNfa_4(int startState, int curPos)
{
   int startsAt = 0;
   jjnewStateCnt = 2;
   int i = 1;
   jjstateSet[0] = startState;
   int kind = 0x7fffffff;
   for (;;)
   {
      if (++jjround == 0x7fffffff)
         ReInitRounds();
      if (curChar < 64)
      {
         long l = 1L << curChar;
         do
         {
            switch(jjstateSet[--i])
            {
               case 0:
                  if (kind > 5)
                     kind = 5;
                  if (curChar == 63)
                  {
                     if (kind > 98)
                        kind = 98;
                  }
                  break;
               case 1:
                  if (curChar == 63 && kind > 98)
                     kind = 98;
                  break;
               default : break;
            }
         } while(i != startsAt);
      }
      else if (curChar < 128)
      {
         long l = 1L << (curChar & 077);
         do
         {
            switch(jjstateSet[--i])
            {
               case 0:
                  kind = 5;
                  break;
               default : break;
            }
         } while(i != startsAt);
      }
      else
      {
         int hiByte = (int)(curChar >> 8);
         int i1 = hiByte >> 6;
         long l1 = 1L << (hiByte & 077);
         int i2 = (curChar & 0xff) >> 6;
         long l2 = 1L << (curChar & 077);
         do
         {
            switch(jjstateSet[--i])
            {
               case 0:
                  if (jjCanMove_0(hiByte, i1, i2, l1, l2) && kind > 5)
                     kind = 5;
                  break;
               default : break;
            }
         } while(i != startsAt);
      }
      if (kind != 0x7fffffff)
      {
         jjmatchedKind = kind;
         jjmatchedPos = curPos;
         kind = 0x7fffffff;
      }
      ++curPos;
      if ((i = jjnewStateCnt) == (startsAt = 2 - (jjnewStateCnt = startsAt)))
         return curPos;
      try { curChar = input_stream.readChar(); }
      catch(java.io.IOException e) { return curPos; }
   }
}
private int jjMoveStringLiteralDfa0_11()
{
   return jjMoveNfa_11(0, 0);
}
private int jjMoveNfa_11(int startState, int curPos)
{
   int startsAt = 0;
   jjnewStateCnt = 46;
   int i = 1;
   jjstateSet[0] = startState;
   int kind = 0x7fffffff;
   for (;;)
   {
      if (++jjround == 0x7fffffff)
         ReInitRounds();
      if (curChar < 64)
      {
         long l = 1L << curChar;
         do
         {
            switch(jjstateSet[--i])
            {
               case 0:
                  if (kind > 82)
                     kind = 82;
                  if (curChar == 63)
                  {
                     if (kind > 98)
                        kind = 98;
                  }
                  break;
               case 1:
                  if (curChar == 63 && kind > 98)
                     kind = 98;
                  break;
               case 4:
                  if ((0x100002600L & l) != 0L && kind > 84)
                     kind = 84;
                  break;
               case 5:
                  if (curChar == 10 && kind > 84)
                     kind = 84;
                  break;
               case 6:
                  if (curChar == 13)
                     jjstateSet[jjnewStateCnt++] = 5;
                  break;
               case 13:
                  if (curChar == 47)
                     jjstateSet[jjnewStateCnt++] = 12;
                  break;
               case 15:
                  if ((0x100002600L & l) != 0L && kind > 85)
                     kind = 85;
                  break;
               case 16:
                  if (curChar == 10 && kind > 85)
                     kind = 85;
                  break;
               case 17:
                  if (curChar == 13)
                     jjstateSet[jjnewStateCnt++] = 16;
                  break;
               case 33:
                  if (curChar == 47)
                     jjstateSet[jjnewStateCnt++] = 32;
                  break;
               case 42:
                  if (curChar == 47)
                     jjstateSet[jjnewStateCnt++] = 41;
                  break;
               default : break;
            }
         } while(i != startsAt);
      }
      else if (curChar < 128)
      {
         long l = 1L << (curChar & 077);
         do
         {
            switch(jjstateSet[--i])
            {
               case 0:
                  if (kind > 82)
                     kind = 82;
                  if (curChar == 123)
                     jjAddStates(0, 3);
                  if (curChar == 123)
                     jjCheckNAddTwoStates(13, 23);
                  break;
               case 2:
                  if (curChar == 123)
                     jjCheckNAddTwoStates(13, 23);
                  break;
               case 3:
                  if (curChar == 108)
                     jjAddStates(4, 5);
                  break;
               case 7:
                  if (curChar == 97)
                     jjstateSet[jjnewStateCnt++] = 3;
                  break;
               case 8:
                  if (curChar == 114)
                     jjstateSet[jjnewStateCnt++] = 7;
                  break;
               case 9:
                  if (curChar == 101)
                     jjstateSet[jjnewStateCnt++] = 8;
                  break;
               case 10:
                  if (curChar == 116)
                     jjstateSet[jjnewStateCnt++] = 9;
                  break;
               case 11:
                  if (curChar == 105)
                     jjstateSet[jjnewStateCnt++] = 10;
                  break;
               case 12:
                  if (curChar == 108)
                     jjstateSet[jjnewStateCnt++] = 11;
                  break;
               case 14:
                  if (curChar == 108)
                     jjAddStates(6, 7);
                  break;
               case 15:
                  if (curChar == 125 && kind > 85)
                     kind = 85;
                  break;
               case 18:
                  if (curChar == 97)
                     jjstateSet[jjnewStateCnt++] = 14;
                  break;
               case 19:
                  if (curChar == 114)
                     jjstateSet[jjnewStateCnt++] = 18;
                  break;
               case 20:
                  if (curChar == 101)
                     jjstateSet[jjnewStateCnt++] = 19;
                  break;
               case 21:
                  if (curChar == 116)
                     jjstateSet[jjnewStateCnt++] = 20;
                  break;
               case 22:
                  if (curChar == 105)
                     jjstateSet[jjnewStateCnt++] = 21;
                  break;
               case 23:
                  if (curChar == 108)
                     jjstateSet[jjnewStateCnt++] = 22;
                  break;
               case 24:
                  if (curChar == 123)
                     jjAddStates(0, 3);
                  break;
               case 25:
                  if (curChar == 125 && kind > 83)
                     kind = 83;
                  break;
               case 26:
                  if (curChar == 108)
                     jjCheckNAdd(25);
                  break;
               case 27:
                  if (curChar == 97)
                     jjstateSet[jjnewStateCnt++] = 26;
                  break;
               case 28:
                  if (curChar == 114)
                     jjstateSet[jjnewStateCnt++] = 27;
                  break;
               case 29:
                  if (curChar == 101)
                     jjstateSet[jjnewStateCnt++] = 28;
                  break;
               case 30:
                  if (curChar == 116)
                     jjstateSet[jjnewStateCnt++] = 29;
                  break;
               case 31:
                  if (curChar == 105)
                     jjstateSet[jjnewStateCnt++] = 30;
                  break;
               case 32:
                  if (curChar == 108)
                     jjstateSet[jjnewStateCnt++] = 31;
                  break;
               case 34:
                  if (curChar == 125)
                     jjCheckNAdd(25);
                  break;
               case 35:
                  if (curChar == 108)
                     jjstateSet[jjnewStateCnt++] = 34;
                  break;
               case 36:
                  if (curChar == 97)
                     jjstateSet[jjnewStateCnt++] = 35;
                  break;
               case 37:
                  if (curChar == 114)
                     jjstateSet[jjnewStateCnt++] = 36;
                  break;
               case 38:
                  if (curChar == 101)
                     jjstateSet[jjnewStateCnt++] = 37;
                  break;
               case 39:
                  if (curChar == 116)
                     jjstateSet[jjnewStateCnt++] = 38;
                  break;
               case 40:
                  if (curChar == 105)
                     jjstateSet[jjnewStateCnt++] = 39;
                  break;
               case 41:
                  if (curChar == 108)
                     jjstateSet[jjnewStateCnt++] = 40;
                  break;
               case 43:
                  if (curChar == 123)
                     jjstateSet[jjnewStateCnt++] = 42;
                  break;
               case 44:
                  if (curChar == 123)
                     jjCheckNAdd(13);
                  break;
               case 45:
                  if (curChar == 123)
                     jjCheckNAdd(23);
                  break;
               default : break;
            }
         } while(i != startsAt);
      }
      else
      {
         int hiByte = (int)(curChar >> 8);
         int i1 = hiByte >> 6;
         long l1 = 1L << (hiByte & 077);
         int i2 = (curChar & 0xff) >> 6;
         long l2 = 1L << (curChar & 077);
         do
         {
            switch(jjstateSet[--i])
            {
               case 0:
                  if (jjCanMove_0(hiByte, i1, i2, l1, l2) && kind > 82)
                     kind = 82;
                  break;
               default : break;
            }
         } while(i != startsAt);
      }
      if (kind != 0x7fffffff)
      {
         jjmatchedKind = kind;
         jjmatchedPos = curPos;
         kind = 0x7fffffff;
      }
      ++curPos;
      if ((i = jjnewStateCnt) == (startsAt = 46 - (jjnewStateCnt = startsAt)))
         return curPos;
      try { curChar = input_stream.readChar(); }
      catch(java.io.IOException e) { return curPos; }
   }
}
private final int jjStopStringLiteralDfa_6(int pos, long active0)
{
   switch (pos)
   {
      case 0:
         if ((active0 & 0xa0000000000000L) != 0L)
            return 11;
         if ((active0 & 0x40000200000000L) != 0L)
            return 5;
         if ((active0 & 0x3000L) != 0L)
         {
            jjmatchedKind = 14;
            jjmatchedPos = 0;
            return 1;
         }
         if ((active0 & 0x414528854800000L) != 0L)
            return 19;
         return -1;
      case 1:
         if ((active0 & 0xa0000000000000L) != 0L)
            return 10;
         if ((active0 & 0x40000000000000L) != 0L)
            return 4;
         if ((active0 & 0x3000L) != 0L)
         {
            if (jjmatchedPos != 1)
            {
               jjmatchedKind = 14;
               jjmatchedPos = 1;
            }
            return 26;
         }
         return -1;
      case 2:
         if ((active0 & 0x3000L) != 0L)
         {
            if (jjmatchedPos != 2)
            {
               jjmatchedKind = 14;
               jjmatchedPos = 2;
            }
            return 26;
         }
         return -1;
      case 3:
         if ((active0 & 0x3000L) != 0L)
         {
            if (jjmatchedPos != 3)
            {
               jjmatchedKind = 14;
               jjmatchedPos = 3;
            }
            return 26;
         }
         return -1;
      case 4:
         if ((active0 & 0x3000L) != 0L)
         {
            jjmatchedKind = 14;
            jjmatchedPos = 4;
            return 26;
         }
         return -1;
      case 5:
         if ((active0 & 0x2000L) != 0L)
         {
            jjmatchedKind = 14;
            jjmatchedPos = 5;
            return 26;
         }
         if ((active0 & 0x1000L) != 0L)
            return 26;
         return -1;
      case 6:
         if ((active0 & 0x2000L) != 0L)
            return 26;
         return -1;
      default :
         return -1;
   }
}
private final int jjStartNfa_6(int pos, long active0)
{
   return jjMoveNfa_6(jjStopStringLiteralDfa_6(pos, active0), pos + 1);
}
private int jjMoveStringLiteralDfa0_6()
{
   switch(curChar)
   {
      case 47:
         return jjMoveStringLiteralDfa1_6(0x414528854800000L);
      case 64:
         return jjMoveStringLiteralDfa1_6(0x3000L);
      case 92:
         return jjMoveStringLiteralDfa1_6(0xe0000L);
      case 99:
         return jjMoveStringLiteralDfa1_6(0x40000200000000L);
      case 100:
         return jjMoveStringLiteralDfa1_6(0xa0000000000000L);
      case 101:
         return jjMoveStringLiteralDfa1_6(0x6000000000L);
      case 102:
         return jjMoveStringLiteralDfa1_6(0x240002000000L);
      case 105:
         return jjMoveStringLiteralDfa1_6(0x81000000000L);
      case 108:
         return jjMoveStringLiteralDfa1_6(0x8000400500000L);
      case 109:
         return jjMoveStringLiteralDfa1_6(0x1000000L);
      case 110:
         return jjMoveStringLiteralDfa1_6(0x100000000010000L);
      case 112:
         return jjMoveStringLiteralDfa1_6(0x2000088000000L);
      case 114:
         return jjMoveStringLiteralDfa1_6(0x200000L);
      case 115:
         return jjMoveStringLiteralDfa1_6(0x10020008000L);
      case 116:
         return jjMoveStringLiteralDfa1_6(0x200000000000000L);
      case 120:
         return jjMoveStringLiteralDfa1_6(0x100000000L);
      default :
         return jjMoveNfa_6(0, 0);
   }
}
private int jjMoveStringLiteralDfa1_6(long active0)
{
   try { curChar = input_stream.readChar(); }
   catch(java.io.IOException e) {
      jjStopStringLiteralDfa_6(0, active0);
      return 1;
   }
   switch(curChar)
   {
      case 97:
         return jjMoveStringLiteralDfa2_6(active0, 0x142000002000000L);
      case 98:
         if ((active0 & 0x100000L) != 0L)
            return jjStopAtPos(1, 20);
         else if ((active0 & 0x200000L) != 0L)
            return jjStopAtPos(1, 21);
         break;
      case 101:
         return jjMoveStringLiteralDfa2_6(active0, 0x2a0000420000000L);
      case 102:
         if ((active0 & 0x1000000000L) != 0L)
         {
            jjmatchedKind = 36;
            jjmatchedPos = 1;
         }
         return jjMoveStringLiteralDfa2_6(active0, 0x580000000000L);
      case 105:
         return jjMoveStringLiteralDfa2_6(active0, 0x8100412000L);
      case 108:
         return jjMoveStringLiteralDfa2_6(active0, 0x10006808800000L);
      case 109:
         return jjMoveStringLiteralDfa2_6(active0, 0x4000000L);
      case 110:
         if ((active0 & 0x20000L) != 0L)
            return jjStopAtPos(1, 17);
         break;
      case 111:
         return jjMoveStringLiteralDfa2_6(active0, 0x8240000000000L);
      case 112:
         if ((active0 & 0x8000L) != 0L)
            return jjStopAtPos(1, 15);
         return jjMoveStringLiteralDfa2_6(active0, 0x4000010001000L);
      case 114:
         if ((active0 & 0x40000L) != 0L)
            return jjStopAtPos(1, 18);
         return jjMoveStringLiteralDfa2_6(active0, 0x80000000L);
      case 115:
         return jjMoveStringLiteralDfa2_6(active0, 0x20241000000L);
      case 116:
         if ((active0 & 0x80000L) != 0L)
            return jjStopAtPos(1, 19);
         return jjMoveStringLiteralDfa2_6(active0, 0x400000000000000L);
      case 119:
         return jjMoveStringLiteralDfa2_6(active0, 0x10000000000L);
      default :
         break;
   }
   return jjStartNfa_6(0, active0);
}
private int jjMoveStringLiteralDfa2_6(long old0, long active0)
{
   if (((active0 &= old0)) == 0L)
      return jjStartNfa_6(0, old0);
   try { curChar = input_stream.readChar(); }
   catch(java.io.IOException e) {
      jjStopStringLiteralDfa_6(1, active0);
      return 2;
   }
   switch(curChar)
   {
      case 97:
         return jjMoveStringLiteralDfa3_6(active0, 0x4000000001000L);
      case 98:
         return jjMoveStringLiteralDfa3_6(active0, 0x20000000000000L);
      case 100:
         if ((active0 & 0x100000000L) != 0L)
            return jjStopAtPos(2, 32);
         break;
      case 101:
         return jjMoveStringLiteralDfa3_6(active0, 0x400080840000000L);
      case 102:
         if ((active0 & 0x8000000000L) != 0L)
            return jjStopAtPos(2, 39);
         return jjMoveStringLiteralDfa3_6(active0, 0x80000000000000L);
      case 103:
         if ((active0 & 0x1000000L) != 0L)
            return jjStopAtPos(2, 24);
         else if ((active0 & 0x8000000000000L) != 0L)
            return jjStopAtPos(2, 51);
         break;
      case 105:
         return jjMoveStringLiteralDfa3_6(active0, 0x10080800000L);
      case 108:
         if ((active0 & 0x10000L) != 0L)
            return jjStopAtPos(2, 16);
         return jjMoveStringLiteralDfa3_6(active0, 0x32000000L);
      case 109:
         return jjMoveStringLiteralDfa3_6(active0, 0x300000000000000L);
      case 110:
         return jjMoveStringLiteralDfa3_6(active0, 0x2000L);
      case 111:
         return jjMoveStringLiteralDfa3_6(active0, 0x10500000000000L);
      case 114:
         if ((active0 & 0x200000000000L) != 0L)
         {
            jjmatchedKind = 45;
            jjmatchedPos = 2;
         }
         return jjMoveStringLiteralDfa3_6(active0, 0x2040000000000L);
      case 115:
         if ((active0 & 0x200000000L) != 0L)
            return jjStopAtPos(2, 33);
         return jjMoveStringLiteralDfa3_6(active0, 0x40006004000000L);
      case 116:
         if ((active0 & 0x400000000L) != 0L)
            return jjStopAtPos(2, 34);
         return jjMoveStringLiteralDfa3_6(active0, 0x400000L);
      case 117:
         return jjMoveStringLiteralDfa3_6(active0, 0x8000000L);
      case 119:
         return jjMoveStringLiteralDfa3_6(active0, 0x20000000000L);
      default :
         break;
   }
   return jjStartNfa_6(1, active0);
}
private int jjMoveStringLiteralDfa3_6(long old0, long active0)
{
   if (((active0 &= old0)) == 0L)
      return jjStartNfa_6(1, old0);
   try { curChar = input_stream.readChar(); }
   catch(java.io.IOException e) {
      jjStopStringLiteralDfa_6(2, active0);
      return 3;
   }
   switch(curChar)
   {
      case 97:
         return jjMoveStringLiteralDfa4_6(active0, 0x82000000000000L);
      case 101:
         if ((active0 & 0x4000000000L) != 0L)
         {
            jjmatchedKind = 38;
            jjmatchedPos = 3;
         }
         else if ((active0 & 0x40000000000000L) != 0L)
            return jjStopAtPos(3, 54);
         return jjMoveStringLiteralDfa4_6(active0, 0x100042020400000L);
      case 103:
         if ((active0 & 0x4000000L) != 0L)
            return jjStopAtPos(3, 26);
         else if ((active0 & 0x10000000000000L) != 0L)
            return jjStopAtPos(3, 52);
         break;
      case 105:
         return jjMoveStringLiteralDfa4_6(active0, 0x20000000000L);
      case 106:
         return jjMoveStringLiteralDfa4_6(active0, 0x2000L);
      case 108:
         return jjMoveStringLiteralDfa4_6(active0, 0x42000000L);
      case 109:
         return jjMoveStringLiteralDfa4_6(active0, 0x400080000000000L);
      case 110:
         return jjMoveStringLiteralDfa4_6(active0, 0x80000000L);
      case 112:
         return jjMoveStringLiteralDfa4_6(active0, 0x200000000000000L);
      case 114:
         if ((active0 & 0x400000000000L) != 0L)
         {
            jjmatchedKind = 46;
            jjmatchedPos = 3;
         }
         return jjMoveStringLiteralDfa4_6(active0, 0x4100008001000L);
      case 116:
         if ((active0 & 0x800000000L) != 0L)
            return jjStopAtPos(3, 35);
         return jjMoveStringLiteralDfa4_6(active0, 0x10000800000L);
      case 117:
         return jjMoveStringLiteralDfa4_6(active0, 0x20000010000000L);
      default :
         break;
   }
   return jjStartNfa_6(2, active0);
}
private int jjMoveStringLiteralDfa4_6(long old0, long active0)
{
   if (((active0 &= old0)) == 0L)
      return jjStartNfa_6(2, old0);
   try { curChar = input_stream.readChar(); }
   catch(java.io.IOException e) {
      jjStopStringLiteralDfa_6(3, active0);
      return 4;
   }
   switch(curChar)
   {
      case 97:
         return jjMoveStringLiteralDfa5_6(active0, 0x4040008001000L);
      case 98:
         return jjMoveStringLiteralDfa5_6(active0, 0x2000000L);
      case 99:
         return jjMoveStringLiteralDfa5_6(active0, 0x10020000000L);
      case 101:
         return jjMoveStringLiteralDfa5_6(active0, 0x100040802000L);
      case 103:
         return jjMoveStringLiteralDfa5_6(active0, 0x20000000000000L);
      case 105:
         return jjMoveStringLiteralDfa5_6(active0, 0x2000000000L);
      case 108:
         return jjMoveStringLiteralDfa5_6(active0, 0x200000000000000L);
      case 109:
         if ((active0 & 0x2000000000000L) != 0L)
            return jjStopAtPos(4, 49);
         break;
      case 112:
         return jjMoveStringLiteralDfa5_6(active0, 0x400080000000000L);
      case 114:
         return jjMoveStringLiteralDfa5_6(active0, 0x10400000L);
      case 115:
         return jjMoveStringLiteralDfa5_6(active0, 0x100000000000000L);
      case 116:
         if ((active0 & 0x80000000L) != 0L)
            return jjStopAtPos(4, 31);
         return jjMoveStringLiteralDfa5_6(active0, 0x20000000000L);
      case 117:
         return jjMoveStringLiteralDfa5_6(active0, 0x80000000000000L);
      default :
         break;
   }
   return jjStartNfa_6(3, active0);
}
private int jjMoveStringLiteralDfa5_6(long old0, long active0)
{
   if (((active0 &= old0)) == 0L)
      return jjStartNfa_6(3, old0);
   try { curChar = input_stream.readChar(); }
   catch(java.io.IOException e) {
      jjStopStringLiteralDfa_6(4, active0);
      return 5;
   }
   switch(curChar)
   {
      case 97:
         return jjMoveStringLiteralDfa6_6(active0, 0x200100012400000L);
      case 99:
         return jjMoveStringLiteralDfa6_6(active0, 0x60040002000L);
      case 102:
         if ((active0 & 0x2000000000L) != 0L)
            return jjStopAtPos(5, 37);
         break;
      case 103:
         return jjMoveStringLiteralDfa6_6(active0, 0x20000000000000L);
      case 104:
         if ((active0 & 0x10000000000L) != 0L)
            return jjStopAtPos(5, 40);
         break;
      case 108:
         if ((active0 & 0x8000000L) != 0L)
            return jjStopAtPos(5, 27);
         return jjMoveStringLiteralDfa6_6(active0, 0x480000000000000L);
      case 109:
         if ((active0 & 0x1000L) != 0L)
            return jjStartNfaWithStates_6(5, 12, 26);
         else if ((active0 & 0x4000000000000L) != 0L)
            return jjStopAtPos(5, 50);
         break;
      case 112:
         return jjMoveStringLiteralDfa6_6(active0, 0x100000000000000L);
      case 114:
         return jjMoveStringLiteralDfa6_6(active0, 0x800000L);
      case 116:
         if ((active0 & 0x20000000L) != 0L)
            return jjStopAtPos(5, 29);
         return jjMoveStringLiteralDfa6_6(active0, 0x80000000000L);
      default :
         break;
   }
   return jjStartNfa_6(4, active0);
}
private int jjMoveStringLiteralDfa6_6(long old0, long active0)
{
   if (((active0 &= old0)) == 0L)
      return jjStartNfa_6(4, old0);
   try { curChar = input_stream.readChar(); }
   catch(java.io.IOException e) {
      jjStopStringLiteralDfa_6(5, active0);
      return 6;
   }
   switch(curChar)
   {
      case 97:
         return jjMoveStringLiteralDfa7_6(active0, 0x500000000800000L);
      case 99:
         return jjMoveStringLiteralDfa7_6(active0, 0x100002000000L);
      case 101:
         return jjMoveStringLiteralDfa7_6(active0, 0x20000000000000L);
      case 104:
         if ((active0 & 0x20000000000L) != 0L)
            return jjStopAtPos(6, 41);
         else if ((active0 & 0x40000000000L) != 0L)
            return jjStopAtPos(6, 42);
         break;
      case 108:
         if ((active0 & 0x400000L) != 0L)
            return jjStopAtPos(6, 22);
         else if ((active0 & 0x10000000L) != 0L)
            return jjStopAtPos(6, 28);
         break;
      case 116:
         if ((active0 & 0x2000L) != 0L)
            return jjStartNfaWithStates_6(6, 13, 26);
         else if ((active0 & 0x40000000L) != 0L)
            return jjStopAtPos(6, 30);
         else if ((active0 & 0x80000000000000L) != 0L)
            return jjStopAtPos(6, 55);
         return jjMoveStringLiteralDfa7_6(active0, 0x200000000000000L);
      case 121:
         if ((active0 & 0x80000000000L) != 0L)
            return jjStopAtPos(6, 43);
         break;
      default :
         break;
   }
   return jjStartNfa_6(5, active0);
}
private int jjMoveStringLiteralDfa7_6(long old0, long active0)
{
   if (((active0 &= old0)) == 0L)
      return jjStartNfa_6(5, old0);
   try { curChar = input_stream.readChar(); }
   catch(java.io.IOException e) {
      jjStopStringLiteralDfa_6(6, active0);
      return 7;
   }
   switch(curChar)
   {
      case 99:
         return jjMoveStringLiteralDfa8_6(active0, 0x100000000000000L);
      case 101:
         if ((active0 & 0x200000000000000L) != 0L)
            return jjStopAtPos(7, 57);
         break;
      case 104:
         if ((active0 & 0x100000000000L) != 0L)
            return jjStopAtPos(7, 44);
         break;
      case 107:
         return jjMoveStringLiteralDfa8_6(active0, 0x2000000L);
      case 108:
         if ((active0 & 0x800000L) != 0L)
            return jjStopAtPos(7, 23);
         break;
      case 114:
         if ((active0 & 0x20000000000000L) != 0L)
            return jjStopAtPos(7, 53);
         break;
      case 116:
         return jjMoveStringLiteralDfa8_6(active0, 0x400000000000000L);
      default :
         break;
   }
   return jjStartNfa_6(6, active0);
}
private int jjMoveStringLiteralDfa8_6(long old0, long active0)
{
   if (((active0 &= old0)) == 0L)
      return jjStartNfa_6(6, old0);
   try { curChar = input_stream.readChar(); }
   catch(java.io.IOException e) {
      jjStopStringLiteralDfa_6(7, active0);
      return 8;
   }
   switch(curChar)
   {
      case 101:
         if ((active0 & 0x100000000000000L) != 0L)
            return jjStopAtPos(8, 56);
         else if ((active0 & 0x400000000000000L) != 0L)
            return jjStopAtPos(8, 58);
         break;
      case 109:
         return jjMoveStringLiteralDfa9_6(active0, 0x2000000L);
      default :
         break;
   }
   return jjStartNfa_6(7, active0);
}
private int jjMoveStringLiteralDfa9_6(long old0, long active0)
{
   if (((active0 &= old0)) == 0L)
      return jjStartNfa_6(7, old0);
   try { curChar = input_stream.readChar(); }
   catch(java.io.IOException e) {
      jjStopStringLiteralDfa_6(8, active0);
      return 9;
   }
   switch(curChar)
   {
      case 115:
         return jjMoveStringLiteralDfa10_6(active0, 0x2000000L);
      default :
         break;
   }
   return jjStartNfa_6(8, active0);
}
private int jjMoveStringLiteralDfa10_6(long old0, long active0)
{
   if (((active0 &= old0)) == 0L)
      return jjStartNfa_6(8, old0);
   try { curChar = input_stream.readChar(); }
   catch(java.io.IOException e) {
      jjStopStringLiteralDfa_6(9, active0);
      return 10;
   }
   switch(curChar)
   {
      case 103:
         if ((active0 & 0x2000000L) != 0L)
            return jjStopAtPos(10, 25);
         break;
      default :
         break;
   }
   return jjStartNfa_6(9, active0);
}
private int jjStartNfaWithStates_6(int pos, int kind, int state)
{
   jjmatchedKind = kind;
   jjmatchedPos = pos;
   try { curChar = input_stream.readChar(); }
   catch(java.io.IOException e) { return pos + 1; }
   return jjMoveNfa_6(state, pos + 1);
}
private int jjMoveNfa_6(int startState, int curPos)
{
   int startsAt = 0;
   jjnewStateCnt = 26;
   int i = 1;
   jjstateSet[0] = startState;
   int kind = 0x7fffffff;
   for (;;)
   {
      if (++jjround == 0x7fffffff)
         ReInitRounds();
      if (curChar < 64)
      {
         long l = 1L << curChar;
         do
         {
            switch(jjstateSet[--i])
            {
               case 0:
                  if (curChar == 47)
                     jjAddStates(8, 9);
                  else if (curChar == 63)
                  {
                     if (kind > 98)
                        kind = 98;
                  }
                  break;
               case 26:
               case 2:
                  if ((0x3ff000000000000L & l) == 0L)
                     break;
                  kind = 14;
                  jjCheckNAddTwoStates(1, 2);
                  break;
               case 14:
                  if (curChar == 63)
                     kind = 98;
                  break;
               case 15:
                  if (curChar == 47)
                     jjAddStates(8, 9);
                  break;
               default : break;
            }
         } while(i != startsAt);
      }
      else if (curChar < 128)
      {
         long l = 1L << (curChar & 077);
         do
         {
            switch(jjstateSet[--i])
            {
               case 19:
                  if (curChar == 100)
                     jjstateSet[jjnewStateCnt++] = 24;
                  else if (curChar == 99)
                     jjstateSet[jjnewStateCnt++] = 18;
                  break;
               case 0:
                  if ((0x2800000000000000L & l) != 0L)
                  {
                     if (kind > 60)
                        kind = 60;
                  }
                  else if (curChar == 100)
                     jjstateSet[jjnewStateCnt++] = 11;
                  else if (curChar == 99)
                     jjstateSet[jjnewStateCnt++] = 5;
                  else if (curChar == 64)
                  {
                     if (kind > 14)
                        kind = 14;
                     jjCheckNAdd(1);
                  }
                  break;
               case 26:
                  if ((0x7fffffe87fffffeL & l) != 0L)
                  {
                     if (kind > 14)
                        kind = 14;
                     jjCheckNAddTwoStates(1, 2);
                  }
                  if ((0x7fffffe87fffffeL & l) != 0L)
                  {
                     if (kind > 14)
                        kind = 14;
                     jjCheckNAddTwoStates(1, 2);
                  }
                  break;
               case 1:
                  if ((0x7fffffe87fffffeL & l) == 0L)
                     break;
                  if (kind > 14)
                     kind = 14;
                  jjCheckNAddTwoStates(1, 2);
                  break;
               case 2:
                  if ((0x7fffffe87fffffeL & l) == 0L)
                     break;
                  if (kind > 14)
                     kind = 14;
                  jjCheckNAddTwoStates(1, 2);
                  break;
               case 3:
                  if (curChar == 108 && kind > 47)
                     kind = 47;
                  break;
               case 4:
               case 7:
                  if (curChar == 108)
                     jjCheckNAdd(3);
                  break;
               case 5:
                  if (curChar == 97)
                     jjstateSet[jjnewStateCnt++] = 4;
                  break;
               case 6:
                  if (curChar == 99)
                     jjstateSet[jjnewStateCnt++] = 5;
                  break;
               case 8:
                  if (curChar == 97)
                     jjstateSet[jjnewStateCnt++] = 7;
                  break;
               case 9:
                  if (curChar == 99)
                     jjstateSet[jjnewStateCnt++] = 8;
                  break;
               case 10:
                  if (curChar == 108)
                     jjstateSet[jjnewStateCnt++] = 9;
                  break;
               case 11:
                  if (curChar == 101)
                     jjstateSet[jjnewStateCnt++] = 10;
                  break;
               case 12:
                  if (curChar == 100)
                     jjstateSet[jjnewStateCnt++] = 11;
                  break;
               case 13:
                  if ((0x2800000000000000L & l) != 0L)
                     kind = 60;
                  break;
               case 16:
                  if (curChar == 108 && kind > 48)
                     kind = 48;
                  break;
               case 17:
               case 20:
                  if (curChar == 108)
                     jjCheckNAdd(16);
                  break;
               case 18:
                  if (curChar == 97)
                     jjstateSet[jjnewStateCnt++] = 17;
                  break;
               case 21:
                  if (curChar == 97)
                     jjstateSet[jjnewStateCnt++] = 20;
                  break;
               case 22:
                  if (curChar == 99)
                     jjstateSet[jjnewStateCnt++] = 21;
                  break;
               case 23:
                  if (curChar == 108)
                     jjstateSet[jjnewStateCnt++] = 22;
                  break;
               case 24:
                  if (curChar == 101)
                     jjstateSet[jjnewStateCnt++] = 23;
                  break;
               case 25:
                  if (curChar == 100)
                     jjstateSet[jjnewStateCnt++] = 24;
                  break;
               default : break;
            }
         } while(i != startsAt);
      }
      else
      {
         int hiByte = (int)(curChar >> 8);
         int i1 = hiByte >> 6;
         long l1 = 1L << (hiByte & 077);
         int i2 = (curChar & 0xff) >> 6;
         long l2 = 1L << (curChar & 077);
         do
         {
            switch(jjstateSet[--i])
            {
               default : break;
            }
         } while(i != startsAt);
      }
      if (kind != 0x7fffffff)
      {
         jjmatchedKind = kind;
         jjmatchedPos = curPos;
         kind = 0x7fffffff;
      }
      ++curPos;
      if ((i = jjnewStateCnt) == (startsAt = 26 - (jjnewStateCnt = startsAt)))
         return curPos;
      try { curChar = input_stream.readChar(); }
      catch(java.io.IOException e) { return curPos; }
   }
}
private final int jjStopStringLiteralDfa_3(int pos, long active0, long active1)
{
   switch (pos)
   {
      case 0:
         if ((active0 & 0x18L) != 0L)
         {
            jjmatchedKind = 88;
            return -1;
         }
         return -1;
      case 1:
         if ((active0 & 0x18L) != 0L)
         {
            if (jjmatchedPos == 0)
            {
               jjmatchedKind = 88;
               jjmatchedPos = 0;
            }
            return -1;
         }
         return -1;
      default :
         return -1;
   }
}
private final int jjStartNfa_3(int pos, long active0, long active1)
{
   return jjMoveNfa_3(jjStopStringLiteralDfa_3(pos, active0, active1), pos + 1);
}
private int jjMoveStringLiteralDfa0_3()
{
   switch(curChar)
   {
      case 47:
         return jjMoveStringLiteralDfa1_3(0x18L);
      case 60:
         return jjStopAtPos(0, 80);
      case 62:
         return jjStopAtPos(0, 81);
      case 123:
         jjmatchedKind = 8;
         return jjMoveStringLiteralDfa1_3(0x200L);
      case 125:
         jjmatchedKind = 10;
         return jjMoveStringLiteralDfa1_3(0x800L);
      default :
         return jjMoveNfa_3(0, 0);
   }
}
private int jjMoveStringLiteralDfa1_3(long active0)
{
   try { curChar = input_stream.readChar(); }
   catch(java.io.IOException e) {
      jjStopStringLiteralDfa_3(0, active0, 0L);
      return 1;
   }
   switch(curChar)
   {
      case 42:
         if ((active0 & 0x10L) != 0L)
         {
            jjmatchedKind = 4;
            jjmatchedPos = 1;
         }
         return jjMoveStringLiteralDfa2_3(active0, 0x8L);
      case 123:
         if ((active0 & 0x200L) != 0L)
            return jjStopAtPos(1, 9);
         break;
      case 125:
         if ((active0 & 0x800L) != 0L)
            return jjStopAtPos(1, 11);
         break;
      default :
         break;
   }
   return jjStartNfa_3(0, active0, 0L);
}
private int jjMoveStringLiteralDfa2_3(long old0, long active0)
{
   if (((active0 &= old0)) == 0L)
      return jjStartNfa_3(0, old0, 0L);
   try { curChar = input_stream.readChar(); }
   catch(java.io.IOException e) {
      jjStopStringLiteralDfa_3(1, active0, 0L);
      return 2;
   }
   switch(curChar)
   {
      case 42:
         if ((active0 & 0x8L) != 0L)
            return jjStopAtPos(2, 3);
         break;
      default :
         break;
   }
   return jjStartNfa_3(1, active0, 0L);
}
private int jjMoveNfa_3(int startState, int curPos)
{
   int startsAt = 0;
   jjnewStateCnt = 9;
   int i = 1;
   jjstateSet[0] = startState;
   int kind = 0x7fffffff;
   for (;;)
   {
      if (++jjround == 0x7fffffff)
         ReInitRounds();
      if (curChar < 64)
      {
         long l = 1L << curChar;
         do
         {
            switch(jjstateSet[--i])
            {
               case 0:
                  if ((0xfffffffeffffd9ffL & l) != 0L)
                  {
                     if (kind > 88)
                        kind = 88;
                  }
                  else if ((0x100000200L & l) != 0L)
                  {
                     if (kind > 87)
                        kind = 87;
                     jjstateSet[jjnewStateCnt++] = 8;
                  }
                  else if ((0x2400L & l) != 0L)
                  {
                     if (kind > 86)
                        kind = 86;
                  }
                  if (curChar == 13)
                     jjstateSet[jjnewStateCnt++] = 1;
                  else if (curChar == 63)
                  {
                     if (kind > 98)
                        kind = 98;
                  }
                  break;
               case 1:
                  if (curChar == 10 && kind > 86)
                     kind = 86;
                  break;
               case 2:
                  if (curChar == 13)
                     jjstateSet[jjnewStateCnt++] = 1;
                  break;
               case 3:
                  if ((0xfffffffeffffd9ffL & l) != 0L && kind > 88)
                     kind = 88;
                  break;
               case 4:
                  if (curChar == 63 && kind > 98)
                     kind = 98;
                  break;
               case 5:
                  if ((0x100000200L & l) == 0L)
                     break;
                  if (kind > 87)
                     kind = 87;
                  jjstateSet[jjnewStateCnt++] = 8;
                  break;
               case 6:
                  if (curChar != 47)
                     break;
                  if (kind > 2)
                     kind = 2;
                  jjCheckNAdd(7);
                  break;
               case 7:
                  if ((0xffffffffffffdbffL & l) == 0L)
                     break;
                  if (kind > 2)
                     kind = 2;
                  jjCheckNAdd(7);
                  break;
               case 8:
                  if (curChar == 47)
                     jjstateSet[jjnewStateCnt++] = 6;
                  break;
               default : break;
            }
         } while(i != startsAt);
      }
      else if (curChar < 128)
      {
         long l = 1L << (curChar & 077);
         do
         {
            switch(jjstateSet[--i])
            {
               case 0:
                  if (kind > 88)
                     kind = 88;
                  break;
               case 7:
                  if (kind > 2)
                     kind = 2;
                  jjstateSet[jjnewStateCnt++] = 7;
                  break;
               default : break;
            }
         } while(i != startsAt);
      }
      else
      {
         int hiByte = (int)(curChar >> 8);
         int i1 = hiByte >> 6;
         long l1 = 1L << (hiByte & 077);
         int i2 = (curChar & 0xff) >> 6;
         long l2 = 1L << (curChar & 077);
         do
         {
            switch(jjstateSet[--i])
            {
               case 0:
                  if (jjCanMove_0(hiByte, i1, i2, l1, l2) && kind > 88)
                     kind = 88;
                  break;
               case 7:
                  if (!jjCanMove_0(hiByte, i1, i2, l1, l2))
                     break;
                  if (kind > 2)
                     kind = 2;
                  jjstateSet[jjnewStateCnt++] = 7;
                  break;
               default : break;
            }
         } while(i != startsAt);
      }
      if (kind != 0x7fffffff)
      {
         jjmatchedKind = kind;
         jjmatchedPos = curPos;
         kind = 0x7fffffff;
      }
      ++curPos;
      if ((i = jjnewStateCnt) == (startsAt = 9 - (jjnewStateCnt = startsAt)))
         return curPos;
      try { curChar = input_stream.readChar(); }
      catch(java.io.IOException e) { return curPos; }
   }
}
private final int jjStopStringLiteralDfa_10(int pos, long active0, long active1)
{
   switch (pos)
   {
      case 0:
         if ((active1 & 0x800L) != 0L)
         {
            jjmatchedKind = 71;
            return -1;
         }
         if ((active1 & 0x4000L) != 0L)
         {
            jjmatchedKind = 71;
            return 5;
         }
         if ((active1 & 0x400L) != 0L)
         {
            jjmatchedKind = 71;
            return 7;
         }
         return -1;
      case 1:
         if ((active1 & 0x400L) != 0L)
            return 4;
         if ((active1 & 0x800L) != 0L)
         {
            if (jjmatchedPos == 0)
            {
               jjmatchedKind = 71;
               jjmatchedPos = 0;
            }
            return -1;
         }
         return -1;
      default :
         return -1;
   }
}
private final int jjStartNfa_10(int pos, long active0, long active1)
{
   return jjMoveNfa_10(jjStopStringLiteralDfa_10(pos, active0, active1), pos + 1);
}
private int jjMoveStringLiteralDfa0_10()
{
   switch(curChar)
   {
      case 47:
         return jjMoveStringLiteralDfa1_10(0x800L);
      case 123:
         return jjMoveStringLiteralDfa1_10(0x4000L);
      case 125:
         return jjMoveStringLiteralDfa1_10(0x400L);
      default :
         return jjMoveNfa_10(0, 0);
   }
}
private int jjMoveStringLiteralDfa1_10(long active1)
{
   try { curChar = input_stream.readChar(); }
   catch(java.io.IOException e) {
      jjStopStringLiteralDfa_10(0, 0L, active1);
      return 1;
   }
   switch(curChar)
   {
      case 123:
         if ((active1 & 0x4000L) != 0L)
            return jjStopAtPos(1, 78);
         break;
      case 125:
         if ((active1 & 0x400L) != 0L)
            return jjStartNfaWithStates_10(1, 74, 4);
         return jjMoveStringLiteralDfa2_10(active1, 0x800L);
      default :
         break;
   }
   return jjStartNfa_10(0, 0L, active1);
}
private int jjMoveStringLiteralDfa2_10(long old1, long active1)
{
   if (((active1 &= old1)) == 0L)
      return jjStartNfa_10(0, 0L, old1);
   try { curChar = input_stream.readChar(); }
   catch(java.io.IOException e) {
      jjStopStringLiteralDfa_10(1, 0L, active1);
      return 2;
   }
   switch(curChar)
   {
      case 125:
         if ((active1 & 0x800L) != 0L)
            return jjStopAtPos(2, 75);
         break;
      default :
         break;
   }
   return jjStartNfa_10(1, 0L, active1);
}
private int jjStartNfaWithStates_10(int pos, int kind, int state)
{
   jjmatchedKind = kind;
   jjmatchedPos = pos;
   try { curChar = input_stream.readChar(); }
   catch(java.io.IOException e) { return pos + 1; }
   return jjMoveNfa_10(state, pos + 1);
}
private int jjMoveNfa_10(int startState, int curPos)
{
   int startsAt = 0;
   jjnewStateCnt = 32;
   int i = 1;
   jjstateSet[0] = startState;
   int kind = 0x7fffffff;
   for (;;)
   {
      if (++jjround == 0x7fffffff)
         ReInitRounds();
      if (curChar < 64)
      {
         long l = 1L << curChar;
         do
         {
            switch(jjstateSet[--i])
            {
               case 0:
                  if (kind > 71)
                     kind = 71;
                  if ((0x100002600L & l) != 0L)
                     jjAddStates(10, 11);
                  else if (curChar == 63)
                  {
                     if (kind > 98)
                        kind = 98;
                  }
                  break;
               case 2:
                  if ((0x3ff000000000000L & l) == 0L)
                     break;
                  if (kind > 67)
                     kind = 67;
                  jjstateSet[jjnewStateCnt++] = 2;
                  break;
               case 3:
                  if (kind > 71)
                     kind = 71;
                  break;
               case 9:
                  if (curChar == 63 && kind > 98)
                     kind = 98;
                  break;
               case 10:
                  if ((0x100002600L & l) != 0L)
                     jjAddStates(10, 11);
                  break;
               case 11:
                  if (curChar == 34)
                     jjstateSet[jjnewStateCnt++] = 12;
                  break;
               case 13:
                  if ((0x3ff000000000000L & l) != 0L)
                     jjAddStates(12, 13);
                  break;
               case 14:
                  if (curChar == 34 && kind > 68)
                     kind = 68;
                  break;
               case 15:
                  if (curChar == 61)
                     jjstateSet[jjnewStateCnt++] = 11;
                  break;
               case 22:
                  if (curChar == 34)
                     jjCheckNAddTwoStates(23, 24);
                  break;
               case 23:
                  if ((0xfffffffbffffffffL & l) != 0L)
                     jjCheckNAddTwoStates(23, 24);
                  break;
               case 24:
                  if (curChar == 34 && kind > 69)
                     kind = 69;
                  break;
               case 25:
                  if (curChar == 61)
                     jjstateSet[jjnewStateCnt++] = 22;
                  break;
               default : break;
            }
         } while(i != startsAt);
      }
      else if (curChar < 128)
      {
         long l = 1L << (curChar & 077);
         do
         {
            switch(jjstateSet[--i])
            {
               case 0:
                  if (kind > 71)
                     kind = 71;
                  if (curChar == 125)
                     jjstateSet[jjnewStateCnt++] = 7;
                  else if (curChar == 123)
                     jjstateSet[jjnewStateCnt++] = 5;
                  else if (curChar == 124)
                     jjstateSet[jjnewStateCnt++] = 1;
                  break;
               case 1:
               case 2:
                  if ((0x7fffffe87fffffeL & l) == 0L)
                     break;
                  if (kind > 67)
                     kind = 67;
                  jjCheckNAdd(2);
                  break;
               case 3:
                  if (kind > 71)
                     kind = 71;
                  break;
               case 4:
                  if (curChar == 125 && kind > 79)
                     kind = 79;
                  break;
               case 5:
               case 7:
                  if (curChar == 125)
                     jjCheckNAdd(4);
                  break;
               case 6:
                  if (curChar == 123)
                     jjstateSet[jjnewStateCnt++] = 5;
                  break;
               case 8:
                  if (curChar == 125)
                     jjstateSet[jjnewStateCnt++] = 7;
                  break;
               case 12:
               case 13:
                  if ((0x7fffffe87fffffeL & l) != 0L)
                     jjCheckNAddTwoStates(13, 14);
                  break;
               case 16:
                  if (curChar == 101)
                     jjstateSet[jjnewStateCnt++] = 15;
                  break;
               case 17:
                  if (curChar == 109)
                     jjstateSet[jjnewStateCnt++] = 16;
                  break;
               case 18:
                  if (curChar == 97)
                     jjstateSet[jjnewStateCnt++] = 17;
                  break;
               case 19:
                  if (curChar == 110)
                     jjstateSet[jjnewStateCnt++] = 18;
                  break;
               case 20:
                  if (curChar == 104)
                     jjstateSet[jjnewStateCnt++] = 19;
                  break;
               case 21:
                  if (curChar == 112)
                     jjstateSet[jjnewStateCnt++] = 20;
                  break;
               case 23:
                  jjAddStates(14, 15);
                  break;
               case 26:
                  if (curChar == 101)
                     jjstateSet[jjnewStateCnt++] = 25;
                  break;
               case 27:
                  if (curChar == 109)
                     jjstateSet[jjnewStateCnt++] = 26;
                  break;
               case 28:
                  if (curChar == 97)
                     jjstateSet[jjnewStateCnt++] = 27;
                  break;
               case 29:
                  if (curChar == 110)
                     jjstateSet[jjnewStateCnt++] = 28;
                  break;
               case 30:
                  if (curChar == 104)
                     jjstateSet[jjnewStateCnt++] = 29;
                  break;
               case 31:
                  if (curChar == 112)
                     jjstateSet[jjnewStateCnt++] = 30;
                  break;
               default : break;
            }
         } while(i != startsAt);
      }
      else
      {
         int hiByte = (int)(curChar >> 8);
         int i1 = hiByte >> 6;
         long l1 = 1L << (hiByte & 077);
         int i2 = (curChar & 0xff) >> 6;
         long l2 = 1L << (curChar & 077);
         do
         {
            switch(jjstateSet[--i])
            {
               case 0:
                  if (jjCanMove_0(hiByte, i1, i2, l1, l2) && kind > 71)
                     kind = 71;
                  break;
               case 23:
                  if (jjCanMove_0(hiByte, i1, i2, l1, l2))
                     jjAddStates(14, 15);
                  break;
               default : break;
            }
         } while(i != startsAt);
      }
      if (kind != 0x7fffffff)
      {
         jjmatchedKind = kind;
         jjmatchedPos = curPos;
         kind = 0x7fffffff;
      }
      ++curPos;
      if ((i = jjnewStateCnt) == (startsAt = 32 - (jjnewStateCnt = startsAt)))
         return curPos;
      try { curChar = input_stream.readChar(); }
      catch(java.io.IOException e) { return curPos; }
   }
}
private final int jjStopStringLiteralDfa_8(int pos, long active0, long active1)
{
   switch (pos)
   {
      default :
         return -1;
   }
}
private final int jjStartNfa_8(int pos, long active0, long active1)
{
   return jjMoveNfa_8(jjStopStringLiteralDfa_8(pos, active0, active1), pos + 1);
}
private int jjMoveStringLiteralDfa0_8()
{
   switch(curChar)
   {
      case 47:
         return jjMoveStringLiteralDfa1_8(0x0L, 0x1L);
      case 125:
         return jjMoveStringLiteralDfa1_8(0x8000000000000000L, 0x0L);
      default :
         return jjMoveNfa_8(0, 0);
   }
}
private int jjMoveStringLiteralDfa1_8(long active0, long active1)
{
   try { curChar = input_stream.readChar(); }
   catch(java.io.IOException e) {
      jjStopStringLiteralDfa_8(0, active0, active1);
      return 1;
   }
   switch(curChar)
   {
      case 125:
         if ((active0 & 0x8000000000000000L) != 0L)
            return jjStopAtPos(1, 63);
         return jjMoveStringLiteralDfa2_8(active0, 0L, active1, 0x1L);
      default :
         break;
   }
   return jjStartNfa_8(0, active0, active1);
}
private int jjMoveStringLiteralDfa2_8(long old0, long active0, long old1, long active1)
{
   if (((active0 &= old0) | (active1 &= old1)) == 0L)
      return jjStartNfa_8(0, old0, old1);
   try { curChar = input_stream.readChar(); }
   catch(java.io.IOException e) {
      jjStopStringLiteralDfa_8(1, 0L, active1);
      return 2;
   }
   switch(curChar)
   {
      case 125:
         if ((active1 & 0x1L) != 0L)
            return jjStopAtPos(2, 64);
         break;
      default :
         break;
   }
   return jjStartNfa_8(1, 0L, active1);
}
private int jjMoveNfa_8(int startState, int curPos)
{
   int startsAt = 0;
   jjnewStateCnt = 4;
   int i = 1;
   jjstateSet[0] = startState;
   int kind = 0x7fffffff;
   for (;;)
   {
      if (++jjround == 0x7fffffff)
         ReInitRounds();
      if (curChar < 64)
      {
         long l = 1L << curChar;
         do
         {
            switch(jjstateSet[--i])
            {
               case 0:
                  if ((0x100002600L & l) != 0L)
                  {
                     if (kind > 65)
                        kind = 65;
                  }
                  else if (curChar == 63)
                  {
                     if (kind > 98)
                        kind = 98;
                  }
                  if (curChar == 13)
                     jjstateSet[jjnewStateCnt++] = 1;
                  break;
               case 1:
                  if (curChar == 10 && kind > 65)
                     kind = 65;
                  break;
               case 2:
                  if (curChar == 13)
                     jjstateSet[jjnewStateCnt++] = 1;
                  break;
               case 3:
                  if (curChar == 63)
                     kind = 98;
                  break;
               default : break;
            }
         } while(i != startsAt);
      }
      else if (curChar < 128)
      {
         long l = 1L << (curChar & 077);
         do
         {
            switch(jjstateSet[--i])
            {
               default : break;
            }
         } while(i != startsAt);
      }
      else
      {
         int hiByte = (int)(curChar >> 8);
         int i1 = hiByte >> 6;
         long l1 = 1L << (hiByte & 077);
         int i2 = (curChar & 0xff) >> 6;
         long l2 = 1L << (curChar & 077);
         do
         {
            switch(jjstateSet[--i])
            {
               default : break;
            }
         } while(i != startsAt);
      }
      if (kind != 0x7fffffff)
      {
         jjmatchedKind = kind;
         jjmatchedPos = curPos;
         kind = 0x7fffffff;
      }
      ++curPos;
      if ((i = jjnewStateCnt) == (startsAt = 4 - (jjnewStateCnt = startsAt)))
         return curPos;
      try { curChar = input_stream.readChar(); }
      catch(java.io.IOException e) { return curPos; }
   }
}
private final int jjStopStringLiteralDfa_9(int pos, long active0, long active1)
{
   switch (pos)
   {
      case 0:
         if ((active1 & 0x100L) != 0L)
            return 4;
         if ((active1 & 0x200L) != 0L)
         {
            jjmatchedKind = 70;
            return 6;
         }
         return -1;
      default :
         return -1;
   }
}
private final int jjStartNfa_9(int pos, long active0, long active1)
{
   return jjMoveNfa_9(jjStopStringLiteralDfa_9(pos, active0, active1), pos + 1);
}
private int jjMoveStringLiteralDfa0_9()
{
   switch(curChar)
   {
      case 47:
         return jjMoveStringLiteralDfa1_9(0x200L);
      case 123:
         return jjStopAtPos(0, 76);
      case 125:
         return jjStartNfaWithStates_9(0, 72, 4);
      default :
         return jjMoveNfa_9(0, 0);
   }
}
private int jjMoveStringLiteralDfa1_9(long active1)
{
   try { curChar = input_stream.readChar(); }
   catch(java.io.IOException e) {
      jjStopStringLiteralDfa_9(0, 0L, active1);
      return 1;
   }
   switch(curChar)
   {
      case 125:
         if ((active1 & 0x200L) != 0L)
            return jjStartNfaWithStates_9(1, 73, 4);
         break;
      default :
         break;
   }
   return jjStartNfa_9(0, 0L, active1);
}
private int jjStartNfaWithStates_9(int pos, int kind, int state)
{
   jjmatchedKind = kind;
   jjmatchedPos = pos;
   try { curChar = input_stream.readChar(); }
   catch(java.io.IOException e) { return pos + 1; }
   return jjMoveNfa_9(state, pos + 1);
}
private int jjMoveNfa_9(int startState, int curPos)
{
   int startsAt = 0;
   jjnewStateCnt = 31;
   int i = 1;
   jjstateSet[0] = startState;
   int kind = 0x7fffffff;
   for (;;)
   {
      if (++jjround == 0x7fffffff)
         ReInitRounds();
      if (curChar < 64)
      {
         long l = 1L << curChar;
         do
         {
            switch(jjstateSet[--i])
            {
               case 0:
                  if (kind > 70)
                     kind = 70;
                  if ((0x100002600L & l) != 0L)
                     jjAddStates(16, 17);
                  else if (curChar == 47)
                     jjstateSet[jjnewStateCnt++] = 6;
                  else if (curChar == 63)
                  {
                     if (kind > 98)
                        kind = 98;
                  }
                  break;
               case 2:
                  if ((0x3ff000000000000L & l) == 0L)
                     break;
                  if (kind > 67)
                     kind = 67;
                  jjstateSet[jjnewStateCnt++] = 2;
                  break;
               case 3:
                  if (kind > 70)
                     kind = 70;
                  break;
               case 7:
                  if (curChar == 47)
                     jjstateSet[jjnewStateCnt++] = 6;
                  break;
               case 8:
                  if (curChar == 63 && kind > 98)
                     kind = 98;
                  break;
               case 9:
                  if ((0x100002600L & l) != 0L)
                     jjAddStates(16, 17);
                  break;
               case 10:
                  if (curChar == 34)
                     jjstateSet[jjnewStateCnt++] = 11;
                  break;
               case 12:
                  if ((0x3ff000000000000L & l) != 0L)
                     jjAddStates(18, 19);
                  break;
               case 13:
                  if (curChar == 34 && kind > 68)
                     kind = 68;
                  break;
               case 14:
                  if (curChar == 61)
                     jjstateSet[jjnewStateCnt++] = 10;
                  break;
               case 21:
                  if (curChar == 34)
                     jjCheckNAddTwoStates(22, 23);
                  break;
               case 22:
                  if ((0xfffffffbffffffffL & l) != 0L)
                     jjCheckNAddTwoStates(22, 23);
                  break;
               case 23:
                  if (curChar == 34 && kind > 69)
                     kind = 69;
                  break;
               case 24:
                  if (curChar == 61)
                     jjstateSet[jjnewStateCnt++] = 21;
                  break;
               default : break;
            }
         } while(i != startsAt);
      }
      else if (curChar < 128)
      {
         long l = 1L << (curChar & 077);
         do
         {
            switch(jjstateSet[--i])
            {
               case 0:
                  if ((0xd7ffffffffffffffL & l) != 0L)
                  {
                     if (kind > 70)
                        kind = 70;
                  }
                  else if (curChar == 125)
                     jjCheckNAdd(4);
                  if (curChar == 124)
                     jjstateSet[jjnewStateCnt++] = 1;
                  break;
               case 1:
               case 2:
                  if ((0x7fffffe87fffffeL & l) == 0L)
                     break;
                  if (kind > 67)
                     kind = 67;
                  jjCheckNAdd(2);
                  break;
               case 3:
                  if ((0xd7ffffffffffffffL & l) != 0L && kind > 70)
                     kind = 70;
                  break;
               case 4:
                  if (curChar == 125 && kind > 77)
                     kind = 77;
                  break;
               case 5:
               case 6:
                  if (curChar == 125)
                     jjCheckNAdd(4);
                  break;
               case 11:
               case 12:
                  if ((0x7fffffe87fffffeL & l) != 0L)
                     jjCheckNAddTwoStates(12, 13);
                  break;
               case 15:
                  if (curChar == 101)
                     jjstateSet[jjnewStateCnt++] = 14;
                  break;
               case 16:
                  if (curChar == 109)
                     jjstateSet[jjnewStateCnt++] = 15;
                  break;
               case 17:
                  if (curChar == 97)
                     jjstateSet[jjnewStateCnt++] = 16;
                  break;
               case 18:
                  if (curChar == 110)
                     jjstateSet[jjnewStateCnt++] = 17;
                  break;
               case 19:
                  if (curChar == 104)
                     jjstateSet[jjnewStateCnt++] = 18;
                  break;
               case 20:
                  if (curChar == 112)
                     jjstateSet[jjnewStateCnt++] = 19;
                  break;
               case 22:
                  jjAddStates(20, 21);
                  break;
               case 25:
                  if (curChar == 101)
                     jjstateSet[jjnewStateCnt++] = 24;
                  break;
               case 26:
                  if (curChar == 109)
                     jjstateSet[jjnewStateCnt++] = 25;
                  break;
               case 27:
                  if (curChar == 97)
                     jjstateSet[jjnewStateCnt++] = 26;
                  break;
               case 28:
                  if (curChar == 110)
                     jjstateSet[jjnewStateCnt++] = 27;
                  break;
               case 29:
                  if (curChar == 104)
                     jjstateSet[jjnewStateCnt++] = 28;
                  break;
               case 30:
                  if (curChar == 112)
                     jjstateSet[jjnewStateCnt++] = 29;
                  break;
               default : break;
            }
         } while(i != startsAt);
      }
      else
      {
         int hiByte = (int)(curChar >> 8);
         int i1 = hiByte >> 6;
         long l1 = 1L << (hiByte & 077);
         int i2 = (curChar & 0xff) >> 6;
         long l2 = 1L << (curChar & 077);
         do
         {
            switch(jjstateSet[--i])
            {
               case 0:
                  if (jjCanMove_0(hiByte, i1, i2, l1, l2) && kind > 70)
                     kind = 70;
                  break;
               case 22:
                  if (jjCanMove_0(hiByte, i1, i2, l1, l2))
                     jjAddStates(20, 21);
                  break;
               default : break;
            }
         } while(i != startsAt);
      }
      if (kind != 0x7fffffff)
      {
         jjmatchedKind = kind;
         jjmatchedPos = curPos;
         kind = 0x7fffffff;
      }
      ++curPos;
      if ((i = jjnewStateCnt) == (startsAt = 31 - (jjnewStateCnt = startsAt)))
         return curPos;
      try { curChar = input_stream.readChar(); }
      catch(java.io.IOException e) { return curPos; }
   }
}
private final int jjStopStringLiteralDfa_7(int pos, long active0)
{
   switch (pos)
   {
      default :
         return -1;
   }
}
private final int jjStartNfa_7(int pos, long active0)
{
   return jjMoveNfa_7(jjStopStringLiteralDfa_7(pos, active0), pos + 1);
}
private int jjMoveStringLiteralDfa0_7()
{
   switch(curChar)
   {
      case 47:
         return jjMoveStringLiteralDfa1_7(0x4000000000000000L);
      case 125:
         return jjStopAtPos(0, 61);
      default :
         return jjMoveNfa_7(0, 0);
   }
}
private int jjMoveStringLiteralDfa1_7(long active0)
{
   try { curChar = input_stream.readChar(); }
   catch(java.io.IOException e) {
      jjStopStringLiteralDfa_7(0, active0);
      return 1;
   }
   switch(curChar)
   {
      case 125:
         if ((active0 & 0x4000000000000000L) != 0L)
            return jjStopAtPos(1, 62);
         break;
      default :
         break;
   }
   return jjStartNfa_7(0, active0);
}
private int jjMoveNfa_7(int startState, int curPos)
{
   int startsAt = 0;
   jjnewStateCnt = 4;
   int i = 1;
   jjstateSet[0] = startState;
   int kind = 0x7fffffff;
   for (;;)
   {
      if (++jjround == 0x7fffffff)
         ReInitRounds();
      if (curChar < 64)
      {
         long l = 1L << curChar;
         do
         {
            switch(jjstateSet[--i])
            {
               case 0:
                  if ((0x100002600L & l) != 0L)
                  {
                     if (kind > 65)
                        kind = 65;
                  }
                  else if (curChar == 63)
                  {
                     if (kind > 98)
                        kind = 98;
                  }
                  if (curChar == 13)
                     jjstateSet[jjnewStateCnt++] = 1;
                  break;
               case 1:
                  if (curChar == 10 && kind > 65)
                     kind = 65;
                  break;
               case 2:
                  if (curChar == 13)
                     jjstateSet[jjnewStateCnt++] = 1;
                  break;
               case 3:
                  if (curChar == 63)
                     kind = 98;
                  break;
               default : break;
            }
         } while(i != startsAt);
      }
      else if (curChar < 128)
      {
         long l = 1L << (curChar & 077);
         do
         {
            switch(jjstateSet[--i])
            {
               default : break;
            }
         } while(i != startsAt);
      }
      else
      {
         int hiByte = (int)(curChar >> 8);
         int i1 = hiByte >> 6;
         long l1 = 1L << (hiByte & 077);
         int i2 = (curChar & 0xff) >> 6;
         long l2 = 1L << (curChar & 077);
         do
         {
            switch(jjstateSet[--i])
            {
               default : break;
            }
         } while(i != startsAt);
      }
      if (kind != 0x7fffffff)
      {
         jjmatchedKind = kind;
         jjmatchedPos = curPos;
         kind = 0x7fffffff;
      }
      ++curPos;
      if ((i = jjnewStateCnt) == (startsAt = 4 - (jjnewStateCnt = startsAt)))
         return curPos;
      try { curChar = input_stream.readChar(); }
      catch(java.io.IOException e) { return curPos; }
   }
}
private final int jjStopStringLiteralDfa_0(int pos, long active0)
{
   switch (pos)
   {
      case 0:
         if ((active0 & 0x18L) != 0L)
         {
            jjmatchedKind = 88;
            return 0;
         }
         return -1;
      default :
         return -1;
   }
}
private final int jjStartNfa_0(int pos, long active0)
{
   return jjMoveNfa_0(jjStopStringLiteralDfa_0(pos, active0), pos + 1);
}
private int jjMoveStringLiteralDfa0_0()
{
   switch(curChar)
   {
      case 47:
         return jjMoveStringLiteralDfa1_0(0x18L);
      case 123:
         jjmatchedKind = 8;
         return jjMoveStringLiteralDfa1_0(0x200L);
      case 125:
         jjmatchedKind = 10;
         return jjMoveStringLiteralDfa1_0(0x800L);
      default :
         return jjMoveNfa_0(3, 0);
   }
}
private int jjMoveStringLiteralDfa1_0(long active0)
{
   try { curChar = input_stream.readChar(); }
   catch(java.io.IOException e) {
      jjStopStringLiteralDfa_0(0, active0);
      return 1;
   }
   switch(curChar)
   {
      case 42:
         if ((active0 & 0x10L) != 0L)
         {
            jjmatchedKind = 4;
            jjmatchedPos = 1;
         }
         return jjMoveStringLiteralDfa2_0(active0, 0x8L);
      case 123:
         if ((active0 & 0x200L) != 0L)
            return jjStopAtPos(1, 9);
         break;
      case 125:
         if ((active0 & 0x800L) != 0L)
            return jjStopAtPos(1, 11);
         break;
      default :
         break;
   }
   return jjStartNfa_0(0, active0);
}
private int jjMoveStringLiteralDfa2_0(long old0, long active0)
{
   if (((active0 &= old0)) == 0L)
      return jjStartNfa_0(0, old0);
   try { curChar = input_stream.readChar(); }
   catch(java.io.IOException e) {
      jjStopStringLiteralDfa_0(1, active0);
      return 2;
   }
   switch(curChar)
   {
      case 42:
         if ((active0 & 0x8L) != 0L)
            return jjStopAtPos(2, 3);
         break;
      default :
         break;
   }
   return jjStartNfa_0(1, active0);
}
private int jjMoveNfa_0(int startState, int curPos)
{
   int startsAt = 0;
   jjnewStateCnt = 9;
   int i = 1;
   jjstateSet[0] = startState;
   int kind = 0x7fffffff;
   for (;;)
   {
      if (++jjround == 0x7fffffff)
         ReInitRounds();
      if (curChar < 64)
      {
         long l = 1L << curChar;
         do
         {
            switch(jjstateSet[--i])
            {
               case 3:
                  if ((0xfffffffeffffd9ffL & l) != 0L)
                  {
                     if (kind > 88)
                        kind = 88;
                  }
                  else if ((0x100000200L & l) != 0L)
                  {
                     if (kind > 87)
                        kind = 87;
                     jjstateSet[jjnewStateCnt++] = 2;
                  }
                  else if ((0x2400L & l) != 0L)
                  {
                     if (kind > 86)
                        kind = 86;
                  }
                  if (curChar == 13)
                     jjstateSet[jjnewStateCnt++] = 4;
                  else if (curChar == 47)
                     jjstateSet[jjnewStateCnt++] = 0;
                  else if (curChar == 63)
                  {
                     if (kind > 98)
                        kind = 98;
                  }
                  break;
               case 0:
                  if (curChar != 47)
                     break;
                  if (kind > 1)
                     kind = 1;
                  jjCheckNAdd(1);
                  break;
               case 1:
                  if ((0xffffffffffffdbffL & l) == 0L)
                     break;
                  if (kind > 1)
                     kind = 1;
                  jjCheckNAdd(1);
                  break;
               case 2:
                  if (curChar == 47)
                     jjstateSet[jjnewStateCnt++] = 0;
                  break;
               case 4:
                  if (curChar == 10 && kind > 86)
                     kind = 86;
                  break;
               case 5:
                  if (curChar == 13)
                     jjstateSet[jjnewStateCnt++] = 4;
                  break;
               case 6:
                  if ((0xfffffffeffffd9ffL & l) != 0L && kind > 88)
                     kind = 88;
                  break;
               case 7:
                  if (curChar == 63 && kind > 98)
                     kind = 98;
                  break;
               case 8:
                  if ((0x100000200L & l) == 0L)
                     break;
                  if (kind > 87)
                     kind = 87;
                  jjstateSet[jjnewStateCnt++] = 2;
                  break;
               default : break;
            }
         } while(i != startsAt);
      }
      else if (curChar < 128)
      {
         long l = 1L << (curChar & 077);
         do
         {
            switch(jjstateSet[--i])
            {
               case 3:
                  if (kind > 88)
                     kind = 88;
                  break;
               case 1:
                  if (kind > 1)
                     kind = 1;
                  jjstateSet[jjnewStateCnt++] = 1;
                  break;
               default : break;
            }
         } while(i != startsAt);
      }
      else
      {
         int hiByte = (int)(curChar >> 8);
         int i1 = hiByte >> 6;
         long l1 = 1L << (hiByte & 077);
         int i2 = (curChar & 0xff) >> 6;
         long l2 = 1L << (curChar & 077);
         do
         {
            switch(jjstateSet[--i])
            {
               case 3:
                  if (jjCanMove_0(hiByte, i1, i2, l1, l2) && kind > 88)
                     kind = 88;
                  break;
               case 1:
                  if (!jjCanMove_0(hiByte, i1, i2, l1, l2))
                     break;
                  if (kind > 1)
                     kind = 1;
                  jjstateSet[jjnewStateCnt++] = 1;
                  break;
               default : break;
            }
         } while(i != startsAt);
      }
      if (kind != 0x7fffffff)
      {
         jjmatchedKind = kind;
         jjmatchedPos = curPos;
         kind = 0x7fffffff;
      }
      ++curPos;
      if ((i = jjnewStateCnt) == (startsAt = 9 - (jjnewStateCnt = startsAt)))
         return curPos;
      try { curChar = input_stream.readChar(); }
      catch(java.io.IOException e) { return curPos; }
   }
}
private final int jjStopStringLiteralDfa_2(int pos, long active0)
{
   switch (pos)
   {
      case 0:
         if ((active0 & 0x18L) != 0L)
         {
            jjmatchedKind = 88;
            return -1;
         }
         return -1;
      case 1:
         if ((active0 & 0x18L) != 0L)
         {
            if (jjmatchedPos == 0)
            {
               jjmatchedKind = 88;
               jjmatchedPos = 0;
            }
            return -1;
         }
         return -1;
      default :
         return -1;
   }
}
private final int jjStartNfa_2(int pos, long active0)
{
   return jjMoveNfa_2(jjStopStringLiteralDfa_2(pos, active0), pos + 1);
}
private int jjMoveStringLiteralDfa0_2()
{
   switch(curChar)
   {
      case 47:
         return jjMoveStringLiteralDfa1_2(0x18L);
      case 123:
         jjmatchedKind = 8;
         return jjMoveStringLiteralDfa1_2(0x200L);
      case 125:
         jjmatchedKind = 10;
         return jjMoveStringLiteralDfa1_2(0x800L);
      default :
         return jjMoveNfa_2(0, 0);
   }
}
private int jjMoveStringLiteralDfa1_2(long active0)
{
   try { curChar = input_stream.readChar(); }
   catch(java.io.IOException e) {
      jjStopStringLiteralDfa_2(0, active0);
      return 1;
   }
   switch(curChar)
   {
      case 42:
         if ((active0 & 0x10L) != 0L)
         {
            jjmatchedKind = 4;
            jjmatchedPos = 1;
         }
         return jjMoveStringLiteralDfa2_2(active0, 0x8L);
      case 123:
         if ((active0 & 0x200L) != 0L)
            return jjStopAtPos(1, 9);
         break;
      case 125:
         if ((active0 & 0x800L) != 0L)
            return jjStopAtPos(1, 11);
         break;
      default :
         break;
   }
   return jjStartNfa_2(0, active0);
}
private int jjMoveStringLiteralDfa2_2(long old0, long active0)
{
   if (((active0 &= old0)) == 0L)
      return jjStartNfa_2(0, old0);
   try { curChar = input_stream.readChar(); }
   catch(java.io.IOException e) {
      jjStopStringLiteralDfa_2(1, active0);
      return 2;
   }
   switch(curChar)
   {
      case 42:
         if ((active0 & 0x8L) != 0L)
            return jjStopAtPos(2, 3);
         break;
      default :
         break;
   }
   return jjStartNfa_2(1, active0);
}
private int jjMoveNfa_2(int startState, int curPos)
{
   int startsAt = 0;
   jjnewStateCnt = 9;
   int i = 1;
   jjstateSet[0] = startState;
   int kind = 0x7fffffff;
   for (;;)
   {
      if (++jjround == 0x7fffffff)
         ReInitRounds();
      if (curChar < 64)
      {
         long l = 1L << curChar;
         do
         {
            switch(jjstateSet[--i])
            {
               case 0:
                  if ((0xfffffffeffffd9ffL & l) != 0L)
                  {
                     if (kind > 88)
                        kind = 88;
                  }
                  else if ((0x100000200L & l) != 0L)
                  {
                     if (kind > 87)
                        kind = 87;
                     jjstateSet[jjnewStateCnt++] = 8;
                  }
                  else if ((0x2400L & l) != 0L)
                  {
                     if (kind > 86)
                        kind = 86;
                  }
                  if (curChar == 13)
                     jjstateSet[jjnewStateCnt++] = 1;
                  else if (curChar == 63)
                  {
                     if (kind > 98)
                        kind = 98;
                  }
                  break;
               case 1:
                  if (curChar == 10 && kind > 86)
                     kind = 86;
                  break;
               case 2:
                  if (curChar == 13)
                     jjstateSet[jjnewStateCnt++] = 1;
                  break;
               case 3:
                  if ((0xfffffffeffffd9ffL & l) != 0L && kind > 88)
                     kind = 88;
                  break;
               case 4:
                  if (curChar == 63 && kind > 98)
                     kind = 98;
                  break;
               case 5:
                  if ((0x100000200L & l) == 0L)
                     break;
                  if (kind > 87)
                     kind = 87;
                  jjstateSet[jjnewStateCnt++] = 8;
                  break;
               case 6:
                  if (curChar != 47)
                     break;
                  if (kind > 2)
                     kind = 2;
                  jjCheckNAdd(7);
                  break;
               case 7:
                  if ((0xffffffffffffdbffL & l) == 0L)
                     break;
                  if (kind > 2)
                     kind = 2;
                  jjCheckNAdd(7);
                  break;
               case 8:
                  if (curChar == 47)
                     jjstateSet[jjnewStateCnt++] = 6;
                  break;
               default : break;
            }
         } while(i != startsAt);
      }
      else if (curChar < 128)
      {
         long l = 1L << (curChar & 077);
         do
         {
            switch(jjstateSet[--i])
            {
               case 0:
                  if (kind > 88)
                     kind = 88;
                  break;
               case 7:
                  if (kind > 2)
                     kind = 2;
                  jjstateSet[jjnewStateCnt++] = 7;
                  break;
               default : break;
            }
         } while(i != startsAt);
      }
      else
      {
         int hiByte = (int)(curChar >> 8);
         int i1 = hiByte >> 6;
         long l1 = 1L << (hiByte & 077);
         int i2 = (curChar & 0xff) >> 6;
         long l2 = 1L << (curChar & 077);
         do
         {
            switch(jjstateSet[--i])
            {
               case 0:
                  if (jjCanMove_0(hiByte, i1, i2, l1, l2) && kind > 88)
                     kind = 88;
                  break;
               case 7:
                  if (!jjCanMove_0(hiByte, i1, i2, l1, l2))
                     break;
                  if (kind > 2)
                     kind = 2;
                  jjstateSet[jjnewStateCnt++] = 7;
                  break;
               default : break;
            }
         } while(i != startsAt);
      }
      if (kind != 0x7fffffff)
      {
         jjmatchedKind = kind;
         jjmatchedPos = curPos;
         kind = 0x7fffffff;
      }
      ++curPos;
      if ((i = jjnewStateCnt) == (startsAt = 9 - (jjnewStateCnt = startsAt)))
         return curPos;
      try { curChar = input_stream.readChar(); }
      catch(java.io.IOException e) { return curPos; }
   }
}
private final int jjStopStringLiteralDfa_1(int pos, long active0, long active1)
{
   switch (pos)
   {
      case 0:
         if ((active0 & 0x18L) != 0L)
         {
            jjmatchedKind = 88;
            return 0;
         }
         return -1;
      default :
         return -1;
   }
}
private final int jjStartNfa_1(int pos, long active0, long active1)
{
   return jjMoveNfa_1(jjStopStringLiteralDfa_1(pos, active0, active1), pos + 1);
}
private int jjMoveStringLiteralDfa0_1()
{
   switch(curChar)
   {
      case 47:
         return jjMoveStringLiteralDfa1_1(0x18L);
      case 60:
         return jjStopAtPos(0, 80);
      case 62:
         return jjStopAtPos(0, 81);
      case 123:
         jjmatchedKind = 8;
         return jjMoveStringLiteralDfa1_1(0x200L);
      case 125:
         jjmatchedKind = 10;
         return jjMoveStringLiteralDfa1_1(0x800L);
      default :
         return jjMoveNfa_1(3, 0);
   }
}
private int jjMoveStringLiteralDfa1_1(long active0)
{
   try { curChar = input_stream.readChar(); }
   catch(java.io.IOException e) {
      jjStopStringLiteralDfa_1(0, active0, 0L);
      return 1;
   }
   switch(curChar)
   {
      case 42:
         if ((active0 & 0x10L) != 0L)
         {
            jjmatchedKind = 4;
            jjmatchedPos = 1;
         }
         return jjMoveStringLiteralDfa2_1(active0, 0x8L);
      case 123:
         if ((active0 & 0x200L) != 0L)
            return jjStopAtPos(1, 9);
         break;
      case 125:
         if ((active0 & 0x800L) != 0L)
            return jjStopAtPos(1, 11);
         break;
      default :
         break;
   }
   return jjStartNfa_1(0, active0, 0L);
}
private int jjMoveStringLiteralDfa2_1(long old0, long active0)
{
   if (((active0 &= old0)) == 0L)
      return jjStartNfa_1(0, old0, 0L);
   try { curChar = input_stream.readChar(); }
   catch(java.io.IOException e) {
      jjStopStringLiteralDfa_1(1, active0, 0L);
      return 2;
   }
   switch(curChar)
   {
      case 42:
         if ((active0 & 0x8L) != 0L)
            return jjStopAtPos(2, 3);
         break;
      default :
         break;
   }
   return jjStartNfa_1(1, active0, 0L);
}
private int jjMoveNfa_1(int startState, int curPos)
{
   int startsAt = 0;
   jjnewStateCnt = 9;
   int i = 1;
   jjstateSet[0] = startState;
   int kind = 0x7fffffff;
   for (;;)
   {
      if (++jjround == 0x7fffffff)
         ReInitRounds();
      if (curChar < 64)
      {
         long l = 1L << curChar;
         do
         {
            switch(jjstateSet[--i])
            {
               case 3:
                  if ((0xfffffffeffffd9ffL & l) != 0L)
                  {
                     if (kind > 88)
                        kind = 88;
                  }
                  else if ((0x100000200L & l) != 0L)
                  {
                     if (kind > 87)
                        kind = 87;
                     jjstateSet[jjnewStateCnt++] = 2;
                  }
                  else if ((0x2400L & l) != 0L)
                  {
                     if (kind > 86)
                        kind = 86;
                  }
                  if (curChar == 13)
                     jjstateSet[jjnewStateCnt++] = 4;
                  else if (curChar == 47)
                     jjstateSet[jjnewStateCnt++] = 0;
                  else if (curChar == 63)
                  {
                     if (kind > 98)
                        kind = 98;
                  }
                  break;
               case 0:
                  if (curChar != 47)
                     break;
                  if (kind > 1)
                     kind = 1;
                  jjCheckNAdd(1);
                  break;
               case 1:
                  if ((0xffffffffffffdbffL & l) == 0L)
                     break;
                  if (kind > 1)
                     kind = 1;
                  jjCheckNAdd(1);
                  break;
               case 2:
                  if (curChar == 47)
                     jjstateSet[jjnewStateCnt++] = 0;
                  break;
               case 4:
                  if (curChar == 10 && kind > 86)
                     kind = 86;
                  break;
               case 5:
                  if (curChar == 13)
                     jjstateSet[jjnewStateCnt++] = 4;
                  break;
               case 6:
                  if ((0xfffffffeffffd9ffL & l) != 0L && kind > 88)
                     kind = 88;
                  break;
               case 7:
                  if (curChar == 63 && kind > 98)
                     kind = 98;
                  break;
               case 8:
                  if ((0x100000200L & l) == 0L)
                     break;
                  if (kind > 87)
                     kind = 87;
                  jjstateSet[jjnewStateCnt++] = 2;
                  break;
               default : break;
            }
         } while(i != startsAt);
      }
      else if (curChar < 128)
      {
         long l = 1L << (curChar & 077);
         do
         {
            switch(jjstateSet[--i])
            {
               case 3:
                  if (kind > 88)
                     kind = 88;
                  break;
               case 1:
                  if (kind > 1)
                     kind = 1;
                  jjstateSet[jjnewStateCnt++] = 1;
                  break;
               default : break;
            }
         } while(i != startsAt);
      }
      else
      {
         int hiByte = (int)(curChar >> 8);
         int i1 = hiByte >> 6;
         long l1 = 1L << (hiByte & 077);
         int i2 = (curChar & 0xff) >> 6;
         long l2 = 1L << (curChar & 077);
         do
         {
            switch(jjstateSet[--i])
            {
               case 3:
                  if (jjCanMove_0(hiByte, i1, i2, l1, l2) && kind > 88)
                     kind = 88;
                  break;
               case 1:
                  if (!jjCanMove_0(hiByte, i1, i2, l1, l2))
                     break;
                  if (kind > 1)
                     kind = 1;
                  jjstateSet[jjnewStateCnt++] = 1;
                  break;
               default : break;
            }
         } while(i != startsAt);
      }
      if (kind != 0x7fffffff)
      {
         jjmatchedKind = kind;
         jjmatchedPos = curPos;
         kind = 0x7fffffff;
      }
      ++curPos;
      if ((i = jjnewStateCnt) == (startsAt = 9 - (jjnewStateCnt = startsAt)))
         return curPos;
      try { curChar = input_stream.readChar(); }
      catch(java.io.IOException e) { return curPos; }
   }
}
private final int jjStopStringLiteralDfa_5(int pos, long active0)
{
   switch (pos)
   {
      case 0:
         if ((active0 & 0x80L) != 0L)
         {
            jjmatchedKind = 5;
            return -1;
         }
         return -1;
      default :
         return -1;
   }
}
private final int jjStartNfa_5(int pos, long active0)
{
   return jjMoveNfa_5(jjStopStringLiteralDfa_5(pos, active0), pos + 1);
}
private int jjMoveStringLiteralDfa0_5()
{
   switch(curChar)
   {
      case 42:
         return jjMoveStringLiteralDfa1_5(0x80L);
      default :
         return jjMoveNfa_5(0, 0);
   }
}
private int jjMoveStringLiteralDfa1_5(long active0)
{
   try { curChar = input_stream.readChar(); }
   catch(java.io.IOException e) {
      jjStopStringLiteralDfa_5(0, active0);
      return 1;
   }
   switch(curChar)
   {
      case 47:
         if ((active0 & 0x80L) != 0L)
            return jjStopAtPos(1, 7);
         break;
      default :
         break;
   }
   return jjStartNfa_5(0, active0);
}
private int jjMoveNfa_5(int startState, int curPos)
{
   int startsAt = 0;
   jjnewStateCnt = 2;
   int i = 1;
   jjstateSet[0] = startState;
   int kind = 0x7fffffff;
   for (;;)
   {
      if (++jjround == 0x7fffffff)
         ReInitRounds();
      if (curChar < 64)
      {
         long l = 1L << curChar;
         do
         {
            switch(jjstateSet[--i])
            {
               case 0:
                  if (kind > 5)
                     kind = 5;
                  if (curChar == 63)
                  {
                     if (kind > 98)
                        kind = 98;
                  }
                  break;
               case 1:
                  if (curChar == 63 && kind > 98)
                     kind = 98;
                  break;
               default : break;
            }
         } while(i != startsAt);
      }
      else if (curChar < 128)
      {
         long l = 1L << (curChar & 077);
         do
         {
            switch(jjstateSet[--i])
            {
               case 0:
                  kind = 5;
                  break;
               default : break;
            }
         } while(i != startsAt);
      }
      else
      {
         int hiByte = (int)(curChar >> 8);
         int i1 = hiByte >> 6;
         long l1 = 1L << (hiByte & 077);
         int i2 = (curChar & 0xff) >> 6;
         long l2 = 1L << (curChar & 077);
         do
         {
            switch(jjstateSet[--i])
            {
               case 0:
                  if (jjCanMove_0(hiByte, i1, i2, l1, l2) && kind > 5)
                     kind = 5;
                  break;
               default : break;
            }
         } while(i != startsAt);
      }
      if (kind != 0x7fffffff)
      {
         jjmatchedKind = kind;
         jjmatchedPos = curPos;
         kind = 0x7fffffff;
      }
      ++curPos;
      if ((i = jjnewStateCnt) == (startsAt = 2 - (jjnewStateCnt = startsAt)))
         return curPos;
      try { curChar = input_stream.readChar(); }
      catch(java.io.IOException e) { return curPos; }
   }
}
static final int[] jjnextStates = {
   33, 43, 44, 45, 4, 6, 15, 17, 19, 25, 21, 31, 13, 14, 23, 24, 
   20, 30, 12, 13, 22, 23, 
};
private static final boolean jjCanMove_0(int hiByte, int i1, int i2, long l1, long l2)
{
   switch(hiByte)
   {
      case 0:
         return ((jjbitVec2[i2] & l2) != 0L);
      default :
         if ((jjbitVec0[i1] & l1) != 0L)
            return true;
         return false;
   }
}

/** Token literal values. */
public static final String[] jjstrLiteralImages = {
"", null, null, null, null, null, null, null, "\173", "\173\173", "\175", 
"\175\175", "\100\160\141\162\141\155", "\100\151\156\152\145\143\164", null, "\163\160", 
"\156\151\154", "\134\156", "\134\162", "\134\164", "\154\142", "\162\142", 
"\154\151\164\145\162\141\154", "\57\154\151\164\145\162\141\154", "\155\163\147", 
"\146\141\154\154\142\141\143\153\155\163\147", "\57\155\163\147", "\160\154\165\162\141\154", "\57\160\154\165\162\141\154", 
"\163\145\154\145\143\164", "\57\163\145\154\145\143\164", "\160\162\151\156\164", "\170\151\144", 
"\143\163\163", "\154\145\164", "\57\154\145\164", "\151\146", "\145\154\163\145\151\146", 
"\145\154\163\145", "\57\151\146", "\163\167\151\164\143\150", "\57\163\167\151\164\143\150", 
"\146\157\162\145\141\143\150", "\151\146\145\155\160\164\171", "\57\146\157\162\145\141\143\150", 
"\146\157\162", "\57\146\157\162", null, null, "\160\141\162\141\155", 
"\57\160\141\162\141\155", "\154\157\147", "\57\154\157\147", "\144\145\142\165\147\147\145\162", 
"\143\141\163\145", "\144\145\146\141\165\154\164", "\156\141\155\145\163\160\141\143\145", 
"\164\145\155\160\154\141\164\145", "\57\164\145\155\160\154\141\164\145", null, null, "\175", "\57\175", 
"\175\175", "\57\175\175", null, null, null, null, null, null, null, "\175", "\57\175", 
"\175\175", "\57\175\175", "\173", null, "\173\173", null, "\74", "\76", null, null, null, 
null, null, null, null, null, null, null, null, null, null, null, null, null, null, 
null, };

/** Lexer state names. */
public static final String[] lexStateNames = {
   "DEFAULT",
   "DEFAULT_IN_MSG_BLOCK_AT_SOL",
   "DEFAULT_NOT_SOL",
   "DEFAULT_IN_MSG_BLOCK_NOT_SOL",
   "IN_BLOCK_DOC_COMMENT",
   "IN_BLOCK_NONDOC_COMMENT",
   "AFTER_SOY_TAG_OPEN",
   "AFTER_CMD_NAME_1",
   "AFTER_CMD_NAME_2",
   "IN_CMD_TEXT_1",
   "IN_CMD_TEXT_2",
   "IN_LITERAL_BLOCK",
};

/** Lex State array. */
public static final int[] jjnewLexState = {
   -1, -1, -1, 4, 5, -1, -1, -1, 6, 6, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 
   -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 
   -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 
   -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 
};
static final long[] jjtoToken = {
   0xf7ffffffffffffc1L, 0x401fbffffL, 
};
static final long[] jjtoSkip = {
   0x80000000000001eL, 0x0L, 
};
static final long[] jjtoMore = {
   0x20L, 0x40000L, 
};
protected SimpleCharStream input_stream;
private final int[] jjrounds = new int[46];
private final int[] jjstateSet = new int[92];
private final StringBuilder jjimage = new StringBuilder();
private StringBuilder image = jjimage;
private int jjimageLen;
private int lengthOfMatch;
protected char curChar;
/** Constructor. */
public TemplateParserTokenManager(SimpleCharStream stream){
   if (SimpleCharStream.staticFlag)
      throw new Error("ERROR: Cannot use a static CharStream class with a non-static lexical analyzer.");
   input_stream = stream;
}

/** Constructor. */
public TemplateParserTokenManager(SimpleCharStream stream, int lexState){
   this(stream);
   SwitchTo(lexState);
}

/** Reinitialise parser. */
public void ReInit(SimpleCharStream stream)
{
   jjmatchedPos = jjnewStateCnt = 0;
   curLexState = defaultLexState;
   input_stream = stream;
   ReInitRounds();
}
private void ReInitRounds()
{
   int i;
   jjround = 0x80000001;
   for (i = 46; i-- > 0;)
      jjrounds[i] = 0x80000000;
}

/** Reinitialise parser. */
public void ReInit(SimpleCharStream stream, int lexState)
{
   ReInit(stream);
   SwitchTo(lexState);
}

/** Switch to specified lex state. */
public void SwitchTo(int lexState)
{
   if (lexState >= 12 || lexState < 0)
      throw new TokenMgrError("Error: Ignoring invalid lexical state : " + lexState + ". State unchanged.", TokenMgrError.INVALID_LEXICAL_STATE);
   else
      curLexState = lexState;
}

protected Token jjFillToken()
{
   final Token t;
   final String curTokenImage;
   final int beginLine;
   final int endLine;
   final int beginColumn;
   final int endColumn;
   if (jjmatchedPos < 0)
   {
      if (image == null)
         curTokenImage = "";
      else
         curTokenImage = image.toString();
      beginLine = endLine = input_stream.getBeginLine();
      beginColumn = endColumn = input_stream.getBeginColumn();
   }
   else
   {
      String im = jjstrLiteralImages[jjmatchedKind];
      curTokenImage = (im == null) ? input_stream.GetImage() : im;
      beginLine = input_stream.getBeginLine();
      beginColumn = input_stream.getBeginColumn();
      endLine = input_stream.getEndLine();
      endColumn = input_stream.getEndColumn();
   }
   t = Token.newToken(jjmatchedKind, curTokenImage);

   t.beginLine = beginLine;
   t.endLine = endLine;
   t.beginColumn = beginColumn;
   t.endColumn = endColumn;

   return t;
}

int curLexState = 0;
int defaultLexState = 0;
int jjnewStateCnt;
int jjround;
int jjmatchedPos;
int jjmatchedKind;

/** Get the next Token. */
public Token getNextToken() 
{
  Token matchedToken;
  int curPos = 0;

  EOFLoop :
  for (;;)
  {
   try
   {
      curChar = input_stream.BeginToken();
   }
   catch(java.io.IOException e)
   {
      jjmatchedKind = 0;
      matchedToken = jjFillToken();
      return matchedToken;
   }
   image = jjimage;
   image.setLength(0);
   jjimageLen = 0;

   for (;;)
   {
     switch(curLexState)
     {
       case 0:
         jjmatchedKind = 0x7fffffff;
         jjmatchedPos = 0;
         curPos = jjMoveStringLiteralDfa0_0();
         break;
       case 1:
         jjmatchedKind = 0x7fffffff;
         jjmatchedPos = 0;
         curPos = jjMoveStringLiteralDfa0_1();
         break;
       case 2:
         jjmatchedKind = 0x7fffffff;
         jjmatchedPos = 0;
         curPos = jjMoveStringLiteralDfa0_2();
         break;
       case 3:
         jjmatchedKind = 0x7fffffff;
         jjmatchedPos = 0;
         curPos = jjMoveStringLiteralDfa0_3();
         break;
       case 4:
         jjmatchedKind = 0x7fffffff;
         jjmatchedPos = 0;
         curPos = jjMoveStringLiteralDfa0_4();
         break;
       case 5:
         jjmatchedKind = 0x7fffffff;
         jjmatchedPos = 0;
         curPos = jjMoveStringLiteralDfa0_5();
         break;
       case 6:
         jjmatchedKind = 59;
         jjmatchedPos = -1;
         curPos = 0;
         curPos = jjMoveStringLiteralDfa0_6();
         break;
       case 7:
         jjmatchedKind = 66;
         jjmatchedPos = -1;
         curPos = 0;
         curPos = jjMoveStringLiteralDfa0_7();
         break;
       case 8:
         jjmatchedKind = 66;
         jjmatchedPos = -1;
         curPos = 0;
         curPos = jjMoveStringLiteralDfa0_8();
         break;
       case 9:
         jjmatchedKind = 0x7fffffff;
         jjmatchedPos = 0;
         curPos = jjMoveStringLiteralDfa0_9();
         break;
       case 10:
         jjmatchedKind = 0x7fffffff;
         jjmatchedPos = 0;
         curPos = jjMoveStringLiteralDfa0_10();
         break;
       case 11:
         jjmatchedKind = 0x7fffffff;
         jjmatchedPos = 0;
         curPos = jjMoveStringLiteralDfa0_11();
         break;
     }
     if (jjmatchedKind != 0x7fffffff)
     {
        if (jjmatchedPos + 1 < curPos)
           input_stream.backup(curPos - jjmatchedPos - 1);
        if ((jjtoToken[jjmatchedKind >> 6] & (1L << (jjmatchedKind & 077))) != 0L)
        {
           matchedToken = jjFillToken();
           TokenLexicalActions(matchedToken);
       if (jjnewLexState[jjmatchedKind] != -1)
         curLexState = jjnewLexState[jjmatchedKind];
           return matchedToken;
        }
        else if ((jjtoSkip[jjmatchedKind >> 6] & (1L << (jjmatchedKind & 077))) != 0L)
        {
           SkipLexicalActions(null);
         if (jjnewLexState[jjmatchedKind] != -1)
           curLexState = jjnewLexState[jjmatchedKind];
           continue EOFLoop;
        }
        jjimageLen += jjmatchedPos + 1;
      if (jjnewLexState[jjmatchedKind] != -1)
        curLexState = jjnewLexState[jjmatchedKind];
        curPos = 0;
        jjmatchedKind = 0x7fffffff;
        try {
           curChar = input_stream.readChar();
           continue;
        }
        catch (java.io.IOException e1) { }
     }
     int error_line = input_stream.getEndLine();
     int error_column = input_stream.getEndColumn();
     String error_after = null;
     boolean EOFSeen = false;
     try { input_stream.readChar(); input_stream.backup(1); }
     catch (java.io.IOException e1) {
        EOFSeen = true;
        error_after = curPos <= 1 ? "" : input_stream.GetImage();
        if (curChar == '\n' || curChar == '\r') {
           error_line++;
           error_column = 0;
        }
        else
           error_column++;
     }
     if (!EOFSeen) {
        input_stream.backup(1);
        error_after = curPos <= 1 ? "" : input_stream.GetImage();
     }
     throw new TokenMgrError(EOFSeen, curLexState, error_line, error_column, error_after, curChar, TokenMgrError.LEXICAL_ERROR);
   }
  }
}

int[] jjemptyLineNo = new int[12];
int[] jjemptyColNo = new int[12];
boolean[] jjbeenHere = new boolean[12];
void SkipLexicalActions(Token matchedToken)
{
   switch(jjmatchedKind)
   {
      case 1 :
         image.append(input_stream.GetSuffix(jjimageLen + (lengthOfMatch = jjmatchedPos + 1)));
    switchToStateDefaultNotSol();
         break;
      case 59 :
         if (jjmatchedPos == -1)
         {
            if (jjbeenHere[6] &&
                jjemptyLineNo[6] == input_stream.getBeginLine() &&
                jjemptyColNo[6] == input_stream.getBeginColumn())
               throw new TokenMgrError(("Error: Bailing out of infinite loop caused by repeated empty string matches at line " + input_stream.getBeginLine() + ", column " + input_stream.getBeginColumn() + "."), TokenMgrError.LOOP_DETECTED);
            jjemptyLineNo[6] = input_stream.getBeginLine();
            jjemptyColNo[6] = input_stream.getBeginColumn();
            jjbeenHere[6] = true;
         }
         image.append(input_stream.GetSuffix(jjimageLen + (lengthOfMatch = jjmatchedPos + 1)));
                            switchToStateInCmdText();
         break;
      default :
         break;
   }
}
void TokenLexicalActions(Token matchedToken)
{
   switch(jjmatchedKind)
   {
      case 6 :
        image.append(input_stream.GetSuffix(jjimageLen + (lengthOfMatch = jjmatchedPos + 1)));
    // Remove the "*/" token and trim the contents.
    matchedToken.image = image.substring(0, image.length() - 2).trim();
    switchToStateDefaultNotSol();
         break;
      case 7 :
        image.append(input_stream.GetSuffix(jjimageLen + (lengthOfMatch = jjmatchedPos + 1)));
    // Remove the "*/" token and trim the contents.
    matchedToken.image = image.substring(0, image.length() - 2).trim();
    switchToStateDefaultNotSol();
         break;
      case 8 :
        image.append(jjstrLiteralImages[8]);
        lengthOfMatch = jjstrLiteralImages[8].length();
    currSoyTagDelim = SoyTagDelimiter.SINGLE_BRACES;
         break;
      case 9 :
        image.append(jjstrLiteralImages[9]);
        lengthOfMatch = jjstrLiteralImages[9].length();
    currSoyTagDelim = SoyTagDelimiter.DOUBLE_BRACES;
         break;
      case 10 :
        image.append(jjstrLiteralImages[10]);
        lengthOfMatch = jjstrLiteralImages[10].length();
    throwTokenMgrError("Unmatched right brace '}'", matchedToken);
         break;
      case 11 :
        image.append(jjstrLiteralImages[11]);
        lengthOfMatch = jjstrLiteralImages[11].length();
    throwTokenMgrError("Unmatched double right brace '}}'", matchedToken);
         break;
      case 12 :
        image.append(jjstrLiteralImages[12]);
        lengthOfMatch = jjstrLiteralImages[12].length();
                                      switchToStateAfterCmdName();
         break;
      case 13 :
        image.append(jjstrLiteralImages[13]);
        lengthOfMatch = jjstrLiteralImages[13].length();
                                                switchToStateAfterCmdName();
         break;
      case 14 :
        image.append(input_stream.GetSuffix(jjimageLen + (lengthOfMatch = jjmatchedPos + 1)));
    throwTokenMgrError("Invalid declaration '" + matchedToken.image + "'", matchedToken);
         break;
      case 15 :
        image.append(jjstrLiteralImages[15]);
        lengthOfMatch = jjstrLiteralImages[15].length();
                           switchToStateAfterCmdName();
         break;
      case 16 :
        image.append(jjstrLiteralImages[16]);
        lengthOfMatch = jjstrLiteralImages[16].length();
                             switchToStateAfterCmdName();
         break;
      case 17 :
        image.append(jjstrLiteralImages[17]);
        lengthOfMatch = jjstrLiteralImages[17].length();
                            switchToStateAfterCmdName();
         break;
      case 18 :
        image.append(jjstrLiteralImages[18]);
        lengthOfMatch = jjstrLiteralImages[18].length();
                            switchToStateAfterCmdName();
         break;
      case 19 :
        image.append(jjstrLiteralImages[19]);
        lengthOfMatch = jjstrLiteralImages[19].length();
                             switchToStateAfterCmdName();
         break;
      case 20 :
        image.append(jjstrLiteralImages[20]);
        lengthOfMatch = jjstrLiteralImages[20].length();
                           switchToStateAfterCmdName();
         break;
      case 21 :
        image.append(jjstrLiteralImages[21]);
        lengthOfMatch = jjstrLiteralImages[21].length();
                           switchToStateAfterCmdName();
         break;
      case 22 :
        image.append(jjstrLiteralImages[22]);
        lengthOfMatch = jjstrLiteralImages[22].length();
    currCmdName = "literal";  // record command name for special case handling
    switchToStateAfterCmdName();
         break;
      case 23 :
        image.append(jjstrLiteralImages[23]);
        lengthOfMatch = jjstrLiteralImages[23].length();
    currCmdName = "/literal";  // record command name for special case handling
    switchToStateAfterCmdName();
         break;
      case 24 :
        image.append(jjstrLiteralImages[24]);
        lengthOfMatch = jjstrLiteralImages[24].length();
    currCmdName = "msg";  // record command name for special case handling
    switchToStateAfterCmdName();
         break;
      case 25 :
        image.append(jjstrLiteralImages[25]);
        lengthOfMatch = jjstrLiteralImages[25].length();
                                             switchToStateAfterCmdName();
         break;
      case 26 :
        image.append(jjstrLiteralImages[26]);
        lengthOfMatch = jjstrLiteralImages[26].length();
    currCmdName = "/msg";  // record command name for special case handling
    switchToStateAfterCmdName();
         break;
      case 27 :
        image.append(jjstrLiteralImages[27]);
        lengthOfMatch = jjstrLiteralImages[27].length();
                                   switchToStateAfterCmdName();
         break;
      case 28 :
        image.append(jjstrLiteralImages[28]);
        lengthOfMatch = jjstrLiteralImages[28].length();
                                        switchToStateAfterCmdName();
         break;
      case 29 :
        image.append(jjstrLiteralImages[29]);
        lengthOfMatch = jjstrLiteralImages[29].length();
                                   switchToStateAfterCmdName();
         break;
      case 30 :
        image.append(jjstrLiteralImages[30]);
        lengthOfMatch = jjstrLiteralImages[30].length();
                                        switchToStateAfterCmdName();
         break;
      case 31 :
        image.append(jjstrLiteralImages[31]);
        lengthOfMatch = jjstrLiteralImages[31].length();
                                 switchToStateAfterCmdName();
         break;
      case 32 :
        image.append(jjstrLiteralImages[32]);
        lengthOfMatch = jjstrLiteralImages[32].length();
                             switchToStateAfterCmdName();
         break;
      case 33 :
        image.append(jjstrLiteralImages[33]);
        lengthOfMatch = jjstrLiteralImages[33].length();
                             switchToStateAfterCmdName();
         break;
      case 34 :
        image.append(jjstrLiteralImages[34]);
        lengthOfMatch = jjstrLiteralImages[34].length();
                             switchToStateAfterCmdName();
         break;
      case 35 :
        image.append(jjstrLiteralImages[35]);
        lengthOfMatch = jjstrLiteralImages[35].length();
                                  switchToStateAfterCmdName();
         break;
      case 36 :
        image.append(jjstrLiteralImages[36]);
        lengthOfMatch = jjstrLiteralImages[36].length();
                           switchToStateAfterCmdName();
         break;
      case 37 :
        image.append(jjstrLiteralImages[37]);
        lengthOfMatch = jjstrLiteralImages[37].length();
                                   switchToStateAfterCmdName();
         break;
      case 38 :
        image.append(jjstrLiteralImages[38]);
        lengthOfMatch = jjstrLiteralImages[38].length();
                               switchToStateAfterCmdName();
         break;
      case 39 :
        image.append(jjstrLiteralImages[39]);
        lengthOfMatch = jjstrLiteralImages[39].length();
                                switchToStateAfterCmdName();
         break;
      case 40 :
        image.append(jjstrLiteralImages[40]);
        lengthOfMatch = jjstrLiteralImages[40].length();
                                   switchToStateAfterCmdName();
         break;
      case 41 :
        image.append(jjstrLiteralImages[41]);
        lengthOfMatch = jjstrLiteralImages[41].length();
                                        switchToStateAfterCmdName();
         break;
      case 42 :
        image.append(jjstrLiteralImages[42]);
        lengthOfMatch = jjstrLiteralImages[42].length();
                                     switchToStateAfterCmdName();
         break;
      case 43 :
        image.append(jjstrLiteralImages[43]);
        lengthOfMatch = jjstrLiteralImages[43].length();
                                     switchToStateAfterCmdName();
         break;
      case 44 :
        image.append(jjstrLiteralImages[44]);
        lengthOfMatch = jjstrLiteralImages[44].length();
                                          switchToStateAfterCmdName();
         break;
      case 45 :
        image.append(jjstrLiteralImages[45]);
        lengthOfMatch = jjstrLiteralImages[45].length();
                             switchToStateAfterCmdName();
         break;
      case 46 :
        image.append(jjstrLiteralImages[46]);
        lengthOfMatch = jjstrLiteralImages[46].length();
                                  switchToStateAfterCmdName();
         break;
      case 47 :
        image.append(input_stream.GetSuffix(jjimageLen + (lengthOfMatch = jjmatchedPos + 1)));
                                               switchToStateAfterCmdName();
         break;
      case 48 :
        image.append(input_stream.GetSuffix(jjimageLen + (lengthOfMatch = jjmatchedPos + 1)));
                                                     switchToStateAfterCmdName();
         break;
      case 49 :
        image.append(jjstrLiteralImages[49]);
        lengthOfMatch = jjstrLiteralImages[49].length();
                                 switchToStateAfterCmdName();
         break;
      case 50 :
        image.append(jjstrLiteralImages[50]);
        lengthOfMatch = jjstrLiteralImages[50].length();
                                      switchToStateAfterCmdName();
         break;
      case 51 :
        image.append(jjstrLiteralImages[51]);
        lengthOfMatch = jjstrLiteralImages[51].length();
                             switchToStateAfterCmdName();
         break;
      case 52 :
        image.append(jjstrLiteralImages[52]);
        lengthOfMatch = jjstrLiteralImages[52].length();
                                  switchToStateAfterCmdName();
         break;
      case 53 :
        image.append(jjstrLiteralImages[53]);
        lengthOfMatch = jjstrLiteralImages[53].length();
                                       switchToStateAfterCmdName();
         break;
      case 54 :
        image.append(jjstrLiteralImages[54]);
        lengthOfMatch = jjstrLiteralImages[54].length();
                               switchToStateAfterCmdName();
         break;
      case 55 :
        image.append(jjstrLiteralImages[55]);
        lengthOfMatch = jjstrLiteralImages[55].length();
                                     switchToStateAfterCmdName();
         break;
      case 56 :
        image.append(jjstrLiteralImages[56]);
        lengthOfMatch = jjstrLiteralImages[56].length();
                                         switchToStateAfterCmdName();
         break;
      case 57 :
        image.append(jjstrLiteralImages[57]);
        lengthOfMatch = jjstrLiteralImages[57].length();
                                       switchToStateAfterCmdName();
         break;
      case 58 :
        image.append(jjstrLiteralImages[58]);
        lengthOfMatch = jjstrLiteralImages[58].length();
                                            switchToStateAfterCmdName();
         break;
      case 60 :
        image.append(input_stream.GetSuffix(jjimageLen + (lengthOfMatch = jjmatchedPos + 1)));
    throwTokenMgrError(
        "First character in a Soy tag must not be a brace character (consider inserting a space" +
        " before the brace character)", matchedToken);
         break;
      case 61 :
        image.append(jjstrLiteralImages[61]);
        lengthOfMatch = jjstrLiteralImages[61].length();
    handleSpecialCaseCmdsWithoutCmdText(matchedToken);
    currCmdName = null;  // clear command name since we're out of the tag
    switchToStateDefaultNotSolOrLiteral();
         break;
      case 62 :
        image.append(jjstrLiteralImages[62]);
        lengthOfMatch = jjstrLiteralImages[62].length();
    handleSpecialCaseCmdsWithoutCmdText(matchedToken);
    currCmdName = null;  // clear command name since we're out of the tag
    switchToStateDefaultNotSolOrLiteral();
         break;
      case 63 :
        image.append(jjstrLiteralImages[63]);
        lengthOfMatch = jjstrLiteralImages[63].length();
    handleSpecialCaseCmdsWithoutCmdText(matchedToken);
    currCmdName = null;  // clear command name since we're out of the tag
    switchToStateDefaultNotSolOrLiteral();
         break;
      case 64 :
        image.append(jjstrLiteralImages[64]);
        lengthOfMatch = jjstrLiteralImages[64].length();
    handleSpecialCaseCmdsWithoutCmdText(matchedToken);
    currCmdName = null;  // clear command name since we're out of the tag
    switchToStateDefaultNotSolOrLiteral();
         break;
      case 65 :
        image.append(input_stream.GetSuffix(jjimageLen + (lengthOfMatch = jjmatchedPos + 1)));
    handleSpecialCaseCmdsWithCmdText(matchedToken);
    switchToStateInCmdText();
         break;
      case 66 :
         if (jjmatchedPos == -1)
         {
            if (jjbeenHere[7] &&
                jjemptyLineNo[7] == input_stream.getBeginLine() &&
                jjemptyColNo[7] == input_stream.getBeginColumn())
               throw new TokenMgrError(("Error: Bailing out of infinite loop caused by repeated empty string matches at line " + input_stream.getBeginLine() + ", column " + input_stream.getBeginColumn() + "."), TokenMgrError.LOOP_DETECTED);
            jjemptyLineNo[7] = input_stream.getBeginLine();
            jjemptyColNo[7] = input_stream.getBeginColumn();
            jjbeenHere[7] = true;
         }
        image.append(input_stream.GetSuffix(jjimageLen + (lengthOfMatch = jjmatchedPos + 1)));
                                                 switchToStateInCmdText();
         break;
      case 69 :
        image.append(input_stream.GetSuffix(jjimageLen + (lengthOfMatch = jjmatchedPos + 1)));
    throwTokenMgrError(
        "Found 'phname' attribute that is not a valid identifier (" + matchedToken.image + ")",
        matchedToken);
         break;
      case 72 :
        image.append(jjstrLiteralImages[72]);
        lengthOfMatch = jjstrLiteralImages[72].length();
    currCmdName = null;  // clear command name since we're out of the tag
    switchToStateDefaultNotSol();
         break;
      case 73 :
        image.append(jjstrLiteralImages[73]);
        lengthOfMatch = jjstrLiteralImages[73].length();
    currCmdName = null;  // clear command name since we're out of the tag
    switchToStateDefaultNotSol();
         break;
      case 74 :
        image.append(jjstrLiteralImages[74]);
        lengthOfMatch = jjstrLiteralImages[74].length();
    currCmdName = null;  // clear command name since we're out of the tag
    switchToStateDefaultNotSol();
         break;
      case 75 :
        image.append(jjstrLiteralImages[75]);
        lengthOfMatch = jjstrLiteralImages[75].length();
    currCmdName = null;  // clear command name since we're out of the tag
    switchToStateDefaultNotSol();
         break;
      case 76 :
        image.append(jjstrLiteralImages[76]);
        lengthOfMatch = jjstrLiteralImages[76].length();
    throwTokenMgrError(
        "Left brace '{' not allowed within a Soy tag delimited by single braces (consider using" +
        " double braces to delimit the Soy tag)", matchedToken);
         break;
      case 77 :
        image.append(input_stream.GetSuffix(jjimageLen + (lengthOfMatch = jjmatchedPos + 1)));
    throwTokenMgrError(
        "Found Soy tag opened by '{' but closed by '}}' (please use consistent delimiters)",
        matchedToken);
         break;
      case 78 :
        image.append(jjstrLiteralImages[78]);
        lengthOfMatch = jjstrLiteralImages[78].length();
    throwTokenMgrError(
        "Double left brace '{{' not allowed within a Soy tag delimited by double braces" +
        " (consider inserting a space: '{ {')", matchedToken);
         break;
      case 79 :
        image.append(input_stream.GetSuffix(jjimageLen + (lengthOfMatch = jjmatchedPos + 1)));
    throwTokenMgrError(
        "Last character in a Soy tag must not be a brace character (consider inserting a space" +
        " after the brace character)", matchedToken);
         break;
      case 80 :
        image.append(jjstrLiteralImages[80]);
        lengthOfMatch = jjstrLiteralImages[80].length();
    if (isInMsgHtmlTag) {
      throwTokenMgrError("In a 'msg' block, found '<' within HTML tag", matchedToken);
    }
    isInMsgHtmlTag = true;
         break;
      case 81 :
        image.append(jjstrLiteralImages[81]);
        lengthOfMatch = jjstrLiteralImages[81].length();
    if (!isInMsgHtmlTag) {
      throwTokenMgrError("In a 'msg' block, found '>' while not within HTML tag", matchedToken);
    }
    isInMsgHtmlTag = false;
         break;
      case 83 :
        image.append(input_stream.GetSuffix(jjimageLen + (lengthOfMatch = jjmatchedPos + 1)));
    isInLiteralBlock = false;
    // Note: 'image' is cumulative over MOREs while 'lengthOfMatch' is just the end tag length.
    matchedToken.image = image.substring(0, image.length() - lengthOfMatch);
    switchToStateDefaultNotSol();
         break;
      case 84 :
        image.append(input_stream.GetSuffix(jjimageLen + (lengthOfMatch = jjmatchedPos + 1)));
    throwTokenMgrError("Tag '/literal' must not have command text", matchedToken);
         break;
      case 85 :
        image.append(input_stream.GetSuffix(jjimageLen + (lengthOfMatch = jjmatchedPos + 1)));
    throwTokenMgrError("Nested 'literal' tags not allowed", matchedToken);
         break;
      case 86 :
        image.append(input_stream.GetSuffix(jjimageLen + (lengthOfMatch = jjmatchedPos + 1)));
    switchToStateDefaultAtSol();
         break;
      case 87 :
        image.append(input_stream.GetSuffix(jjimageLen + (lengthOfMatch = jjmatchedPos + 1)));
    switchToStateDefaultNotSol();
         break;
      case 88 :
        image.append(input_stream.GetSuffix(jjimageLen + (lengthOfMatch = jjmatchedPos + 1)));
    switchToStateDefaultNotSol();
         break;
      default :
         break;
   }
}
private void jjCheckNAdd(int state)
{
   if (jjrounds[state] != jjround)
   {
      jjstateSet[jjnewStateCnt++] = state;
      jjrounds[state] = jjround;
   }
}
private void jjAddStates(int start, int end)
{
   do {
      jjstateSet[jjnewStateCnt++] = jjnextStates[start];
   } while (start++ != end);
}
private void jjCheckNAddTwoStates(int state1, int state2)
{
   jjCheckNAdd(state1);
   jjCheckNAdd(state2);
}

}
