/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.soytree;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.template.soy.base.SourceLocation;
import com.google.template.soy.base.internal.BaseUtils;
import com.google.template.soy.exprparse.ExpressionParser;
import com.google.template.soy.exprtree.ExprNode;
import com.google.template.soy.exprtree.ExprRootNode;
import com.google.template.soy.soyparse.ErrorReporter;
import com.google.template.soy.soyparse.ErrorReporterImpl;
import com.google.template.soy.soytree.AbstractParentCommandNode;
import com.google.template.soy.soytree.ExprUnion;
import com.google.template.soy.soytree.MsgSubstUnitBaseVarNameUtils;
import com.google.template.soy.soytree.PrintDirectiveNode;
import com.google.template.soy.soytree.SoyNode;
import java.util.List;
import javax.annotation.Nullable;

public final class PrintNode
extends AbstractParentCommandNode<PrintDirectiveNode>
implements SoyNode.StandaloneNode,
SoyNode.SplitLevelTopNode<PrintDirectiveNode>,
SoyNode.StatementNode,
SoyNode.ExprHolderNode,
SoyNode.MsgPlaceholderInitialNode {
    public static final String FALLBACK_BASE_PLACEHOLDER_NAME = "XXX";
    private final boolean isImplicit;
    private final ExprUnion exprUnion;
    @Nullable
    private final String userSuppliedPlaceholderName;

    private PrintNode(int id, boolean isImplicit, ExprUnion exprUnion, SourceLocation sourceLocation, @Nullable String userSuppliedPlaceholderName) {
        super(id, "print", "");
        this.setSourceLocation(sourceLocation);
        this.isImplicit = isImplicit;
        this.exprUnion = exprUnion;
        this.userSuppliedPlaceholderName = userSuppliedPlaceholderName;
    }

    private PrintNode(PrintNode orig) {
        super(orig);
        this.isImplicit = orig.isImplicit;
        this.exprUnion = orig.exprUnion != null ? orig.exprUnion.clone() : null;
        this.userSuppliedPlaceholderName = orig.userSuppliedPlaceholderName;
    }

    @Override
    public SoyNode.Kind getKind() {
        return SoyNode.Kind.PRINT_NODE;
    }

    public boolean isImplicit() {
        return this.isImplicit;
    }

    public String getExprText() {
        return this.exprUnion.getExprText();
    }

    public ExprUnion getExprUnion() {
        return this.exprUnion;
    }

    @Override
    public String getUserSuppliedPhName() {
        return this.userSuppliedPlaceholderName;
    }

    @Override
    public String genBasePhName() {
        if (this.userSuppliedPlaceholderName != null) {
            return BaseUtils.convertToUpperUnderscore(this.userSuppliedPlaceholderName);
        }
        ExprRootNode<?> exprRoot = this.exprUnion.getExpr();
        if (exprRoot == null) {
            return FALLBACK_BASE_PLACEHOLDER_NAME;
        }
        return MsgSubstUnitBaseVarNameUtils.genNaiveBaseNameForExpr(exprRoot, FALLBACK_BASE_PLACEHOLDER_NAME);
    }

    @Override
    public Object genSamenessKey() {
        return this.getCommandText();
    }

    @Override
    public List<ExprUnion> getAllExprUnions() {
        return ImmutableList.of((Object)this.exprUnion);
    }

    @Override
    public String getCommandText() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.exprUnion.getExprText());
        for (PrintDirectiveNode child : this.getChildren()) {
            sb.append(' ').append(child.toSourceString());
        }
        if (this.userSuppliedPlaceholderName != null) {
            sb.append(" phname=\"").append(this.userSuppliedPlaceholderName).append('\"');
        }
        return sb.toString();
    }

    @Override
    public String getTagString() {
        return this.buildTagStringHelper(false, this.isImplicit);
    }

    @Override
    public String toSourceString() {
        return this.getTagString();
    }

    @Override
    public SoyNode.BlockNode getParent() {
        return (SoyNode.BlockNode)super.getParent();
    }

    @Override
    public PrintNode clone() {
        return new PrintNode(this);
    }

    public static final class Builder {
        private final int id;
        private final boolean isImplicit;
        private final SourceLocation sourceLocation;
        @Nullable
        private String exprText;
        @Nullable
        private ExprUnion exprUnion;
        @Nullable
        private String userSuppliedPlaceholderName;

        public Builder(int id, boolean isImplicit, SourceLocation sourceLocation) {
            this.id = id;
            this.isImplicit = isImplicit;
            this.sourceLocation = sourceLocation;
        }

        public Builder exprText(String exprText) {
            Preconditions.checkState((this.exprText == null ? 1 : 0) != 0);
            Preconditions.checkState((this.exprUnion == null ? 1 : 0) != 0);
            this.exprText = exprText;
            return this;
        }

        public Builder exprUnion(ExprUnion exprUnion) {
            Preconditions.checkState((this.exprText == null ? 1 : 0) != 0);
            Preconditions.checkState((this.exprUnion == null ? 1 : 0) != 0);
            this.exprUnion = exprUnion;
            return this;
        }

        public Builder userSuppliedPlaceholderName(String userSuppliedPlaceholderName) {
            this.userSuppliedPlaceholderName = userSuppliedPlaceholderName;
            return this;
        }

        public PrintNode build(ErrorReporter unusedForNow) {
            ExprUnion exprUnion = this.getOrParseExprUnion();
            return new PrintNode(this.id, this.isImplicit, exprUnion, this.sourceLocation, this.userSuppliedPlaceholderName);
        }

        private ExprUnion getOrParseExprUnion() {
            if (this.exprUnion != null) {
                return this.exprUnion;
            }
            Preconditions.checkNotNull((Object)this.exprText);
            ErrorReporterImpl internal = new ErrorReporterImpl();
            ErrorReporter.Checkpoint checkpoint = internal.checkpoint();
            ExprRootNode<? extends ExprNode> expr = new ExpressionParser(this.exprText, this.sourceLocation, internal).parseExpression();
            return internal.errorsSince(checkpoint) ? new ExprUnion(this.exprText) : new ExprUnion(expr);
        }
    }
}

