/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.soytree;

import com.google.common.collect.ImmutableList;
import com.google.template.soy.base.SourceLocation;
import com.google.template.soy.basetree.SyntaxVersion;
import com.google.template.soy.basetree.SyntaxVersionBound;
import com.google.template.soy.exprparse.ExpressionParser;
import com.google.template.soy.exprtree.ExprNode;
import com.google.template.soy.exprtree.ExprRootNode;
import com.google.template.soy.internal.base.Pair;
import com.google.template.soy.shared.SoyCssRenamingMap;
import com.google.template.soy.soyparse.ErrorReporter;
import com.google.template.soy.soytree.AbstractCommandNode;
import com.google.template.soy.soytree.ExprUnion;
import com.google.template.soy.soytree.SoyNode;
import java.util.Collections;
import java.util.List;
import java.util.regex.Pattern;
import javax.annotation.Nullable;

public final class CssNode
extends AbstractCommandNode
implements SoyNode.StandaloneNode,
SoyNode.StatementNode,
SoyNode.ExprHolderNode {
    private static final String CSS_CLASS_NAME_RE = "(-|%)?[a-zA-Z_]+[a-zA-Z0-9_-]*";
    private static final Pattern SELECTOR_TEXT_PATTERN = Pattern.compile("^((-|%)?[a-zA-Z_]+[a-zA-Z0-9_-]*|[$]?[a-zA-Z_][a-zA-Z_0-9]*(?:[.][a-zA-Z_][a-zA-Z_0-9]*)*)$");
    @Nullable
    private final ExprRootNode<?> componentNameExpr;
    private final String selectorText;
    Pair<SoyCssRenamingMap, String> renameCache;

    private CssNode(int id, String commandText, @Nullable ExprRootNode<?> componentNameExpr, String selectorText, SourceLocation sourceLocation) {
        super(id, "css", commandText);
        this.setSourceLocation(sourceLocation);
        this.componentNameExpr = componentNameExpr;
        this.selectorText = selectorText;
        if (!SELECTOR_TEXT_PATTERN.matcher(selectorText).matches()) {
            this.maybeSetSyntaxVersionBound(new SyntaxVersionBound(SyntaxVersion.V2_1, "Invalid 'css' command text."));
        }
    }

    private CssNode(CssNode orig) {
        super(orig);
        this.componentNameExpr = orig.componentNameExpr != null ? orig.componentNameExpr.clone() : null;
        this.selectorText = orig.selectorText;
    }

    public CssNode(CssNode orig, String newSelectorText) {
        super(orig);
        this.componentNameExpr = orig.componentNameExpr != null ? orig.componentNameExpr.clone() : null;
        this.selectorText = newSelectorText;
    }

    @Override
    public SoyNode.Kind getKind() {
        return SoyNode.Kind.CSS_NODE;
    }

    @Nullable
    public ExprRootNode<?> getComponentNameExpr() {
        return this.componentNameExpr;
    }

    public String getComponentNameText() {
        return this.componentNameExpr != null ? this.componentNameExpr.toSourceString() : null;
    }

    public String getSelectorText() {
        return this.selectorText;
    }

    public String getRenamedSelectorText(SoyCssRenamingMap cssRenamingMap) {
        String mappedText;
        Pair<SoyCssRenamingMap, String> cache = this.renameCache;
        if (cache != null && cache.first == cssRenamingMap) {
            return (String)cache.second;
        }
        if (cssRenamingMap != null && (mappedText = cssRenamingMap.get(this.selectorText)) != null) {
            this.renameCache = Pair.of(cssRenamingMap, mappedText);
            return mappedText;
        }
        return this.selectorText;
    }

    @Override
    public List<ExprUnion> getAllExprUnions() {
        return this.componentNameExpr != null ? ImmutableList.of((Object)new ExprUnion(this.componentNameExpr)) : Collections.emptyList();
    }

    @Override
    public SoyNode.BlockNode getParent() {
        return (SoyNode.BlockNode)super.getParent();
    }

    @Override
    public CssNode clone() {
        return new CssNode(this);
    }

    public static final class Builder {
        private final int id;
        private final String commandText;
        private final SourceLocation sourceLocation;

        public Builder(int id, String commandText, SourceLocation sourceLocation) {
            this.id = id;
            this.commandText = commandText;
            this.sourceLocation = sourceLocation;
        }

        public CssNode build(ErrorReporter errorReporter) {
            int delimPos = this.commandText.lastIndexOf(44);
            ExprRootNode<? extends ExprNode> componentNameExpr = null;
            String selectorText = this.commandText;
            if (delimPos != -1) {
                String componentNameText = this.commandText.substring(0, delimPos).trim();
                componentNameExpr = new ExpressionParser(componentNameText, this.sourceLocation, errorReporter).parseExpression();
                selectorText = this.commandText.substring(delimPos + 1).trim();
            }
            return new CssNode(this.id, this.commandText, componentNameExpr, selectorText, this.sourceLocation);
        }
    }
}

