/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.pysrc.internal;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.inject.assistedinject.Assisted;
import com.google.inject.assistedinject.AssistedInject;
import com.google.template.soy.base.internal.BaseUtils;
import com.google.template.soy.exprtree.ExprRootNode;
import com.google.template.soy.exprtree.Operator;
import com.google.template.soy.pysrc.internal.GenPyCallExprVisitor;
import com.google.template.soy.pysrc.internal.IsComputableAsPyExprVisitor;
import com.google.template.soy.pysrc.internal.LocalVariableStack;
import com.google.template.soy.pysrc.internal.MsgFuncGenerator;
import com.google.template.soy.pysrc.internal.TranslateToPyExprVisitor;
import com.google.template.soy.pysrc.restricted.PyExpr;
import com.google.template.soy.pysrc.restricted.PyExprUtils;
import com.google.template.soy.pysrc.restricted.PyStringExpr;
import com.google.template.soy.pysrc.restricted.SoyPySrcPrintDirective;
import com.google.template.soy.soytree.AbstractSoyNodeVisitor;
import com.google.template.soy.soytree.CallNode;
import com.google.template.soy.soytree.CallParamContentNode;
import com.google.template.soy.soytree.IfCondNode;
import com.google.template.soy.soytree.IfElseNode;
import com.google.template.soy.soytree.IfNode;
import com.google.template.soy.soytree.MsgFallbackGroupNode;
import com.google.template.soy.soytree.MsgNode;
import com.google.template.soy.soytree.PrintDirectiveNode;
import com.google.template.soy.soytree.PrintNode;
import com.google.template.soy.soytree.RawTextNode;
import com.google.template.soy.soytree.SoyNode;
import com.google.template.soy.soytree.SoySyntaxExceptionUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class GenPyExprsVisitor
extends AbstractSoyNodeVisitor<List<PyExpr>> {
    Map<String, SoyPySrcPrintDirective> soyPySrcDirectivesMap;
    private final IsComputableAsPyExprVisitor isComputableAsPyExprVisitor;
    private final GenPyExprsVisitorFactory genPyExprsVisitorFactory;
    private final TranslateToPyExprVisitor.TranslateToPyExprVisitorFactory translateToPyExprVisitorFactory;
    private final GenPyCallExprVisitor genPyCallExprVisitor;
    private final MsgFuncGenerator.MsgFuncGeneratorFactory msgFuncGeneratorFactory;
    private final LocalVariableStack localVarExprs;
    private List<PyExpr> pyExprs;

    @AssistedInject
    GenPyExprsVisitor(ImmutableMap<String, SoyPySrcPrintDirective> soyPySrcDirectivesMap, IsComputableAsPyExprVisitor isComputableAsPyExprVisitor, GenPyExprsVisitorFactory genPyExprsVisitorFactory, MsgFuncGenerator.MsgFuncGeneratorFactory msgFuncGeneratorFactory, TranslateToPyExprVisitor.TranslateToPyExprVisitorFactory translateToPyExprVisitorFactory, GenPyCallExprVisitor genPyCallExprVisitor, @Assisted LocalVariableStack localVarExprs) {
        this.soyPySrcDirectivesMap = soyPySrcDirectivesMap;
        this.isComputableAsPyExprVisitor = isComputableAsPyExprVisitor;
        this.genPyExprsVisitorFactory = genPyExprsVisitorFactory;
        this.translateToPyExprVisitorFactory = translateToPyExprVisitorFactory;
        this.genPyCallExprVisitor = genPyCallExprVisitor;
        this.msgFuncGeneratorFactory = msgFuncGeneratorFactory;
        this.localVarExprs = localVarExprs;
    }

    @Override
    public List<PyExpr> exec(SoyNode node) {
        Preconditions.checkArgument((boolean)((Boolean)this.isComputableAsPyExprVisitor.exec(node)));
        this.pyExprs = new ArrayList<PyExpr>();
        this.visit(node);
        return this.pyExprs;
    }

    List<PyExpr> execOnChildren(SoyNode.ParentSoyNode<?> node) {
        Preconditions.checkArgument((boolean)this.isComputableAsPyExprVisitor.execOnChildren(node));
        this.pyExprs = new ArrayList<PyExpr>();
        this.visitChildren(node);
        return this.pyExprs;
    }

    @Override
    protected void visitRawTextNode(RawTextNode node) {
        String exprText = BaseUtils.escapeToSoyString(node.getRawText(), false);
        this.pyExprs.add(new PyStringExpr(exprText));
    }

    @Override
    protected void visitPrintNode(PrintNode node) {
        TranslateToPyExprVisitor translator = this.translateToPyExprVisitorFactory.create(this.localVarExprs);
        PyExpr pyExpr = (PyExpr)translator.exec(node.getExprUnion().getExpr());
        for (PrintDirectiveNode directiveNode : node.getChildren()) {
            SoyPySrcPrintDirective directive = this.soyPySrcDirectivesMap.get(directiveNode.getName());
            if (directive == null) {
                throw SoySyntaxExceptionUtils.createWithNode("Failed to find SoyPySrcPrintDirective with name '" + directiveNode.getName() + "'" + " (tag " + node.toSourceString() + ")", directiveNode);
            }
            List<ExprRootNode<?>> args = directiveNode.getArgs();
            if (!directive.getValidArgsSizes().contains(args.size())) {
                throw SoySyntaxExceptionUtils.createWithNode("Print directive '" + directiveNode.getName() + "' used with the wrong number of" + " arguments (tag " + node.toSourceString() + ").", directiveNode);
            }
            ArrayList<PyExpr> argsPyExprs = new ArrayList<PyExpr>(args.size());
            for (ExprRootNode<?> arg : args) {
                argsPyExprs.add((PyExpr)translator.exec(arg));
            }
            pyExpr = directive.applyForPySrc(pyExpr, argsPyExprs);
        }
        this.pyExprs.add(pyExpr);
    }

    @Override
    protected void visitMsgFallbackGroupNode(MsgFallbackGroupNode node) {
        GenPyExprsVisitor genPyExprsVisitor = this.genPyExprsVisitorFactory.create(this.localVarExprs);
        if (node.numChildren() == 1) {
            this.visitChildren(node);
        } else {
            StringBuilder pyExprTextSb = new StringBuilder();
            List<PyExpr> firstMsgPyExpr = genPyExprsVisitor.exec((SoyNode)node.getChild(0));
            List<PyExpr> fallbackMsgPyExpr = genPyExprsVisitor.exec((SoyNode)node.getChild(1));
            pyExprTextSb.append(PyExprUtils.concatPyExprs(firstMsgPyExpr).toPyString().getText());
            pyExprTextSb.append(" if ");
            pyExprTextSb.append("is_msg_available(" + node.getId() + ")");
            pyExprTextSb.append(" else ");
            pyExprTextSb.append(PyExprUtils.concatPyExprs(fallbackMsgPyExpr).toPyString().getText());
            this.pyExprs.add(new PyStringExpr(pyExprTextSb.toString(), PyExprUtils.pyPrecedenceForOperator(Operator.CONDITIONAL)));
        }
    }

    @Override
    protected void visitMsgNode(MsgNode node) {
        MsgFuncGenerator msgFuncGenerator = this.msgFuncGeneratorFactory.create(node, this.localVarExprs);
        this.pyExprs.add(msgFuncGenerator.getPyExpr());
    }

    @Override
    protected void visitIfNode(IfNode node) {
        GenPyExprsVisitor genPyExprsVisitor = this.genPyExprsVisitorFactory.create(this.localVarExprs);
        TranslateToPyExprVisitor translator = this.translateToPyExprVisitorFactory.create(this.localVarExprs);
        StringBuilder pyExprTextSb = new StringBuilder();
        boolean hasElse = false;
        for (SoyNode child : node.getChildren()) {
            if (child instanceof IfCondNode) {
                IfCondNode icn = (IfCondNode)child;
                PyExpr condBlock = PyExprUtils.concatPyExprs(genPyExprsVisitor.exec(icn)).toPyString();
                condBlock = PyExprUtils.maybeProtect(condBlock, PyExprUtils.pyPrecedenceForOperator(Operator.CONDITIONAL));
                pyExprTextSb.append(condBlock.getText());
                PyExpr condPyExpr = (PyExpr)translator.exec(icn.getExprUnion().getExpr());
                pyExprTextSb.append(" if ").append(condPyExpr.getText()).append(" else ");
                continue;
            }
            if (child instanceof IfElseNode) {
                hasElse = true;
                IfElseNode ien = (IfElseNode)child;
                PyStringExpr elseBlock = PyExprUtils.concatPyExprs(genPyExprsVisitor.exec(ien)).toPyString();
                pyExprTextSb.append(elseBlock.getText());
                continue;
            }
            throw new AssertionError((Object)("Unexpected if child node type. Child: " + child));
        }
        if (!hasElse) {
            pyExprTextSb.append("''");
        }
        this.pyExprs.add(new PyStringExpr(pyExprTextSb.toString(), PyExprUtils.pyPrecedenceForOperator(Operator.CONDITIONAL)));
    }

    @Override
    protected void visitIfCondNode(IfCondNode node) {
        this.visitChildren(node);
    }

    @Override
    protected void visitIfElseNode(IfElseNode node) {
        this.visitChildren(node);
    }

    @Override
    protected void visitCallNode(CallNode node) {
        this.pyExprs.add(this.genPyCallExprVisitor.exec(node, this.localVarExprs));
    }

    @Override
    protected void visitCallParamContentNode(CallParamContentNode node) {
        this.visitChildren(node);
    }

    public static interface GenPyExprsVisitorFactory {
        public GenPyExprsVisitor create(LocalVariableStack var1);
    }
}

