/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.pysrc.internal;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.template.soy.base.SoySyntaxException;
import com.google.template.soy.base.internal.SoyFileKind;
import com.google.template.soy.exprtree.ExprNode;
import com.google.template.soy.exprtree.ExprRootNode;
import com.google.template.soy.exprtree.Operator;
import com.google.template.soy.internal.base.Pair;
import com.google.template.soy.pysrc.internal.GenPyCallExprVisitor;
import com.google.template.soy.pysrc.internal.GenPyExprsVisitor;
import com.google.template.soy.pysrc.internal.IsComputableAsPyExprVisitor;
import com.google.template.soy.pysrc.internal.LocalVariableStack;
import com.google.template.soy.pysrc.internal.PyCodeBuilder;
import com.google.template.soy.pysrc.internal.TranslateToPyExprVisitor;
import com.google.template.soy.pysrc.restricted.PyExpr;
import com.google.template.soy.pysrc.restricted.PyExprUtils;
import com.google.template.soy.pysrc.restricted.PyFunctionExprBuilder;
import com.google.template.soy.pysrc.restricted.PyStringExpr;
import com.google.template.soy.shared.internal.FindCalleesNotInFileVisitor;
import com.google.template.soy.shared.restricted.ApiCallScopeBindingAnnotations;
import com.google.template.soy.sharedpasses.ShouldEnsureDataIsDefinedVisitor;
import com.google.template.soy.soytree.AbstractSoyNodeVisitor;
import com.google.template.soy.soytree.CallNode;
import com.google.template.soy.soytree.CallParamContentNode;
import com.google.template.soy.soytree.CallParamNode;
import com.google.template.soy.soytree.ForNode;
import com.google.template.soy.soytree.ForeachIfemptyNode;
import com.google.template.soy.soytree.ForeachNode;
import com.google.template.soy.soytree.ForeachNonemptyNode;
import com.google.template.soy.soytree.IfCondNode;
import com.google.template.soy.soytree.IfElseNode;
import com.google.template.soy.soytree.IfNode;
import com.google.template.soy.soytree.LetContentNode;
import com.google.template.soy.soytree.LetValueNode;
import com.google.template.soy.soytree.PrintNode;
import com.google.template.soy.soytree.SoyFileNode;
import com.google.template.soy.soytree.SoyFileSetNode;
import com.google.template.soy.soytree.SoyNode;
import com.google.template.soy.soytree.SoySyntaxExceptionUtils;
import com.google.template.soy.soytree.SwitchCaseNode;
import com.google.template.soy.soytree.SwitchDefaultNode;
import com.google.template.soy.soytree.SwitchNode;
import com.google.template.soy.soytree.TemplateDelegateNode;
import com.google.template.soy.soytree.TemplateNode;
import java.util.ArrayList;
import java.util.List;
import javax.inject.Inject;

final class GenPyCodeVisitor
extends AbstractSoyNodeVisitor<List<String>> {
    private final String runtimePath;
    private final String bidiIsRtlFn;
    private final String translationClass;
    private List<String> pyFilesContents;
    @VisibleForTesting
    protected PyCodeBuilder pyCodeBuilder;
    private final IsComputableAsPyExprVisitor isComputableAsPyExprVisitor;
    private final GenPyExprsVisitor.GenPyExprsVisitorFactory genPyExprsVisitorFactory;
    @VisibleForTesting
    protected GenPyExprsVisitor genPyExprsVisitor;
    private final TranslateToPyExprVisitor.TranslateToPyExprVisitorFactory translateToPyExprVisitorFactory;
    private final GenPyCallExprVisitor genPyCallExprVisitor;
    @VisibleForTesting
    protected LocalVariableStack localVarExprs;

    @Inject
    GenPyCodeVisitor(@ApiCallScopeBindingAnnotations.PyRuntimePath String runtimePath, @ApiCallScopeBindingAnnotations.PyBidiIsRtlFn String bidiIsRtlFn, @ApiCallScopeBindingAnnotations.PyTranslationClass String translationClass, IsComputableAsPyExprVisitor isComputableAsPyExprVisitor, GenPyExprsVisitor.GenPyExprsVisitorFactory genPyExprsVisitorFactory, TranslateToPyExprVisitor.TranslateToPyExprVisitorFactory translateToPyExprVisitorFactory, GenPyCallExprVisitor genPyCallExprVisitor) {
        this.runtimePath = runtimePath;
        this.bidiIsRtlFn = bidiIsRtlFn;
        this.translationClass = translationClass;
        this.isComputableAsPyExprVisitor = isComputableAsPyExprVisitor;
        this.genPyExprsVisitorFactory = genPyExprsVisitorFactory;
        this.translateToPyExprVisitorFactory = translateToPyExprVisitorFactory;
        this.genPyCallExprVisitor = genPyCallExprVisitor;
    }

    @Override
    public List<String> exec(SoyNode node) {
        this.pyFilesContents = new ArrayList<String>();
        this.pyCodeBuilder = null;
        this.genPyExprsVisitor = null;
        this.localVarExprs = null;
        this.visit(node);
        return this.pyFilesContents;
    }

    @Override
    @VisibleForTesting
    protected void visit(SoyNode node) {
        super.visit(node);
    }

    @Override
    protected void visitChildren(SoyNode.ParentSoyNode<?> node) {
        if (node.numChildren() > 0 && !((Boolean)this.isComputableAsPyExprVisitor.exec(node.getChild(0))).booleanValue()) {
            this.pyCodeBuilder.initOutputVarIfNecessary();
        }
        ArrayList<PyExpr> childPyExprs = new ArrayList<PyExpr>();
        for (SoyNode child : node.getChildren()) {
            if (((Boolean)this.isComputableAsPyExprVisitor.exec(child)).booleanValue()) {
                childPyExprs.addAll(this.genPyExprsVisitor.exec(child));
                continue;
            }
            if (!childPyExprs.isEmpty()) {
                this.pyCodeBuilder.addToOutputVar((List<? extends PyExpr>)childPyExprs);
                childPyExprs.clear();
            }
            this.visit(child);
        }
        if (!childPyExprs.isEmpty()) {
            this.pyCodeBuilder.addToOutputVar((List<? extends PyExpr>)childPyExprs);
            childPyExprs.clear();
        }
    }

    @Override
    protected void visitSoyFileSetNode(SoyFileSetNode node) {
        for (SoyFileNode soyFile : node.getChildren()) {
            try {
                this.visit(soyFile);
            }
            catch (SoySyntaxException sse) {
                throw sse.associateMetaInfo(null, soyFile.getFilePath(), null);
            }
        }
    }

    @Override
    protected void visitSoyFileNode(SoyFileNode node) {
        if (node.getSoyFileKind() != SoyFileKind.SRC) {
            return;
        }
        this.pyCodeBuilder = new PyCodeBuilder();
        this.pyCodeBuilder.appendLine("# coding=utf-8");
        this.pyCodeBuilder.appendLine("\"\"\" This file was automatically generated from ", node.getFileName(), ".");
        this.pyCodeBuilder.appendLine("Please don't edit this file by hand.");
        this.pyCodeBuilder.appendLine(new String[0]);
        if (node.getNamespace() != null) {
            this.pyCodeBuilder.appendLine("Templates in namespace ", node.getNamespace(), ".");
        }
        this.pyCodeBuilder.appendLine("\"\"\"");
        this.pyCodeBuilder.appendLine(new String[0]);
        this.addCodeToRequireGeneralDeps();
        this.addCodeToRequireSoyNamespaces(node);
        this.addCodeToRegisterCurrentSoyNamespace(node);
        this.addCodeToFixUnicodeStrings();
        for (TemplateNode template : node.getChildren()) {
            this.pyCodeBuilder.appendLine(new String[0]).appendLine(new String[0]);
            try {
                this.visit(template);
            }
            catch (SoySyntaxException sse) {
                throw sse.associateMetaInfo(null, null, template.getTemplateNameForUserMsgs());
            }
        }
        this.pyFilesContents.add(this.pyCodeBuilder.getCode());
        this.pyCodeBuilder = null;
    }

    @Override
    protected void visitTemplateNode(TemplateNode node) {
        this.localVarExprs = new LocalVariableStack();
        this.genPyExprsVisitor = this.genPyExprsVisitorFactory.create(this.localVarExprs);
        this.pyCodeBuilder.appendLine("def ", node.getPartialTemplateName().substring(1), "(opt_data=None, opt_ijData=None):");
        this.pyCodeBuilder.increaseIndent();
        this.generateFunctionBody(node);
        this.pyCodeBuilder.decreaseIndent();
    }

    @Override
    protected void visitTemplateDelegateNode(TemplateDelegateNode node) {
        this.visitTemplateNode(node);
        String delTemplateIdExprText = "'" + node.getDelTemplateName() + "'";
        String delTemplateVariantExprText = "'" + node.getDelTemplateVariant() + "'";
        this.pyCodeBuilder.appendLine("runtime.register_delegate_fn(", delTemplateIdExprText, ", ", delTemplateVariantExprText, ", ", Integer.toString(node.getDelPriority()), ", ", node.getPartialTemplateName().substring(1), ", '", node.getPartialTemplateName().substring(1), "')");
    }

    @Override
    protected void visitPrintNode(PrintNode node) {
        this.pyCodeBuilder.addToOutputVar((List<? extends PyExpr>)this.genPyExprsVisitor.exec(node));
    }

    @Override
    protected void visitIfNode(IfNode node) {
        if (((Boolean)this.isComputableAsPyExprVisitor.exec(node)).booleanValue()) {
            this.pyCodeBuilder.addToOutputVar((List<? extends PyExpr>)this.genPyExprsVisitor.exec(node));
            return;
        }
        TranslateToPyExprVisitor translator = this.translateToPyExprVisitorFactory.create(this.localVarExprs);
        for (SoyNode child : node.getChildren()) {
            if (child instanceof IfCondNode) {
                IfCondNode icn = (IfCondNode)child;
                PyExpr condPyExpr = (PyExpr)translator.exec(icn.getExprUnion().getExpr());
                if (icn.getCommandName().equals("if")) {
                    this.pyCodeBuilder.appendLine("if ", condPyExpr.getText(), ":");
                } else {
                    this.pyCodeBuilder.appendLine("elif ", condPyExpr.getText(), ":");
                }
                this.pyCodeBuilder.increaseIndent();
                this.visitChildren(icn);
                this.pyCodeBuilder.decreaseIndent();
                continue;
            }
            if (child instanceof IfElseNode) {
                this.pyCodeBuilder.appendLine("else:");
                this.pyCodeBuilder.increaseIndent();
                this.visitChildren((IfElseNode)child);
                this.pyCodeBuilder.decreaseIndent();
                continue;
            }
            throw new AssertionError((Object)("Unexpected if child node type. Child: " + child));
        }
    }

    @Override
    protected void visitSwitchNode(SwitchNode node) {
        TranslateToPyExprVisitor translator = this.translateToPyExprVisitorFactory.create(this.localVarExprs);
        String switchValueVarName = "switchValue";
        PyExpr switchValuePyExpr = (PyExpr)translator.exec(node.getExpr());
        this.pyCodeBuilder.appendLine(switchValueVarName, " = ", switchValuePyExpr.getText());
        if (node.getChildren().size() == 1 && node.getChild(0) instanceof SwitchDefaultNode) {
            this.visitChildren((SwitchDefaultNode)node.getChild(0));
            return;
        }
        boolean isFirstCase = true;
        for (SoyNode child : node.getChildren()) {
            if (child instanceof SwitchCaseNode) {
                SwitchCaseNode scn = (SwitchCaseNode)child;
                for (ExprNode exprNode : scn.getExprList()) {
                    PyExpr casePyExpr = (PyExpr)translator.exec(exprNode);
                    PyExpr conditionFn = new PyFunctionExprBuilder("runtime.type_safe_eq").addArg(new PyExpr(switchValueVarName, Integer.MAX_VALUE)).addArg(casePyExpr).asPyExpr();
                    if (isFirstCase) {
                        this.pyCodeBuilder.appendLineStart("if ").append(conditionFn.getText()).appendLineEnd(":");
                        isFirstCase = false;
                    } else {
                        this.pyCodeBuilder.appendLineStart("elif ").append(conditionFn.getText()).appendLineEnd(":");
                    }
                    this.pyCodeBuilder.increaseIndent();
                    this.visitChildren(scn);
                    this.pyCodeBuilder.decreaseIndent();
                }
                continue;
            }
            if (child instanceof SwitchDefaultNode) {
                SwitchDefaultNode sdn = (SwitchDefaultNode)child;
                this.pyCodeBuilder.appendLine("else:");
                this.pyCodeBuilder.increaseIndent();
                this.visitChildren(sdn);
                this.pyCodeBuilder.decreaseIndent();
                continue;
            }
            throw new AssertionError((Object)("Unexpected switch child node type. Child: " + child));
        }
    }

    @Override
    protected void visitForNode(ForNode node) {
        TranslateToPyExprVisitor translator = this.translateToPyExprVisitorFactory.create(this.localVarExprs);
        String varName = node.getVarName();
        String nodeId = Integer.toString(node.getId());
        this.pyCodeBuilder.appendLineStart("for ", varName, nodeId, " in ");
        PyFunctionExprBuilder funcBuilder = new PyFunctionExprBuilder("xrange");
        for (ExprRootNode<?> arg : node.getRangeArgs()) {
            funcBuilder.addArg((PyExpr)translator.exec(arg));
        }
        this.pyCodeBuilder.appendLineEnd(funcBuilder.asPyExpr().getText(), ":");
        this.localVarExprs.pushFrame();
        this.localVarExprs.addVariable(varName, new PyExpr(varName + nodeId, Integer.MAX_VALUE));
        this.pyCodeBuilder.increaseIndent();
        this.visitChildren(node);
        this.pyCodeBuilder.decreaseIndent();
        this.localVarExprs.popFrame();
    }

    @Override
    protected void visitForeachNode(ForeachNode node) {
        boolean hasIfemptyNode;
        ForeachNonemptyNode nonEmptyNode = (ForeachNonemptyNode)node.getChild(0);
        String baseVarName = nonEmptyNode.getVarName();
        String listVarName = String.format("%sList%d", baseVarName, node.getId());
        TranslateToPyExprVisitor translator = this.translateToPyExprVisitorFactory.create(this.localVarExprs);
        PyExpr dataRefPyExpr = (PyExpr)translator.exec(node.getExpr());
        this.pyCodeBuilder.appendLine(listVarName, " = ", dataRefPyExpr.getText());
        boolean bl = hasIfemptyNode = node.numChildren() == 2;
        if (hasIfemptyNode) {
            this.pyCodeBuilder.appendLine("if ", listVarName, ":");
            this.pyCodeBuilder.increaseIndent();
        }
        this.visit(nonEmptyNode);
        if (hasIfemptyNode) {
            this.pyCodeBuilder.decreaseIndent();
            this.pyCodeBuilder.appendLine("else:");
            this.pyCodeBuilder.increaseIndent();
            this.visit((SoyNode)node.getChild(1));
            this.pyCodeBuilder.decreaseIndent();
        }
    }

    @Override
    protected void visitForeachNonemptyNode(ForeachNonemptyNode node) {
        String baseVarName = node.getVarName();
        String foreachNodeId = Integer.toString(node.getForeachNodeId());
        String listVarName = baseVarName + "List" + foreachNodeId;
        String indexVarName = baseVarName + "Index" + foreachNodeId;
        String dataVarName = baseVarName + "Data" + foreachNodeId;
        this.pyCodeBuilder.appendLine("for ", indexVarName, ", ", dataVarName, " in enumerate(", listVarName, "):");
        this.pyCodeBuilder.increaseIndent();
        int eqPrecedence = PyExprUtils.pyPrecedenceForOperator(Operator.EQUAL);
        this.localVarExprs.pushFrame();
        this.localVarExprs.addVariable(baseVarName, new PyExpr(dataVarName, Integer.MAX_VALUE)).addVariable(baseVarName + "__isFirst", new PyExpr(indexVarName + " == 0", eqPrecedence)).addVariable(baseVarName + "__isLast", new PyExpr(indexVarName + " == len(" + listVarName + ") - 1", eqPrecedence)).addVariable(baseVarName + "__index", new PyExpr(indexVarName, Integer.MAX_VALUE));
        this.visitChildren(node);
        this.localVarExprs.popFrame();
        this.pyCodeBuilder.decreaseIndent();
    }

    @Override
    protected void visitForeachIfemptyNode(ForeachIfemptyNode node) {
        this.visitChildren(node);
    }

    @Override
    protected void visitLetValueNode(LetValueNode node) {
        String generatedVarName = node.getUniqueVarName();
        TranslateToPyExprVisitor translator = this.translateToPyExprVisitorFactory.create(this.localVarExprs);
        PyExpr valuePyExpr = (PyExpr)translator.exec(node.getValueExpr());
        this.pyCodeBuilder.appendLine(generatedVarName, " = ", valuePyExpr.getText());
        this.localVarExprs.addVariable(node.getVarName(), new PyExpr(generatedVarName, Integer.MAX_VALUE));
    }

    @Override
    protected void visitLetContentNode(LetContentNode node) {
        if (node.getContentKind() == null) {
            throw SoySyntaxExceptionUtils.createWithNode("Let content node is missing a content kind. This may be due to using a non-strict template, which is unsupported in the Python compiler.", node);
        }
        String generatedVarName = node.getUniqueVarName();
        PyStringExpr content = PyExprUtils.concatPyExprs(this.genPyExprsVisitor.execOnChildren(node)).toPyString();
        this.pyCodeBuilder.appendLine(generatedVarName, " = ", PyExprUtils.wrapAsSanitizedContent(node.getContentKind(), content).getText());
        this.localVarExprs.addVariable(node.getVarName(), new PyExpr(generatedVarName, Integer.MAX_VALUE));
    }

    @Override
    protected void visitCallNode(CallNode node) {
        for (CallParamNode child : node.getChildren()) {
            if (!(child instanceof CallParamContentNode) || ((Boolean)this.isComputableAsPyExprVisitor.exec(child)).booleanValue()) continue;
            this.visit(child);
        }
        this.pyCodeBuilder.addToOutputVar(this.genPyCallExprVisitor.exec(node, this.localVarExprs).toPyString());
    }

    @Override
    protected void visitCallParamContentNode(CallParamContentNode node) {
        Preconditions.checkArgument(((Boolean)this.isComputableAsPyExprVisitor.exec(node) == false ? 1 : 0) != 0, (Object)"Should only define 'param<n>' when not computable as Python expressions.");
        this.pyCodeBuilder.pushOutputVar("param" + node.getId());
        this.pyCodeBuilder.initOutputVarIfNecessary();
        this.visitChildren(node);
        this.pyCodeBuilder.popOutputVar();
    }

    @Override
    protected void visitSoyNode(SoyNode node) {
        if (!((Boolean)this.isComputableAsPyExprVisitor.exec(node)).booleanValue()) {
            throw new UnsupportedOperationException();
        }
        this.pyCodeBuilder.addToOutputVar((List<? extends PyExpr>)this.genPyExprsVisitor.exec(node));
    }

    private void addCodeToRequireGeneralDeps() {
        this.pyCodeBuilder.appendLine("from __future__ import unicode_literals");
        this.pyCodeBuilder.appendLine("import math");
        this.pyCodeBuilder.appendLine("import random");
        this.pyCodeBuilder.appendLine("from ", this.runtimePath, " import bidi");
        this.pyCodeBuilder.appendLine("from ", this.runtimePath, " import directives");
        this.pyCodeBuilder.appendLine("from ", this.runtimePath, " import runtime");
        this.pyCodeBuilder.appendLine("from ", this.runtimePath, " import sanitize");
        this.pyCodeBuilder.appendLine(new String[0]);
        if (!this.bidiIsRtlFn.isEmpty()) {
            int dotIndex = this.bidiIsRtlFn.lastIndexOf(46);
            String bidiModulePath = this.bidiIsRtlFn.substring(0, dotIndex);
            Pair<String, String> nameSpaceAndName = GenPyCodeVisitor.namespaceAndNameFromModule(bidiModulePath);
            String bidiNamespace = (String)nameSpaceAndName.first;
            String bidiModuleName = (String)nameSpaceAndName.second;
            this.pyCodeBuilder.appendLine("from ", bidiNamespace, " import ", bidiModuleName, " as ", "external_bidi");
        }
        if (!this.translationClass.isEmpty()) {
            Pair<String, String> nameSpaceAndName = GenPyCodeVisitor.namespaceAndNameFromModule(this.translationClass);
            String translationNamespace = (String)nameSpaceAndName.first;
            String translationName = (String)nameSpaceAndName.second;
            this.pyCodeBuilder.appendLine("from ", translationNamespace, " import ", translationName);
            this.pyCodeBuilder.appendLine("translator_impl", " = ", translationName, "()");
        }
    }

    private void addCodeToRequireSoyNamespaces(SoyFileNode soyFile) {
        for (String calleeNotInFile : new FindCalleesNotInFileVisitor().exec(soyFile)) {
            int lastDotIndex = calleeNotInFile.lastIndexOf(46);
            if (lastDotIndex == -1) {
                throw SoySyntaxExceptionUtils.createWithNode("Called template \"" + calleeNotInFile + "\" does not reside in a namespace.", soyFile);
            }
            String calleeModule = calleeNotInFile.substring(0, lastDotIndex);
            if (calleeModule.isEmpty()) continue;
            Pair<String, String> nameSpaceAndName = GenPyCodeVisitor.namespaceAndNameFromModule(calleeModule);
            String calleeNamespace = (String)nameSpaceAndName.first;
            String calleeName = (String)nameSpaceAndName.second;
            this.pyCodeBuilder.appendLine(calleeName, " = runtime.namespaced_import('", calleeName, "', namespace='", calleeNamespace, "')");
        }
        this.pyCodeBuilder.appendLine(new String[0]);
    }

    private void addCodeToRegisterCurrentSoyNamespace(SoyFileNode soyFile) {
        String namespace = soyFile.getNamespace();
        this.pyCodeBuilder.appendLine("SOY_NAMESPACE = '" + namespace + "'");
    }

    private static Pair<String, String> namespaceAndNameFromModule(String moduleName) {
        String namespace = moduleName;
        String name = moduleName;
        int lastDotIndex = moduleName.lastIndexOf(46);
        if (lastDotIndex != -1) {
            namespace = moduleName.substring(0, lastDotIndex);
            name = moduleName.substring(lastDotIndex + 1);
        }
        return new Pair<String, String>(namespace, name);
    }

    private void addCodeToFixUnicodeStrings() {
        this.pyCodeBuilder.appendLine("try:");
        this.pyCodeBuilder.increaseIndent();
        this.pyCodeBuilder.appendLine("str = unicode");
        this.pyCodeBuilder.decreaseIndent();
        this.pyCodeBuilder.appendLine("except NameError:");
        this.pyCodeBuilder.increaseIndent();
        this.pyCodeBuilder.appendLine("pass");
        this.pyCodeBuilder.decreaseIndent();
        this.pyCodeBuilder.appendLine(new String[0]);
    }

    private void generateFunctionBody(TemplateNode node) {
        this.localVarExprs.pushFrame();
        if (new ShouldEnsureDataIsDefinedVisitor().exec(node)) {
            this.pyCodeBuilder.appendLine("opt_data = opt_data or {}");
        }
        this.pyCodeBuilder.pushOutputVar("output");
        this.visitChildren(node);
        PyExpr resultPyExpr = this.pyCodeBuilder.getOutputAsString();
        this.pyCodeBuilder.popOutputVar();
        resultPyExpr = PyExprUtils.wrapAsSanitizedContent(node.getContentKind(), resultPyExpr);
        this.pyCodeBuilder.appendLine("return ", resultPyExpr.getText());
        this.localVarExprs.popFrame();
    }
}

