/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.parsepasses.contextautoesc;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.template.soy.data.SanitizedContent;
import com.google.template.soy.parsepasses.contextautoesc.EscapingMode;
import java.util.EnumMap;
import javax.annotation.Nullable;

public final class Context {
    public final State state;
    public final ElementType elType;
    public final AttributeType attrType;
    public final AttributeEndDelimiter delimType;
    public final JsFollowingSlash slashType;
    public final UriPart uriPart;
    public final int templateNestDepth;
    public static final Context HTML_PCDATA = new Context(State.HTML_PCDATA);
    public static final Context ERROR = new Context(State.ERROR);
    private static final int N_STATE_BITS = 5;
    private static final int N_ELEMENT_BITS = 3;
    private static final int N_ATTR_BITS = 3;
    private static final int N_DELIM_BITS = 2;
    private static final int N_JS_SLASH_BITS = 2;
    private static final int N_URI_PART_BITS = 3;
    private static final ImmutableMap<State, SanitizedContent.ContentKind> STATE_TO_CONTENT_KIND;

    private Context(State state, ElementType elType, AttributeType attrType, AttributeEndDelimiter delimType, JsFollowingSlash slashType, UriPart uriPart, int templateNestDepth) {
        this.state = state;
        this.elType = elType;
        this.attrType = attrType;
        this.delimType = delimType;
        this.slashType = slashType;
        this.uriPart = uriPart;
        this.templateNestDepth = templateNestDepth;
    }

    private Context(State state) {
        this(state, ElementType.NONE, AttributeType.NONE, AttributeEndDelimiter.NONE, JsFollowingSlash.NONE, UriPart.NONE, 0);
    }

    public Context derive(State state) {
        return state == this.state ? this : this.toBuilder().withState(state).build();
    }

    public Context derive(JsFollowingSlash slashType) {
        return slashType == this.slashType ? this : this.toBuilder().withSlashType(slashType).build();
    }

    public Context derive(UriPart uriPart) {
        return uriPart == this.uriPart ? this : this.toBuilder().withUriPart(uriPart).build();
    }

    Builder toBuilder() {
        return new Builder(this);
    }

    public Context getContextAfterEscaping(@Nullable EscapingMode mode) {
        if (mode == null) {
            return ERROR;
        }
        if (mode == EscapingMode.ESCAPE_JS_VALUE) {
            switch (this.slashType) {
                case DIV_OP: 
                case UNKNOWN: {
                    return this;
                }
                case REGEX: {
                    return this.derive(JsFollowingSlash.DIV_OP);
                }
            }
            throw new IllegalStateException(this.slashType.name());
        }
        if (this.state == State.HTML_BEFORE_TAG_NAME) {
            return this.derive(State.HTML_TAG_NAME);
        }
        if (this.state == State.HTML_TAG) {
            return this.toBuilder().withState(State.HTML_ATTRIBUTE_NAME).withAttrType(AttributeType.PLAIN_TEXT).build();
        }
        if (this.uriPart == UriPart.START) {
            return this.derive(UriPart.PRE_QUERY);
        }
        return this;
    }

    Context getContextBeforeDynamicValue() {
        if (this.state == State.HTML_BEFORE_ATTRIBUTE_VALUE) {
            return Context.computeContextAfterAttributeDelimiter(this.elType, this.attrType, AttributeEndDelimiter.SPACE_OR_TAG_END, this.templateNestDepth);
        }
        return this;
    }

    static Context computeContextAfterAttributeDelimiter(ElementType elType, AttributeType attrType, AttributeEndDelimiter delim, int templateNestDepth) {
        State state;
        JsFollowingSlash slash = JsFollowingSlash.NONE;
        UriPart uriPart = UriPart.NONE;
        switch (attrType) {
            case PLAIN_TEXT: {
                state = State.HTML_NORMAL_ATTR_VALUE;
                break;
            }
            case SCRIPT: {
                state = State.JS;
                slash = JsFollowingSlash.REGEX;
                break;
            }
            case STYLE: {
                state = State.CSS;
                break;
            }
            case URI: {
                state = State.URI;
                uriPart = UriPart.START;
                break;
            }
            default: {
                throw new AssertionError((Object)("Unexpected attribute type " + (Object)((Object)attrType)));
            }
        }
        return new Context(state, elType, attrType, delim, slash, uriPart, templateNestDepth);
    }

    public ImmutableList<EscapingMode> getEscapingModes() {
        EscapingMode escapingMode = this.state.escapingMode;
        if (escapingMode == null) {
            return ImmutableList.of();
        }
        EscapingMode extraEscapingMode = null;
        switch (this.uriPart) {
            case QUERY: {
                escapingMode = EscapingMode.ESCAPE_URI;
                break;
            }
            case START: {
                if (escapingMode != EscapingMode.NORMALIZE_URI) {
                    extraEscapingMode = escapingMode;
                }
                escapingMode = EscapingMode.FILTER_NORMALIZE_URI;
                break;
            }
            case UNKNOWN: 
            case UNKNOWN_PRE_FRAGMENT: {
                return ImmutableList.of();
            }
        }
        switch (this.delimType) {
            case SPACE_OR_TAG_END: {
                if (escapingMode == EscapingMode.ESCAPE_HTML_ATTRIBUTE || escapingMode == EscapingMode.NORMALIZE_URI) {
                    escapingMode = EscapingMode.ESCAPE_HTML_ATTRIBUTE_NOSPACE;
                    break;
                }
                extraEscapingMode = EscapingMode.ESCAPE_HTML_ATTRIBUTE_NOSPACE;
                break;
            }
            case SINGLE_QUOTE: 
            case DOUBLE_QUOTE: {
                if (escapingMode == EscapingMode.NORMALIZE_URI) {
                    escapingMode = EscapingMode.ESCAPE_HTML_ATTRIBUTE;
                    break;
                }
                if (escapingMode.isHtmlEmbeddable) break;
                extraEscapingMode = EscapingMode.ESCAPE_HTML_ATTRIBUTE;
                break;
            }
        }
        return extraEscapingMode == null ? ImmutableList.of((Object)((Object)escapingMode)) : ImmutableList.of((Object)((Object)escapingMode), (Object)((Object)extraEscapingMode));
    }

    Optional<MsgEscapingStrategy> getMsgEscapingStrategy() {
        switch (this.state) {
            case HTML_PCDATA: {
                return Optional.of((Object)new MsgEscapingStrategy(this, (ImmutableList<EscapingMode>)ImmutableList.of()));
            }
            case CSS_DQ_STRING: 
            case CSS_SQ_STRING: 
            case JS_DQ_STRING: 
            case JS_SQ_STRING: 
            case TEXT: 
            case URI: {
                if (this.state == State.URI && this.uriPart != UriPart.QUERY) {
                    return Optional.absent();
                }
                return Optional.of((Object)new MsgEscapingStrategy(new Context(State.TEXT), this.getEscapingModes()));
            }
            case HTML_RCDATA: 
            case HTML_NORMAL_ATTR_VALUE: 
            case HTML_COMMENT: {
                return Optional.of((Object)new MsgEscapingStrategy(this, (ImmutableList<EscapingMode>)ImmutableList.of((Object)((Object)EscapingMode.NORMALIZE_HTML))));
            }
        }
        return Optional.absent();
    }

    public boolean isCompatibleWith(EscapingMode mode) {
        if (mode == EscapingMode.ESCAPE_JS_VALUE) {
            switch (this.state) {
                case CSS_DQ_STRING: 
                case CSS_SQ_STRING: 
                case JS_DQ_STRING: 
                case JS_SQ_STRING: {
                    return false;
                }
            }
            return true;
        }
        if (mode == EscapingMode.TEXT) {
            return this.state == State.TEXT;
        }
        return this.delimType != AttributeEndDelimiter.SPACE_OR_TAG_END || mode != EscapingMode.ESCAPE_HTML && mode != EscapingMode.ESCAPE_HTML_ATTRIBUTE && mode != EscapingMode.ESCAPE_HTML_RCDATA;
    }

    public boolean isErrorContext() {
        return this.state == State.ERROR;
    }

    @Deprecated
    public boolean equals(Object o) {
        if (!(o instanceof Context)) {
            return false;
        }
        Context that = (Context)o;
        return this.state == that.state && this.elType == that.elType && this.attrType == that.attrType && this.delimType == that.delimType && this.slashType == that.slashType && this.uriPart == that.uriPart && this.templateNestDepth == that.templateNestDepth;
    }

    public int hashCode() {
        return this.packedBits();
    }

    public int packedBits() {
        return (((((this.templateNestDepth << 3 | this.uriPart.ordinal()) << 2 | this.slashType.ordinal()) << 2 | this.delimType.ordinal()) << 3 | this.attrType.ordinal()) << 3 | this.elType.ordinal()) << 5 | this.state.ordinal();
    }

    public static Context union(Context a, Context b) {
        if (a.equals(b)) {
            return a;
        }
        if (a.templateNestDepth != b.templateNestDepth) {
            return ERROR;
        }
        if (a.equals(b.derive(a.slashType))) {
            return a.derive(JsFollowingSlash.UNKNOWN);
        }
        if (a.equals(b.derive(a.uriPart))) {
            return a.derive(a.uriPart != UriPart.FRAGMENT && b.uriPart != UriPart.FRAGMENT && a.uriPart != UriPart.UNKNOWN && b.uriPart != UriPart.UNKNOWN ? UriPart.UNKNOWN_PRE_FRAGMENT : UriPart.UNKNOWN);
        }
        if (a.state.compareTo(b.state) > 0) {
            Context swap = a;
            a = b;
            b = swap;
        }
        if (a.state == State.HTML_TAG_NAME && b.state == State.HTML_TAG) {
            return b;
        }
        if (a.state == State.HTML_TAG && a.elType == b.elType && (b.state == State.HTML_ATTRIBUTE_NAME || b.delimType == AttributeEndDelimiter.SPACE_OR_TAG_END)) {
            return a;
        }
        return ERROR;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("(Context ").append(this.state.name());
        if (this.elType != ElementType.NONE) {
            sb.append(' ').append(this.elType.name());
        }
        if (this.attrType != AttributeType.NONE) {
            sb.append(' ').append(this.attrType.name());
        }
        if (this.delimType != AttributeEndDelimiter.NONE) {
            sb.append(' ').append(this.delimType.name());
        }
        if (this.slashType != JsFollowingSlash.NONE) {
            sb.append(' ').append(this.slashType.name());
        }
        if (this.uriPart != UriPart.NONE) {
            sb.append(' ').append(this.uriPart.name());
        }
        if (this.templateNestDepth != 0) {
            sb.append(" templateNestDepth=").append(this.templateNestDepth);
        }
        return sb.append(')').toString();
    }

    public static Context getStartContextForContentKind(SanitizedContent.ContentKind contentKind) {
        return HTML_PCDATA.toBuilder().withStartKind(contentKind).build();
    }

    public boolean isValidStartContextForContentKind(SanitizedContent.ContentKind contentKind) {
        if (this.templateNestDepth != 0) {
            return false;
        }
        switch (contentKind) {
            case ATTRIBUTES: {
                return this.state == State.HTML_ATTRIBUTE_NAME || this.state == State.HTML_TAG;
            }
        }
        return this.equals(Context.getStartContextForContentKind(contentKind));
    }

    public boolean isValidStartContextForContentKindLoose(SanitizedContent.ContentKind contentKind) {
        switch (contentKind) {
            case URI: {
                return this.state == State.URI;
            }
        }
        return this.isValidStartContextForContentKind(contentKind);
    }

    public SanitizedContent.ContentKind getMostAppropriateContentKind() {
        SanitizedContent.ContentKind kind = (SanitizedContent.ContentKind)((Object)STATE_TO_CONTENT_KIND.get((Object)this.state));
        if (kind != null && this.isValidStartContextForContentKindLoose(kind)) {
            return kind;
        }
        return SanitizedContent.ContentKind.TEXT;
    }

    public final boolean isValidEndContextForContentKind(SanitizedContent.ContentKind contentKind) {
        if (this.templateNestDepth != 0) {
            return false;
        }
        switch (contentKind) {
            case CSS: {
                return this.state == State.CSS && this.elType == ElementType.NONE;
            }
            case HTML: {
                return this.state == State.HTML_PCDATA && this.elType == ElementType.NONE;
            }
            case ATTRIBUTES: {
                return this.state == State.HTML_ATTRIBUTE_NAME || this.state == State.HTML_TAG;
            }
            case JS: {
                return this.state == State.JS && this.elType == ElementType.NONE;
            }
            case URI: {
                return this.state == State.URI && this.uriPart != UriPart.START;
            }
            case TEXT: {
                return this.state == State.TEXT;
            }
        }
        throw new IllegalArgumentException("Specified content kind has no associated end context.");
    }

    public final String getLikelyEndContextMismatchCause(SanitizedContent.ContentKind contentKind) {
        Preconditions.checkArgument((!this.isValidEndContextForContentKind(contentKind) ? 1 : 0) != 0);
        if (contentKind == SanitizedContent.ContentKind.ATTRIBUTES) {
            return "an unterminated attribute value, or ending with an unquoted attribute";
        }
        switch (this.state) {
            case HTML_NORMAL_ATTR_VALUE: 
            case HTML_TAG_NAME: 
            case HTML_TAG: 
            case HTML_ATTRIBUTE_NAME: {
                return "an unterminated HTML tag or attribute";
            }
            case CSS: {
                return "an unclosed style block or attribute";
            }
            case JS: 
            case JS_LINE_COMMENT: {
                return "an unclosed script block or attribute";
            }
            case HTML_COMMENT: 
            case CSS_COMMENT: 
            case JS_BLOCK_COMMENT: {
                return "an unterminated comment";
            }
            case CSS_DQ_STRING: 
            case CSS_SQ_STRING: 
            case JS_DQ_STRING: 
            case JS_SQ_STRING: {
                return "an unterminated string literal";
            }
            case URI: 
            case CSS_URI: 
            case CSS_DQ_URI: 
            case CSS_SQ_URI: {
                return "an unterminated or empty URI";
            }
            case JS_REGEX: {
                return "an unterminated regular expression";
            }
        }
        if (this.templateNestDepth != 0) {
            return "an unterminated <template> element";
        }
        return "unknown to compiler";
    }

    static {
        if (32 < State.values().length || 8 < ElementType.values().length || 8 < AttributeType.values().length || 4 < AttributeEndDelimiter.values().length || 4 < JsFollowingSlash.values().length || 8 < UriPart.values().length) {
            throw new AssertionError();
        }
        EnumMap<State, SanitizedContent.ContentKind> stateToContextKind = new EnumMap<State, SanitizedContent.ContentKind>(State.class);
        stateToContextKind.put(State.CSS, SanitizedContent.ContentKind.CSS);
        stateToContextKind.put(State.HTML_PCDATA, SanitizedContent.ContentKind.HTML);
        stateToContextKind.put(State.HTML_TAG, SanitizedContent.ContentKind.ATTRIBUTES);
        stateToContextKind.put(State.JS, SanitizedContent.ContentKind.JS);
        stateToContextKind.put(State.URI, SanitizedContent.ContentKind.URI);
        stateToContextKind.put(State.TEXT, SanitizedContent.ContentKind.TEXT);
        STATE_TO_CONTENT_KIND = ImmutableMap.copyOf(stateToContextKind);
    }

    static final class Builder {
        private State state;
        private ElementType elType;
        private AttributeType attrType;
        private AttributeEndDelimiter delimType;
        private JsFollowingSlash slashType;
        private UriPart uriPart;
        private int templateNestDepth;

        private Builder(Context context) {
            this.state = context.state;
            this.elType = context.elType;
            this.attrType = context.attrType;
            this.delimType = context.delimType;
            this.slashType = context.slashType;
            this.uriPart = context.uriPart;
            this.templateNestDepth = context.templateNestDepth;
        }

        Builder withState(State state) {
            this.state = (State)((Object)Preconditions.checkNotNull((Object)((Object)state)));
            return this;
        }

        Builder withElType(ElementType elType) {
            this.elType = (ElementType)((Object)Preconditions.checkNotNull((Object)((Object)elType)));
            return this;
        }

        Builder withAttrType(AttributeType attrType) {
            this.attrType = (AttributeType)((Object)Preconditions.checkNotNull((Object)((Object)attrType)));
            return this;
        }

        Builder withDelimType(AttributeEndDelimiter delimType) {
            this.delimType = (AttributeEndDelimiter)((Object)Preconditions.checkNotNull((Object)((Object)delimType)));
            return this;
        }

        Builder withSlashType(JsFollowingSlash slashType) {
            this.slashType = (JsFollowingSlash)((Object)Preconditions.checkNotNull((Object)((Object)slashType)));
            return this;
        }

        Builder withUriPart(UriPart uriPart) {
            this.uriPart = (UriPart)((Object)Preconditions.checkNotNull((Object)((Object)uriPart)));
            return this;
        }

        Builder withTemplateNestDepth(int templateNestDepth) {
            Preconditions.checkArgument((templateNestDepth >= 0 ? 1 : 0) != 0);
            this.templateNestDepth = templateNestDepth;
            return this;
        }

        Builder withoutAttrContext() {
            return this.withAttrType(AttributeType.NONE).withDelimType(AttributeEndDelimiter.NONE).withSlashType(JsFollowingSlash.NONE).withUriPart(UriPart.NONE);
        }

        Builder withStartKind(SanitizedContent.ContentKind contentKind) {
            boolean inTag = false;
            this.withoutAttrContext();
            switch (contentKind) {
                case CSS: {
                    this.withState(State.CSS);
                    break;
                }
                case HTML: {
                    this.withState(State.HTML_PCDATA);
                    break;
                }
                case ATTRIBUTES: {
                    this.withState(State.HTML_TAG);
                    inTag = true;
                    break;
                }
                case JS: {
                    this.withState(State.JS);
                    this.withSlashType(JsFollowingSlash.REGEX);
                    break;
                }
                case URI: {
                    this.withState(State.URI);
                    this.withUriPart(UriPart.START);
                    break;
                }
                case TEXT: {
                    this.withState(State.TEXT);
                    break;
                }
            }
            if (!inTag) {
                this.withElType(ElementType.NONE);
            }
            return this;
        }

        Context build() {
            return new Context(this.state, this.elType, this.attrType, this.delimType, this.slashType, this.uriPart, this.templateNestDepth);
        }
    }

    public static enum UriPart {
        NONE,
        START,
        PRE_QUERY,
        QUERY,
        FRAGMENT,
        UNKNOWN_PRE_FRAGMENT,
        UNKNOWN;

    }

    public static enum JsFollowingSlash {
        NONE,
        REGEX,
        DIV_OP,
        UNKNOWN;

    }

    public static enum AttributeEndDelimiter {
        NONE,
        DOUBLE_QUOTE("\""),
        SINGLE_QUOTE("'"),
        SPACE_OR_TAG_END("");

        @Nullable
        public final String text;

        private AttributeEndDelimiter(String text) {
            this.text = text;
        }

        private AttributeEndDelimiter() {
            this.text = null;
        }
    }

    public static enum AttributeType {
        NONE,
        SCRIPT,
        STYLE,
        URI,
        PLAIN_TEXT;

    }

    public static enum ElementType {
        NONE,
        SCRIPT,
        STYLE,
        TEXTAREA,
        TITLE,
        LISTING,
        XMP,
        NORMAL;

    }

    public static enum State {
        HTML_PCDATA(EscapingMode.ESCAPE_HTML),
        HTML_RCDATA(EscapingMode.ESCAPE_HTML_RCDATA),
        HTML_BEFORE_TAG_NAME(EscapingMode.FILTER_HTML_ELEMENT_NAME),
        HTML_TAG_NAME(EscapingMode.FILTER_HTML_ELEMENT_NAME),
        HTML_TAG(EscapingMode.FILTER_HTML_ATTRIBUTES),
        HTML_ATTRIBUTE_NAME(EscapingMode.FILTER_HTML_ATTRIBUTES),
        HTML_BEFORE_ATTRIBUTE_VALUE,
        HTML_COMMENT(EscapingMode.ESCAPE_HTML_RCDATA),
        HTML_NORMAL_ATTR_VALUE(EscapingMode.ESCAPE_HTML_ATTRIBUTE),
        CSS(EscapingMode.FILTER_CSS_VALUE),
        CSS_COMMENT,
        CSS_DQ_STRING(EscapingMode.ESCAPE_CSS_STRING),
        CSS_SQ_STRING(EscapingMode.ESCAPE_CSS_STRING),
        CSS_URI(EscapingMode.NORMALIZE_URI),
        CSS_DQ_URI(EscapingMode.NORMALIZE_URI),
        CSS_SQ_URI(EscapingMode.NORMALIZE_URI),
        JS(EscapingMode.ESCAPE_JS_VALUE),
        JS_LINE_COMMENT,
        JS_BLOCK_COMMENT,
        JS_DQ_STRING(EscapingMode.ESCAPE_JS_STRING),
        JS_SQ_STRING(EscapingMode.ESCAPE_JS_STRING),
        JS_REGEX(EscapingMode.ESCAPE_JS_REGEX),
        URI(EscapingMode.NORMALIZE_URI),
        TEXT(EscapingMode.TEXT),
        ERROR;

        @Nullable
        private final EscapingMode escapingMode;

        private State(EscapingMode escapingMode) {
            this.escapingMode = escapingMode;
        }

        private State() {
            this.escapingMode = null;
        }
    }

    static final class MsgEscapingStrategy {
        final Context childContext;
        final ImmutableList<EscapingMode> escapingModesForFullMessage;

        MsgEscapingStrategy(Context childContext, ImmutableList<EscapingMode> escapingModesForFullMessage) {
            this.childContext = childContext;
            this.escapingModesForFullMessage = escapingModesForFullMessage;
        }
    }
}

