/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.jssrc.internal;

import com.google.common.base.CharMatcher;
import com.google.common.base.Optional;
import com.google.common.collect.HashBasedTable;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Maps;
import com.google.common.collect.Table;
import com.google.template.soy.exprtree.AbstractExprNodeVisitor;
import com.google.template.soy.exprtree.DataAccessNode;
import com.google.template.soy.exprtree.ExprNode;
import com.google.template.soy.exprtree.FieldAccessNode;
import com.google.template.soy.exprtree.ItemAccessNode;
import com.google.template.soy.exprtree.VarRefNode;
import com.google.template.soy.jssrc.internal.HelperFunctions;
import com.google.template.soy.types.SoyType;
import com.google.template.soy.types.aggregate.UnionType;
import java.util.Collection;
import java.util.Map;

final class CollectTypeHelpersExprVisitor
extends AbstractExprNodeVisitor<Void> {
    private final String closureNamespace;
    private final Table<SoyType, String, HelperFunctions.FieldAccessorHelperInfo> fieldAccessorHelperInfo = HashBasedTable.create();
    private final Map<SoyType, HelperFunctions.ValueConverterHelperInfo> valueConverterHelperInfo = Maps.newLinkedHashMap();
    private int nameCounter;

    CollectTypeHelpersExprVisitor(String closureNamespace) {
        this.closureNamespace = closureNamespace;
    }

    public Optional<HelperFunctions.ValueConverterHelperInfo> converterFor(SoyType valueType) {
        Optional<SoyType> keyTypeOpt = this.updateTablesBasedOnValueType(valueType, false);
        if (keyTypeOpt.isPresent()) {
            return Optional.of((Object)this.valueConverterHelperInfo.get(keyTypeOpt.get()));
        }
        return Optional.absent();
    }

    public Optional<HelperFunctions.FieldAccessorHelperInfo> fieldAccessorFor(SoyType containerType, String fieldName) {
        Optional<SoyType> keyTypeOpt = this.updateTablesBasedOnField(containerType, fieldName, false);
        if (keyTypeOpt.isPresent()) {
            return Optional.of((Object)this.fieldAccessorHelperInfo.get(keyTypeOpt.get(), (Object)fieldName));
        }
        return Optional.absent();
    }

    @Override
    protected void visitVarRefNode(VarRefNode node) {
        this.updateTablesBasedOnValueType(node.getType(), node.isNullSafeInjected());
    }

    @Override
    protected void visitDataAccessNode(DataAccessNode node) {
        throw new AssertionError();
    }

    @Override
    protected void visitFieldAccessNode(FieldAccessNode node) {
        SoyType containerType = node.getBaseExprChild().getType();
        String fieldName = node.getFieldName();
        boolean isNullSafe = node.isNullSafe();
        this.updateTablesBasedOnField(containerType, fieldName, isNullSafe);
        this.updateTablesBasedOnValueType(node.getType(), isNullSafe);
    }

    @Override
    protected void visitItemAccessNode(ItemAccessNode node) {
        this.updateTablesBasedOnValueType(node.getType(), node.isNullSafe());
    }

    @Override
    protected void visitExprNode(ExprNode node) {
        if (node instanceof ExprNode.ParentExprNode) {
            this.visitChildren((ExprNode.ParentExprNode)node);
        }
    }

    private Optional<SoyType> updateTablesBasedOnValueType(SoyType valueType, boolean appearsInUnion) {
        return new HelperTableMaintainer<HelperFunctions.ValueConverterHelperInfo>(){

            @Override
            boolean shouldAppearInTable(SoyType type) {
                return HelperFunctions.converterForType(type).isPresent();
            }

            @Override
            Optional<HelperFunctions.ValueConverterHelperInfo> lookupHelperInfo(SoyType minimalType) {
                return Optional.fromNullable(CollectTypeHelpersExprVisitor.this.valueConverterHelperInfo.get(minimalType));
            }

            @Override
            Optional<String> externalClosurePathFor(SoyType minimalType) {
                return HelperFunctions.converterForType(minimalType);
            }

            @Override
            String helperNamePrefix() {
                return "ConvertValue";
            }

            @Override
            HelperFunctions.ValueConverterHelperInfo storeHelperInfo(String closurePath, HelperFunctions.CodeLocation loc, SoyType minimalType) {
                HelperFunctions.ValueConverterHelperInfo info = new HelperFunctions.ValueConverterHelperInfo(closurePath, loc, minimalType);
                CollectTypeHelpersExprVisitor.this.valueConverterHelperInfo.put(minimalType, info);
                return info;
            }
        }.updateTable(valueType, appearsInUnion);
    }

    private Optional<SoyType> updateTablesBasedOnField(SoyType containerType, final String fieldName, boolean appearsInUnion) {
        return new HelperTableMaintainer<HelperFunctions.FieldAccessorHelperInfo>(){

            @Override
            boolean shouldAppearInTable(SoyType type) {
                HelperFunctions.FieldAccessStrategy defaultStrategy;
                HelperFunctions.FieldAccessStrategy strategy = HelperFunctions.strategyForFieldLookup(type, fieldName);
                return !strategy.equals(defaultStrategy = HelperFunctions.defaultStrategyForField(fieldName));
            }

            @Override
            Optional<HelperFunctions.FieldAccessorHelperInfo> lookupHelperInfo(SoyType minimalType) {
                return Optional.fromNullable((Object)CollectTypeHelpersExprVisitor.this.fieldAccessorHelperInfo.get((Object)minimalType, (Object)fieldName));
            }

            @Override
            Optional<String> externalClosurePathFor(SoyType minimalType) {
                HelperFunctions.FieldAccessStrategy strategy = HelperFunctions.strategyForFieldLookup(minimalType, fieldName);
                switch (strategy.op) {
                    case BRACKET: 
                    case DOT: 
                    case METHOD: {
                        return Optional.absent();
                    }
                    case LIBRARY_FN: {
                        return Optional.of((Object)strategy.fieldKey);
                    }
                }
                throw new AssertionError((Object)("unrecognized " + (Object)((Object)strategy.op)));
            }

            @Override
            String helperNamePrefix() {
                return "Read_" + fieldName;
            }

            @Override
            HelperFunctions.FieldAccessorHelperInfo storeHelperInfo(String closurePath, HelperFunctions.CodeLocation loc, SoyType minimalType) {
                HelperFunctions.FieldAccessorHelperInfo info = new HelperFunctions.FieldAccessorHelperInfo(closurePath, loc, minimalType, fieldName);
                CollectTypeHelpersExprVisitor.this.fieldAccessorHelperInfo.put((Object)minimalType, (Object)fieldName, (Object)info);
                return info;
            }
        }.updateTable(containerType, appearsInUnion);
    }

    private String allocateHelperName(String prefix, SoyType type) {
        if (this.nameCounter < 0) {
            throw new AssertionError((Object)"underflow");
        }
        String suffix = "_" + this.nameCounter;
        ++this.nameCounter;
        return this.closureNamespace + "." + prefix + CollectTypeHelpersExprVisitor.toJsIdentifierPart(type.toString()) + suffix;
    }

    private static String toJsIdentifierPart(String s) {
        StringBuilder sb = new StringBuilder(s);
        int n = sb.length();
        for (int i = 0; i < n; ++i) {
            if (CharMatcher.JAVA_LETTER_OR_DIGIT.matches(sb.charAt(i))) continue;
            sb.setCharAt(i, '_');
        }
        return sb.toString();
    }

    private abstract class HelperTableMaintainer<HelperInfoT extends HelperFunctions.BaseHelperInfo> {
        private HelperTableMaintainer() {
        }

        Optional<SoyType> updateTable(SoyType type, boolean appearsInUnion) {
            HelperFunctions.BaseHelperInfo info;
            Optional<HelperInfoT> infoOpt;
            SoyType minimalType;
            if (type instanceof UnionType) {
                UnionType unionType = (UnionType)type;
                ImmutableList.Builder helperMemberTypes = ImmutableList.builder();
                for (SoyType memberType : unionType.getMembers()) {
                    Optional<SoyType> helperMemberTypeOpt = this.updateTable(memberType, true);
                    if (!helperMemberTypeOpt.isPresent()) continue;
                    helperMemberTypes.add(helperMemberTypeOpt.get());
                }
                minimalType = UnionType.of((Collection<SoyType>)helperMemberTypes.build());
                if (minimalType instanceof UnionType && ((UnionType)minimalType).getMembers().isEmpty()) {
                    return Optional.absent();
                }
            } else {
                if (this.shouldAppearInTable(type)) {
                    return Optional.absent();
                }
                minimalType = type;
            }
            if ((infoOpt = this.lookupHelperInfo(minimalType)).isPresent()) {
                info = (HelperFunctions.BaseHelperInfo)infoOpt.get();
            } else {
                HelperFunctions.CodeLocation loc;
                String closurePath;
                Optional<String> closurePathOpt = this.externalClosurePathFor(minimalType);
                if (closurePathOpt.isPresent()) {
                    closurePath = (String)closurePathOpt.get();
                    loc = HelperFunctions.CodeLocation.EXTERNAL;
                } else {
                    closurePath = CollectTypeHelpersExprVisitor.this.allocateHelperName(this.helperNamePrefix(), minimalType);
                    loc = HelperFunctions.CodeLocation.GENERATED;
                }
                info = this.storeHelperInfo(closurePath, loc, minimalType);
            }
            if (appearsInUnion) {
                info.appearsInUnion = true;
            }
            return Optional.of((Object)minimalType);
        }

        abstract boolean shouldAppearInTable(SoyType var1);

        abstract Optional<HelperInfoT> lookupHelperInfo(SoyType var1);

        abstract Optional<String> externalClosurePathFor(SoyType var1);

        abstract String helperNamePrefix();

        abstract HelperInfoT storeHelperInfo(String var1, HelperFunctions.CodeLocation var2, SoyType var3);
    }
}

