/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.jbcsrc;

import com.google.common.base.Preconditions;
import com.google.common.collect.Sets;
import com.google.template.soy.jbcsrc.AutoValue_VariableSet_VarKey;
import com.google.template.soy.jbcsrc.Expression;
import com.google.template.soy.jbcsrc.FieldRef;
import com.google.template.soy.jbcsrc.LocalVariable;
import com.google.template.soy.jbcsrc.Statement;
import com.google.template.soy.jbcsrc.TypeInfo;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Deque;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.Label;
import org.objectweb.asm.Type;
import org.objectweb.asm.commons.GeneratorAdapter;
import org.objectweb.asm.commons.Method;

final class VariableSet {
    private final List<Variable> allVariables = new ArrayList<Variable>();
    private final Deque<Map<VarKey, Variable>> frames = new ArrayDeque<Map<VarKey, Variable>>();
    private final Set<String> activeLocalNames = new HashSet<String>();
    private final Set<String> fieldNames = new HashSet<String>();
    private final BitSet availableSlots = new BitSet();
    private final TypeInfo owner;
    private final LocalVariable thisVar;

    VariableSet(TypeInfo owner, LocalVariable thisVar, Method method) {
        this.owner = owner;
        this.thisVar = thisVar;
        this.availableSlots.set(0);
        int from = 1;
        for (Type type : method.getArgumentTypes()) {
            int to = from + type.getSize();
            this.availableSlots.set(from, to);
            from = to;
        }
    }

    Scope enterScope() {
        final LinkedHashMap currentFrame = new LinkedHashMap();
        this.frames.push(currentFrame);
        return new Scope(){

            @Override
            Variable createSynthetic(String proposedName, Type type, Label start, Label end) {
                VarKey key = VarKey.create(VarKey.Kind.SYNTHETIC, proposedName);
                String name = VariableSet.this.getAvailableFieldName("$" + proposedName);
                int index = VariableSet.this.reserveSlotFor(type);
                Variable var = new Variable(LocalVariable.createLocal(name, index, type, start, end));
                currentFrame.put(key, var);
                VariableSet.this.allVariables.add(var);
                return var;
            }

            @Override
            Statement exitScope() {
                VariableSet.this.frames.pop();
                final Set endLabels = Sets.newSetFromMap(new IdentityHashMap());
                for (Variable var : currentFrame.values()) {
                    endLabels.add(var.local.end());
                    VariableSet.this.activeLocalNames.remove(var.local.name());
                    VariableSet.this.availableSlots.clear(var.local.index(), var.local.index() + var.local.resultType().getSize());
                }
                return new Statement(){

                    @Override
                    void doGen(GeneratorAdapter adapter) {
                        for (Label label : endLabels) {
                            adapter.visitLabel(label);
                        }
                    }
                };
            }
        };
    }

    void generateTableEntries(GeneratorAdapter ga) {
        for (Variable var : this.allVariables) {
            var.local().tableEntry(ga);
        }
    }

    void defineFields(ClassWriter writer) {
        for (Variable var : this.allVariables) {
            var.maybeDefineField(writer);
        }
    }

    private int reserveSlotFor(Type type) {
        int size = type.getSize();
        Preconditions.checkArgument((size != 0 ? 1 : 0) != 0);
        int start = 0;
        int nextClear = this.availableSlots.nextClearBit(start);
        if (size == 2 && this.availableSlots.get(nextClear + 1)) {
            start = nextClear + 1;
        }
        this.availableSlots.set(nextClear, nextClear + size);
        return nextClear;
    }

    private String getAvailableFieldName(String name) {
        String proposal = name;
        int counter = 0;
        while (!this.fieldNames.add(proposal)) {
            proposal = name + "_" + ++counter;
        }
        return proposal;
    }

    final class Variable {
        private FieldRef fieldRef;
        private final LocalVariable local;

        private Variable(LocalVariable local) {
            this.local = local;
        }

        LocalVariable local() {
            return this.local;
        }

        Statement save() {
            return this.getField().putInstanceField(VariableSet.this.thisVar, this.local());
        }

        Statement restore() {
            Expression fieldValue = this.getField().accessor(VariableSet.this.thisVar);
            return this.local.store(fieldValue);
        }

        private FieldRef getField() {
            if (this.fieldRef == null) {
                this.fieldRef = FieldRef.createField(VariableSet.this.owner, this.local.name(), this.local.resultType());
            }
            return this.fieldRef;
        }

        private void maybeDefineField(ClassWriter writer) {
            if (this.fieldRef != null) {
                this.fieldRef.defineField((ClassVisitor)writer);
            }
        }
    }

    static abstract class VarKey {
        VarKey() {
        }

        static VarKey create(Kind synthetic, String proposedName) {
            return new AutoValue_VariableSet_VarKey(synthetic, proposedName);
        }

        abstract Kind kind();

        abstract String name();

        static enum Kind {
            USER_DEFINED,
            SYNTHETIC;

        }
    }

    abstract class Scope {
        private Scope() {
        }

        abstract Variable createSynthetic(String var1, Type var2, Label var3, Label var4);

        abstract Statement exitScope();
    }
}

