/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.jbcsrc;

import com.google.template.soy.data.SoyRecord;
import com.google.template.soy.jbcsrc.BytecodeUtils;
import com.google.template.soy.jbcsrc.ClassData;
import com.google.template.soy.jbcsrc.CompiledTemplateMetadata;
import com.google.template.soy.jbcsrc.LocalVariable;
import com.google.template.soy.jbcsrc.api.CompiledTemplate;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.Label;
import org.objectweb.asm.Type;
import org.objectweb.asm.commons.GeneratorAdapter;
import org.objectweb.asm.commons.Method;

final class TemplateFactoryCompiler {
    private static final String[] INTERFACES = new String[]{Type.getInternalName(CompiledTemplate.Factory.class)};
    private static final Method CREATE_METHOD;
    private final CompiledTemplateMetadata template;

    TemplateFactoryCompiler(CompiledTemplateMetadata currentClass) {
        this.template = currentClass;
    }

    ClassData compile() {
        ClassWriter cw = new ClassWriter(3);
        cw.visit(51, 49, this.template.factory().type().getInternalName(), null, Type.getInternalName(Object.class), INTERFACES);
        this.generateStaticInitializer(cw);
        BytecodeUtils.defineDefaultConstructor((ClassVisitor)cw, this.template.factory());
        this.generateCreateMethod(cw);
        cw.visitEnd();
        byte[] byteArray = cw.toByteArray();
        return ClassData.create(this.template.factory(), byteArray);
    }

    private void generateStaticInitializer(ClassWriter cw) {
        GeneratorAdapter ga = new GeneratorAdapter(8, BytecodeUtils.CLASS_INIT, null, null, (ClassVisitor)cw);
        ga.push(this.template.typeInfo().type());
        ga.visitVarInsn(58, 0);
        ga.returnValue();
        ga.endMethod();
    }

    private void generateCreateMethod(ClassWriter cw) {
        Label start = new Label();
        Label end = new Label();
        LocalVariable thisVar = LocalVariable.createThisVar(this.template.factory(), start, end);
        LocalVariable paramsVar = LocalVariable.createLocal("params", 1, Type.getType(SoyRecord.class), start, end);
        GeneratorAdapter ga = new GeneratorAdapter(1, CREATE_METHOD, null, null, (ClassVisitor)cw);
        ga.mark(start);
        ga.newInstance(this.template.typeInfo().type());
        ga.dup();
        paramsVar.gen(ga);
        ga.invokeConstructor(this.template.typeInfo().type(), CompiledTemplateMetadata.GENERATED_CONSTRUCTOR);
        ga.returnValue();
        ga.mark(end);
        thisVar.tableEntry(ga);
        paramsVar.tableEntry(ga);
        ga.endMethod();
    }

    static {
        try {
            CREATE_METHOD = Method.getMethod((java.lang.reflect.Method)CompiledTemplate.Factory.class.getDeclaredMethod("create", SoyRecord.class));
        }
        catch (NoSuchMethodException | SecurityException e) {
            throw new RuntimeException(e);
        }
    }
}

