/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.jbcsrc;

import com.google.common.base.Preconditions;
import com.google.template.soy.base.SourceLocation;
import com.google.template.soy.jbcsrc.BytecodeProducer;
import java.util.Arrays;
import org.objectweb.asm.commons.GeneratorAdapter;

abstract class Statement
extends BytecodeProducer {
    static final Statement NULL_STATEMENT = new Statement(){

        @Override
        void doGen(GeneratorAdapter adapter) {
        }
    };

    static Statement concat(Statement ... statements) {
        return Statement.concat(Arrays.asList(statements));
    }

    static Statement concat(final Iterable<? extends Statement> statements) {
        Preconditions.checkNotNull(statements);
        return new Statement(){

            @Override
            void doGen(GeneratorAdapter adapter) {
                for (Statement statement : statements) {
                    statement.gen(adapter);
                }
            }
        };
    }

    Statement() {
    }

    Statement(SourceLocation location) {
        super(location);
    }

    public final Statement withSourceLocation(SourceLocation location) {
        Preconditions.checkNotNull((Object)location);
        return new Statement(location){

            @Override
            void doGen(GeneratorAdapter adapter) {
                Statement.this.doGen(adapter);
            }
        };
    }

    public String toString() {
        return "Statement:\n" + this.trace();
    }
}

