/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.jbcsrc;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.template.soy.exprtree.ExprRootNode;
import com.google.template.soy.jbcsrc.BytecodeUtils;
import com.google.template.soy.jbcsrc.ControlFlow;
import com.google.template.soy.jbcsrc.Expression;
import com.google.template.soy.jbcsrc.ExpressionCompiler;
import com.google.template.soy.jbcsrc.MethodRef;
import com.google.template.soy.jbcsrc.SoyExpression;
import com.google.template.soy.jbcsrc.Statement;
import com.google.template.soy.jbcsrc.VariableSet;
import com.google.template.soy.jbcsrc.api.AdvisingAppendable;
import com.google.template.soy.jbcsrc.api.RenderContext;
import com.google.template.soy.soytree.AbstractReturningSoyNodeVisitor;
import com.google.template.soy.soytree.CssNode;
import com.google.template.soy.soytree.DebuggerNode;
import com.google.template.soy.soytree.IfCondNode;
import com.google.template.soy.soytree.IfElseNode;
import com.google.template.soy.soytree.IfNode;
import com.google.template.soy.soytree.LogNode;
import com.google.template.soy.soytree.PrintNode;
import com.google.template.soy.soytree.RawTextNode;
import com.google.template.soy.soytree.SoyNode;
import com.google.template.soy.soytree.SwitchCaseNode;
import com.google.template.soy.soytree.SwitchDefaultNode;
import com.google.template.soy.soytree.SwitchNode;
import com.google.template.soy.soytree.TemplateBasicNode;
import com.google.template.soy.soytree.TemplateNode;
import com.google.template.soy.soytree.XidNode;
import java.util.ArrayList;
import org.objectweb.asm.Label;
import org.objectweb.asm.Type;

final class SoyNodeCompiler
extends AbstractReturningSoyNodeVisitor<Statement> {
    private final VariableSet variables;
    private final Expression appendableExpression;
    private final Expression contextExpression;
    private final ExpressionCompiler exprCompiler;

    SoyNodeCompiler(VariableSet variables, Expression appendableExpression, Expression contextExpression, ExpressionCompiler exprCompiler) {
        appendableExpression.checkType(Type.getType(AdvisingAppendable.class));
        contextExpression.checkType(Type.getType(RenderContext.class));
        this.variables = variables;
        this.appendableExpression = appendableExpression;
        this.contextExpression = contextExpression;
        this.exprCompiler = (ExpressionCompiler)Preconditions.checkNotNull((Object)exprCompiler);
    }

    Statement compile(TemplateBasicNode node) {
        return (Statement)this.visit(node);
    }

    @Override
    protected Statement visitTemplateBasicNode(TemplateNode node) {
        return this.childrenAsStatement(node);
    }

    private Statement childrenAsStatement(SoyNode.ParentSoyNode<? extends SoyNode> node) {
        return Statement.concat(this.visitChildren(node)).withSourceLocation(node.getSourceLocation());
    }

    @Override
    protected Statement visitIfNode(IfNode node) {
        ArrayList<ControlFlow.IfBlock> ifs = new ArrayList<ControlFlow.IfBlock>();
        Optional elseBlock = Optional.absent();
        for (SoyNode child : node.getChildren()) {
            if (child instanceof IfCondNode) {
                IfCondNode icn = (IfCondNode)child;
                SoyExpression cond = this.exprCompiler.compile(icn.getExprUnion().getExpr()).convert(Boolean.TYPE);
                Statement block = this.childrenAsStatement(icn);
                ifs.add(ControlFlow.IfBlock.create(cond, block));
                continue;
            }
            IfElseNode ien = (IfElseNode)child;
            elseBlock = Optional.of((Object)this.childrenAsStatement(ien));
        }
        return ControlFlow.ifElseChain(ifs, (Optional<Statement>)elseBlock).withSourceLocation(node.getSourceLocation());
    }

    @Override
    protected Statement visitSwitchNode(SwitchNode node) {
        SoyExpression expression = this.exprCompiler.compile(node.getExpr());
        Label start = new Label();
        Label end = new Label();
        ArrayList<ControlFlow.IfBlock> cases = new ArrayList<ControlFlow.IfBlock>();
        Optional defaultBlock = Optional.absent();
        VariableSet.Scope scope = this.variables.enterScope();
        VariableSet.Variable variable = scope.createSynthetic("switchVar", expression.resultType(), start, end);
        SoyExpression.LocalVariableBinding binding = expression.createBinding(variable.local(), start);
        Statement init = binding.initializer();
        expression = binding.accessor();
        for (SoyNode child : node.getChildren()) {
            if (child instanceof SwitchCaseNode) {
                SwitchCaseNode caseNode = (SwitchCaseNode)child;
                ArrayList<Expression> comparisons = new ArrayList<Expression>();
                for (ExprRootNode<?> caseExpr : caseNode.getExprList()) {
                    comparisons.add(BytecodeUtils.compareSoyEquals(expression, this.exprCompiler.compile(caseExpr)));
                }
                Statement block = this.childrenAsStatement(caseNode);
                cases.add(ControlFlow.IfBlock.create(BytecodeUtils.logicalOr(comparisons), block));
                continue;
            }
            SwitchDefaultNode defaultNode = (SwitchDefaultNode)child;
            defaultBlock = Optional.of((Object)this.childrenAsStatement(defaultNode));
        }
        Statement exitScope = scope.exitScope();
        return Statement.concat(init, ControlFlow.ifElseChain(cases, (Optional<Statement>)defaultBlock), exitScope).withSourceLocation(node.getSourceLocation());
    }

    @Override
    protected Statement visitPrintNode(PrintNode node) {
        if (!node.getChildren().isEmpty()) {
            throw new UnsupportedOperationException("The jbcsrc implementation does not support print directives (yet!): " + node.toSourceString());
        }
        SoyExpression printExpr = this.exprCompiler.compile(node.getExprUnion().getExpr());
        return MethodRef.SOY_VALUE_RENDER.invokeVoid(printExpr.box(), this.appendableExpression).withSourceLocation(node.getSourceLocation());
    }

    @Override
    protected Statement visitRawTextNode(RawTextNode node) {
        return MethodRef.ADVISING_APPENDABLE_APPEND.invoke(this.appendableExpression, BytecodeUtils.constant(node.getRawText())).toStatement().withSourceLocation(node.getSourceLocation());
    }

    @Override
    protected Statement visitDebuggerNode(DebuggerNode node) {
        return Statement.NULL_STATEMENT.withSourceLocation(node.getSourceLocation());
    }

    @Override
    protected Statement visitXidNode(XidNode node) {
        Expression rename = MethodRef.RENDER_CONTEXT_RENAME_XID.invoke(this.contextExpression, BytecodeUtils.constant(node.getText()));
        return MethodRef.ADVISING_APPENDABLE_APPEND.invoke(this.appendableExpression, rename).toStatement().withSourceLocation(node.getSourceLocation());
    }

    @Override
    protected Statement visitCssNode(CssNode node) {
        Expression renameSelector = MethodRef.RENDER_CONTEXT_RENAME_CSS_SELECTOR.invoke(this.contextExpression, BytecodeUtils.constant(node.getSelectorText()));
        Statement selectorStatement = MethodRef.ADVISING_APPENDABLE_APPEND.invoke(this.appendableExpression, renameSelector).toStatement();
        if (node.getComponentNameExpr() != null) {
            return Statement.concat(MethodRef.SOY_VALUE_RENDER.invokeVoid(this.exprCompiler.compile(node.getComponentNameExpr()).box(), this.appendableExpression), MethodRef.ADVISING_APPENDABLE_APPEND_CHAR.invoke(this.appendableExpression, BytecodeUtils.constant('-')).toStatement(), selectorStatement);
        }
        return selectorStatement;
    }

    @Override
    protected Statement visitLogNode(LogNode node) {
        SoyNodeCompiler loggerCompiler = new SoyNodeCompiler(this.variables, MethodRef.RUNTIME_LOGGER.invoke(new Expression[0]), this.contextExpression, this.exprCompiler);
        return Statement.concat(loggerCompiler.visitChildren(node)).withSourceLocation(node.getSourceLocation());
    }

    @Override
    protected Statement visitSoyNode(SoyNode node) {
        throw new UnsupportedOperationException("The jbcsrc backend doesn't support: " + (Object)((Object)node.getKind()) + " nodes yet.");
    }
}

