/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.jbcsrc;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import com.google.template.soy.data.SoyValue;
import com.google.template.soy.jbcsrc.AutoValue_SoyExpression_LocalVariableBinding;
import com.google.template.soy.jbcsrc.BytecodeUtils;
import com.google.template.soy.jbcsrc.Expression;
import com.google.template.soy.jbcsrc.FieldRef;
import com.google.template.soy.jbcsrc.LocalVariable;
import com.google.template.soy.jbcsrc.MethodRef;
import com.google.template.soy.jbcsrc.Statement;
import com.google.template.soy.types.SoyType;
import com.google.template.soy.types.aggregate.ListType;
import com.google.template.soy.types.aggregate.MapType;
import com.google.template.soy.types.aggregate.RecordType;
import com.google.template.soy.types.primitive.BoolType;
import com.google.template.soy.types.primitive.FloatType;
import com.google.template.soy.types.primitive.IntType;
import com.google.template.soy.types.primitive.NullType;
import com.google.template.soy.types.primitive.StringType;
import java.util.List;
import java.util.Map;
import org.objectweb.asm.Label;
import org.objectweb.asm.Type;
import org.objectweb.asm.commons.GeneratorAdapter;

class SoyExpression
extends Expression {
    private static final ImmutableSet<SoyType.Kind> STRING_KINDS = Sets.immutableEnumSet((Enum)SoyType.Kind.STRING, (Enum[])new SoyType.Kind[]{SoyType.Kind.HTML, SoyType.Kind.ATTRIBUTES, SoyType.Kind.JS, SoyType.Kind.CSS, SoyType.Kind.URI});
    static final SoyExpression NULL = new SoyExpression(NullType.getInstance(), Object.class, new Expression.SimpleExpression(Type.getType(Object.class), true){

        @Override
        void doGen(GeneratorAdapter adapter) {
            adapter.visitInsn(1);
        }
    });
    static final SoyExpression TRUE = new SoyExpression((SoyType)BoolType.getInstance(), (Class)Boolean.TYPE, BytecodeUtils.constant(true)){

        @Override
        SoyExpression box() {
            return new DefaultBoxed((SoyType)BoolType.getInstance(), this, FieldRef.BOOLEAN_DATA_TRUE.accessor());
        }
    };
    static final SoyExpression FALSE = new SoyExpression((SoyType)BoolType.getInstance(), (Class)Boolean.TYPE, BytecodeUtils.constant(false)){

        @Override
        SoyExpression box() {
            return new DefaultBoxed((SoyType)BoolType.getInstance(), this, FieldRef.BOOLEAN_DATA_FALSE.accessor());
        }
    };
    private final Class<?> clazz;
    private final SoyType soyType;
    private final Expression delegate;

    static SoyExpression forSoyValue(SoyType type, Expression delegate) {
        return new SoyExpression(type, type.javaType(), delegate);
    }

    static SoyExpression forBool(Expression delegate) {
        return new SoyExpression(BoolType.getInstance(), Boolean.TYPE, delegate);
    }

    static SoyExpression forFloat(Expression delegate) {
        return new SoyExpression(FloatType.getInstance(), Double.TYPE, delegate);
    }

    static SoyExpression forInt(Expression delegate) {
        return new SoyExpression(IntType.getInstance(), Long.TYPE, delegate);
    }

    static SoyExpression forString(Expression delegate) {
        return new SoyExpression(StringType.getInstance(), String.class, delegate);
    }

    static SoyExpression forList(ListType listType, Expression delegate) {
        return new SoyExpression(listType, List.class, delegate);
    }

    static SoyExpression forMap(MapType mapType, Expression delegate) {
        return new SoyExpression(mapType, Map.class, delegate);
    }

    static SoyExpression forRecord(RecordType recordType, Expression delegate) {
        return new SoyExpression(recordType, Map.class, delegate);
    }

    private SoyExpression(SoyType soyType, Class<?> clazz, Expression delegate) {
        Preconditions.checkArgument((boolean)clazz.isAssignableFrom(BytecodeUtils.classFromAsmType(delegate.resultType())), (String)"delegate with type %s isn't compatible with asserted SoyExpression type %s", (Object[])new Object[]{delegate.resultType(), clazz});
        if (SoyValue.class.isAssignableFrom(clazz) && !soyType.javaType().isAssignableFrom(clazz)) {
            throw new IllegalArgumentException(clazz + " is not compatible with soy type: " + soyType);
        }
        this.soyType = soyType;
        this.clazz = clazz;
        this.delegate = delegate;
    }

    @Override
    final Type resultType() {
        return this.delegate.resultType();
    }

    @Override
    final boolean isConstant() {
        return this.delegate.isConstant();
    }

    @Override
    final void doGen(GeneratorAdapter adapter) {
        this.delegate.gen(adapter);
    }

    boolean isKnownString() {
        return STRING_KINDS.contains((Object)this.soyType.getKind());
    }

    boolean isKnownInt() {
        return this.soyType.getKind() == SoyType.Kind.INT;
    }

    boolean isKnownFloat() {
        return this.soyType.getKind() == SoyType.Kind.FLOAT;
    }

    boolean isKnownList() {
        return this.soyType.getKind() == SoyType.Kind.LIST;
    }

    boolean isKnownMap() {
        return this.soyType.getKind() == SoyType.Kind.MAP;
    }

    boolean isKnownRecord() {
        return this.soyType.getKind() == SoyType.Kind.RECORD;
    }

    private boolean isBoxed() {
        return SoyValue.class.isAssignableFrom(this.clazz);
    }

    final boolean isKnownNumber() {
        return this.isKnownFloat() || this.isKnownInt();
    }

    SoyExpression box() {
        if (this.isBoxed()) {
            return this;
        }
        if (this.isKnownInt()) {
            return this.asBoxed(MethodRef.INTEGER_DATA_FOR_VALUE.invoke(this.delegate));
        }
        if (this.isKnownFloat()) {
            return this.asBoxed(MethodRef.FLOAT_DATA_FOR_VALUE.invoke(this.delegate));
        }
        if (this.isKnownString()) {
            return this.asBoxed(MethodRef.STRING_DATA_FOR_VALUE.invoke(this.delegate));
        }
        if (this.isKnownList()) {
            return this.asBoxed(MethodRef.LIST_IMPL_FOR_PROVIDER_LIST.invoke(this.delegate));
        }
        if (this.isKnownMap()) {
            return this.asBoxed(MethodRef.DICT_IMPL_FOR_PROVIDER_MAP.invoke(this.delegate));
        }
        if (this.soyType.getKind() == SoyType.Kind.NULL) {
            return this.asBoxed(FieldRef.NULL_DATA_INSTANCE.accessor());
        }
        throw new IllegalStateException("cannot box expression of type " + this.clazz);
    }

    private DefaultBoxed asBoxed(Expression expr) {
        return new DefaultBoxed(this.soyType, this, expr);
    }

    SoyExpression convert(Class<?> asType) {
        Preconditions.checkArgument((!SoyValue.class.isAssignableFrom(asType) ? 1 : 0) != 0, (String)"Cannot use convert() to convert to a  SoyValue: %s", (Object[])new Object[]{asType});
        if (asType.equals(this.clazz)) {
            return this;
        }
        if (this.isKnownInt()) {
            Expression intExpr = this.delegate;
            if (this.isBoxed()) {
                intExpr = MethodRef.SOY_VALUE_LONG_VALUE.invoke(intExpr);
            }
            if (asType.equals(Double.TYPE)) {
                return SoyExpression.forFloat(BytecodeUtils.numericConversion(intExpr, Type.DOUBLE_TYPE));
            }
            if (asType.equals(Boolean.TYPE)) {
                return SoyExpression.forBool(BytecodeUtils.compare(154, intExpr, BytecodeUtils.constant(0L)));
            }
            if (asType.equals(String.class)) {
                return SoyExpression.forString(MethodRef.LONG_TO_STRING.invoke(intExpr));
            }
        }
        if (this.isKnownFloat()) {
            Expression floatExpr = this.delegate;
            if (this.isBoxed()) {
                floatExpr = MethodRef.SOY_VALUE_LONG_VALUE.invoke(floatExpr);
            }
            if (asType.equals(Long.TYPE)) {
                throw new IllegalArgumentException("Cannot convert float to int");
            }
            if (asType.equals(Boolean.TYPE)) {
                return SoyExpression.forBool(MethodRef.RUNTIME_COERCE_DOUBLE_TO_BOOLEAN.invoke(floatExpr));
            }
            if (asType.equals(String.class)) {
                return SoyExpression.forString(MethodRef.DOUBLE_TO_STRING.invoke(floatExpr));
            }
        }
        if (this.isKnownString()) {
            Expression stringExpr = this.delegate;
            if (this.isBoxed()) {
                stringExpr = MethodRef.SOY_VALUE_STRING_VALUE.invoke(stringExpr);
            }
            if (asType.equals(Double.TYPE) || asType.equals(Long.TYPE)) {
                throw new IllegalArgumentException("Cannot convert string to " + asType);
            }
            if (asType.equals(Boolean.TYPE)) {
                return SoyExpression.forBool(MethodRef.STRING_IS_EMPTY.invoke(stringExpr));
            }
        }
        if (asType.equals(Long.TYPE)) {
            return SoyExpression.forInt(MethodRef.SOY_VALUE_LONG_VALUE.invoke(this.box()));
        }
        if (asType.equals(Double.TYPE)) {
            return SoyExpression.forFloat(MethodRef.SOY_VALUE_FLOAT_VALUE.invoke(this.box()));
        }
        if (asType.equals(String.class)) {
            return SoyExpression.forString(MethodRef.TO_STRING.invoke(this.box()));
        }
        if (asType.equals(Boolean.TYPE)) {
            return SoyExpression.forBool(MethodRef.SOY_VALUE_COERCE_TO_BOOLEAN.invoke(this.box()));
        }
        throw new UnsupportedOperationException("Can't unbox " + this.clazz + " as " + asType);
    }

    LocalVariableBinding createBinding(LocalVariable variable, Label startLabel) {
        return new AutoValue_SoyExpression_LocalVariableBinding(new SoyExpression(this.soyType, this.clazz, variable), variable.store((Expression)this, startLabel));
    }

    private static final class DefaultBoxed
    extends SoyExpression {
        private final SoyExpression unboxed;

        DefaultBoxed(SoyType soyType, SoyExpression unboxed, Expression delegate) {
            super(soyType, soyType.javaType(), delegate);
            this.unboxed = unboxed;
        }

        @Override
        final SoyExpression convert(Class<?> asType) {
            return this.unboxed.convert(asType);
        }

        @Override
        final SoyExpression box() {
            return this;
        }
    }

    static abstract class LocalVariableBinding {
        LocalVariableBinding() {
        }

        abstract SoyExpression accessor();

        abstract Statement initializer();
    }
}

