/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.jbcsrc;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.template.soy.data.SoyRecord;
import com.google.template.soy.data.SoyValue;
import com.google.template.soy.data.SoyValueProvider;
import com.google.template.soy.data.internal.DictImpl;
import com.google.template.soy.data.internal.ListImpl;
import com.google.template.soy.data.restricted.BooleanData;
import com.google.template.soy.data.restricted.FloatData;
import com.google.template.soy.data.restricted.IntegerData;
import com.google.template.soy.data.restricted.StringData;
import com.google.template.soy.jbcsrc.AutoValue_MethodRef;
import com.google.template.soy.jbcsrc.Expression;
import com.google.template.soy.jbcsrc.Statement;
import com.google.template.soy.jbcsrc.TypeInfo;
import com.google.template.soy.jbcsrc.api.AdvisingAppendable;
import com.google.template.soy.jbcsrc.api.RenderContext;
import com.google.template.soy.jbcsrc.api.RenderResult;
import com.google.template.soy.jbcsrc.runtime.Runtime;
import com.google.template.soy.shared.internal.SharedRuntime;
import java.io.PrintStream;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.objectweb.asm.Type;
import org.objectweb.asm.commons.GeneratorAdapter;

abstract class MethodRef {
    static final MethodRef BOOLEAN_DATA_FOR_VALUE = MethodRef.create(BooleanData.class, "forValue", Boolean.TYPE);
    static final MethodRef INTEGER_DATA_FOR_VALUE = MethodRef.create(IntegerData.class, "forValue", Long.TYPE);
    static final MethodRef STRING_DATA_FOR_VALUE = MethodRef.create(StringData.class, "forValue", String.class);
    static final MethodRef FLOAT_DATA_FOR_VALUE = MethodRef.create(FloatData.class, "forValue", Double.TYPE);
    static final MethodRef LIST_IMPL_FOR_PROVIDER_LIST = MethodRef.create(ListImpl.class, "forProviderList", List.class);
    static final MethodRef DICT_IMPL_FOR_PROVIDER_MAP = MethodRef.create(DictImpl.class, "forProviderMap", Map.class);
    static final MethodRef RUNTIME_DIVIDED_BY = MethodRef.create(SharedRuntime.class, "dividedBy", SoyValue.class, SoyValue.class);
    static final MethodRef RUNTIME_TIMES = MethodRef.create(SharedRuntime.class, "times", SoyValue.class, SoyValue.class);
    static final MethodRef RUNTIME_MINUS = MethodRef.create(SharedRuntime.class, "minus", SoyValue.class, SoyValue.class);
    static final MethodRef RUNTIME_PLUS = MethodRef.create(SharedRuntime.class, "plus", SoyValue.class, SoyValue.class);
    static final MethodRef RUNTIME_LESS_THAN = MethodRef.create(SharedRuntime.class, "lessThan", SoyValue.class, SoyValue.class);
    static final MethodRef RUNTIME_LESS_THAN_OR_EQUAL = MethodRef.create(SharedRuntime.class, "lessThanOrEqual", SoyValue.class, SoyValue.class);
    static final MethodRef RUNTIME_EQUAL = MethodRef.create(SharedRuntime.class, "equal", SoyValue.class, SoyValue.class);
    static final MethodRef RUNTIME_NEGATIVE = MethodRef.create(SharedRuntime.class, "negative", SoyValue.class);
    static final MethodRef RUNTIME_STRING_EQUALS_AS_NUMBER = MethodRef.create(Runtime.class, "stringEqualsAsNumber", String.class, Double.TYPE);
    static final MethodRef RUNTIME_COERCE_DOUBLE_TO_BOOLEAN = MethodRef.create(Runtime.class, "coerceToBoolean", Double.TYPE);
    static final MethodRef IMMUTABLE_LIST_OF = MethodRef.create(ImmutableList.class, "of", new Class[0]);
    static final MethodRef IMMUTABLE_MAP_OF = MethodRef.create(ImmutableMap.class, "of", new Class[0]);
    static final MethodRef RENDER_RESULT_DONE = MethodRef.create(RenderResult.class, "done", new Class[0]);
    static final MethodRef RUNTIME_CHECK_REQUIRED_PARAM = MethodRef.create(Runtime.class, "checkRequiredParam", SoyRecord.class, String.class);
    static final MethodRef RUNTIME_LOGGER = MethodRef.create(Runtime.class, "logger", new Class[0]);
    static final MethodRef LONG_TO_STRING = MethodRef.create(Long.class, "toString", Long.TYPE);
    static final MethodRef DOUBLE_TO_STRING = MethodRef.create(Double.class, "toString", Double.TYPE);
    static final MethodRef ARRAY_LIST_ADD = MethodRef.create(ArrayList.class, "add", Object.class);
    static final MethodRef EQUALS = MethodRef.create(Object.class, "equals", Object.class);
    static final MethodRef TO_STRING = MethodRef.create(Object.class, "toString", new Class[0]);
    static final MethodRef PRINT_STREAM_PRINTLN = MethodRef.create(PrintStream.class, "println", new Class[0]);
    static final MethodRef LINKED_HASH_MAP_PUT = MethodRef.create(LinkedHashMap.class, "put", Object.class, Object.class);
    static final MethodRef SOY_VALUE_RENDER = MethodRef.create(SoyValue.class, "render", Appendable.class);
    static final MethodRef SOY_VALUE_COERCE_TO_BOOLEAN = MethodRef.create(SoyValue.class, "coerceToBoolean", new Class[0]);
    static final MethodRef SOY_VALUE_LONG_VALUE = MethodRef.create(SoyValue.class, "longValue", new Class[0]);
    static final MethodRef SOY_VALUE_FLOAT_VALUE = MethodRef.create(SoyValue.class, "floatValue", new Class[0]);
    static final MethodRef SOY_VALUE_STRING_VALUE = MethodRef.create(SoyValue.class, "stringValue", new Class[0]);
    static final MethodRef SOY_VALUE_PROVIDER_RESOLVE = MethodRef.create(SoyValueProvider.class, "resolve", new Class[0]);
    static final MethodRef SOY_RECORD_HAS_FIELD = MethodRef.create(SoyRecord.class, "hasField", String.class);
    static final MethodRef SOY_RECORD_GET_FIELD_PROVIDER = MethodRef.create(SoyRecord.class, "getFieldProvider", String.class);
    static final MethodRef INTEGER_DATA_GET_VALUE = MethodRef.create(IntegerData.class, "getValue", new Class[0]);
    static final MethodRef INTEGER_DATA_INTEGER_VALUE = MethodRef.create(IntegerData.class, "integerValue", new Class[0]);
    static final MethodRef STRING_CONCAT = MethodRef.create(String.class, "concat", String.class);
    static final MethodRef STRING_IS_EMPTY = MethodRef.create(String.class, "isEmpty", new Class[0]);
    static final MethodRef ADVISING_APPENDABLE_APPEND = MethodRef.create(AdvisingAppendable.class, "append", CharSequence.class);
    static final MethodRef ADVISING_APPENDABLE_APPEND_CHAR = MethodRef.create(AdvisingAppendable.class, "append", Character.TYPE);
    static final MethodRef RENDER_CONTEXT_RENAME_CSS_SELECTOR = MethodRef.create(RenderContext.class, "renameCssSelector", String.class);
    static final MethodRef RENDER_CONTEXT_RENAME_XID = MethodRef.create(RenderContext.class, "renameXid", String.class);

    MethodRef() {
    }

    private static MethodRef create(Class<?> clazz, String methodName, Class<?> ... params) {
        Method m;
        try {
            m = clazz.getMethod(methodName, params);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        TypeInfo ownerType = TypeInfo.create(clazz);
        boolean isStatic = Modifier.isStatic(m.getModifiers());
        ImmutableList argTypes = isStatic ? ImmutableList.copyOf((Object[])Type.getArgumentTypes((Method)m)) : ImmutableList.builder().add((Object)ownerType.type()).add((Object[])Type.getArgumentTypes((Method)m)).build();
        return new AutoValue_MethodRef(clazz.isInterface() ? 185 : (isStatic ? 184 : 182), ownerType, methodName, Type.getMethodDescriptor((Method)m), m.getReturnType(), (ImmutableList<Type>)argTypes);
    }

    abstract int opcode();

    abstract TypeInfo owner();

    abstract String methodName();

    abstract String methodDescriptor();

    abstract Class<?> returnType();

    abstract ImmutableList<Type> argTypes();

    Statement invokeVoid(final Expression ... args) {
        Preconditions.checkState((boolean)Void.TYPE.equals(this.returnType()), (Object)"Method return type is not void.");
        Expression.checkTypes(this.argTypes(), args);
        return new Statement(){

            @Override
            void doGen(GeneratorAdapter adapter) {
                MethodRef.this.doInvoke(adapter, args);
            }
        };
    }

    Expression invoke(final Expression ... args) {
        Preconditions.checkState((!Void.TYPE.equals(this.returnType()) ? 1 : 0) != 0, (Object)"Cannot produce an expression from a void method.");
        Expression.checkTypes(this.argTypes(), args);
        boolean isConstant = Expression.areAllConstant(Arrays.asList(args));
        return new Expression.SimpleExpression(Type.getType(this.returnType()), isConstant){

            @Override
            void doGen(GeneratorAdapter mv) {
                MethodRef.this.doInvoke(mv, args);
            }
        };
    }

    private void doInvoke(GeneratorAdapter mv, Expression ... args) {
        for (Expression arg : args) {
            arg.gen(mv);
        }
        mv.visitMethodInsn(this.opcode(), this.owner().internalName(), this.methodName(), this.methodDescriptor(), this.opcode() == 185);
    }
}

