/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.jbcsrc;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.template.soy.jbcsrc.AutoValue_LocalVariable;
import com.google.template.soy.jbcsrc.Expression;
import com.google.template.soy.jbcsrc.Statement;
import com.google.template.soy.jbcsrc.TypeInfo;
import org.objectweb.asm.Label;
import org.objectweb.asm.Type;
import org.objectweb.asm.commons.GeneratorAdapter;

abstract class LocalVariable
extends Expression {
    LocalVariable() {
    }

    static LocalVariable createThisVar(TypeInfo owner, Label start, Label end) {
        return new AutoValue_LocalVariable("this", owner.type(), 0, start, end);
    }

    static LocalVariable createLocal(String name, int index, Type type, Label start, Label end) {
        Preconditions.checkArgument((!name.equals("this") ? 1 : 0) != 0);
        return new AutoValue_LocalVariable(name, type, index, start, end);
    }

    abstract String variableName();

    @Override
    abstract Type resultType();

    abstract int index();

    abstract Label start();

    abstract Label end();

    void tableEntry(GeneratorAdapter mv) {
        mv.visitLocalVariable(this.variableName(), this.resultType().getDescriptor(), null, this.start(), this.end(), this.index());
    }

    @Override
    public void doGen(GeneratorAdapter mv) {
        mv.visitVarInsn(this.resultType().getOpcode(21), this.index());
    }

    Statement store(Expression expr) {
        return this.store(expr, (Optional<Label>)Optional.absent());
    }

    Statement store(Expression expr, Label firstVarInstruction) {
        return this.store(expr, (Optional<Label>)Optional.of((Object)firstVarInstruction));
    }

    private Statement store(final Expression expr, final Optional<Label> firstVarInstruction) {
        expr.checkType(this.resultType());
        return new Statement(){

            @Override
            void doGen(GeneratorAdapter adapter) {
                expr.gen(adapter);
                if (firstVarInstruction.isPresent()) {
                    adapter.mark((Label)firstVarInstruction.get());
                }
                adapter.visitVarInsn(LocalVariable.this.resultType().getOpcode(54), LocalVariable.this.index());
            }
        };
    }
}

