/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.jbcsrc;

import com.google.common.base.Preconditions;
import com.google.template.soy.exprtree.AbstractReturningExprNodeVisitor;
import com.google.template.soy.exprtree.BooleanNode;
import com.google.template.soy.exprtree.ExprNode;
import com.google.template.soy.exprtree.ExprRootNode;
import com.google.template.soy.exprtree.FieldAccessNode;
import com.google.template.soy.exprtree.FloatNode;
import com.google.template.soy.exprtree.FunctionNode;
import com.google.template.soy.exprtree.IntegerNode;
import com.google.template.soy.exprtree.ItemAccessNode;
import com.google.template.soy.exprtree.ListLiteralNode;
import com.google.template.soy.exprtree.MapLiteralNode;
import com.google.template.soy.exprtree.NullNode;
import com.google.template.soy.exprtree.OperatorNodes;
import com.google.template.soy.exprtree.StringNode;
import com.google.template.soy.exprtree.VarRefNode;
import com.google.template.soy.jbcsrc.BytecodeUtils;
import com.google.template.soy.jbcsrc.ConstructorRef;
import com.google.template.soy.jbcsrc.Expression;
import com.google.template.soy.jbcsrc.MethodRef;
import com.google.template.soy.jbcsrc.SoyExpression;
import com.google.template.soy.jbcsrc.Statement;
import com.google.template.soy.types.SoyType;
import com.google.template.soy.types.aggregate.ListType;
import com.google.template.soy.types.aggregate.MapType;
import com.google.template.soy.types.aggregate.RecordType;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.objectweb.asm.Label;
import org.objectweb.asm.Type;
import org.objectweb.asm.commons.GeneratorAdapter;

abstract class ExpressionCompiler
extends AbstractReturningExprNodeVisitor<SoyExpression> {
    ExpressionCompiler() {
    }

    SoyExpression compile(ExprNode node) {
        return (SoyExpression)this.visit((ExprNode)Preconditions.checkNotNull((Object)node));
    }

    @Override
    protected final SoyExpression visitExprRootNode(ExprRootNode<?> node) {
        return (SoyExpression)this.visit((ExprNode)node.getChild(0));
    }

    @Override
    protected final SoyExpression visitNullNode(NullNode node) {
        return SoyExpression.NULL;
    }

    @Override
    protected final SoyExpression visitFloatNode(FloatNode node) {
        return SoyExpression.forFloat(BytecodeUtils.constant(node.getValue()));
    }

    @Override
    protected final SoyExpression visitStringNode(StringNode node) {
        return SoyExpression.forString(BytecodeUtils.constant(node.getValue()));
    }

    @Override
    protected final SoyExpression visitBooleanNode(BooleanNode node) {
        return node.getValue() ? SoyExpression.TRUE : SoyExpression.FALSE;
    }

    @Override
    protected final SoyExpression visitIntegerNode(IntegerNode node) {
        return SoyExpression.forInt(BytecodeUtils.constant((long)node.getValue()));
    }

    @Override
    protected final SoyExpression visitListLiteralNode(ListLiteralNode node) {
        int numChildren = node.getChildren().size();
        ListType listType = (ListType)node.getType();
        if (numChildren == 0) {
            return SoyExpression.forList(listType, MethodRef.IMMUTABLE_LIST_OF.invoke(new Expression[0]).asConstant());
        }
        ArrayList<Statement> adds = new ArrayList<Statement>(numChildren);
        Expression dupExpr = BytecodeUtils.dupExpr(Type.getType(ArrayList.class));
        boolean isConstant = true;
        for (ExprNode child : node.getChildren()) {
            SoyExpression childExpr = ((SoyExpression)this.visit(child)).box();
            isConstant = isConstant && childExpr.isConstant();
            adds.add(MethodRef.ARRAY_LIST_ADD.invoke(dupExpr, childExpr).toStatement());
        }
        final Expression construct = ConstructorRef.ARRAY_LIST_SIZE.construct(BytecodeUtils.constant(numChildren));
        final Statement addAll = Statement.concat(adds);
        return SoyExpression.forList(listType, new Expression.SimpleExpression(Type.getType(List.class), isConstant){

            @Override
            void doGen(GeneratorAdapter mv) {
                construct.gen(mv);
                addAll.gen(mv);
            }
        });
    }

    @Override
    protected final SoyExpression visitMapLiteralNode(MapLiteralNode node) {
        int numItems = node.numChildren() / 2;
        if (numItems == 0) {
            MapType mapType = (MapType)node.getType();
            return SoyExpression.forMap(mapType, MethodRef.IMMUTABLE_MAP_OF.invoke(new Expression[0]).asConstant());
        }
        boolean isRecord = node.getType().getKind() == SoyType.Kind.RECORD;
        int hashMapCapacity = this.hashMapCapacity(numItems);
        Expression dupExpr = BytecodeUtils.dupExpr(Type.getType(LinkedHashMap.class));
        ArrayList<Statement> puts = new ArrayList<Statement>(numItems);
        boolean isConstant = true;
        for (int i = 0; i < numItems; ++i) {
            SoyExpression key = (SoyExpression)this.visit(node.getChild(2 * i));
            key = isRecord ? key.convert(String.class) : key.box();
            SoyExpression value = ((SoyExpression)this.visit(node.getChild(2 * i + 1))).box();
            isConstant = isConstant && key.isConstant() && value.isConstant();
            puts.add(MethodRef.LINKED_HASH_MAP_PUT.invoke(dupExpr, key, value).toStatement());
        }
        final Expression construct = ConstructorRef.LINKED_HASH_MAP_SIZE.construct(BytecodeUtils.constant(hashMapCapacity));
        final Statement putAll = Statement.concat(puts);
        Expression.SimpleExpression mapExpr = new Expression.SimpleExpression(Type.getType(Map.class), isConstant){

            @Override
            void doGen(GeneratorAdapter mv) {
                construct.gen(mv);
                putAll.gen(mv);
            }
        };
        if (isRecord) {
            return SoyExpression.forRecord((RecordType)node.getType(), mapExpr);
        }
        return SoyExpression.forMap((MapType)node.getType(), mapExpr);
    }

    @Override
    protected final SoyExpression visitEqualOpNode(OperatorNodes.EqualOpNode node) {
        return SoyExpression.forBool(BytecodeUtils.compareSoyEquals((SoyExpression)this.visit(node.getChild(0)), (SoyExpression)this.visit(node.getChild(1))));
    }

    @Override
    protected final SoyExpression visitNotEqualOpNode(OperatorNodes.NotEqualOpNode node) {
        return SoyExpression.forBool(BytecodeUtils.logicalNot(BytecodeUtils.compareSoyEquals((SoyExpression)this.visit(node.getChild(0)), (SoyExpression)this.visit(node.getChild(1)))));
    }

    @Override
    protected final SoyExpression visitLessThanOpNode(OperatorNodes.LessThanOpNode node) {
        SoyExpression left = (SoyExpression)this.visit(node.getChild(0));
        SoyExpression right = (SoyExpression)this.visit(node.getChild(1));
        if (left.isKnownInt() && right.isKnownInt()) {
            return SoyExpression.forBool(BytecodeUtils.compare(155, left.convert(Long.TYPE), right.convert(Long.TYPE)));
        }
        if (left.isKnownNumber() && right.isKnownNumber()) {
            return SoyExpression.forBool(BytecodeUtils.compare(155, left.convert(Double.TYPE), right.convert(Double.TYPE)));
        }
        return SoyExpression.forBool(MethodRef.RUNTIME_LESS_THAN.invoke(left.box(), right.box()));
    }

    @Override
    protected final SoyExpression visitGreaterThanOpNode(OperatorNodes.GreaterThanOpNode node) {
        SoyExpression left = (SoyExpression)this.visit(node.getChild(0));
        SoyExpression right = (SoyExpression)this.visit(node.getChild(1));
        if (left.isKnownInt() && right.isKnownInt()) {
            return SoyExpression.forBool(BytecodeUtils.compare(157, left.convert(Long.TYPE), right.convert(Long.TYPE)));
        }
        if (left.isKnownNumber() && right.isKnownNumber()) {
            return SoyExpression.forBool(BytecodeUtils.compare(157, left.convert(Double.TYPE), right.convert(Double.TYPE)));
        }
        return SoyExpression.forBool(MethodRef.RUNTIME_LESS_THAN.invoke(right.box(), left.box()));
    }

    @Override
    protected final SoyExpression visitLessThanOrEqualOpNode(OperatorNodes.LessThanOrEqualOpNode node) {
        SoyExpression left = (SoyExpression)this.visit(node.getChild(0));
        SoyExpression right = (SoyExpression)this.visit(node.getChild(1));
        if (left.isKnownInt() && right.isKnownInt()) {
            return SoyExpression.forBool(BytecodeUtils.compare(158, left.convert(Long.TYPE), right.convert(Long.TYPE)));
        }
        if (left.isKnownNumber() && right.isKnownNumber()) {
            return SoyExpression.forBool(BytecodeUtils.compare(158, left.convert(Double.TYPE), right.convert(Double.TYPE)));
        }
        return SoyExpression.forBool(MethodRef.RUNTIME_LESS_THAN_OR_EQUAL.invoke(left.box(), right.box()));
    }

    @Override
    protected final SoyExpression visitGreaterThanOrEqualOpNode(OperatorNodes.GreaterThanOrEqualOpNode node) {
        SoyExpression left = (SoyExpression)this.visit(node.getChild(0));
        SoyExpression right = (SoyExpression)this.visit(node.getChild(1));
        if (left.isKnownInt() && right.isKnownInt()) {
            return SoyExpression.forBool(BytecodeUtils.compare(156, left.convert(Long.TYPE), right.convert(Long.TYPE)));
        }
        if (left.isKnownNumber() && right.isKnownNumber()) {
            return SoyExpression.forBool(BytecodeUtils.compare(156, left.convert(Double.TYPE), right.convert(Double.TYPE)));
        }
        return SoyExpression.forBool(MethodRef.RUNTIME_LESS_THAN_OR_EQUAL.invoke(right.box(), left.box()));
    }

    @Override
    protected final SoyExpression visitPlusOpNode(OperatorNodes.PlusOpNode node) {
        SoyExpression left = (SoyExpression)this.visit(node.getChild(0));
        SoyExpression right = (SoyExpression)this.visit(node.getChild(1));
        if (left.isKnownInt() && right.isKnownInt()) {
            return this.applyBinaryIntOperator(97, left, right);
        }
        if (left.isKnownNumber() && right.isKnownNumber()) {
            return this.applyBinaryFloatOperator(99, left, right);
        }
        if (left.isKnownString() || right.isKnownString()) {
            SoyExpression leftString = left.convert(String.class);
            SoyExpression rightString = right.convert(String.class);
            return SoyExpression.forString(MethodRef.STRING_CONCAT.invoke(leftString, rightString));
        }
        return SoyExpression.forSoyValue(node.getType(), MethodRef.RUNTIME_PLUS.invoke(left.box(), right.box()));
    }

    @Override
    protected final SoyExpression visitMinusOpNode(OperatorNodes.MinusOpNode node) {
        SoyExpression left = (SoyExpression)this.visit(node.getChild(0));
        SoyExpression right = (SoyExpression)this.visit(node.getChild(1));
        if (left.isKnownInt() && right.isKnownInt()) {
            return this.applyBinaryIntOperator(101, left, right);
        }
        if (left.isKnownNumber() && right.isKnownNumber()) {
            return this.applyBinaryFloatOperator(103, left, right);
        }
        return SoyExpression.forSoyValue(node.getType(), MethodRef.RUNTIME_MINUS.invoke(left.box(), right.box()));
    }

    @Override
    protected final SoyExpression visitTimesOpNode(OperatorNodes.TimesOpNode node) {
        SoyExpression left = (SoyExpression)this.visit(node.getChild(0));
        SoyExpression right = (SoyExpression)this.visit(node.getChild(1));
        if (left.isKnownInt() && right.isKnownInt()) {
            return this.applyBinaryIntOperator(105, left, right);
        }
        if (left.isKnownNumber() && right.isKnownNumber()) {
            return this.applyBinaryFloatOperator(107, left, right);
        }
        return SoyExpression.forSoyValue(node.getType(), MethodRef.RUNTIME_TIMES.invoke(left.box(), right.box()));
    }

    @Override
    protected final SoyExpression visitDivideByOpNode(OperatorNodes.DivideByOpNode node) {
        return this.applyBinaryFloatOperator(111, (SoyExpression)this.visit(node.getChild(0)), (SoyExpression)this.visit(node.getChild(1)));
    }

    @Override
    protected final SoyExpression visitModOpNode(OperatorNodes.ModOpNode node) {
        return this.applyBinaryIntOperator(113, (SoyExpression)this.visit(node.getChild(0)), (SoyExpression)this.visit(node.getChild(1)));
    }

    private SoyExpression applyBinaryIntOperator(final int operator, SoyExpression left, SoyExpression right) {
        final SoyExpression leftInt = left.convert(Long.TYPE);
        final SoyExpression rightInt = right.convert(Long.TYPE);
        return SoyExpression.forInt(new Expression.SimpleExpression(Type.LONG_TYPE, leftInt.isConstant() && rightInt.isConstant()){

            @Override
            void doGen(GeneratorAdapter mv) {
                leftInt.gen(mv);
                rightInt.gen(mv);
                mv.visitInsn(operator);
            }
        });
    }

    private SoyExpression applyBinaryFloatOperator(final int operator, SoyExpression left, SoyExpression right) {
        final SoyExpression leftFloat = left.convert(Double.TYPE);
        final SoyExpression rightFloat = right.convert(Double.TYPE);
        return SoyExpression.forFloat(new Expression.SimpleExpression(Type.DOUBLE_TYPE, leftFloat.isConstant() && rightFloat.isConstant()){

            @Override
            void doGen(GeneratorAdapter mv) {
                leftFloat.gen(mv);
                rightFloat.gen(mv);
                mv.visitInsn(operator);
            }
        });
    }

    @Override
    protected final SoyExpression visitNegativeOpNode(OperatorNodes.NegativeOpNode node) {
        SoyExpression child = (SoyExpression)this.visit(node.getChild(0));
        if (child.isKnownInt()) {
            final SoyExpression intExpr = child.convert(Long.TYPE);
            return SoyExpression.forInt(new Expression.SimpleExpression(Type.LONG_TYPE, child.isConstant()){

                @Override
                void doGen(GeneratorAdapter mv) {
                    intExpr.gen(mv);
                    mv.visitInsn(117);
                }
            });
        }
        if (child.isKnownNumber()) {
            final SoyExpression floatExpr = child.convert(Double.TYPE);
            return SoyExpression.forFloat(new Expression.SimpleExpression(Type.DOUBLE_TYPE, child.isConstant()){

                @Override
                void doGen(GeneratorAdapter mv) {
                    floatExpr.gen(mv);
                    mv.visitInsn(119);
                }
            });
        }
        return SoyExpression.forSoyValue(node.getType(), MethodRef.RUNTIME_NEGATIVE.invoke(child.box()));
    }

    @Override
    protected final SoyExpression visitNotOpNode(OperatorNodes.NotOpNode node) {
        return SoyExpression.forBool(BytecodeUtils.logicalNot(((SoyExpression)this.visit(node.getChild(0))).convert(Boolean.TYPE)));
    }

    @Override
    protected final SoyExpression visitAndOpNode(OperatorNodes.AndOpNode node) {
        SoyExpression left = ((SoyExpression)this.visit(node.getChild(0))).convert(Boolean.TYPE);
        SoyExpression right = ((SoyExpression)this.visit(node.getChild(1))).convert(Boolean.TYPE);
        return SoyExpression.forBool(BytecodeUtils.logicalAnd(left, right));
    }

    @Override
    protected final SoyExpression visitOrOpNode(OperatorNodes.OrOpNode node) {
        SoyExpression left = ((SoyExpression)this.visit(node.getChild(0))).convert(Boolean.TYPE);
        SoyExpression right = ((SoyExpression)this.visit(node.getChild(1))).convert(Boolean.TYPE);
        return SoyExpression.forBool(BytecodeUtils.logicalOr(left, right));
    }

    @Override
    protected final SoyExpression visitConditionalOpNode(OperatorNodes.ConditionalOpNode node) {
        boolean constant;
        final SoyExpression condition = ((SoyExpression)this.visit(node.getChild(0))).convert(Boolean.TYPE);
        SoyExpression trueBranch = (SoyExpression)this.visit(node.getChild(1));
        SoyExpression falseBranch = (SoyExpression)this.visit(node.getChild(2));
        boolean bl = constant = condition.isConstant() && trueBranch.isConstant() && falseBranch.isConstant();
        if (trueBranch.isKnownInt() && falseBranch.isKnownInt()) {
            final SoyExpression trueAsLong = trueBranch.convert(Long.TYPE);
            final SoyExpression falseAsLong = falseBranch.convert(Long.TYPE);
            return SoyExpression.forInt(new Expression.SimpleExpression(Type.LONG_TYPE, constant){

                @Override
                void doGen(GeneratorAdapter adapter) {
                    ExpressionCompiler.doCondition(adapter, condition, trueAsLong, falseAsLong);
                }
            });
        }
        if (trueBranch.isKnownNumber() && falseBranch.isKnownNumber()) {
            final SoyExpression trueAsFloat = trueBranch.convert(Double.TYPE);
            final SoyExpression falseAsFloat = falseBranch.convert(Double.TYPE);
            return SoyExpression.forFloat(new Expression.SimpleExpression(Type.DOUBLE_TYPE, constant){

                @Override
                void doGen(GeneratorAdapter adapter) {
                    ExpressionCompiler.doCondition(adapter, condition, trueAsFloat, falseAsFloat);
                }
            });
        }
        if (trueBranch.isKnownString() && falseBranch.isKnownString()) {
            final SoyExpression trueAsString = trueBranch.convert(String.class);
            final SoyExpression falseAsString = falseBranch.convert(String.class);
            return SoyExpression.forString(new Expression.SimpleExpression(Type.getType(String.class), constant){

                @Override
                void doGen(GeneratorAdapter adapter) {
                    ExpressionCompiler.doCondition(adapter, condition, trueAsString, falseAsString);
                }
            });
        }
        final SoyExpression trueBoxed = trueBranch.box();
        final SoyExpression falseBoxed = falseBranch.box();
        Type type = Type.getType(node.getType().javaType());
        return SoyExpression.forSoyValue(node.getType(), new Expression.SimpleExpression(type, constant){

            @Override
            void doGen(GeneratorAdapter mv) {
                ExpressionCompiler.doCondition(mv, condition, trueBoxed, falseBoxed);
            }
        });
    }

    private static void doCondition(GeneratorAdapter mv, Expression condition, SoyExpression trueBranch, SoyExpression falseBranch) {
        condition.gen(mv);
        Label ifFalse = new Label();
        Label end = new Label();
        mv.visitJumpInsn(153, ifFalse);
        trueBranch.gen(mv);
        mv.visitJumpInsn(167, end);
        mv.visitLabel(ifFalse);
        falseBranch.gen(mv);
        mv.visitLabel(end);
    }

    @Override
    protected abstract SoyExpression visitVarRefNode(VarRefNode var1);

    @Override
    protected abstract SoyExpression visitFieldAccessNode(FieldAccessNode var1);

    @Override
    protected abstract SoyExpression visitItemAccessNode(ItemAccessNode var1);

    @Override
    protected abstract SoyExpression visitFunctionNode(FunctionNode var1);

    @Override
    protected final SoyExpression visitExprNode(ExprNode node) {
        throw new UnsupportedOperationException("Support for " + (Object)((Object)node.getKind()) + " has node been added yet");
    }

    private int hashMapCapacity(int expectedSize) {
        if (expectedSize < 3) {
            return expectedSize + 1;
        }
        if (expectedSize < 0x40000000) {
            return (int)((float)expectedSize / 0.75f + 1.0f);
        }
        return Integer.MAX_VALUE;
    }
}

