/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.jbcsrc;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.template.soy.jbcsrc.BytecodeProducer;
import com.google.template.soy.jbcsrc.Statement;
import org.objectweb.asm.Type;
import org.objectweb.asm.commons.GeneratorAdapter;

abstract class Expression
extends BytecodeProducer {
    Expression() {
    }

    static boolean areAllConstant(Iterable<? extends Expression> args) {
        for (Expression expression : args) {
            if (expression.isConstant()) continue;
            return false;
        }
        return true;
    }

    static void checkTypes(ImmutableList<Type> types, Expression ... exprs) {
        Preconditions.checkArgument((exprs.length == types.size() ? 1 : 0) != 0, (String)"Supplied the wrong number of parameters. Expected %s, got %s", (Object[])new Object[]{types.size(), exprs.length});
        for (int i = 0; i < exprs.length; ++i) {
            exprs[i].checkType((Type)types.get(i), "Parameter %s", i);
        }
    }

    @Override
    abstract void doGen(GeneratorAdapter var1);

    abstract Type resultType();

    boolean isConstant() {
        return false;
    }

    final void checkType(Type expected) {
        this.checkType(expected, "", new Object[0]);
    }

    final void checkType(Type expected, String fmt, Object ... args) {
        if (this.resultType().equals((Object)expected)) {
            return;
        }
        if (expected.getSort() == this.resultType().getSort() && expected.getSort() == 10) {
            return;
        }
        String message = String.format("Type mismatch. Expected %s, got %s.", expected, this.resultType());
        if (!fmt.isEmpty()) {
            message = String.format(fmt, args) + ". " + message;
        }
        throw new IllegalArgumentException(message);
    }

    Statement toStatement() {
        return new Statement(){

            @Override
            void doGen(GeneratorAdapter adapter) {
                Expression.this.gen(adapter);
                switch (Expression.this.resultType().getSize()) {
                    case 0: {
                        throw new AssertionError((Object)"void expressions are not allowed");
                    }
                    case 1: {
                        adapter.pop();
                        break;
                    }
                    case 2: {
                        adapter.pop2();
                    }
                }
            }
        };
    }

    Expression asConstant() {
        if (this.isConstant()) {
            return this;
        }
        return new ConstantExpression(this);
    }

    public String toString() {
        return this.name() + "<" + this.resultType() + ">:\n" + this.trace();
    }

    String name() {
        if (this.isConstant()) {
            return "ConstantExpression";
        }
        String simpleName = this.getClass().getSimpleName();
        return simpleName.isEmpty() ? "Expression" : simpleName;
    }

    private static final class ConstantExpression
    extends Expression {
        private final Expression delegate;

        ConstantExpression(Expression expression) {
            this.delegate = expression;
        }

        @Override
        void doGen(GeneratorAdapter adapter) {
            this.delegate.gen(adapter);
        }

        @Override
        Type resultType() {
            return this.delegate.resultType();
        }

        @Override
        boolean isConstant() {
            return true;
        }
    }

    static abstract class SimpleExpression
    extends Expression {
        private final Type resultType;
        private final boolean isConstant;

        SimpleExpression(Type resultType, boolean isConstant) {
            this.resultType = (Type)Preconditions.checkNotNull((Object)resultType);
            this.isConstant = isConstant;
        }

        @Override
        final boolean isConstant() {
            return this.isConstant;
        }

        @Override
        final Type resultType() {
            return this.resultType;
        }
    }
}

