/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.jbcsrc;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.primitives.Primitives;
import com.google.template.soy.jbcsrc.Expression;
import com.google.template.soy.jbcsrc.LocalVariable;
import com.google.template.soy.jbcsrc.MethodRef;
import com.google.template.soy.jbcsrc.SoyExpression;
import com.google.template.soy.jbcsrc.TypeInfo;
import java.lang.reflect.Array;
import java.util.List;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;
import org.objectweb.asm.commons.GeneratorAdapter;
import org.objectweb.asm.commons.Method;
import org.objectweb.asm.util.Printer;

final class BytecodeUtils {
    static final Method NULLARY_INIT = Method.getMethod((String)"void <init>()");
    static final Method CLASS_INIT = Method.getMethod((String)"void <clinit>()");
    private static final ImmutableMap<String, Class<?>> PRIMITIVES_MAP;

    private BytecodeUtils() {
    }

    static Class<?> classFromAsmType(Type type) {
        switch (type.getSort()) {
            case 9: {
                Class<?> elementType = BytecodeUtils.classFromAsmType(type.getElementType());
                Object array = Array.newInstance(elementType, 0);
                return array.getClass();
            }
            case 10: {
                try {
                    return Class.forName(type.getClassName(), false, BytecodeUtils.class.getClassLoader());
                }
                catch (ClassNotFoundException e) {
                    throw new IllegalArgumentException("Could not load " + type, e);
                }
            }
            case 11: {
                throw new IllegalArgumentException("Method types are not supported: " + type);
            }
        }
        return (Class)PRIMITIVES_MAP.get((Object)type.getClassName());
    }

    static Expression constant(final boolean value) {
        return new Expression.SimpleExpression(Type.BOOLEAN_TYPE, true){

            @Override
            void doGen(GeneratorAdapter mv) {
                mv.push(value);
            }
        };
    }

    static Expression constant(final int value) {
        return new Expression.SimpleExpression(Type.INT_TYPE, true){

            @Override
            void doGen(GeneratorAdapter mv) {
                mv.push(value);
            }
        };
    }

    static Expression constant(final char value) {
        return new Expression.SimpleExpression(Type.CHAR_TYPE, true){

            @Override
            void doGen(GeneratorAdapter mv) {
                mv.push((int)value);
            }
        };
    }

    static Expression constant(final long value) {
        return new Expression.SimpleExpression(Type.LONG_TYPE, true){

            @Override
            void doGen(GeneratorAdapter mv) {
                mv.push(value);
            }
        };
    }

    static Expression constant(final double value) {
        return new Expression.SimpleExpression(Type.DOUBLE_TYPE, true){

            @Override
            void doGen(GeneratorAdapter mv) {
                mv.push(value);
            }
        };
    }

    static Expression constant(final String value) {
        Preconditions.checkNotNull((Object)value);
        return new Expression.SimpleExpression(Type.getType(String.class), true){

            @Override
            void doGen(GeneratorAdapter mv) {
                mv.push(value);
            }
        };
    }

    static Expression numericConversion(final Expression expr, final Type to) {
        if (to.equals((Object)expr.resultType())) {
            return expr;
        }
        if (!BytecodeUtils.isNumericPrimitive(to) || !BytecodeUtils.isNumericPrimitive(expr.resultType())) {
            throw new IllegalArgumentException("Cannot convert from " + expr.resultType() + " to " + to);
        }
        return new Expression.SimpleExpression(to, expr.isConstant()){

            @Override
            void doGen(GeneratorAdapter adapter) {
                expr.gen(adapter);
                adapter.cast(expr.resultType(), to);
            }
        };
    }

    private static boolean isNumericPrimitive(Type type) {
        int sort = type.getSort();
        switch (sort) {
            case 0: 
            case 1: 
            case 9: 
            case 10: 
            case 11: {
                return false;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                return true;
            }
        }
        throw new AssertionError((Object)("unexpected type " + type));
    }

    static Expression dupExpr(Type type) {
        switch (type.getSize()) {
            case 1: {
                return new Expression.SimpleExpression(type, false){

                    @Override
                    void doGen(GeneratorAdapter mv) {
                        mv.dup();
                    }
                };
            }
            case 2: {
                return new Expression.SimpleExpression(type, false){

                    @Override
                    void doGen(GeneratorAdapter mv) {
                        mv.dup2();
                    }
                };
            }
        }
        throw new AssertionError((Object)("cannot dup() " + type));
    }

    static void loadDefault(MethodVisitor mv, Type type) {
        switch (type.getSort()) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                mv.visitInsn(3);
                break;
            }
            case 6: {
                mv.visitInsn(11);
                break;
            }
            case 7: {
                mv.visitInsn(9);
                break;
            }
            case 8: {
                mv.visitInsn(14);
                break;
            }
            case 9: 
            case 10: {
                mv.visitInsn(1);
                break;
            }
            default: {
                throw new AssertionError((Object)("unexpected sort for type: " + type));
            }
        }
    }

    static void defineDefaultConstructor(ClassVisitor cv, TypeInfo ownerType) {
        GeneratorAdapter mg = new GeneratorAdapter(1, NULLARY_INIT, null, null, cv);
        Label start = mg.mark();
        Label end = mg.newLabel();
        LocalVariable thisVar = LocalVariable.createThisVar(ownerType, start, end);
        thisVar.gen(mg);
        mg.invokeConstructor(Type.getType(Object.class), NULLARY_INIT);
        mg.returnValue();
        mg.mark(end);
        thisVar.tableEntry(mg);
        mg.endMethod();
    }

    static Expression compare(final int comparisonOpcode, final Expression left, final Expression right) {
        Preconditions.checkArgument((boolean)left.resultType().equals((Object)right.resultType()), (String)"left and right must have matching types, found %s and %s", (Object[])new Object[]{left.resultType(), right.resultType()});
        BytecodeUtils.checkIntComparisonOpcode(left.resultType(), comparisonOpcode);
        return new Expression.SimpleExpression(Type.BOOLEAN_TYPE, left.isConstant() && right.isConstant()){

            @Override
            void doGen(GeneratorAdapter mv) {
                left.gen(mv);
                right.gen(mv);
                Label ifTrue = mv.newLabel();
                Label end = mv.newLabel();
                mv.ifCmp(left.resultType(), comparisonOpcode, ifTrue);
                mv.push(false);
                mv.goTo(end);
                mv.mark(ifTrue);
                mv.push(true);
                mv.mark(end);
            }
        };
    }

    private static void checkIntComparisonOpcode(Type comparisonType, int opcode) {
        switch (opcode) {
            case 153: 
            case 154: {
                return;
            }
            case 155: 
            case 156: 
            case 157: 
            case 158: {
                if (comparisonType.getSort() == 9 || comparisonType.getSort() == 10) {
                    throw new IllegalArgumentException("Type: " + comparisonType + " cannot be compared via " + Printer.OPCODES[opcode]);
                }
                return;
            }
        }
        throw new IllegalArgumentException("Unsupported opcode for comparison operation: " + opcode);
    }

    static Expression logicalNot(final Expression baseExpr) {
        baseExpr.checkType(Type.BOOLEAN_TYPE);
        Preconditions.checkArgument((boolean)baseExpr.resultType().equals((Object)Type.BOOLEAN_TYPE), (Object)"not a boolean expression");
        return new Expression.SimpleExpression(Type.BOOLEAN_TYPE, baseExpr.isConstant()){

            @Override
            void doGen(GeneratorAdapter mv) {
                baseExpr.gen(mv);
                Label ifTrue = mv.newLabel();
                Label end = mv.newLabel();
                mv.ifZCmp(154, ifTrue);
                mv.push(true);
                mv.goTo(end);
                mv.mark(ifTrue);
                mv.push(false);
                mv.mark(end);
            }
        };
    }

    static Expression compareSoyEquals(SoyExpression left, SoyExpression right) {
        if (left.isKnownString()) {
            return BytecodeUtils.doEqualsString(left.convert(String.class), right);
        }
        if (right.isKnownString()) {
            return BytecodeUtils.doEqualsString(right.convert(String.class), left);
        }
        if (left.isKnownInt() && right.isKnownInt()) {
            return BytecodeUtils.compare(153, left.convert(Long.TYPE), right.convert(Long.TYPE));
        }
        if (left.isKnownNumber() && right.isKnownNumber()) {
            return BytecodeUtils.compare(153, left.convert(Double.TYPE), right.convert(Double.TYPE));
        }
        return MethodRef.RUNTIME_EQUAL.invoke(left.box(), right.box());
    }

    private static Expression doEqualsString(SoyExpression stringExpr, SoyExpression other) {
        if (other.isKnownString()) {
            SoyExpression strOther = other.convert(String.class);
            return MethodRef.EQUALS.invoke(stringExpr, strOther);
        }
        if (other.isKnownNumber()) {
            return MethodRef.RUNTIME_STRING_EQUALS_AS_NUMBER.invoke(stringExpr, other.convert(Double.TYPE));
        }
        return MethodRef.RUNTIME_EQUAL.invoke(stringExpr.box(), other.box());
    }

    static Expression logicalOr(Expression ... expressions) {
        return BytecodeUtils.logicalOr((List<? extends Expression>)ImmutableList.copyOf((Object[])expressions));
    }

    static Expression logicalOr(List<? extends Expression> expressions) {
        return BytecodeUtils.doShortCircuitingLogicalOperator((ImmutableList<? extends Expression>)ImmutableList.copyOf(expressions), true);
    }

    static Expression logicalAnd(Expression ... expressions) {
        return BytecodeUtils.logicalAnd((List<? extends Expression>)ImmutableList.copyOf((Object[])expressions));
    }

    static Expression logicalAnd(List<? extends Expression> expressions) {
        return BytecodeUtils.doShortCircuitingLogicalOperator((ImmutableList<? extends Expression>)ImmutableList.copyOf(expressions), false);
    }

    private static Expression doShortCircuitingLogicalOperator(final ImmutableList<? extends Expression> expressions, final boolean isOrOperator) {
        Preconditions.checkArgument((!expressions.isEmpty() ? 1 : 0) != 0);
        for (Expression expr : expressions) {
            expr.checkType(Type.BOOLEAN_TYPE);
        }
        if (expressions.size() == 1) {
            return (Expression)expressions.get(0);
        }
        return new Expression.SimpleExpression(Type.BOOLEAN_TYPE, Expression.areAllConstant(expressions)){

            @Override
            void doGen(GeneratorAdapter adapter) {
                Label end = new Label();
                Label shortCircuit = new Label();
                for (int i = 0; i < expressions.size(); ++i) {
                    Expression expr = (Expression)expressions.get(i);
                    expr.gen(adapter);
                    if (i == expressions.size() - 1) {
                        adapter.goTo(end);
                        continue;
                    }
                    adapter.ifZCmp(isOrOperator ? 154 : 153, shortCircuit);
                }
                adapter.mark(shortCircuit);
                adapter.push(isOrOperator);
                adapter.mark(end);
            }
        };
    }

    static {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (Class cl : Primitives.allPrimitiveTypes()) {
            builder.put((Object)cl.getName(), (Object)cl);
        }
        PRIMITIVES_MAP = builder.build();
    }
}

