/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.jbcsrc;

import com.google.common.base.Optional;
import com.google.template.soy.base.SourceLocation;
import java.io.PrintWriter;
import java.io.StringWriter;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.commons.GeneratorAdapter;
import org.objectweb.asm.util.Printer;
import org.objectweb.asm.util.Textifier;
import org.objectweb.asm.util.TraceMethodVisitor;

abstract class BytecodeProducer {
    private static final ThreadLocal<Boolean> isGenerating = new ThreadLocal<Boolean>(){

        @Override
        protected Boolean initialValue() {
            return false;
        }
    };
    private final Optional<SourceLocation> location;

    BytecodeProducer() {
        this((Optional<SourceLocation>)Optional.absent());
    }

    BytecodeProducer(SourceLocation location) {
        this((Optional<SourceLocation>)(location.isKnown() ? Optional.of((Object)location) : Optional.absent()));
    }

    private BytecodeProducer(Optional<SourceLocation> location) {
        if (isGenerating.get().booleanValue()) {
            throw new IllegalStateException("All bytecode producers should be created prior to code generation beginning.");
        }
        this.location = location;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void gen(GeneratorAdapter adapter) {
        boolean shouldClearIsGeneratingBit = false;
        if (!isGenerating.get().booleanValue()) {
            isGenerating.set(true);
            shouldClearIsGeneratingBit = true;
        }
        try {
            if (this.location.isPresent()) {
                Label start = new Label();
                adapter.mark(start);
                adapter.visitLineNumber(((SourceLocation)this.location.get()).getLineNumber(), start);
            }
            this.doGen(adapter);
            if (this.location.isPresent()) {
                Label end = new Label();
                adapter.mark(end);
                adapter.visitLineNumber(((SourceLocation)this.location.get()).getEndLine(), end);
            }
        }
        finally {
            if (shouldClearIsGeneratingBit) {
                isGenerating.set(false);
            }
        }
    }

    abstract void doGen(GeneratorAdapter var1);

    final String trace() {
        Textifier textifier = new Textifier(327680){
            {
                this.tab = null;
                this.tab2 = "  ";
                this.tab3 = "";
                this.ltab = "";
            }
        };
        this.gen(new GeneratorAdapter((MethodVisitor)new TraceMethodVisitor((Printer)textifier), 0, "trace", "()V"));
        StringWriter writer = new StringWriter();
        textifier.print(new PrintWriter(writer));
        return writer.toString();
    }
}

