/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.jbcsrc;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableMap;
import com.google.template.soy.jbcsrc.ClassData;
import com.google.template.soy.jbcsrc.CompiledTemplateMetadata;
import com.google.template.soy.jbcsrc.CompiledTemplateRegistry;
import com.google.template.soy.jbcsrc.CompiledTemplates;
import com.google.template.soy.jbcsrc.MemoryClassLoader;
import com.google.template.soy.jbcsrc.TemplateCompiler;
import com.google.template.soy.jbcsrc.api.CompiledTemplate;
import com.google.template.soy.soytree.TemplateBasicNode;
import com.google.template.soy.soytree.TemplateRegistry;
import java.util.Map;

final class BytecodeCompiler {
    static CompiledTemplates compile(TemplateRegistry registry) {
        CompiledTemplateRegistry compilerRegistry = new CompiledTemplateRegistry(registry);
        MemoryClassLoader loader = BytecodeCompiler.compileTemplates(registry, compilerRegistry);
        ImmutableMap.Builder factories = ImmutableMap.builder();
        for (String name : registry.getBasicTemplatesMap().keySet()) {
            factories.put((Object)name, (Object)BytecodeCompiler.loadFactory(compilerRegistry.getTemplateInfo(name), loader));
        }
        return new CompiledTemplates((ImmutableMap<String, CompiledTemplate.Factory>)factories.build());
    }

    @VisibleForTesting
    static CompiledTemplate.Factory loadFactory(CompiledTemplateMetadata templateInfo, ClassLoader loader) {
        CompiledTemplate.Factory factory;
        try {
            Class<CompiledTemplate.Factory> factoryClass = Class.forName(templateInfo.factory().className(), true, loader).asSubclass(CompiledTemplate.Factory.class);
            factory = factoryClass.newInstance();
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
            throw new AssertionError((Object)e);
        }
        return factory;
    }

    private static MemoryClassLoader compileTemplates(TemplateRegistry registry, CompiledTemplateRegistry compilerRegistry) {
        MemoryClassLoader.Builder builder = new MemoryClassLoader.Builder();
        for (Map.Entry<String, TemplateBasicNode> template : registry.getBasicTemplatesMap().entrySet()) {
            String name = template.getKey();
            CompiledTemplateMetadata classInfo = compilerRegistry.getTemplateInfo(name);
            for (ClassData clazz : new TemplateCompiler(classInfo).compile()) {
                builder.add(clazz);
            }
        }
        return builder.build();
    }

    private BytecodeCompiler() {
    }
}

