/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy;

import com.google.common.base.Preconditions;
import com.google.common.collect.Sets;
import com.google.template.soy.base.SourceLocation;
import com.google.template.soy.base.SoySyntaxException;
import com.google.template.soy.base.internal.IdGenerator;
import com.google.template.soy.base.internal.IncrementingIdGenerator;
import com.google.template.soy.base.internal.SoyFileSupplier;
import com.google.template.soy.basetree.SyntaxVersion;
import com.google.template.soy.internal.base.Pair;
import com.google.template.soy.parsepasses.CheckCallsVisitor;
import com.google.template.soy.parsepasses.CheckDelegatesVisitor;
import com.google.template.soy.parsepasses.InferRequiredSyntaxVersionVisitor;
import com.google.template.soy.parsepasses.ReplaceHasDataFunctionVisitor;
import com.google.template.soy.parsepasses.RewriteGenderMsgsVisitor;
import com.google.template.soy.parsepasses.RewriteNullCoalescingOpVisitor;
import com.google.template.soy.parsepasses.RewriteRemainderNodesVisitor;
import com.google.template.soy.parsepasses.SetDefaultForDelcallAllowsEmptyDefaultVisitor;
import com.google.template.soy.parsepasses.SetFullCalleeNamesVisitor;
import com.google.template.soy.parsepasses.VerifyPhnameAttrOnlyOnPlaceholdersVisitor;
import com.google.template.soy.shared.SoyAstCache;
import com.google.template.soy.sharedpasses.CheckCallingParamTypesVisitor;
import com.google.template.soy.sharedpasses.CheckSoyDocVisitor;
import com.google.template.soy.sharedpasses.CheckTemplateVisibility;
import com.google.template.soy.sharedpasses.RemoveHtmlCommentsVisitor;
import com.google.template.soy.sharedpasses.ReportSyntaxVersionErrorsVisitor;
import com.google.template.soy.sharedpasses.ResolveExpressionTypesVisitor;
import com.google.template.soy.sharedpasses.ResolveNamesVisitor;
import com.google.template.soy.soyparse.ErrorReporter;
import com.google.template.soy.soyparse.SoyError;
import com.google.template.soy.soyparse.SoyFileParser;
import com.google.template.soy.soytree.SoyFileNode;
import com.google.template.soy.soytree.SoyFileSetNode;
import com.google.template.soy.soytree.SoyNode;
import com.google.template.soy.types.SoyTypeRegistry;
import java.io.IOException;
import java.io.Reader;
import java.util.HashSet;
import java.util.List;
import javax.annotation.Nullable;

public final class SoyFileSetParser {
    private static final SoyError VERSION_SKEW_IN_SOY_FILE = SoyError.of("Version skew in Soy file {0}");
    private final SoyTypeRegistry typeRegistry;
    @Nullable
    private final SoyAstCache cache;
    private final SyntaxVersion declaredSyntaxVersion;
    private final List<SoyFileSupplier> soyFileSuppliers;
    private final boolean doRunInitialParsingPasses;
    private final boolean doRunCheckingPasses;
    private final ErrorReporter errorReporter;

    public SoyFileSetParser(SoyTypeRegistry typeRegistry, @Nullable SoyAstCache astCache, SyntaxVersion declaredSyntaxVersion, List<SoyFileSupplier> soyFileSuppliers, ErrorReporter errorReporter) {
        this(typeRegistry, astCache, declaredSyntaxVersion, soyFileSuppliers, errorReporter, true, true);
    }

    SoyFileSetParser(SoyTypeRegistry typeRegistry, @Nullable SoyAstCache astCache, SyntaxVersion declaredSyntaxVersion, List<SoyFileSupplier> soyFileSuppliers, ErrorReporter errorReporter, boolean doRunInitialParsingPasses, boolean doRunCheckingPasses) {
        this.typeRegistry = typeRegistry;
        this.cache = astCache;
        this.declaredSyntaxVersion = declaredSyntaxVersion;
        this.soyFileSuppliers = soyFileSuppliers;
        this.errorReporter = errorReporter;
        SoyFileSetParser.verifyUniquePaths(soyFileSuppliers);
        this.doRunInitialParsingPasses = doRunInitialParsingPasses;
        this.doRunCheckingPasses = doRunCheckingPasses;
    }

    public SoyFileSetNode parse() {
        return this.parseWithVersions();
    }

    private static void verifyUniquePaths(Iterable<SoyFileSupplier> soyFileSuppliers) {
        HashSet paths = Sets.newHashSet();
        for (SoyFileSupplier supplier : soyFileSuppliers) {
            Preconditions.checkArgument((!paths.contains(supplier.getFilePath()) ? 1 : 0) != 0, (Object)("Two file suppliers have the same path: " + supplier.getFilePath()));
            paths.add(supplier.getFilePath());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SoyFileSetNode parseWithVersions() {
        Preconditions.checkState((this.cache == null || this.doRunInitialParsingPasses && this.doRunCheckingPasses ? 1 : 0) != 0, (Object)"AST caching is only allowed when all parsing and checking passes are enabled, to avoid caching inconsistent versions");
        IdGenerator nodeIdGen = this.cache != null ? this.cache.getNodeIdGenerator() : new IncrementingIdGenerator();
        SoyFileSetNode soyTree = new SoyFileSetNode(nodeIdGen.genId(), nodeIdGen);
        for (SoyFileSupplier soyFileSupplier : this.soyFileSuppliers) {
            Pair<SoyFileNode, SoyFileSupplier.Version> fileAndVersion;
            Pair<SoyFileNode, SoyFileSupplier.Version> pair = fileAndVersion = this.cache != null ? this.cache.get(soyFileSupplier) : null;
            if (fileAndVersion == null) {
                IdGenerator idGenerator = nodeIdGen;
                synchronized (idGenerator) {
                    fileAndVersion = this.parseSoyFileHelper(soyFileSupplier, nodeIdGen, this.typeRegistry);
                    if (fileAndVersion.first == null) {
                        return soyTree;
                    }
                    if (this.doRunInitialParsingPasses) {
                        this.runSingleFileParsingPasses(fileAndVersion.getFirst(), nodeIdGen);
                    }
                }
                if (this.doRunCheckingPasses) {
                    this.runSingleFileCheckingPasses((SoyFileNode)fileAndVersion.first);
                }
                if (this.cache != null) {
                    this.cache.put(soyFileSupplier, (SoyFileSupplier.Version)fileAndVersion.second, (SoyFileNode)fileAndVersion.first);
                }
            }
            if (fileAndVersion.first == null) continue;
            soyTree.addChild((SoyNode)fileAndVersion.first);
        }
        if (this.doRunCheckingPasses) {
            this.runWholeFileSetCheckingPasses(soyTree);
        }
        return soyTree;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Pair<SoyFileNode, SoyFileSupplier.Version> parseSoyFileHelper(SoyFileSupplier soyFileSupplier, IdGenerator nodeIdGen, SoyTypeRegistry typeRegistry) {
        String filePath = soyFileSupplier.getFilePath();
        SoyFileSupplier.Version version = soyFileSupplier.getVersion();
        try (Reader soyFileReader = soyFileSupplier.open();){
            SoyFileNode soyFileNode = new SoyFileParser(typeRegistry, nodeIdGen, soyFileReader, soyFileSupplier.getSoyFileKind(), filePath, this.errorReporter).parseSoyFile();
            if (soyFileSupplier.hasChangedSince(version)) {
                this.errorReporter.report(new SourceLocation(filePath, -1, -1, -1, -1), VERSION_SKEW_IN_SOY_FILE, filePath);
            }
            Pair<SoyFileNode, SoyFileSupplier.Version> pair = Pair.of(soyFileNode, version);
            return pair;
        }
        catch (IOException e) {
            throw SoySyntaxException.createCausedWithoutMetaInfo("Error opening/closing Soy file " + soyFileSupplier.getFilePath(), e);
        }
    }

    private void runSingleFileParsingPasses(SoyFileNode fileNode, IdGenerator nodeIdGen) {
        new RewriteGenderMsgsVisitor(nodeIdGen).exec(fileNode);
        new RewriteRemainderNodesVisitor().exec(fileNode);
        new ReplaceHasDataFunctionVisitor(this.declaredSyntaxVersion).exec(fileNode);
        new RewriteNullCoalescingOpVisitor().exec(fileNode);
        new SetFullCalleeNamesVisitor().exec(fileNode);
        new SetDefaultForDelcallAllowsEmptyDefaultVisitor(this.declaredSyntaxVersion).exec(fileNode);
        if (this.declaredSyntaxVersion == SyntaxVersion.V1_0) {
            new RemoveHtmlCommentsVisitor(nodeIdGen).exec(fileNode);
        }
        new ResolveNamesVisitor(this.declaredSyntaxVersion).exec(fileNode);
        new ResolveExpressionTypesVisitor(this.typeRegistry, this.declaredSyntaxVersion).exec(fileNode);
    }

    private void runSingleFileCheckingPasses(SoyFileNode fileNode) {
        new VerifyPhnameAttrOnlyOnPlaceholdersVisitor().exec(fileNode);
        new ReportSyntaxVersionErrorsVisitor(this.declaredSyntaxVersion, true).exec(fileNode);
        SyntaxVersion inferredSyntaxVersion = new InferRequiredSyntaxVersionVisitor().exec(fileNode);
        if (inferredSyntaxVersion.num > this.declaredSyntaxVersion.num) {
            new ReportSyntaxVersionErrorsVisitor(inferredSyntaxVersion, false).exec(fileNode);
        }
    }

    private void runWholeFileSetCheckingPasses(SoyFileSetNode soyTree) {
        new CheckSoyDocVisitor(this.declaredSyntaxVersion).exec(soyTree);
        new CheckDelegatesVisitor().exec(soyTree);
        new CheckCallsVisitor().exec(soyTree);
        new CheckCallingParamTypesVisitor().exec(soyTree);
        new CheckTemplateVisibility().exec(soyTree);
    }
}

