/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.soytree;

import com.google.template.soy.base.SourceLocation;
import com.google.template.soy.exprparse.ExpressionParser;
import com.google.template.soy.exprtree.ExprNode;
import com.google.template.soy.exprtree.ExprRootNode;
import com.google.template.soy.exprtree.StringNode;
import com.google.template.soy.soyparse.ErrorReporter;
import com.google.template.soy.soyparse.SoyError;
import com.google.template.soy.soyparse.TransitionalThrowingErrorReporter;
import com.google.template.soy.soytree.CaseOrDefaultNode;
import com.google.template.soy.soytree.SoyNode;

public final class MsgSelectCaseNode
extends CaseOrDefaultNode
implements SoyNode.MsgBlockNode {
    private static final SoyError INVALID_STRING_FOR_SELECT_CASE = SoyError.of("Invalid string for select ''case''.");
    private final String caseValue;

    private MsgSelectCaseNode(int id, String commandText, String caseValue) {
        super(id, "case", commandText);
        this.caseValue = caseValue;
    }

    private MsgSelectCaseNode(MsgSelectCaseNode orig) {
        super(orig);
        this.caseValue = orig.caseValue;
    }

    @Override
    public SoyNode.Kind getKind() {
        return SoyNode.Kind.MSG_SELECT_CASE_NODE;
    }

    public String getCaseValue() {
        return this.caseValue;
    }

    @Override
    public MsgSelectCaseNode clone() {
        return new MsgSelectCaseNode(this);
    }

    public static final class Builder {
        public static final MsgSelectCaseNode ERROR = new MsgSelectCaseNode(-1, "error", "error");
        private final int id;
        private final String commandText;
        private final SourceLocation sourceLocation;

        public Builder(int id, String commandText, SourceLocation sourceLocation) {
            this.id = id;
            this.commandText = commandText;
            this.sourceLocation = sourceLocation;
        }

        public MsgSelectCaseNode build(ErrorReporter errorReporter) {
            ErrorReporter.Checkpoint checkpoint = errorReporter.checkpoint();
            ExprRootNode<? extends ExprNode> strLit = new ExpressionParser(this.commandText, this.sourceLocation, errorReporter).parseExpression();
            if (strLit.numChildren() != 1 || !(strLit.getChild(0) instanceof StringNode)) {
                errorReporter.report(this.sourceLocation, INVALID_STRING_FOR_SELECT_CASE, new String[0]);
            }
            if (errorReporter.errorsSince(checkpoint)) {
                return ERROR;
            }
            String caseValue = ((StringNode)strLit.getChild(0)).getValue();
            MsgSelectCaseNode node = new MsgSelectCaseNode(this.id, this.commandText, caseValue);
            node.setSourceLocation(this.sourceLocation);
            return node;
        }

        public MsgSelectCaseNode buildAndThrowIfInvalid() {
            TransitionalThrowingErrorReporter errorReporter = new TransitionalThrowingErrorReporter();
            MsgSelectCaseNode node = this.build(errorReporter);
            errorReporter.throwIfErrorsPresent();
            return node;
        }
    }
}

