/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.soytree;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.template.soy.base.SourceLocation;
import com.google.template.soy.exprparse.ExpressionParser;
import com.google.template.soy.exprtree.ExprNode;
import com.google.template.soy.exprtree.ExprRootNode;
import com.google.template.soy.exprtree.VarNode;
import com.google.template.soy.soyparse.ErrorReporter;
import com.google.template.soy.soyparse.SoyError;
import com.google.template.soy.soytree.AbstractBlockCommandNode;
import com.google.template.soy.soytree.ExprUnion;
import com.google.template.soy.soytree.SoyNode;
import com.google.template.soy.soytree.defn.LocalVar;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class ForNode
extends AbstractBlockCommandNode
implements SoyNode.StandaloneNode,
SoyNode.StatementNode,
SoyNode.ConditionalBlockNode,
SoyNode.LoopNode,
SoyNode.ExprHolderNode,
SoyNode.LocalVarBlockNode {
    private static final SoyError INVALID_COMMAND_TEXT = SoyError.of("Invalid ''for'' command text");
    private static final SoyError INVALID_RANGE_SPECIFICATION = SoyError.of("Invalid range specification");
    private static final Pattern COMMAND_TEXT_PATTERN = Pattern.compile("( [$] \\w+ ) \\s+ in \\s+ range[(] \\s* (.*) \\s* [)]", 36);
    private final LocalVar var;
    private final ImmutableList<String> rangeArgTexts;
    private final ImmutableList<ExprRootNode<?>> rangeArgs;

    public ForNode(int id, String commandText, SourceLocation sourceLocation, ErrorReporter errorReporter) {
        super(id, "for", commandText);
        this.setSourceLocation(sourceLocation);
        Matcher matcher = COMMAND_TEXT_PATTERN.matcher(commandText);
        if (!matcher.matches()) {
            errorReporter.report(sourceLocation, INVALID_COMMAND_TEXT, new String[0]);
        }
        String varName = ForNode.parseVarName(matcher.group(1), sourceLocation, errorReporter);
        List<ExprRootNode<?>> tempRangeArgs = ForNode.parseRangeArgs(matcher.group(2), sourceLocation, errorReporter);
        if (tempRangeArgs.size() > 3) {
            errorReporter.report(sourceLocation, INVALID_RANGE_SPECIFICATION, new String[0]);
        }
        this.rangeArgs = ImmutableList.copyOf(tempRangeArgs);
        ArrayList tempRangeArgTexts = Lists.newArrayList();
        for (ExprNode rangeArg : this.rangeArgs) {
            tempRangeArgTexts.add(rangeArg.toSourceString());
        }
        this.rangeArgTexts = ImmutableList.copyOf((Collection)tempRangeArgTexts);
        this.var = new LocalVar(varName, this, null);
    }

    private static String parseVarName(String input, SourceLocation sourceLocation, ErrorReporter errorReporter) {
        return ((VarNode)new ExpressionParser(input, sourceLocation, errorReporter).parseVariable().getChild(0)).getName();
    }

    private static List<ExprRootNode<?>> parseRangeArgs(String input, SourceLocation sourceLocation, ErrorReporter errorReporter) {
        return new ExpressionParser(input, sourceLocation, errorReporter).parseExpressionList();
    }

    private ForNode(ForNode orig) {
        super(orig);
        this.var = orig.var.clone();
        this.rangeArgTexts = orig.rangeArgTexts;
        ArrayList tempRangeArgs = Lists.newArrayListWithCapacity((int)orig.rangeArgs.size());
        for (ExprRootNode origRangeArg : orig.rangeArgs) {
            tempRangeArgs.add(origRangeArg.clone());
        }
        this.rangeArgs = ImmutableList.copyOf((Collection)tempRangeArgs);
    }

    @Override
    public SoyNode.Kind getKind() {
        return SoyNode.Kind.FOR_NODE;
    }

    public final LocalVar getVar() {
        return this.var;
    }

    @Override
    public final String getVarName() {
        return this.var.name();
    }

    public List<String> getRangeArgTexts() {
        return this.rangeArgTexts;
    }

    public List<ExprRootNode<?>> getRangeArgs() {
        return this.rangeArgs;
    }

    @Override
    public List<ExprUnion> getAllExprUnions() {
        return ExprUnion.createList(this.rangeArgs);
    }

    @Override
    public SoyNode.BlockNode getParent() {
        return (SoyNode.BlockNode)super.getParent();
    }

    @Override
    public ForNode clone() {
        return new ForNode(this);
    }
}

